/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken;

import com.pingidentity.adapters.opentoken.BaseAuthnAdapter;
import com.pingidentity.adapters.opentoken.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.opentoken.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.opentoken.utils.AdapterSession;
import com.pingidentity.adapters.opentoken.utils.AdapterSessionFactory;
import com.pingidentity.adapters.opentoken.utils.LoggerMessage;
import com.pingidentity.adapters.opentoken.utils.Util;
import com.pingidentity.opentoken.TokenException;
import com.pingidentity.opentoken.util.UrlHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.BearerAssertionReplayPreventionServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.websso.bindings.FormPost;

public class IdpAuthnAdapter
extends BaseAuthnAdapter
implements IdpAuthenticationAdapter {
    private static final IntegrationsLogger logger = new IntegrationsLogger(IdpAuthnAdapter.class);
    protected String authnService;
    protected boolean onetimeCookie;
    private boolean trackAuthenticationTime;

    public IdpAuthnAdapter() {
        this.transportModeConstant = "transport.mode.idp";
    }

    public Map lookupAuthN(HttpServletRequest req, HttpServletResponse resp, String partnerSpEntityId, AuthnPolicy authnPolicy, String resumePath) throws AuthnAdapterException, IOException {
        AdapterSession adapterSession = AdapterSessionFactory.getAdapterSession();
        return this.lookupAuthNHelper(req, resp, partnerSpEntityId, authnPolicy, resumePath, adapterSession);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Map lookupAuthNHelper(HttpServletRequest req, HttpServletResponse resp, String partnerSpEntityId, AuthnPolicy authnPolicy, String resumePath, AdapterSession adapterSession) throws IOException, AuthnAdapterException, MalformedURLException {
        block12: {
            block11: {
                MultiMap ids = this.readToken(req, resp);
                if (ids == null) break block11;
                adapterSession.removeAttribute("NUMBER_OF_ATTEMPTS", req, resp);
                if (authnPolicy.reauthenticate() && (resumePath == null || !req.getRequestURI().endsWith(resumePath))) {
                    if (this.agent.getAgentConfiguration().isUseCookie()) {
                        this.agent.deleteToken(resp);
                    }
                    break block12;
                } else {
                    List authContextList;
                    if (this.agent.getAgentConfiguration().isUseCookie() && this.onetimeCookie) {
                        this.agent.deleteToken(resp);
                    }
                    if ((authContextList = (List)ids.get((Object)"authnContext")) != null) {
                        String authnContext = (String)authContextList.get(0);
                        if (authnContext != null) {
                            ids.put((Object)"org.sourceid.saml20.adapter.idp.authn.authnCtx", (Object)authnContext);
                        }
                        if (this.trackAuthenticationTime) {
                            ids.put((Object)"org.sourceid.saml20.adapter.idp.authn.authnInst", (Object)String.valueOf(System.currentTimeMillis()));
                        }
                    }
                    ids.put((Object)"userId", ((List)ids.get((Object)"subject")).get(0));
                    return this.convertFromMultiMap(ids);
                }
            }
            String strNumberOfAttempts = (String)adapterSession.getAttribute("NUMBER_OF_ATTEMPTS", req, resp);
            int numberOfAttempts = 0;
            numberOfAttempts = strNumberOfAttempts == null ? 0 : Integer.parseInt(strNumberOfAttempts);
            adapterSession.setAttribute("NUMBER_OF_ATTEMPTS", Integer.toString(++numberOfAttempts), req, resp);
            if (numberOfAttempts > 1 && resumePath != null && req.getRequestURI().endsWith(resumePath)) {
                adapterSession.removeAttribute("NUMBER_OF_ATTEMPTS", req, resp);
                if (!authnPolicy.allowUserInteraction()) {
                    return new HashMap();
                }
                logger.log(LoggerMessage.MESSAGE_TRANSPORT_MISMATCHED);
                logger.log((LogEvent)LoggerMessage.GENERIC_ERROR, this.agent.getLastError());
                throw new AuthnAdapterException("Could not obtain attributes from the IdP Authentication Service.");
            }
        }
        UrlHelper url = new UrlHelper(this.authnService);
        url.addParameter("resume", IdpAuthnAdapter.URLEncode(resumePath));
        url.addParameter("spentity", IdpAuthnAdapter.URLEncode(partnerSpEntityId));
        if (!authnPolicy.allowUserInteraction()) {
            url.addParameter("IsPassive", "true");
        }
        if (authnPolicy.reauthenticate()) {
            url.addParameter("ForceAuthn", "true");
        }
        resp.sendRedirect(url.toString());
        return null;
    }

    @Override
    protected MultiMap readToken(HttpServletRequest req, HttpServletResponse resp) {
        MultiMap tokenAttributes = null;
        try {
            tokenAttributes = this.agent.readTokenToMultiMap(req);
            if (tokenAttributes == null) {
                return null;
            }
        }
        catch (TokenException e) {
            logger.log((LogEvent)LoggerMessage.ERROR_DECODING_TOKEN, e);
            return null;
        }
        if (Boolean.TRUE.equals(this.replayPrevention)) {
            String date = this.getNotOnOrAfter(tokenAttributes);
            if (date == null) {
                logger.log(LoggerMessage.MISSING_NOT_ON_OR_AFTER);
                return null;
            }
            try {
                String openTokenValue = null;
                if (this.agent.getAgentConfiguration().isUseCookie() && req.getCookies() != null) {
                    for (Cookie cookie : req.getCookies()) {
                        if (!cookie.getName().equals(this.agent.getAgentConfiguration().getTokenName())) continue;
                        openTokenValue = cookie.getValue();
                        break;
                    }
                } else {
                    openTokenValue = req.getParameter(this.agent.getAgentConfiguration().getTokenName());
                }
                if (openTokenValue != null) {
                    String tokenHash = DigestUtils.shaHex((String)openTokenValue);
                    AssertionReplayPreventionService replaySvc = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
                    if (replaySvc.isReplay(tokenHash, this.parseDate(date))) {
                        logger.log(LoggerMessage.REPLAY_DETECTED);
                        logger.log((LogEvent)LoggerMessage.OPEN_TOKEN, openTokenValue);
                        if (this.agent.getAgentConfiguration().isUseCookie()) {
                            this.agent.deleteToken(resp);
                        }
                        return null;
                    }
                }
            }
            catch (BearerAssertionReplayPreventionServiceException e) {
                logger.log((LogEvent)LoggerMessage.REPLAY_PREVENTION_FAILURE, e);
            }
            catch (ParseException pe) {
                logger.log((LogEvent)LoggerMessage.MISSING_NOT_ON_OR_AFTER, pe);
            }
        }
        return tokenAttributes;
    }

    public boolean logoutAuthN(Map authnIdentifiers, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        if (req == null && resp == null && resumePath == null) {
            return false;
        }
        if (resumePath != null && req.getRequestURI().endsWith(resumePath)) {
            if (this.agent.getAgentConfiguration().isUseCookie()) {
                this.agent.deleteToken(resp);
            }
            return true;
        }
        String currentBaseUrl = Util.getCurrentBaseUrl(req);
        if (this.logoutService == null || this.logoutService.length() < 1) {
            String resumePathToAppend = "";
            if (resumePath != null) {
                resumePathToAppend = resumePath.startsWith("/") ? resumePath.substring(1) : resumePath;
            }
            String sloEndpoint = currentBaseUrl + resumePathToAppend;
            logger.log(LoggerMessage.LOGOUT_SERVICE_NOT_CONFIGURED);
            resp.sendRedirect(sloEndpoint);
            return true;
        }
        UrlHelper url = new UrlHelper(this.logoutService);
        url.addParameter("resume", resumePath);
        if (this.transportMode == 2) {
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put(this.agent.getAgentConfiguration().getTokenName(), this.writeToken(this.convertToMultiMap(authnIdentifiers)));
            FormPost.post((String)url.toString(), postParams, (HttpServletResponse)resp);
        } else {
            this.writeToken(this.convertToMultiMap(authnIdentifiers), resp, url, true);
        }
        return false;
    }

    @Override
    public void configure(Configuration cfg) {
        super.configure(cfg);
        this.authnService = cfg.getFieldValue(this.helper.getFieldName("authn.service"));
        this.onetimeCookie = cfg.getBooleanFieldValue(this.helper.getFieldName("cookie.onetime"));
        this.trackAuthenticationTime = cfg.getBooleanFieldValue(this.helper.getFieldName("track.authntime"));
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        AdapterConfigurationGuiDescriptor gui = this.setupBaseGui();
        this.helper.setAddFieldToAdvanced(false);
        this.helper.addURLField(gui, "authn.service", true, 40);
        this.helper.setAddFieldToAdvanced(true);
        this.helper.addCheckboxField(gui, "cookie.onetime", false);
        this.helper.addCheckboxField(gui, "replay.prevention", false);
        this.helper.addCheckboxField(gui, "detect.malformed.attributes", false);
        this.helper.addCheckboxField(gui, "track.authntime", false);
        return new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, "OpenToken IdP Adapter 2.9", DEFAULT_CONTRACT, true, gui, false);
    }

    private Map<String, AttributeValue> convertFromMultiMap(MultiMap attributes) throws IOException {
        HashMap<String, AttributeValue> resultingMap = new HashMap<String, AttributeValue>();
        Set infoNames = attributes.keySet();
        Iterator iterator = infoNames.iterator();
        while (iterator.hasNext()) {
            String infoName = iterator.next().toString();
            Object infoValue = null;
            if (!attributes.containsKey((Object)infoName) || attributes.get((Object)infoName) == null) continue;
            List attrValuesList = (List)attributes.get((Object)infoName);
            resultingMap.put(infoName, new AttributeValue((Collection)attrValuesList));
        }
        return resultingMap;
    }

    private MultiMap convertToMultiMap(Map<String, AttributeValue> attributes) throws IOException {
        MultiValueMap resultingMap = new MultiValueMap();
        for (Map.Entry<String, AttributeValue> e : attributes.entrySet()) {
            String key = e.getKey();
            if (e.getValue() == null) continue;
            if (e.getValue().isMultiValue()) {
                resultingMap.put((Object)key, (Object)e.getValue().getValue());
                continue;
            }
            resultingMap.put((Object)key, (Object)e.getValue().getValue());
        }
        return resultingMap;
    }

    private String getNotOnOrAfter(MultiMap tokenAttributes) {
        List notOnOrAfterList;
        if (tokenAttributes.get((Object)"not-on-or-after") != null && (notOnOrAfterList = (List)tokenAttributes.get((Object)"not-on-or-after")) != null && !notOnOrAfterList.isEmpty()) {
            return (String)notOnOrAfterList.get(0);
        }
        return null;
    }

    public static String URLEncode(String value) throws UnsupportedEncodingException {
        String encodedValue = null;
        if (value != null) {
            encodedValue = URLEncoder.encode(value, "UTF-8");
        }
        return encodedValue;
    }
}

