/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken;

import com.pingidentity.adapters.opentoken.BaseAuthnAdapter;
import com.pingidentity.adapters.opentoken.config.Constants;
import com.pingidentity.adapters.opentoken.config.NonNullValidator;
import com.pingidentity.adapters.opentoken.utils.Util;
import com.pingidentity.opentoken.util.UrlHelper;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.HttpURLValidator;
import org.sourceid.saml20.adapter.sp.authn.SpAuthenticationAdapter;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.websso.bindings.FormPost;

public class SpAuthnAdapter
extends BaseAuthnAdapter
implements SpAuthenticationAdapter {
    protected String authnService;
    protected String accountLinkService;
    protected boolean sendUserIdQueryParam;
    protected String userIdQueryParam;
    protected int sendExtAttributes;
    protected boolean encodeCookieValue;
    private static boolean isSetDefaultForLegacyConfigMethodPresent;
    private static final Log log;

    public SpAuthnAdapter() {
        this.transportModeConstant = "transport.mode.sp";
    }

    private void setCookie(HttpServletResponse resp, String name, String value, int maxage) {
        Cookie c = new Cookie(name, value);
        c.setMaxAge(maxage);
        c.setPath(this.agent.getAgentConfiguration().getCookiePath());
        c.setHttpOnly(this.agent.getAgentConfiguration().isHttpOnly());
        String domain = this.agent.getAgentConfiguration().getCookieDomain();
        if (domain != null && domain.length() > 0) {
            c.setDomain(domain);
        }
        resp.addCookie(c);
    }

    public Serializable createAuthN(SsoContext ssoContext, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        UrlHelper url = null;
        if (this.authnService != null && this.authnService.length() > 0) {
            url = new UrlHelper(this.authnService);
            if (ssoContext.getTargetResourceUrl() != null) {
                url.addParameter("resume", this.urlEncode(ssoContext.getTargetResourceUrl()));
            }
        } else {
            url = new UrlHelper(ssoContext.getTargetResourceUrl());
        }
        MultiValueMap outmap = new MultiValueMap();
        for (Map.Entry e : ssoContext.getSubjectAttrs().entrySet()) {
            String key = (String)e.getKey();
            if (e.getValue() == null) continue;
            if (((AttributeValue)e.getValue()).isMultiValue()) {
                for (String s : ((AttributeValue)e.getValue()).getValues()) {
                    outmap.put((Object)key, (Object)s);
                }
            } else {
                outmap.put((Object)key, (Object)((AttributeValue)e.getValue()).getValue());
            }
            if (key.equals("subject") || key.equals("authnContext")) continue;
            switch (this.sendExtAttributes) {
                case 0: {
                    break;
                }
                case 1: {
                    String value = this.encodeCookieValue ? this.urlEncode(((AttributeValue)e.getValue()).getValue()) : ((AttributeValue)e.getValue()).getValue();
                    this.setCookie(resp, key, value, -1);
                    break;
                }
                case 2: {
                    url.addParameter(key, ((AttributeValue)e.getValue()).getValue());
                }
            }
        }
        outmap.put((Object)"authnContext", (Object)ssoContext.getAuthenticationContext());
        if (this.transportMode == 2) {
            HashMap<String, String> postParams = new HashMap<String, String>();
            if (this.sendUserIdQueryParam) {
                postParams.put(this.userIdQueryParam, ((AttributeValue)ssoContext.getSubjectAttrs().get("subject")).getValue());
            }
            postParams.put(this.agent.getAgentConfiguration().getTokenName(), this.writeToken((MultiMap)outmap));
            FormPost.post((String)url.toString(), postParams, (HttpServletResponse)resp);
            req.setAttribute("create.authn.complete", (Object)true);
        } else {
            if (this.sendUserIdQueryParam) {
                url.addParameter(this.userIdQueryParam, ((AttributeValue)ssoContext.getSubjectAttrs().get("subject")).getValue());
            }
            this.writeToken((MultiMap)outmap, resp, url, false);
        }
        ssoContext.setTargetResourceUrl(url.toString());
        return (Serializable)ssoContext.getSubjectAttrs().get("subject");
    }

    public boolean logoutAuthN(Serializable authnBean, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        if (req == null && resp == null && resumePath == null) {
            return false;
        }
        if (resumePath != null && req.getRequestURI().endsWith(resumePath)) {
            if (this.agent.getAgentConfiguration().isUseCookie()) {
                this.agent.deleteToken(resp);
            }
            return true;
        }
        String currentBaseUrl = Util.getCurrentBaseUrl(req);
        if (this.logoutService == null || this.logoutService.length() < 1) {
            String resumePathToAppend = "";
            if (resumePath != null) {
                resumePathToAppend = resumePath.startsWith("/") ? resumePath.substring(1) : resumePath;
            }
            String sloEndpoint = currentBaseUrl + resumePathToAppend;
            log.debug((Object)"Logout functionality invoked, but no logout service is configured for this adapter. So redirecting to locally process the request.");
            resp.sendRedirect(sloEndpoint);
            return true;
        }
        UrlHelper url = new UrlHelper(this.logoutService);
        url.addParameter("resume", resumePath);
        MultiValueMap ids = new MultiValueMap();
        ids.put((Object)"subject", (Object)authnBean.toString());
        if (this.transportMode == 2) {
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put(this.agent.getAgentConfiguration().getTokenName(), this.writeToken((MultiMap)ids));
            FormPost.post((String)url.toString(), postParams, (HttpServletResponse)resp);
        } else {
            this.writeToken((MultiMap)ids, resp, url, true);
        }
        return false;
    }

    public String lookupLocalUserId(HttpServletRequest req, HttpServletResponse resp, String partnerIdpEntityId, String resumePath) throws AuthnAdapterException, IOException {
        MultiMap ids = this.readToken(req, resp);
        if (ids != null) {
            List subjectList = (List)ids.get((Object)"subject");
            return (String)subjectList.get(0);
        }
        if (resumePath != null && req.getRequestURI().endsWith(resumePath)) {
            throw new AuthnAdapterException("Could not obtain attibutes from the SP Account Linking Service.");
        }
        if (this.accountLinkService == null || this.accountLinkService.length() < 1) {
            throw new AuthnAdapterException("No Account Link Service specified for this adapter configuration.");
        }
        UrlHelper url = new UrlHelper(this.accountLinkService);
        url.addParameter("resume", resumePath);
        url.addParameter("idpentity", partnerIdpEntityId);
        resp.sendRedirect(url.toString());
        return null;
    }

    @Override
    public void configure(Configuration cfg) {
        super.configure(cfg);
        this.authnService = cfg.getFieldValue(this.helper.getFieldName("authn.service"));
        this.accountLinkService = cfg.getFieldValue(this.helper.getFieldName("alink.service"));
        this.sendUserIdQueryParam = cfg.getBooleanFieldValue(this.helper.getFieldName("uid.queryparam.flag"));
        this.userIdQueryParam = cfg.getFieldValue(this.helper.getFieldName("uid.queryparam"));
        this.sendExtAttributes = cfg.getIntFieldValue(this.helper.getFieldName("ext.attrs.flag"));
        Field encodeField = cfg.getField(this.helper.getFieldName("encode.cookie.value"));
        this.encodeCookieValue = encodeField == null ? true : cfg.getBooleanFieldValue(this.helper.getFieldName("encode.cookie.value"));
    }

    public AuthnAdapterDescriptor getAdapterDescriptor() {
        AdapterConfigurationGuiDescriptor gui = this.setupBaseGui();
        TextFieldDescriptor f = this.helper.newTextField(this.helper.getFieldName("authn.service"), this.helper.getFieldDesc("authn.service.sp"), false, 40);
        f.addValidator((FieldValidator)new NonNullValidator((FieldValidator)new HttpURLValidator()));
        this.helper.addFieldBefore(gui, "logout.service", (FieldDescriptor)f);
        f = this.helper.newTextField(this.helper.getFieldName("alink.service"), this.helper.getFieldDesc("alink.service"), false, 40);
        f.addValidator((FieldValidator)new NonNullValidator((FieldValidator)new HttpURLValidator()));
        this.helper.addFieldBefore(gui, "logout.service", (FieldDescriptor)f);
        this.helper.addCheckboxField(gui, "uid.queryparam.flag", false);
        this.helper.addTextField(gui, "uid.queryparam", 15);
        this.helper.addDropdownField(gui, "ext.attrs.flag", Constants.EXT_ATTRS, false);
        this.helper.addCheckboxField(gui, "remove.trailing.backslash", false);
        CheckBoxFieldDescriptor encodeCookieCheckboxField = new CheckBoxFieldDescriptor(this.helper.getFieldName("encode.cookie.value"), this.helper.getFieldDesc("encode.cookie.value"));
        encodeCookieCheckboxField.setDefaultValue(this.helper.getFieldDefault("encode.cookie.value"));
        if (isSetDefaultForLegacyConfigMethodPresent) {
            encodeCookieCheckboxField.setDefaultForLegacyConfig(this.helper.getFieldDefault("encode.cookie.value"));
        }
        gui.addAdvancedField((FieldDescriptor)encodeCookieCheckboxField);
        return new AuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, "OpenToken SP Adapter 2.9", DEFAULT_CONTRACT, true, gui);
    }

    private String urlEncode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }

    static {
        Method[] methods;
        isSetDefaultForLegacyConfigMethodPresent = false;
        log = LogFactory.getLog(SpAuthnAdapter.class);
        for (Method m : methods = TextFieldDescriptor.class.getMethods()) {
            if (!m.getName().equals("setDefaultForLegacyConfig")) continue;
            isSetDefaultForLegacyConfigMethodPresent = true;
            break;
        }
    }
}

