/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken.config;

import com.pingidentity.adapters.opentoken.config.GuiHelper;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class ConfigValidator
implements ConfigurationValidator {
    GuiHelper helper;

    public ConfigValidator(GuiHelper helper) {
        this.helper = helper;
    }

    public void validate(Configuration cfg) throws ValidationException {
        String tokenName;
        boolean useCookie;
        String userIdQueryParam;
        String domain = cfg.getFieldValue(this.helper.getFieldName("cookie.domain"));
        if (domain.length() > 0 && domain.indexOf(46, 1) == -1) {
            throw new ValidationException("'" + this.helper.getFieldName("cookie.domain") + "' must be of the format (example.com).");
        }
        boolean sendUserIdQueryParam = cfg.getBooleanFieldValue(this.helper.getFieldName("uid.queryparam.flag"));
        if (sendUserIdQueryParam && (userIdQueryParam = cfg.getFieldValue(this.helper.getFieldName("uid.queryparam"))).length() <= 0) {
            throw new ValidationException("'" + this.helper.getFieldName("uid.queryparam").trim() + "' must be specified if '" + this.helper.getFieldName("uid.queryparam.flag") + "' is checked.");
        }
        boolean bl = useCookie = cfg.getIntFieldValue(this.helper.getFieldName("transport.mode.sp")) == 1;
        if (useCookie) {
            String cookiePath = cfg.getFieldValue(this.helper.getFieldName("cookie.path"));
            if (cookiePath.length() <= 0) {
                throw new ValidationException("'" + this.helper.getFieldName("cookie.path") + "' must be specified if '" + this.helper.getFieldName("transport.mode.sp") + "' is set as 'Cookie'.");
            }
            boolean isSecureCookie = cfg.getBooleanFieldValue(this.helper.getFieldName("secure.cookie"));
            int sameSiteCookieAttr = cfg.getIntFieldValue(this.helper.getFieldName("cookie.samesite"));
            if (!isSecureCookie && sameSiteCookieAttr == 2) {
                throw new ValidationException("'" + this.helper.getFieldName("secure.cookie") + "' must be checked if '" + this.helper.getFieldName("cookie.samesite") + "' is set to 'None'.");
            }
        }
        if ((tokenName = cfg.getFieldValue(this.helper.getFieldName("token.name"))).indexOf(44) >= 0) {
            throw new ValidationException("'" + this.helper.getFieldName("token.name") + "' must not contain commas");
        }
        if (tokenName.indexOf(32) >= 0) {
            throw new ValidationException("'" + this.helper.getFieldName("token.name") + "' must not contain spaces");
        }
        if (useCookie && (tokenName.equalsIgnoreCase("Comment") || tokenName.equalsIgnoreCase("CommentURL") || tokenName.equalsIgnoreCase("Discard") || tokenName.equalsIgnoreCase("Domain") || tokenName.equalsIgnoreCase("Expires") || tokenName.equalsIgnoreCase("Max-Age") || tokenName.equalsIgnoreCase("Path") || tokenName.equalsIgnoreCase("Port") || tokenName.equalsIgnoreCase("Secure") || tokenName.equalsIgnoreCase("Versions") || tokenName.equalsIgnoreCase("HttpOnly") || tokenName.equalsIgnoreCase("TrackAuthnTime"))) {
            throw new ValidationException("'" + this.helper.getFieldName("token.name") + "' value (" + tokenName + ") is a reserved word.");
        }
    }
}

