/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken.config;

import com.pingidentity.adapters.opentoken.config.NonNullValidator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.HttpURLValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class GuiHelper {
    private static final String GUI_FILE = "gui.properties";
    private Properties props;
    private boolean addToAdvanced = false;
    private static boolean isSetDefaultForLegacyConfigMethodPresent;
    private static final Class[] SET_SIZE_PARAM;

    public GuiHelper() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(GUI_FILE);
        this.props = new Properties();
        try {
            this.props.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading gui.properties", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading gui.properties", e);
                }
            }
        }
    }

    public boolean getAddFieldsToAdvanced() {
        return this.addToAdvanced;
    }

    public void setAddFieldToAdvanced(boolean value) {
        this.addToAdvanced = value;
    }

    public String getFieldName(String key) {
        return this.props.getProperty(key + ".field");
    }

    public String getFieldDesc(String key) {
        return this.props.getProperty(key + ".desc");
    }

    public String getFieldDefault(String key) {
        return this.props.getProperty(key + ".default", "").trim();
    }

    private String getValue(String key) {
        return this.props.getProperty(key);
    }

    private void addField(AdapterConfigurationGuiDescriptor gui, FieldDescriptor f) {
        if (this.addToAdvanced) {
            gui.addAdvancedField(f);
        } else {
            gui.addField(f);
        }
    }

    public void addTextField(AdapterConfigurationGuiDescriptor gui, String key, boolean required, boolean encrypt, int len) {
        TextFieldDescriptor f = this.newTextField(this.getFieldName(key), this.getFieldDesc(key), encrypt, len);
        f.setDefaultValue(this.getFieldDefault(key));
        if (required) {
            f.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        this.addField(gui, (FieldDescriptor)f);
    }

    public void addTextField(AdapterConfigurationGuiDescriptor gui, String key, int len) {
        this.addTextField(gui, key, false, len);
    }

    public void addTextField(AdapterConfigurationGuiDescriptor gui, String key, boolean required, int len) {
        this.addTextField(gui, key, required, false, len);
    }

    public void addIntField(AdapterConfigurationGuiDescriptor gui, String key, boolean required, int min, int max) {
        TextFieldDescriptor f = this.newTextField(this.getFieldName(key), this.getFieldDesc(key), false, 8);
        f.setDefaultValue(this.getFieldDefault(key));
        if (required) {
            f.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        f.addValidator((FieldValidator)new NonNullValidator((FieldValidator)new IntegerValidator(min, max)));
        this.addField(gui, (FieldDescriptor)f);
    }

    public void addRadioGroupField(AdapterConfigurationGuiDescriptor gui, String key, String[] enumKeys, boolean required) {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        for (int i = 0; i < enumKeys.length; ++i) {
            options.add(new AbstractSelectionFieldDescriptor.OptionValue(this.getValue(enumKeys[i]), Integer.toString(i)));
        }
        RadioGroupFieldDescriptor f = new RadioGroupFieldDescriptor(this.getFieldName(key), this.getFieldDesc(key), options);
        f.setDefaultValue(this.getFieldDefault(key));
        if (isSetDefaultForLegacyConfigMethodPresent) {
            f.setDefaultForLegacyConfig(this.getFieldDefault(key));
        }
        this.addField(gui, (FieldDescriptor)f);
    }

    public void addDropdownField(AdapterConfigurationGuiDescriptor gui, String key, String[] enumKeys, boolean required) {
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> options = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        for (int i = 0; i < enumKeys.length; ++i) {
            options.add(new AbstractSelectionFieldDescriptor.OptionValue(this.getValue(enumKeys[i]), Integer.toString(i)));
        }
        SelectFieldDescriptor f = new SelectFieldDescriptor(this.getFieldName(key), this.getFieldDesc(key), options);
        f.setDefaultValue(this.getFieldDefault(key));
        this.addField(gui, (FieldDescriptor)f);
    }

    public void addCheckboxField(AdapterConfigurationGuiDescriptor gui, String key, boolean required, boolean hideField) {
        CheckBoxFieldDescriptor f = new CheckBoxFieldDescriptor(this.getFieldName(key), this.getFieldDesc(key));
        f.setDefaultValue(this.getFieldDefault(key));
        f.setHidden(hideField);
        this.addField(gui, (FieldDescriptor)f);
    }

    public void addCheckboxField(AdapterConfigurationGuiDescriptor gui, String key, boolean required) {
        CheckBoxFieldDescriptor f = new CheckBoxFieldDescriptor(this.getFieldName(key), this.getFieldDesc(key));
        f.setDefaultValue(this.getFieldDefault(key));
        this.addField(gui, (FieldDescriptor)f);
    }

    public void addURLField(AdapterConfigurationGuiDescriptor gui, String key, boolean required, int len) {
        TextFieldDescriptor f = this.newTextField(this.getFieldName(key), this.getFieldDesc(key), false, len);
        if (required) {
            f.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        f.addValidator((FieldValidator)new NonNullValidator((FieldValidator)new HttpURLValidator()));
        this.addField(gui, (FieldDescriptor)f);
    }

    public void addFieldBefore(AdapterConfigurationGuiDescriptor gui, String beforeKey, FieldDescriptor f) {
        int i;
        String fname = this.getFieldName(beforeKey);
        List fields = gui.getFields();
        for (i = 0; i < fields.size(); ++i) {
            if (!((FieldDescriptor)fields.get(i)).getName().equals(fname)) continue;
            fields.add(i, f);
            return;
        }
        fields = gui.getAdvancedFields();
        for (i = 0; i < fields.size(); ++i) {
            String fieldName = ((FieldDescriptor)fields.get(i)).getName();
            if (fieldName == null || !fieldName.equals(fname)) continue;
            fields.add(i, f);
            return;
        }
    }

    public TextFieldDescriptor newTextField(String name, String desc, boolean encrypt, int length) {
        TextFieldDescriptor tf = new TextFieldDescriptor(name, desc, encrypt);
        try {
            Method setLengthMethod = tf.getClass().getMethod("setSize", SET_SIZE_PARAM);
            if (setLengthMethod != null) {
                setLengthMethod.invoke((Object)tf, length);
            }
        }
        catch (NoSuchMethodException setLengthMethod) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getCause());
        }
        return tf;
    }

    static {
        Method[] methods;
        isSetDefaultForLegacyConfigMethodPresent = false;
        for (Method m : methods = TextFieldDescriptor.class.getMethods()) {
            if (!m.getName().equals("setDefaultForLegacyConfig")) continue;
            isSetDefaultForLegacyConfigMethodPresent = true;
            break;
        }
        SET_SIZE_PARAM = new Class[]{Integer.TYPE};
    }
}

