/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.opentoken.utils;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;

public class Util {
    private static String processUrl(String url) {
        if (!url.endsWith("/")) {
            return url + "/";
        }
        return url;
    }

    private static String tryGetCurrentBaseUrl() {
        String currentBaseUrl = "";
        try {
            Class<?> baseUrlAccessorClass = Class.forName("com.pingidentity.access.BaseUrlAccessor");
            Method getCurrentBaseUrlMethod = baseUrlAccessorClass.getMethod("getCurrentBaseUrl", new Class[0]);
            currentBaseUrl = Util.processUrl((String)getCurrentBaseUrlMethod.invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentBaseUrl;
    }

    public static String getCurrentBaseUrl(HttpServletRequest req) {
        String currentBaseUrl = Util.tryGetCurrentBaseUrl();
        if (currentBaseUrl == null || currentBaseUrl.isEmpty()) {
            currentBaseUrl = Util.processUrl(Util.getBaseUrlFromRequest(req));
        }
        return currentBaseUrl;
    }

    private static String getBaseUrlFromRequest(HttpServletRequest req) {
        String scheme = req.getScheme();
        String host = req.getServerName();
        int port = req.getServerPort();
        StringBuffer baseUrl = new StringBuffer(scheme).append("://").append(host);
        if (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443) {
            baseUrl.append(":").append(port);
        }
        return baseUrl.toString();
    }
}

