/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken;

import com.pingidentity.opentoken.AgentConfiguration;
import com.pingidentity.opentoken.Token;
import com.pingidentity.opentoken.TokenException;
import com.pingidentity.opentoken.TokenExpiredException;
import com.pingidentity.opentoken.key.KeyManager;
import com.pingidentity.opentoken.key.PasswordKeyManager;
import com.pingidentity.opentoken.util.KeyValueSerializer;
import com.pingidentity.opentoken.util.UrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Agent {
    public static final String TOKEN_SUBJECT = "subject";
    public static final String TOKEN_NOT_BEFORE = "not-before";
    public static final String TOKEN_NOT_ON_OR_AFTER = "not-on-or-after";
    public static final String TOKEN_RENEW_UNTIL = "renew-until";
    public static final String OPENTOKEN_SYSTEM_DEBUG = "opentoken.debug";
    private static final Log log = LogFactory.getLog(Agent.class);
    private AgentConfiguration config;
    private String lastError;
    private KeyManager keyman;
    private static final Pattern suspiciouAttributeValuePattern = Pattern.compile("^.*['\"]\\n.*=$", 32);

    public Agent() {
        this(false);
    }

    public Agent(boolean loadDefaultConfigurationFile) {
        this.config = new AgentConfiguration(loadDefaultConfigurationFile);
        this.keyman = new PasswordKeyManager(this.config.getPasswordBytes(), this.config.getCipherSuite(), this.config.isUseSunJCE());
    }

    public Agent(InputStream configStream) throws IOException {
        this.config = new AgentConfiguration(configStream);
        this.keyman = new PasswordKeyManager(this.config.getPasswordBytes(), this.config.getCipherSuite(), this.config.isUseSunJCE());
    }

    public Agent(AgentConfiguration configuration) {
        this.config = configuration.copy();
        this.keyman = new PasswordKeyManager(this.config.getPasswordBytes(), this.config.getCipherSuite(), this.config.isUseSunJCE());
    }

    public Agent(String file) throws IOException {
        this.config = new AgentConfiguration(file);
        this.keyman = new PasswordKeyManager(this.config.getPasswordBytes(), this.config.getCipherSuite(), this.config.isUseSunJCE());
    }

    public String getLastError() {
        return this.lastError;
    }

    KeyManager getKeyManager() {
        return this.keyman;
    }

    public AgentConfiguration getAgentConfiguration() {
        try {
            AgentConfiguration clone = (AgentConfiguration)BeanUtils.cloneBean((Object)this.config);
            clone.setObfuscatePassword(this.config.isObfuscatePassword());
            return clone;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map readToken(String token) throws TokenException {
        return Agent.convertFromMultiMap(this.readTokenToMultiMap(token));
    }

    public MultiMap readTokenToMultiMap(String token) throws TokenException {
        MultiMap ids = Token.decode(token, this.keyman, this.config.isUseSunJCE(), this.config.isUseVerboseErrorMessages());
        if (this.config.isDetectMalformedAttributes()) {
            Agent.checkForBadBackslashEscape(ids);
        }
        if (!ids.containsKey((Object)TOKEN_SUBJECT)) {
            throw new TokenException("Token does not have a subject key/value pair.");
        }
        Calendar notBefore = null;
        Calendar notOnOrAfter = null;
        Calendar renewUntil = null;
        try {
            notBefore = this.parseDate(KeyValueSerializer.convertListToString((List)ids.get((Object)TOKEN_NOT_BEFORE)));
            notOnOrAfter = this.parseDate(KeyValueSerializer.convertListToString((List)ids.get((Object)TOKEN_NOT_ON_OR_AFTER)));
            renewUntil = this.parseDate(KeyValueSerializer.convertListToString((List)ids.get((Object)TOKEN_RENEW_UNTIL)));
        }
        catch (ParseException e) {
            throw new TokenException("Invalid token; token lifetime fields are improperly formatted.", e);
        }
        catch (NullPointerException e) {
            throw new TokenException("Invalid token; missing not-before or not-on-or-after or renew-until fields.");
        }
        this.validateTokenLifetimes(notBefore, notOnOrAfter, renewUntil);
        return ids;
    }

    private void validateTokenLifetimes(Calendar notBefore, Calendar notOnOrAfter, Calendar renewUntil) throws TokenException {
        Calendar now = Calendar.getInstance(AgentConfiguration.UTC_TZ);
        Calendar futureNow = (Calendar)now.clone();
        futureNow.add(13, this.config.getNotBeforeTolerance());
        if (notBefore.after(notOnOrAfter)) {
            throw new TokenException("Invalid token; not-on-or-after precedes not-before.");
        }
        if (notBefore.after(now) && notBefore.after(futureNow)) {
            throw new TokenException("Invalid token; token is not yet valid (not-before > now)");
        }
        if (now.after(notOnOrAfter)) {
            throw new TokenExpiredException("Invalid token; token has expired (now > not-on-or-after)");
        }
        if (now.after(renewUntil)) {
            throw new TokenExpiredException("Invalid token; token may no longer be renewed (now > renew-until");
        }
    }

    static void checkForBadBackslashEscape(MultiMap attrs) throws TokenException {
        for (String av : attrs.values()) {
            if (!suspiciouAttributeValuePattern.matcher(av).matches()) continue;
            throw new TokenException("Found suspicious attribute value");
        }
    }

    public Map readToken(HttpServletRequest request) throws TokenException {
        return Agent.convertFromMultiMap(this.readTokenToMultiMap(request));
    }

    public MultiMap readTokenToMultiMap(HttpServletRequest request) throws TokenException {
        String token = this.getTokenFromRequest(request);
        if (null != token) {
            return this.readTokenToMultiMap(token);
        }
        return null;
    }

    private String getTokenFromRequest(HttpServletRequest request) {
        String token = null;
        String tokenName = this.config.getTokenName();
        if (this.config.isUseCookie()) {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie c = cookies[i];
                    if (!c.getName().equals(tokenName) && !c.getName().equals(tokenName + "-legacy")) continue;
                    token = c.getValue();
                }
            }
            if (token == null) {
                this.lastError = "No cookie token found named '" + tokenName + "'";
                return null;
            }
        } else {
            token = request.getParameter(this.config.getTokenName());
            if (token == null) {
                this.lastError = "No query parameter token found named '" + tokenName + "'";
                return null;
            }
        }
        log.debug((Object)(tokenName + ": " + token));
        return token;
    }

    public void writeToken(Map ids, HttpServletResponse response, String targetUrl) throws MalformedURLException, IOException, TokenException {
        this.writeToken(Agent.convertToMultiMap(ids), response, new UrlHelper(targetUrl), true);
    }

    public void writeToken(MultiMap ids, HttpServletResponse response, String targetUrl) throws MalformedURLException, IOException, TokenException {
        this.writeToken(ids, response, new UrlHelper(targetUrl), true);
    }

    public void writeToken(Map ids, HttpServletResponse response, UrlHelper targetUrl) throws IOException, TokenException {
        this.writeToken(Agent.convertToMultiMap(ids), response, targetUrl, true);
    }

    public void writeToken(MultiMap ids, HttpServletResponse response, UrlHelper targetUrl) throws IOException, TokenException {
        this.writeToken(ids, response, targetUrl, true);
    }

    public void writeToken(Map ids, HttpServletResponse response, UrlHelper targetUrl, boolean doRedirect) throws IOException, TokenException {
        this.writeToken(Agent.convertToMultiMap(ids), response, targetUrl, doRedirect);
    }

    public void writeToken(MultiMap ids, HttpServletResponse response, UrlHelper targetUrl, boolean doRedirect) throws IOException, TokenException {
        String token = this.writeToken(ids);
        this.setCookieOrParameterAndRedirect(token, response, targetUrl, doRedirect);
    }

    private void setCookieOrParameterAndRedirect(String token, HttpServletResponse response, UrlHelper targetUrl, boolean doRedirect) throws IOException {
        if (this.config.isUseCookie()) {
            StringBuilder cookie = new StringBuilder();
            if (this.config.getCookieDomain() != null && this.config.getCookieDomain().length() > 0) {
                cookie.append("Domain=" + this.config.getCookieDomain() + "; ");
            }
            if (!this.config.isSessionCookie()) {
                cookie.append("Max-Age=" + this.config.getTokenLifetime() + "; ");
            }
            if (this.config.isSecureCookie()) {
                cookie.append("Secure; ");
            }
            cookie.append("Path=" + this.config.getCookiePath() + "; ");
            if (this.config.isHttpOnly()) {
                cookie.append("HttpOnly; ");
            }
            StringBuilder legacyCookie = new StringBuilder(cookie);
            legacyCookie.insert(0, this.config.getTokenName() + "-legacy=" + token + "; ");
            cookie.insert(0, this.config.getTokenName() + "=" + token + "; ");
            if (this.config.hasSameSiteCookieAttr()) {
                String samesite = this.config.getSameSiteCookieAttr();
                if (samesite.equals("None") && !this.config.isSecureCookie()) {
                    log.debug((Object)"Received SameSite None but Secure is false. So skip setting SameSite attribute");
                } else if (samesite.equals("Strict") || samesite.equals("Lax") || samesite.equals("None")) {
                    cookie.append("SameSite=" + samesite);
                }
            }
            response.addHeader("Set-Cookie", cookie.toString());
            response.addHeader("Set-Cookie", legacyCookie.toString());
        } else {
            targetUrl.addParameter(this.config.getTokenName(), token);
        }
        if (doRedirect) {
            response.sendRedirect(targetUrl.toString());
        }
    }

    public String writeToken(Map ids) throws TokenException {
        return this.writeToken(Agent.convertToMultiMap(ids));
    }

    public String writeToken(MultiMap ids) throws TokenException {
        if (!ids.containsKey((Object)TOKEN_SUBJECT)) {
            throw new TokenException("Encode failed; token must include a subject key/value pair.");
        }
        Calendar notBefore = Calendar.getInstance(AgentConfiguration.UTC_TZ);
        Calendar notOnOrAfter = (Calendar)notBefore.clone();
        notOnOrAfter.add(13, this.config.getTokenLifetime());
        ids.remove((Object)TOKEN_NOT_BEFORE);
        ids.remove((Object)TOKEN_NOT_ON_OR_AFTER);
        ids.put((Object)TOKEN_NOT_BEFORE, (Object)this.serializeDate(notBefore));
        ids.put((Object)TOKEN_NOT_ON_OR_AFTER, (Object)this.serializeDate(notOnOrAfter));
        if (!ids.containsKey((Object)TOKEN_RENEW_UNTIL)) {
            Calendar renewUntil = (Calendar)notBefore.clone();
            renewUntil.add(13, this.config.getRenewUntilLifetime());
            ids.put((Object)TOKEN_RENEW_UNTIL, (Object)this.serializeDate(renewUntil));
        }
        String encodedToken = Token.encode(ids, this.keyman, this.config.isUseSunJCE(), this.config.isUseVerboseErrorMessages(), this.config.isRemoveTrailingBackslash());
        log.debug((Object)(this.config.getTokenName() + ": " + encodedToken));
        return encodedToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(InputStream is) throws IOException {
        Agent agent = this;
        synchronized (agent) {
            this.config = new AgentConfiguration(is);
            this.keyman = new PasswordKeyManager(this.config.getPasswordBytes(), this.config.getCipherSuite(), this.config.isUseSunJCE());
        }
    }

    public void deleteToken(HttpServletResponse response) {
        if (this.config.isUseCookie()) {
            StringBuilder cookie = new StringBuilder();
            if (this.config.getCookieDomain() != null && this.config.getCookieDomain().length() > 0) {
                cookie.append("Domain=" + this.config.getCookieDomain() + "; ");
            }
            if (this.config.isSecureCookie()) {
                cookie.append("Secure; ");
            }
            cookie.append("Path=" + this.config.getCookiePath() + "; ");
            if (this.config.isHttpOnly()) {
                cookie.append("HttpOnly; ");
            }
            StringBuilder legacyCookie = new StringBuilder(cookie);
            legacyCookie.insert(0, this.config.getTokenName() + "-legacy=; ");
            cookie.insert(0, this.config.getTokenName() + "=; ");
            if (this.config.hasSameSiteCookieAttr()) {
                String samesite = this.config.getSameSiteCookieAttr();
                if (samesite.equals("None") && !this.config.isSecureCookie()) {
                    log.debug((Object)"Received SameSite None but Secure is false. So skip setting SameSite attribute");
                } else if (samesite.equals("Strict") || samesite.equals("Lax") || samesite.equals("None")) {
                    cookie.append("SameSite=" + samesite + "; ");
                }
            }
            cookie.append("Max-Age=0");
            legacyCookie.append("Max-Age=0");
            response.addHeader("Set-Cookie", cookie.toString());
            response.addHeader("Set-Cookie", legacyCookie.toString());
        }
    }

    Calendar parseDate(String s) throws ParseException {
        Calendar result = Calendar.getInstance(AgentConfiguration.UTC_TZ);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(AgentConfiguration.UTC_TZ);
        result.setTime(formatter.parse(s));
        return result;
    }

    String serializeDate(Calendar c) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(AgentConfiguration.UTC_TZ);
        return formatter.format(c.getTime());
    }

    public static Map convertFromMultiMap(MultiMap attributes) {
        HashMap resultingMap = new HashMap();
        if (attributes == null) {
            return null;
        }
        Set infoNames = attributes.keySet();
        Iterator iterator = infoNames.iterator();
        while (iterator.hasNext()) {
            String infoName = iterator.next().toString();
            if (!attributes.containsKey((Object)infoName) || attributes.get((Object)infoName) == null) continue;
            List attrValuesList = (List)attributes.get((Object)infoName);
            resultingMap.put(infoName, attrValuesList.get(0));
        }
        return resultingMap;
    }

    public static MultiMap convertToMultiMap(Map attributes) {
        MultiValueMap resultingMap = new MultiValueMap();
        Set infoNames = attributes.keySet();
        Iterator iterator = infoNames.iterator();
        while (iterator.hasNext()) {
            String infoName = iterator.next().toString();
            if (!attributes.containsKey(infoName) || attributes.get(infoName) == null) continue;
            resultingMap.put((Object)infoName, attributes.get(infoName));
        }
        return resultingMap;
    }
}

