/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.generic;

import com.pingidentity.opentoken.TokenException;
import com.pingidentity.opentoken.TokenExpiredException;
import com.pingidentity.opentoken.generic.AgentConfiguration;
import com.pingidentity.opentoken.generic.Token;
import com.pingidentity.opentoken.generic.util.KeyValueSerializer;
import com.pingidentity.opentoken.generic.util.PingFederateMultiMap;
import com.pingidentity.opentoken.generic.util.PingFederateMultiMapUtil;
import com.pingidentity.opentoken.key.KeyManager;
import com.pingidentity.opentoken.key.PasswordKeyManager;
import com.pingidentity.opentoken.util.UrlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Agent {
    public static final String TOKEN_SUBJECT = "subject";
    public static final String TOKEN_NOT_BEFORE = "not-before";
    public static final String TOKEN_NOT_ON_OR_AFTER = "not-on-or-after";
    public static final String TOKEN_RENEW_UNTIL = "renew-until";
    public static final String OPENTOKEN_SYSTEM_DEBUG = "opentoken.debug";
    private static final Log log = LogFactory.getLog(Agent.class);
    private AgentConfiguration config;
    private String lastError;
    private KeyManager keyman;

    public Agent() {
        this.config = new AgentConfiguration();
        this.keyman = new PasswordKeyManager(this.config.getPasswordBytes(), this.config.getCipherSuite(), this.config.isUseSunJCE());
    }

    public Agent(AgentConfiguration configuration) {
        this.config = configuration.copy();
        this.keyman = new PasswordKeyManager(this.config.getPasswordBytes(), this.config.getCipherSuite(), this.config.isUseSunJCE());
    }

    public static Agent createUsingNativeMultiMap(String file) throws IOException {
        return new Agent(AgentConfiguration.createWithNativeMultiMap(file));
    }

    public static Agent createUsingNativeMultiMap(InputStream configStream) throws IOException {
        return new Agent(AgentConfiguration.createWithNativeMultiMap(configStream));
    }

    public void writeToken(Map ids, HttpServletResponse response, UrlHelper targetUrl) throws IOException, TokenException {
        this.writeToken(PingFederateMultiMapUtil.convertToMultiMap(ids), response, targetUrl, true);
    }

    public void writeToken(Map ids, HttpServletResponse response, String targetUrl) throws MalformedURLException, IOException, TokenException {
        this.writeToken(PingFederateMultiMapUtil.convertToMultiMap(ids), response, new UrlHelper(targetUrl), true);
    }

    public void writeToken(Map ids, HttpServletResponse response, UrlHelper targetUrl, boolean doRedirect) throws IOException, TokenException {
        this.writeToken(PingFederateMultiMapUtil.convertToMultiMap(ids), response, targetUrl, doRedirect);
    }

    public void writeToken(PingFederateMultiMap ids, HttpServletResponse response, String targetUrl) throws MalformedURLException, IOException, TokenException {
        this.writeToken(ids, response, new UrlHelper(targetUrl), true);
    }

    public void writeToken(PingFederateMultiMap ids, HttpServletResponse response, UrlHelper targetUrl) throws IOException, TokenException {
        this.writeToken(ids, response, targetUrl, true);
    }

    public void writeToken(PingFederateMultiMap ids, HttpServletResponse response, UrlHelper targetUrl, boolean doRedirect) throws IOException, TokenException {
        String token = this.writeToken(ids);
        this.setCookieOrParameterAndRedirect(token, response, targetUrl, doRedirect);
    }

    public String writeToken(PingFederateMultiMap ids) throws TokenException {
        if (!ids.containsKey(TOKEN_SUBJECT)) {
            throw new TokenException("Encode failed; token must include a subject key/value pair.");
        }
        Calendar notBefore = Calendar.getInstance(AgentConfiguration.UTC_TZ);
        Calendar notOnOrAfter = (Calendar)notBefore.clone();
        notOnOrAfter.add(13, this.config.getTokenLifetime());
        ids.remove(TOKEN_NOT_BEFORE);
        ids.remove(TOKEN_NOT_ON_OR_AFTER);
        ids.put(TOKEN_NOT_BEFORE, this.serializeDate(notBefore));
        ids.put(TOKEN_NOT_ON_OR_AFTER, this.serializeDate(notOnOrAfter));
        if (!ids.containsKey(TOKEN_RENEW_UNTIL)) {
            Calendar renewUntil = (Calendar)notBefore.clone();
            renewUntil.add(13, this.config.getRenewUntilLifetime());
            ids.put(TOKEN_RENEW_UNTIL, this.serializeDate(renewUntil));
        }
        String encodedToken = Token.encode(ids, this.keyman, this.config.isUseSunJCE(), this.config.isUseVerboseErrorMessages(), this.config.isRemoveTrailingBackslash());
        log.debug((Object)(this.config.getTokenName() + ": " + encodedToken));
        return encodedToken;
    }

    public Map readToken(HttpServletRequest request) throws TokenException {
        return PingFederateMultiMapUtil.convertFromMultiMap(this.readTokenToMultiMap(request));
    }

    public PingFederateMultiMap readTokenToMultiMap(HttpServletRequest request) throws TokenException {
        String token = this.getTokenFromRequest(request);
        if (null != token) {
            return this.readTokenToNativeMultiMap(token);
        }
        return null;
    }

    public Map readToken(String token) throws TokenException {
        return PingFederateMultiMapUtil.convertFromMultiMap(this.readTokenToNativeMultiMap(token));
    }

    public PingFederateMultiMap readTokenToNativeMultiMap(String token) throws TokenException {
        PingFederateMultiMap ids = Token.decodeNative(token, this.keyman, this.config.isUseSunJCE(), this.config.isUseVerboseErrorMessages());
        if (this.config.isDetectMalformedAttributes()) {
            PingFederateMultiMapUtil.checkForBadBackslashEscape(ids);
        }
        if (!ids.containsKey(TOKEN_SUBJECT)) {
            throw new TokenException("Token does not have a subject key/value pair.");
        }
        Calendar notBefore = null;
        Calendar notOnOrAfter = null;
        Calendar renewUntil = null;
        try {
            notBefore = this.parseDate(KeyValueSerializer.convertListToString(ids.get(TOKEN_NOT_BEFORE)));
            notOnOrAfter = this.parseDate(KeyValueSerializer.convertListToString(ids.get(TOKEN_NOT_ON_OR_AFTER)));
            renewUntil = this.parseDate(KeyValueSerializer.convertListToString(ids.get(TOKEN_RENEW_UNTIL)));
        }
        catch (ParseException e) {
            throw new TokenException("Invalid token; token lifetime fields are improperly formatted.", e);
        }
        catch (NullPointerException e) {
            throw new TokenException("Invalid token; missing not-before or not-on-or-after or renew-until fields.");
        }
        this.validateTokenLifetimes(notBefore, notOnOrAfter, renewUntil);
        return ids;
    }

    public PingFederateMultiMap readTokenToNativeMultiMap(HttpServletRequest request) throws TokenException {
        String token = this.getTokenFromRequest(request);
        return null == token ? null : this.readTokenToNativeMultiMap(token);
    }

    private void setCookieOrParameterAndRedirect(String token, HttpServletResponse response, UrlHelper targetUrl, boolean doRedirect) throws IOException {
        if (this.config.isUseCookie()) {
            StringBuilder cookie = new StringBuilder();
            if (this.config.getCookieDomain() != null && this.config.getCookieDomain().length() > 0) {
                cookie.append("Domain=" + this.config.getCookieDomain() + "; ");
            }
            if (!this.config.isSessionCookie()) {
                cookie.append("Max-Age=" + this.config.getTokenLifetime() + "; ");
            }
            if (this.config.isSecureCookie()) {
                cookie.append("Secure; ");
            }
            cookie.append("Path=" + this.config.getCookiePath() + "; ");
            if (this.config.isHttpOnly()) {
                cookie.append("HttpOnly; ");
            }
            StringBuilder legacyCookie = new StringBuilder(cookie);
            legacyCookie.insert(0, this.config.getTokenName() + "-legacy=" + token + "; ");
            cookie.insert(0, this.config.getTokenName() + "=" + token + "; ");
            if (this.config.hasSameSiteCookieAttr()) {
                String samesite = this.config.getSameSiteCookieAttr();
                if (samesite.equals("None") && !this.config.isSecureCookie()) {
                    log.debug((Object)"Received SameSite None but Secure is false. So skip setting SameSite attribute");
                } else if (samesite.equals("Strict") || samesite.equals("Lax") || samesite.equals("None")) {
                    cookie.append("SameSite=" + samesite);
                }
            }
            response.addHeader("Set-Cookie", cookie.toString());
            response.addHeader("Set-Cookie", legacyCookie.toString());
        } else {
            targetUrl.addParameter(this.config.getTokenName(), token);
        }
        if (doRedirect) {
            response.sendRedirect(targetUrl.toString());
        }
    }

    private String getTokenFromRequest(HttpServletRequest request) {
        String token = null;
        String tokenName = this.config.getTokenName();
        if (this.config.isUseCookie()) {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie c = cookies[i];
                    if (!c.getName().equals(tokenName) && !c.getName().equals(tokenName + "-legacy")) continue;
                    token = c.getValue();
                }
            }
            if (token == null) {
                this.lastError = "No cookie token found named '" + tokenName + "'";
                return null;
            }
        } else {
            token = request.getParameter(this.config.getTokenName());
            if (token == null) {
                this.lastError = "No query parameter token found named '" + tokenName + "'";
                return null;
            }
        }
        log.debug((Object)(tokenName + ": " + token));
        return token;
    }

    String serializeDate(Calendar c) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(AgentConfiguration.UTC_TZ);
        return formatter.format(c.getTime());
    }

    Calendar parseDate(String s) throws ParseException {
        Calendar result = Calendar.getInstance(AgentConfiguration.UTC_TZ);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        formatter.setTimeZone(AgentConfiguration.UTC_TZ);
        result.setTime(formatter.parse(s));
        return result;
    }

    private void validateTokenLifetimes(Calendar notBefore, Calendar notOnOrAfter, Calendar renewUntil) throws TokenException {
        Calendar now = Calendar.getInstance(AgentConfiguration.UTC_TZ);
        Calendar futureNow = (Calendar)now.clone();
        futureNow.add(13, this.config.getNotBeforeTolerance());
        if (notBefore.after(notOnOrAfter)) {
            throw new TokenException("Invalid token; not-on-or-after precedes not-before.");
        }
        if (notBefore.after(now) && notBefore.after(futureNow)) {
            throw new TokenException("Invalid token; token is not yet valid (not-before > now)");
        }
        if (now.after(notOnOrAfter)) {
            throw new TokenExpiredException("Invalid token; token has expired (now > not-on-or-after)");
        }
        if (now.after(renewUntil)) {
            throw new TokenExpiredException("Invalid token; token may no longer be renewed (now > renew-until");
        }
    }

    public String getLastError() {
        return this.lastError;
    }

    KeyManager getKeyManager() {
        return this.keyman;
    }

    public AgentConfiguration getAgentConfiguration() {
        try {
            AgentConfiguration clone = (AgentConfiguration)this.config.clone();
            clone.setObfuscatePassword(this.config.isObfuscatePassword());
            return clone;
        }
        catch (Exception e) {
            return null;
        }
    }
}

