/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.generic;

import com.pingidentity.opentoken.generic.util.AgentConfigurationUtil;
import com.pingidentity.opentoken.generic.util.KeyValueSerializer;
import com.pingidentity.opentoken.generic.util.PingFederateMultiMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentConfiguration
implements Cloneable {
    public static final boolean USE_VERBOSE_TOKEN_EXCEPTION_MESSAGES_DEFAULT = false;
    public static final boolean DETECT_MALFORMED_ATTRIBUTES_DEFAULT = false;
    public static final boolean REMOVE_TRAILING_BACKSLASH_DEFAULT = false;
    public static final int TOKEN_LIFETIME_DEFAULT = 300;
    public static final int RENEW_UNTIL_LIFETIME_DEFALUT = 43200;
    public static final int NOT_BEFORE_TOLERANCE_DEFAULT = 120;
    public static final boolean USE_SUN_JCE_DEFAULT = false;
    public static final boolean OBFUSCATE_PASSWORD_DEFAULT = true;
    public static final boolean SESSION_COOKIE_DEFAULT = false;
    public static final boolean SECURE_COOKIE_DEFAULT = true;
    public static final boolean USE_COOKIE_DEFAULT = false;
    public static final String COOKIE_SAMESITE_DEFAULT = "Nothing";
    public static final String COOKIE_PATH_DEFAULT = "/";
    public static final String COOKIE_DOMAIN_DEFAULT = "";
    public static final String TOKEN_NAME_DEFAULT = "opentoken";
    public static final boolean HTTP_ONLY_DEFAULT = true;
    public static final String AGENT_CONFIG_FILE_DEFALUT = "agent-config.txt";
    public static final boolean TRACK_AUTHNTIME_DEFAULT = true;
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    private boolean useVerboseErrorMessages = false;
    private boolean removeTrailingBackslash = false;
    private boolean detectMalformedAttributes = false;
    private int tokenLifetime = 300;
    private int renewUntilLifetime = 43200;
    private int notBeforeTolerance = 120;
    private int cipherSuite = 0;
    private boolean useSunJCE = false;
    private boolean obfuscatePassword = true;
    private String sameSiteCookie = "Nothing";
    private boolean sessionCookie = false;
    private boolean secureCookie = true;
    private boolean useCookie = false;
    private String cookiePath = "/";
    private String cookieDomain = "";
    private byte[] password = null;
    private String tokenName = "opentoken";
    private boolean httpOnly = true;
    private boolean trackAuthnTime = true;
    private static final Log log = LogFactory.getLog(AgentConfiguration.class);

    public boolean isUseVerboseErrorMessages() {
        return this.useVerboseErrorMessages;
    }

    public void setUseVerboseErrorMessages(boolean useVerboseErrorMessages) {
        this.useVerboseErrorMessages = useVerboseErrorMessages;
    }

    public boolean isRemoveTrailingBackslash() {
        return this.removeTrailingBackslash;
    }

    public void setRemoveTrailingBackslash(boolean removeTrailingBackslash) {
        this.removeTrailingBackslash = removeTrailingBackslash;
    }

    public boolean isDetectMalformedAttributes() {
        return this.detectMalformedAttributes;
    }

    public void setDetectMalformedAttributes(boolean detectMalformedAttributes) {
        this.detectMalformedAttributes = detectMalformedAttributes;
    }

    public int getTokenLifetime() {
        return this.tokenLifetime;
    }

    public void setTokenLifetime(int tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    public int getRenewUntilLifetime() {
        return this.renewUntilLifetime;
    }

    public void setRenewUntilLifetime(int renewUntilLifetime) {
        this.renewUntilLifetime = renewUntilLifetime;
    }

    public int getNotBeforeTolerance() {
        return this.notBeforeTolerance;
    }

    public void setNotBeforeTolerance(int notBeforeTolerance) {
        this.notBeforeTolerance = notBeforeTolerance;
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public void setCipherSuite(int cipherSuite) {
        this.cipherSuite = cipherSuite;
    }

    public boolean isUseSunJCE() {
        return this.useSunJCE;
    }

    public void setUseSunJCE(boolean useSunJCE) {
        this.useSunJCE = useSunJCE;
    }

    public boolean isObfuscatePassword() {
        return this.obfuscatePassword;
    }

    public void setObfuscatePassword(boolean obfuscatePassword) {
        this.obfuscatePassword = obfuscatePassword;
    }

    public void setObfuscatePasword(boolean obfuscatePassword) {
        this.obfuscatePassword = obfuscatePassword;
    }

    public boolean hasSameSiteCookieAttr() {
        return !this.sameSiteCookie.equals(COOKIE_SAMESITE_DEFAULT);
    }

    public String getSameSiteCookieAttr() {
        return this.sameSiteCookie;
    }

    public void setSameSiteCookieAttr(String attribute) {
        this.sameSiteCookie = attribute;
    }

    public boolean isSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(boolean sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public boolean isSecureCookie() {
        return this.secureCookie;
    }

    public void setSecureCookie(boolean secureCookie) {
        this.secureCookie = secureCookie;
    }

    public boolean isUseCookie() {
        return this.useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this.useCookie = useCookie;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public String getPassword() {
        if (this.password != null && this.password.length > 0) {
            try {
                return new String(this.password, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.password);
            }
        }
        return null;
    }

    public void setPassword(String password) {
        if (password != null) {
            try {
                this.password = new byte[password.length()];
                System.arraycopy(password.getBytes("UTF-8"), 0, this.password, 0, password.length());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public void setPassword(byte[] password) {
        if (password != null && password.length > 0) {
            this.password = new byte[password.length];
            System.arraycopy(password, 0, this.password, 0, password.length);
        }
    }

    public byte[] getPasswordBytes() {
        return this.password;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean isTrackAuthnTime() {
        return this.trackAuthnTime;
    }

    public void setTrackAuthnTime(boolean trackAuthnTime) {
        this.trackAuthnTime = trackAuthnTime;
    }

    public static AgentConfiguration createWithNativeMultiMap(InputStream configStream) throws IOException {
        try {
            PingFederateMultiMap map = KeyValueSerializer.deserializeNative(configStream);
            AgentConfiguration agentConfiguration = AgentConfigurationUtil.createWithNativeMultiMap(map);
            return agentConfiguration;
        }
        finally {
            if (null != configStream) {
                configStream.close();
            }
        }
    }

    public static AgentConfiguration createWithNativeMultiMap(String file) throws IOException {
        InputStream configStream = AgentConfiguration.class.getClassLoader().getResourceAsStream(file);
        try {
            if (null == configStream) {
                configStream = new ByteArrayInputStream(AgentConfiguration.getBytesFromFile(file));
            }
            AgentConfiguration agentConfiguration = AgentConfiguration.createWithNativeMultiMap(configStream);
            return agentConfiguration;
        }
        finally {
            if (null != configStream) {
                configStream.close();
            }
        }
    }

    public AgentConfiguration copy() {
        try {
            AgentConfiguration clone = (AgentConfiguration)this.clone();
            clone.setPassword(this.getPasswordBytes());
            clone.setObfuscatePassword(this.isObfuscatePassword());
            return clone;
        }
        catch (Exception e) {
            log.debug((Object)"Unable to copy AgentConfiguration object.", (Throwable)e);
            return null;
        }
    }

    public Object clone() {
        AgentConfiguration clone = null;
        try {
            clone = (AgentConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.debug((Object)"Unable to clone AgentConfiguration object.", (Throwable)e);
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesFromFile(String FilePath) throws IOException {
        File file = new File(FilePath);
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }
}

