/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.generic;

import com.pingidentity.opentoken.TokenException;
import com.pingidentity.opentoken.generic.util.KeyValueSerializer;
import com.pingidentity.opentoken.generic.util.PingFederateMultiMap;
import com.pingidentity.opentoken.generic.util.TokenUtil;
import com.pingidentity.opentoken.key.KeyManager;
import com.pingidentity.opentoken.mac.MACInputStream;
import com.pingidentity.opentoken.mac.MACOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

public class Token {
    public static final int CIPHER_SUITE_NULL = 0;
    public static final int CIPHER_SUITE_AES256CBC = 1;
    public static final int CIPHER_SUITE_AES128CBC = 2;
    public static final int CIPHER_SUITE_3DES168CBC = 3;
    public static final String SUN_CRYPTO_PROVIDER = "SunJCE";
    public static final byte[] V1_HEADER = new byte[]{79, 84, 75, 1};
    private static final byte[] EMPTY_PAYLOAD_LEN = new byte[]{0, 0};
    public static final byte[] V1_MAC = new byte[20];
    public static final int V1_MAC_POS = 5;
    public static final int V1_CS_POS = 4;
    public static final int V1_IVLEN_POS = 25;
    public static final int V1_IV_POS = 26;

    private Token() {
    }

    public static String encode(PingFederateMultiMap values, KeyManager keyman, boolean useSunJCE, boolean useVerboseErrorMessages, boolean removeTrailingBackslashes) throws TokenException {
        KeyManager.KeyInfo keyinfo = keyman.getEncryptKey();
        if (!TokenUtil.validateKey(keyinfo.cipherSuite, keyinfo.key)) {
            throw new TokenException("Wrong type of key provided for this cipher suite.");
        }
        if (keyinfo.metadata != null && keyinfo.metadata.length > 255) {
            throw new TokenException("Key metadata is longer than 255 bytes.");
        }
        Cipher cipher = TokenUtil.setupCipher(keyinfo.cipherSuite, keyinfo.key, 1, null, useSunJCE);
        byte[] iv = cipher.getIV();
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(V1_HEADER);
            os.write(keyinfo.cipherSuite);
            os.write(V1_MAC);
            int payloadOffset = 26;
            if (keyinfo.cipherSuite != 0 && iv != null && iv.length > 0) {
                os.write((byte)iv.length);
                os.write(iv);
                payloadOffset += iv.length;
            } else {
                os.write(0);
            }
            if (keyinfo.metadata != null && keyinfo.metadata.length > 0) {
                os.write((byte)keyinfo.metadata.length);
                os.write(keyinfo.metadata);
                payloadOffset += 1 + keyinfo.metadata.length;
            } else {
                os.write(0);
                ++payloadOffset;
            }
            os.write(EMPTY_PAYLOAD_LEN);
            payloadOffset += 2;
            boolean useCompression = true;
            String debug = System.getProperty("opentoken.debug");
            if (debug != null && debug.equals("true")) {
                useCompression = false;
            }
            MACOutputStream mos = useCompression ? new MACOutputStream(new DeflaterOutputStream(new CipherOutputStream(os, cipher)), keyinfo.key, useSunJCE) : new MACOutputStream(new DeflaterOutputStream((OutputStream)new CipherOutputStream(os, cipher), new Deflater(0)), keyinfo.key, useSunJCE);
            mos.getMAC().update((byte)1);
            mos.getMAC().update((byte)keyinfo.cipherSuite);
            if (keyinfo.cipherSuite != 0 && iv != null && iv.length > 0) {
                mos.getMAC().update(iv);
            }
            if (keyinfo.metadata != null && keyinfo.metadata.length > 0) {
                mos.getMAC().update(keyinfo.metadata);
            }
            KeyValueSerializer.serialize(values, mos, removeTrailingBackslashes);
            mos.close();
            byte[] rawToken = os.toByteArray();
            byte[] payloadLen = TokenUtil.shortToNetwork(rawToken.length - payloadOffset);
            if (payloadLen == null) {
                throw new TokenException("Encoding failed; payload length exceeds 65k.");
            }
            byte[] finalMac = mos.getMAC().doFinal();
            System.arraycopy(finalMac, 0, rawToken, 5, finalMac.length);
            System.arraycopy(payloadLen, 0, rawToken, payloadOffset - 2, payloadLen.length);
            return TokenUtil.b64encode(rawToken);
        }
        catch (IOException e) {
            throw new TokenException("Stream error occurred while encoding the token", e);
        }
    }

    public static PingFederateMultiMap decodeNative(String token, KeyManager keyman, boolean useSunJCE, boolean useVerboseErrorMessages) throws TokenException {
        PingFederateMultiMap result = null;
        try {
            MACInputStream is = TokenUtil.validateTokenAndGetInputStream(token, keyman, useSunJCE, useVerboseErrorMessages);
            byte[] datamac = TokenUtil.getDatamac(token);
            try {
                result = KeyValueSerializer.deserializeNative(is);
            }
            catch (IOException e) {
                throw new TokenException("Stream error occurred while decoding the token", e);
            }
            if (!Arrays.equals(datamac, is.getMAC().doFinal())) {
                throw new TokenException("MAC verification failed.");
            }
        }
        catch (Exception e) {
            if (useVerboseErrorMessages) {
                throw new TokenException(e.getMessage(), e);
            }
            throw new TokenException("Error");
        }
        return result;
    }
}

