/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.generic.util;

import com.pingidentity.opentoken.TokenException;
import com.pingidentity.opentoken.generic.Token;
import com.pingidentity.opentoken.key.KeyManager;
import com.pingidentity.opentoken.mac.MACInputStream;
import com.pingidentity.opentoken.util.Base64;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class TokenUtil {
    public static Cipher setupCipher(int cipherSuite, SecretKey key, int opmode, AlgorithmParameterSpec params, boolean useSunJCE) {
        try {
            Cipher result = null;
            switch (cipherSuite) {
                case 0: {
                    result = new NullCipher();
                    break;
                }
                case 1: 
                case 2: {
                    result = useSunJCE ? Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE") : Cipher.getInstance("AES/CBC/PKCS5Padding");
                    result.init(opmode, (Key)key, params);
                    break;
                }
                case 3: {
                    result = useSunJCE ? Cipher.getInstance("DESede/CBC/PKCS5Padding", "SunJCE") : Cipher.getInstance("DESede/CBC/PKCS5Padding");
                    result.init(opmode, (Key)key, params);
                }
            }
            return result;
        }
        catch (InvalidKeyException e) {
            if (cipherSuite == 1) {
                throw new RuntimeException("The unlimited strength JCE may not be installed to allow cipher suite AES-256/CBC", e);
            }
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getDatamac(String token) {
        byte[] rawdata = TokenUtil.b64decode(token);
        byte[] datamac = new byte[Token.V1_MAC.length];
        System.arraycopy(rawdata, 5, datamac, 0, Token.V1_MAC.length);
        return datamac;
    }

    public static MACInputStream validateTokenAndGetInputStream(String token, KeyManager keyman, boolean useSunJCE, boolean useVerboseErrorMessages) throws TokenException {
        try {
            byte[] rawdata = TokenUtil.b64decode(token);
            if (rawdata == null) {
                throw new TokenException("Base64 decoding of token failed.");
            }
            for (int i = 0; i < Token.V1_HEADER.length; ++i) {
                if (rawdata[i] == Token.V1_HEADER[i]) continue;
                throw new TokenException("Invalid token header.");
            }
            byte cipherSuite = rawdata[4];
            if (cipherSuite < 0 || cipherSuite > 3) {
                throw new TokenException("Unknown cipher suite used in token.");
            }
            byte[] datamac = new byte[Token.V1_MAC.length];
            System.arraycopy(rawdata, 5, datamac, 0, Token.V1_MAC.length);
            byte ivlen = rawdata[25];
            if (!TokenUtil.validateIV(ivlen, cipherSuite)) {
                throw new TokenException("Decode failed; IV length does not work with selected cipher suite.");
            }
            IvParameterSpec ivSpec = null;
            if (ivlen > 0) {
                ivSpec = new IvParameterSpec(rawdata, 26, ivlen);
            }
            int keymetadataLenOffset = 26 + ivlen;
            byte keymetadataLen = rawdata[keymetadataLenOffset];
            byte[] keymetadata = null;
            if (keymetadataLen > 0) {
                throw new TokenException("Decode failed; keyinfo metadata value not supported.");
            }
            KeyManager.KeyInfo keyinfo = keyman.getDecryptKey(keymetadata);
            if (cipherSuite != keyinfo.cipherSuite) {
                throw new TokenException("Decode failed; cipher suite in token does not match cipher suite used by key manager.");
            }
            if (!TokenUtil.validateKey(cipherSuite, keyinfo.key)) {
                throw new TokenException("Decode failed; cipher suite in token does not work with provided key.");
            }
            Cipher cipher = TokenUtil.setupCipher(cipherSuite, keyinfo.key, 2, ivSpec, useSunJCE);
            int payloadLenOffset = keymetadataLenOffset + keymetadataLen + 1;
            int payloadLen = TokenUtil.networkToShort(rawdata, payloadLenOffset);
            int payloadOffset = payloadLenOffset + 2;
            ByteArrayInputStream bis = new ByteArrayInputStream(rawdata, payloadOffset, payloadLen);
            MACInputStream is = new MACInputStream(new InflaterInputStream(new CipherInputStream(bis, cipher)), keyinfo.key, useSunJCE);
            is.getMAC().update((byte)1);
            is.getMAC().update(cipherSuite);
            if (cipherSuite != 0 && ivSpec != null) {
                is.getMAC().update(ivSpec.getIV());
            }
            return is;
        }
        catch (Exception e) {
            if (useVerboseErrorMessages) {
                throw new TokenException(e.getMessage(), e);
            }
            throw new TokenException("Error");
        }
    }

    public static boolean validateIV(int ivlen, int cipherSuite) {
        switch (cipherSuite) {
            case 0: {
                return ivlen == 0;
            }
            case 1: 
            case 2: {
                return ivlen == 16;
            }
            case 3: {
                return ivlen == 8;
            }
        }
        return false;
    }

    public static byte[] b64decode(String data) {
        char[] c = data.toCharArray();
        for (int i = c.length - 1; i >= 0 && c[i] == '*'; --i) {
            c[i] = 61;
        }
        return Base64.decode(new String(c), 24);
    }

    public static String b64encode(byte[] data) {
        String b64 = Base64.encodeBytes(data, 24);
        char[] c = b64.toCharArray();
        for (int i = c.length - 1; i >= 0 && c[i] == '='; --i) {
            c[i] = 42;
        }
        return new String(c);
    }

    public static int networkToShort(byte[] value, int offset) {
        int result = 0;
        result += (value[offset] & 0xFF) << 8;
        return result += value[offset + 1] & 0xFF;
    }

    public static byte[] shortToNetwork(int value) {
        if (value > 65536) {
            return null;
        }
        return new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static boolean validateKey(int cipherSuite, SecretKey key) {
        switch (cipherSuite) {
            case 0: {
                return key == null;
            }
            case 1: {
                return key != null && "AES".equals(key.getAlgorithm()) && key.getEncoded().length == 32;
            }
            case 2: {
                return key != null && "AES".equals(key.getAlgorithm()) && key.getEncoded().length == 16;
            }
            case 3: {
                return key != null && "DESede".equals(key.getAlgorithm()) && key.getEncoded().length == 24;
            }
        }
        return false;
    }
}

