/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.opentoken.mac;

import com.pingidentity.opentoken.mac.HmacSHA1Wrapper;
import com.pingidentity.opentoken.mac.MACWrapper;
import com.pingidentity.opentoken.mac.NormalSHA1Wrapper;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.SecretKey;

public class MACInputStream
extends FilterInputStream {
    private MACWrapper mac;

    public MACInputStream(InputStream in, SecretKey key, boolean useSunJCE) {
        super(in);
        this.mac = key != null ? new HmacSHA1Wrapper(key, useSunJCE) : new NormalSHA1Wrapper(useSunJCE);
    }

    public MACWrapper getMAC() {
        return this.mac;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result > -1) {
            this.mac.update((byte)result);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result > -1) {
            this.mac.update(b, off, result);
        }
        return result;
    }
}

