/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.crypto;

import com.pingidentity.pingcommons.crypto.ObfuscationException;
import com.pingidentity.pingcommons.crypto.PasswordUtil;
import com.pingidentity.pingcommons.crypto.SecretObfuscator;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class JweSecretObfuscator
implements SecretObfuscator {
    private JsonWebKeySet jwks;

    public JweSecretObfuscator(JsonWebKeySet jwks) {
        this.jwks = jwks;
    }

    public JweSecretObfuscator(JsonWebKey jwk) {
        this.jwks = new JsonWebKeySet(new JsonWebKey[]{jwk});
    }

    @Override
    public String obfuscate(String secret) throws ObfuscationException {
        if (this.jwks.getJsonWebKeys().isEmpty()) {
            throw new ObfuscationException("JWK set is empty");
        }
        try {
            return PasswordUtil.obfuscateAndEncode(secret, (JsonWebKey)this.jwks.getJsonWebKeys().get(0));
        }
        catch (JoseException e) {
            throw new ObfuscationException("Failed to obfuscate text", e);
        }
    }

    @Override
    public String deobfuscate(String obfuscated) throws ObfuscationException {
        String result = null;
        try {
            result = PasswordUtil.decodeAndDeobfuscate(obfuscated, this.jwks);
        }
        catch (JoseException e) {
            throw new ObfuscationException("Failed to deobfuscate text", e);
        }
        if (result == null) {
            throw new ObfuscationException("Failed to deobfuscate text, format may be invalid or decryption key may be missing from key set");
        }
        return result;
    }
}

