/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.format;

import com.google.common.collect.Table;
import com.pingidentity.pingcommons.format.HorizontalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TableFormatter {
    private int columnSpacing = 2;
    private char columnHeaderChar = (char)45;
    private boolean includeRowLabels = false;
    private boolean includeColumnLabels = true;
    private HorizontalAlignment columnAlignment = HorizontalAlignment.LEFT;

    public TableFormatter setColumnSpacing(int columnSpacing) {
        this.columnSpacing = columnSpacing;
        return this;
    }

    public TableFormatter setColumnHeaderChar(char columnHeaderChar) {
        this.columnHeaderChar = columnHeaderChar;
        return this;
    }

    public TableFormatter setIncludeRowLabels(boolean includeRowLabels) {
        this.includeRowLabels = includeRowLabels;
        return this;
    }

    public TableFormatter setIncludeColumnLabels(boolean includeColumnLabels) {
        this.includeColumnLabels = includeColumnLabels;
        return this;
    }

    public TableFormatter setColumnAlignment(HorizontalAlignment columnAlignment) {
        this.columnAlignment = Objects.requireNonNull(columnAlignment, "columnAlignment");
        return this;
    }

    public <R, C, V> String format(Table<R, C, V> table) {
        int c;
        if (table == null) {
            return "null";
        }
        if (table.isEmpty()) {
            return "(empty)";
        }
        ArrayList rows = new ArrayList(table.rowKeySet());
        ArrayList cols = new ArrayList(table.columnKeySet());
        List rowNames = rows.stream().map(String::valueOf).collect(Collectors.toList());
        List colNames = cols.stream().map(String::valueOf).collect(Collectors.toList());
        int rowCount = rows.size();
        int colCount = cols.size();
        String[][] values = new String[rowCount][colCount];
        for (int r = 0; r < rowCount; ++r) {
            for (c = 0; c < colCount; ++c) {
                Object row = rows.get(r);
                Object col = cols.get(c);
                Object value = table.get(row, col);
                values[r][c] = String.valueOf(value);
            }
        }
        int[] widths = new int[colCount];
        for (c = 0; c < colCount; ++c) {
            widths[c] = ((String)colNames.get(c)).length();
            for (int r = 0; r < rowCount; ++r) {
                widths[c] = Math.max(widths[c], values[r][c].length());
            }
        }
        int rowNameWidth = 0;
        for (String name : rowNames) {
            rowNameWidth = Math.max(rowNameWidth, name.length());
        }
        StringBuilder sb = new StringBuilder();
        if (this.includeColumnLabels) {
            int c2;
            if (this.includeRowLabels) {
                TableFormatter.appendSpaces(rowNameWidth + this.columnSpacing, sb);
            }
            for (c2 = 0; c2 < colCount; ++c2) {
                this.appendPadded((String)colNames.get(c2), widths[c2], sb);
                TableFormatter.appendSpaces(this.columnSpacing, sb);
            }
            sb.append("\n");
            if (this.includeRowLabels) {
                TableFormatter.appendSpaces(rowNameWidth + this.columnSpacing, sb);
            }
            for (c2 = 0; c2 < colCount; ++c2) {
                TableFormatter.appendRepeated(this.columnHeaderChar, widths[c2], sb);
                TableFormatter.appendSpaces(this.columnSpacing, sb);
            }
            sb.append("\n");
        }
        for (int r = 0; r < rowCount; ++r) {
            if (this.includeRowLabels) {
                this.appendPadded((String)rowNames.get(r), rowNameWidth, sb);
                TableFormatter.appendSpaces(this.columnSpacing, sb);
            }
            for (int c3 = 0; c3 < colCount; ++c3) {
                this.appendPadded(values[r][c3], widths[c3], sb);
                TableFormatter.appendSpaces(this.columnSpacing, sb);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void appendRepeated(char c, int n, StringBuilder sb) {
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
    }

    private static void appendSpaces(int n, StringBuilder sb) {
        TableFormatter.appendRepeated(' ', n, sb);
    }

    private void appendPadded(String value, int width, StringBuilder sb) {
        int right;
        int left;
        int padding = width - value.length();
        switch (this.columnAlignment) {
            case LEFT: {
                left = 0;
                right = padding;
                break;
            }
            case CENTER: {
                left = padding / 2;
                right = padding - left;
                break;
            }
            default: {
                left = padding;
                right = 0;
            }
        }
        TableFormatter.appendSpaces(left, sb);
        sb.append(value);
        TableFormatter.appendSpaces(right, sb);
    }
}

