/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.http.uri;

import com.pingidentity.pingcommons.http.uri.AbsoluteFormUri;
import com.pingidentity.pingcommons.http.uri.HttpUri;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import com.pingidentity.pingcommons.http.uri.LocationUri;
import com.pingidentity.pingcommons.http.uri.NormalizeOriginFormUri;
import com.pingidentity.pingcommons.http.uri.NormalizeStrictOriginFormUri;
import com.pingidentity.pingcommons.http.uri.OriginFormUri;
import com.pingidentity.pingcommons.http.uri.OriginUri;
import com.pingidentity.pingcommons.http.uri.RedirectUri;
import com.pingidentity.pingcommons.http.uri.StrictAbsoluteFormUri;
import com.pingidentity.pingcommons.http.uri.StrictLocationUri;
import com.pingidentity.pingcommons.http.uri.StrictOriginFormUri;
import com.pingidentity.pingcommons.http.uri.StrictRedirectUri;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUriFactory {
    public static final Params DEFUALT_PARAMS = new Params(false, "");
    private static final Logger logger = LoggerFactory.getLogger(HttpUriFactory.class);
    private final Mode mode;
    private final Params params;

    private HttpUriFactory(Mode mode, Params params) {
        this.mode = mode;
        this.params = params;
    }

    public static HttpUriFactory createOriginFormUriFactory(Params params) {
        return new HttpUriFactory(Mode.REQUEST_ORIGIN_FORM, params);
    }

    public static HttpUriFactory createAbsoluteFormUriFactory(Params params) {
        return new HttpUriFactory(Mode.ABSOLUTE_FORM, params);
    }

    public static HttpUriFactory createRedirectUriFactory(Params params) {
        return new HttpUriFactory(Mode.REDIRECT_URI, params);
    }

    public static HttpUriFactory createLocationUriFactory(Params params) {
        return new HttpUriFactory(Mode.LOCATION, params);
    }

    public static HttpUriFactory createOriginFactory(Params params) {
        return new HttpUriFactory(Mode.ORIGIN, params);
    }

    public HttpUri create(String rawUri) throws InvalidHttpUriException {
        try {
            switch (this.mode) {
                case REDIRECT_URI: {
                    if (this.params.isStrict()) {
                        return new StrictRedirectUri(rawUri);
                    }
                    return new RedirectUri(rawUri);
                }
                case LOCATION: {
                    if (this.params.isStrict()) {
                        return new StrictLocationUri(rawUri);
                    }
                    return new LocationUri(rawUri);
                }
                case ABSOLUTE_FORM: {
                    if (this.params.isStrict()) {
                        return new StrictAbsoluteFormUri(rawUri);
                    }
                    return new AbsoluteFormUri(rawUri);
                }
                case ORIGIN: {
                    return new OriginUri(rawUri);
                }
            }
            if (this.params.isStrict()) {
                if (this.params.isNormalize()) {
                    return new NormalizeStrictOriginFormUri(rawUri, this.params.isCanonicalize());
                }
                return new StrictOriginFormUri(rawUri);
            }
            if (this.params.isNormalize()) {
                return new NormalizeOriginFormUri(rawUri, this.params.isCanonicalize());
            }
            return new OriginFormUri(rawUri);
        }
        catch (InvalidHttpUriException e) {
            Throwable cause;
            if (this.params.isStrict() && (cause = e.getCause()) instanceof URISyntaxException && HttpUriFactory.syntaxErrorInQueryFragment((URISyntaxException)cause)) {
                logger.error(this.params.getStrictUriErrorMessage(), (Object)e.getRawUri());
            }
            throw e;
        }
    }

    private static boolean syntaxErrorInQueryFragment(URISyntaxException e) {
        int index = e.getIndex();
        String input = e.getInput();
        String reason = e.getReason();
        if (reason != null && input != null && index != -1 && reason.contains("Illegal character")) {
            int queryIndex = input.indexOf(63);
            int fragmentIndex = input.indexOf(35);
            if (queryIndex != -1 && index > queryIndex || fragmentIndex != -1 && index > fragmentIndex) {
                return true;
            }
        }
        return false;
    }

    public static final class Params {
        private final boolean strict;
        private final String strictUriErrorMessage;
        private final boolean normalize;
        private final boolean canonicalize;

        public Params(boolean strict, String strictUriErrorMessage) {
            this.strict = strict;
            this.strictUriErrorMessage = strictUriErrorMessage;
            this.normalize = false;
            this.canonicalize = false;
        }

        public Params(boolean strict, String strictUriErrorMessage, boolean normalize, boolean canonicalize) {
            this.strict = strict;
            this.strictUriErrorMessage = strictUriErrorMessage;
            this.normalize = normalize;
            this.canonicalize = canonicalize;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public String getStrictUriErrorMessage() {
            return this.strictUriErrorMessage;
        }

        public boolean isNormalize() {
            return this.normalize;
        }

        public boolean isCanonicalize() {
            return this.canonicalize;
        }
    }

    private static enum Mode {
        REQUEST_ORIGIN_FORM,
        ABSOLUTE_FORM,
        REDIRECT_URI,
        ORIGIN,
        LOCATION;

    }
}

