/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.http.uri;

import com.pingidentity.pingcommons.http.uri.BaseHttpUri;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import com.pingidentity.pingcommons.http.uri.OriginFormRequestTargetUtil;
import com.pingidentity.pingcommons.http.uri.OriginFormUri;
import com.pingidentity.pingcommons.http.uri.QueryFragmentParser;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizeOriginFormUri
extends BaseHttpUri {
    private static final Logger logger = LoggerFactory.getLogger(OriginFormUri.class);
    private final URI prefix;
    private final String query;

    NormalizeOriginFormUri(String rawRequestTarget, boolean canonicalize) throws InvalidHttpUriException {
        OriginFormRequestTargetUtil.validateRawRequestTarget(rawRequestTarget);
        QueryFragmentParser queryFragmentParser = new QueryFragmentParser(rawRequestTarget);
        this.query = queryFragmentParser.getQuery();
        if (queryFragmentParser.getFragment() != null) {
            logger.debug("Fragment silently removed from origin-form URI '{}'", (Object)rawRequestTarget);
        }
        try {
            String path = canonicalize ? OriginFormRequestTargetUtil.canonicalizeUri(queryFragmentParser.getPrefix()) : queryFragmentParser.getPrefix();
            this.prefix = OriginFormRequestTargetUtil.createUri(path).normalize();
        }
        catch (URISyntaxException e) {
            throw new InvalidHttpUriException(rawRequestTarget, "request-target path is invalid", e);
        }
    }

    @Override
    public String getScheme() {
        return null;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public String getPath() {
        return this.prefix.getRawPath();
    }

    @Override
    public String getDecodedPath() {
        return this.prefix.getPath();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public String getFragment() {
        return null;
    }
}

