/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.http.uri;

import com.pingidentity.pingcommons.http.uri.BaseHttpUri;
import com.pingidentity.pingcommons.http.uri.InvalidHttpUriException;
import com.pingidentity.pingcommons.lang.EOLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class OriginUri
extends BaseHttpUri {
    private final URI originUri;

    OriginUri(String inputUri) throws InvalidHttpUriException {
        String authority;
        URI parsedUri;
        if (StringUtils.isBlank((String)inputUri)) {
            throw new InvalidHttpUriException(inputUri, "An origin cannot be empty");
        }
        if (EOLUtil.hasEOLs(inputUri)) {
            throw new InvalidHttpUriException(inputUri, "An origin cannot contain EOL characters");
        }
        try {
            parsedUri = new URI(inputUri);
        }
        catch (URISyntaxException e) {
            throw new InvalidHttpUriException(inputUri, "Invalid origin", e);
        }
        if (parsedUri.getScheme() == null) {
            throw new InvalidHttpUriException(inputUri, "An origin must be of the form scheme://host:port");
        }
        if (parsedUri.getRawAuthority() == null) {
            throw new InvalidHttpUriException(inputUri, "An origin must be of the form scheme://host:port");
        }
        int port = parsedUri.getPort();
        if (port != -1 && (port < 1 || port > 65535)) {
            throw new InvalidHttpUriException(inputUri, "Invalid port in origin");
        }
        switch (parsedUri.getScheme()) {
            case "http": {
                if (parsedUri.getPort() == -1) {
                    authority = parsedUri.getRawAuthority() + ":" + 80;
                    break;
                }
                authority = parsedUri.getRawAuthority();
                break;
            }
            case "https": {
                if (parsedUri.getPort() == -1) {
                    authority = parsedUri.getRawAuthority() + ":" + 443;
                    break;
                }
                authority = parsedUri.getRawAuthority();
                break;
            }
            default: {
                throw new InvalidHttpUriException(inputUri, "Invalid scheme in origin '" + inputUri + "'");
            }
        }
        try {
            this.originUri = new URI(parsedUri.getScheme(), authority.toLowerCase(Locale.ENGLISH), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new InvalidHttpUriException(inputUri, "Invalid origin '" + inputUri + "'");
        }
    }

    @Override
    public String getUri() {
        return this.originUri.toASCIIString();
    }

    @Override
    public String getResourceUri() {
        return this.originUri.toASCIIString();
    }

    @Override
    public String getScheme() {
        return this.originUri.getScheme();
    }

    @Override
    public String getHost() {
        return this.originUri.getHost();
    }

    @Override
    public int getPort() {
        return this.originUri.getPort();
    }

    @Override
    public String getAuthority() {
        String authority = super.getAuthority();
        if (authority == null) {
            authority = this.originUri.getRawAuthority();
        }
        return authority;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public String getDecodedPath() {
        return null;
    }

    @Override
    public String getQuery() {
        return null;
    }

    @Override
    public String getFragment() {
        return null;
    }
}

