/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.monitoring.processor;

import java.text.DecimalFormat;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Monitor {
    DecimalFormat df = new DecimalFormat("###.###");
    private static final double KB = 0.001;
    private static final double MB = 1.0E-6;
    private static final double GB = 1.0E-9;
    protected String contentType = "application/json";
    protected Map<String, Object> results;

    public Monitor(Map<String, Object> results) {
        this.results = results;
    }

    public String getTotalJvmMemory() {
        return this.getTotalJvmMemory("");
    }

    public String getTotalJvmMemory(String denomination) {
        return this.convert(denomination, (Long)this.results.get("total.jvm.memory"));
    }

    public String getFreeJvmMemory() {
        return this.getFreeJvmMemory("");
    }

    public String getFreeJvmMemory(String denomination) {
        return this.convert(denomination, (Long)this.results.get("free.jvm.memory"));
    }

    public String getUsedJvmMemory() {
        return this.getUsedJvmMemory("");
    }

    public String getUsedJvmMemory(String denomination) {
        return this.convert(denomination, (Long)this.results.get("used.jvm.memory"));
    }

    public String getTotalPhysicalSystemMemory() {
        return this.getTotalPhysicalSystemMemory("");
    }

    public String getTotalPhysicalSystemMemory(String denomination) {
        return this.convert(denomination, (Long)this.results.get("total.physical.system.memory"));
    }

    public String getTotalFreePhysicalSystemMemory() {
        return this.getTotalFreePhysicalSystemMemory("");
    }

    public String getTotalFreePhysicalSystemMemory(String denomination) {
        return this.convert(denomination, (Long)this.results.get("total.free.physical.system.memory"));
    }

    public String getTotalUsedPhysicalSystemMemory() {
        return this.getTotalUsedPhysicalSystemMemory("");
    }

    public String getTotalUsedPhysicalSystemMemory(String denomination) {
        return this.convert(denomination, (Long)this.results.get("total.used.physical.system.memory"));
    }

    protected String convert(String denomination, Long value) {
        String trimmedDenomination = denomination.trim();
        if ("kb".equalsIgnoreCase(trimmedDenomination)) {
            double result = (double)value.longValue() * 0.001;
            return this.df.format(result);
        }
        if ("mb".equalsIgnoreCase(trimmedDenomination)) {
            double result = (double)value.longValue() * 1.0E-6;
            return this.df.format(result);
        }
        if ("gb".equalsIgnoreCase(trimmedDenomination)) {
            double result = (double)value.longValue() * 1.0E-9;
            return this.df.format(result);
        }
        return String.valueOf(value);
    }

    public String getHostname() {
        return (String)this.results.get("hostname");
    }

    public String getNumberOfCpus() {
        return (String)this.results.get("number.of.cpus");
    }

    public String getCpuLoad() {
        Double cpuLoad = (Double)this.results.get("cpu.load");
        return String.valueOf(cpuLoad);
    }

    public String getCpuLoad(String format) {
        Double cpuLoad = (Double)this.results.get("cpu.load");
        if (cpuLoad > 0.0) {
            if (StringUtils.isNotEmpty((String)format)) {
                DecimalFormat df = new DecimalFormat(format);
                return df.format(cpuLoad * 100.0);
            }
            return String.valueOf(cpuLoad);
        }
        return "0";
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        if (StringUtils.isNotEmpty((String)contentType)) {
            this.contentType = contentType.trim();
        }
    }
}

