/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.security;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public interface AccountLockingService {
    public static final int DEFAULT_MAX_CONSECUTIVE_FAILURES = 3;
    public static final int DEFAULT_MAX_MALICIOUS_ACTIONS = 5;
    public static final int DEFAULT_LOCKOUT_PERIOD = 1;
    public static final int FAILURE_MAP_MAX_SIZE = 10000;
    public static final int MALICIOUS_MAP_MAX_SIZE = 1000;

    public void logFailedLogin(String var1);

    public void logMaliciousAction(String var1);

    public boolean isLocked(String var1);

    public boolean isLocked(String var1, int var2, int var3);

    public boolean isLocked(String var1, int var2, int var3, int var4);

    public void clearFailedLogins(String var1);

    public void clearMaliciousActions(String var1);

    public int getMaxConsecutiveFailures();

    public int getMaxMaliciousActions();

    public int getLockoutPeriod();

    public Map<String, AccountLockingState> getFailureMap();

    public Map<String, AccountLockingState> getMaliciousActionsMap();

    public long getCurrentTimeMillis();

    public static class AccountLockingState {
        private long lockExpiry;
        private final LinkedList<Long> failures = new LinkedList();
        private int lockoutPeriod = this.getLockoutPeriod();

        public void addFailure(long timestamp) {
            this.failures.add(timestamp);
        }

        public int getFailureCount() {
            return this.failures.size();
        }

        public void deleteFailuresOlderThan(long timestamp) {
            Iterator iterator = this.failures.iterator();
            while (iterator.hasNext()) {
                long failureTimestamp = (Long)iterator.next();
                if (failureTimestamp > timestamp) continue;
                iterator.remove();
            }
            if (this.failures.isEmpty()) {
                this.lockExpiry = 0L;
            }
        }

        public long getLockExpiry() {
            return this.lockExpiry;
        }

        public void setLockExpiry(long lockExpiry) {
            this.lockExpiry = lockExpiry;
        }

        public int getLockoutPeriod() {
            return this.lockoutPeriod;
        }

        public void setLockoutPeriod(int lockoutPeriod) {
            this.lockoutPeriod = lockoutPeriod;
        }
    }
}

