/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.file;

import com.pingidentity.pingcommons.upgrade.file.AbstractFileMigrator;
import com.pingidentity.pingcommons.upgrade.file.FileMigrationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFileMigrator
extends AbstractFileMigrator {
    private static final Logger logger = LoggerFactory.getLogger(CopyFileMigrator.class);

    @Override
    public void migrate(Path sourceFilePath, Path destinationFilePath, Path defaultFilePath) throws FileMigrationException {
        File sourceFile = sourceFilePath.toFile();
        File destinationFile = destinationFilePath.toFile();
        try {
            if (sourceFile.isDirectory()) {
                FileUtils.copyDirectory((File)sourceFile, (File)destinationFile);
            } else {
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
            logger.info("Copied " + sourceFile.getPath() + " to " + destinationFile.getPath());
        }
        catch (IOException e) {
            throw new FileMigrationException("Unable to copy " + sourceFile.getPath() + " to " + destinationFile.getPath(), e);
        }
    }
}

