/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.file;

import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MavenCoordinates
implements Comparable<MavenCoordinates> {
    private static final String NA = "?";
    private final String groupId;
    private final String artifactId;
    private final String version;

    public MavenCoordinates(String groupId, String artifactId, String version) {
        this.groupId = StringUtils.defaultIfBlank((String)groupId, (String)NA);
        this.artifactId = StringUtils.defaultIfBlank((String)artifactId, (String)NA);
        this.version = StringUtils.defaultIfBlank((String)version, (String)NA);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean matchesGroupAndArtifact(String groupId, String artifactId) {
        return this.groupId.equalsIgnoreCase(groupId) && this.artifactId.equalsIgnoreCase(artifactId);
    }

    public boolean matchesGroupAndArtifact(MavenCoordinates other) {
        Objects.requireNonNull(other, "other");
        return this.matchesGroupAndArtifact(other.groupId, other.artifactId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MavenCoordinates)) {
            return false;
        }
        MavenCoordinates other = (MavenCoordinates)o;
        return this.groupId.equalsIgnoreCase(other.groupId) && this.artifactId.equalsIgnoreCase(other.artifactId) && this.version.equalsIgnoreCase(other.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    @Override
    public int compareTo(MavenCoordinates o) {
        if (o == null) {
            return -1;
        }
        int result = this.groupId.compareTo(o.groupId);
        if (result == 0 && (result = this.artifactId.compareTo(o.artifactId)) == 0) {
            result = this.version.compareTo(o.version);
        }
        return result;
    }

    public static MavenCoordinates extract(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        return new MavenCoordinates(properties.getProperty("groupId"), properties.getProperty("artifactId"), properties.getProperty("version"));
    }

    public static MavenCoordinates parse(String str) {
        Objects.requireNonNull(str, "str");
        String[] tokens = str.split(":");
        if (tokens.length == 3) {
            return new MavenCoordinates(tokens[0], tokens[1], tokens[2]);
        }
        throw new IllegalArgumentException("Invalid Maven coordinates '" + str + "' -- should be in the form [groupId]:[artifactId]:[version]");
    }
}

