/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.file;

import com.pingidentity.pingcommons.upgrade.file.MavenCoordinates;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public final class MavenJarUtils {
    private static final Pattern POM_PROPERTIES_PATTERN = Pattern.compile("META-INF/maven/.+/pom\\.properties", 2);
    private static final Pattern JAR_FILENAME_PATTERN = Pattern.compile(".+\\.jar", 2);

    private MavenJarUtils() {
    }

    public static Optional<MavenCoordinates> getCoordinates(Path jarFile) throws IOException {
        Objects.requireNonNull(jarFile, "jarFile");
        try (JarFile jar = new JarFile(jarFile.toFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!MavenJarUtils.isPOMProperties(entry)) continue;
                Optional<MavenCoordinates> optional = Optional.of(MavenJarUtils.loadMavenCoords(entry, jar));
                return optional;
            }
        }
        return Optional.empty();
    }

    private static boolean isPOMProperties(JarEntry entry) {
        return POM_PROPERTIES_PATTERN.matcher(entry.getName()).matches();
    }

    private static MavenCoordinates loadMavenCoords(JarEntry entry, JarFile jar) throws IOException {
        try (InputStream stream = jar.getInputStream(entry);){
            Properties properties = new Properties();
            properties.load(stream);
            MavenCoordinates mavenCoordinates = MavenCoordinates.extract(properties);
            return mavenCoordinates;
        }
    }

    public static boolean isJARFile(Path file) {
        Objects.requireNonNull(file, "file");
        Path filename = file.getFileName();
        return filename != null && JAR_FILENAME_PATTERN.matcher(filename.toString()).matches();
    }
}

