/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.file;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PropertyFileItem {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern COMMENT = Pattern.compile("^\\s*[#!]");
    private final Type type;
    private final String content;
    private final String propertyName;
    private final String propertyValue;

    private PropertyFileItem(Type type, String content, String propertyName, String propertyValue) {
        this.type = Objects.requireNonNull(type, "type");
        this.content = Objects.requireNonNull(content, "content");
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isWhitespace() {
        return this.type == Type.WHITESPACE;
    }

    public boolean isComment() {
        return this.type == Type.COMMENT;
    }

    public boolean isProperty() {
        return this.type == Type.PROPERTY;
    }

    public String getContent() {
        return this.content;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isCommentedProperty(String propertyName) {
        return this.type == Type.COMMENT && this.content.matches("^\\s*[#!]" + propertyName + "\\s*[=:].*");
    }

    public String toString() {
        return "[" + (Object)((Object)this.type) + "] " + this.content;
    }

    public static List<PropertyFileItem> loadPropertiesFile(Path propertyFile) throws IOException {
        return PropertyFileItem.loadPropertiesFile(propertyFile, Charset.defaultCharset());
    }

    public static List<PropertyFileItem> loadPropertiesFile(Path propertyFile, Charset charset) throws IOException {
        Objects.requireNonNull(propertyFile, "propertyFile");
        Objects.requireNonNull(charset, "charset");
        List<String> lines = Files.readAllLines(propertyFile, charset);
        LinkedList<PropertyFileItem> items = new LinkedList<PropertyFileItem>();
        ArrayList<String> propertyBuffer = new ArrayList<String>();
        for (String line : lines) {
            if (StringUtils.isBlank((String)line)) {
                items.add(new PropertyFileItem(Type.WHITESPACE, line, null, null));
                continue;
            }
            if (PropertyFileItem.isComment(line)) {
                items.add(new PropertyFileItem(Type.COMMENT, line, null, null));
                continue;
            }
            propertyBuffer.add(line);
            if (PropertyFileItem.isMultiline(line)) continue;
            items.add(PropertyFileItem.parsePropertyItem(propertyBuffer));
            propertyBuffer.clear();
        }
        if (!propertyBuffer.isEmpty()) {
            items.add(PropertyFileItem.parsePropertyItem(propertyBuffer));
        }
        return items;
    }

    private static PropertyFileItem parsePropertyItem(List<String> buffer) throws IOException {
        try {
            String content = StringUtils.join(buffer, (String)LINE_SEPARATOR);
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            String name = properties.stringPropertyNames().iterator().next();
            String value = properties.getProperty(name);
            return new PropertyFileItem(Type.PROPERTY, content, name, value);
        }
        catch (IOException | RuntimeException e) {
            throw new IOException("Failed to parse property name/value", e);
        }
    }

    private static boolean isComment(String line) {
        return COMMENT.matcher(line).find();
    }

    private static boolean isMultiline(String line) {
        line = line.trim();
        int backslashes = 0;
        for (int i = line.length() - 1; i >= 0 && line.charAt(i) == '\\'; --i) {
            ++backslashes;
        }
        return backslashes % 2 == 1;
    }

    public static enum Type {
        PROPERTY,
        COMMENT,
        WHITESPACE;

    }
}

