/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.file;

import com.pingidentity.pingcommons.upgrade.file.AbstractFileMigrator;
import com.pingidentity.pingcommons.upgrade.file.FileMigrationException;
import com.pingidentity.pingcommons.upgrade.file.LogHelper;
import com.pingidentity.pingcommons.upgrade.file.PropertyAppender;
import com.pingidentity.pingcommons.upgrade.file.PropertyFileItem;
import com.pingidentity.pingcommons.upgrade.file.PropertyMigrator;
import com.pingidentity.pingcommons.upgrade.file.PropertyRemover;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileMigrator
extends AbstractFileMigrator {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileMigrator.class);
    static final String HIDDEN_LOG_VALUE = "{hidden}";
    private final String NEWLINE = System.getProperty("line.separator", "\n");
    private PropertyMigrator customMigrator;
    private Charset propertiesCharset = StandardCharsets.ISO_8859_1;
    private boolean hasNewPropertiesAdded = false;
    private boolean hidePasswordProperties = true;
    private PropertyAppender customPropertyAppender;
    private PropertyRemover propertyRemover;

    public PropertyFileMigrator() {
    }

    public PropertyFileMigrator(LogHelper pathHandler, Charset propertiesCharset) {
        super(pathHandler);
        this.propertiesCharset = propertiesCharset;
    }

    public PropertyFileMigrator(LogHelper pathHandler) {
        super(pathHandler);
    }

    public void setCustomMigrator(PropertyMigrator customMigrator) {
        this.customMigrator = customMigrator;
    }

    public void setPropertyAppender(PropertyAppender customPropertyAppender) {
        this.customPropertyAppender = customPropertyAppender;
    }

    public void setPropertyRemover(PropertyRemover propertyRemover) {
        this.propertyRemover = propertyRemover;
    }

    public boolean hasNewPropertiesAdded() {
        return this.hasNewPropertiesAdded;
    }

    public void setHidePasswordProperties(boolean hidePasswordProperties) {
        this.hidePasswordProperties = hidePasswordProperties;
    }

    @Override
    public void migrate(Path sourceFilePath, Path destinationFilePath, Path defaultFilePath) throws FileMigrationException {
        StringBuilder contents = new StringBuilder();
        try {
            String propertyName;
            File sourceFile = sourceFilePath.toFile();
            File destinationFile = destinationFilePath.toFile();
            File defaultSourceFile = defaultFilePath.toFile();
            Properties defaultSourceProperties = this.loadProperties(defaultSourceFile);
            Properties sourceProperties = this.loadProperties(sourceFile);
            Properties destinationProperties = this.loadProperties(destinationFile);
            Set<Object> propertiesToRemove = new HashSet();
            if (this.propertyRemover != null) {
                propertiesToRemove = this.propertyRemover.getPropertiesToRemove(sourceProperties, destinationProperties, defaultFilePath.getFileName().toString());
            }
            HashMap<String, String> propertiesInSourceNotInDestination = new HashMap<String, String>();
            for (Map.Entry<Object, Object> sourceEntry : sourceProperties.entrySet()) {
                if (destinationProperties.containsKey(sourceEntry.getKey())) continue;
                propertiesInSourceNotInDestination.put((String)sourceEntry.getKey(), (String)sourceEntry.getValue());
            }
            List<PropertyFileItem> items = PropertyFileItem.loadPropertiesFile(destinationFilePath, this.propertiesCharset);
            for (PropertyFileItem item : items) {
                boolean appendItem = true;
                if (item.isComment()) {
                    for (Map.Entry entry : propertiesInSourceNotInDestination.entrySet()) {
                        String propertyName2 = (String)entry.getKey();
                        String propertyValue = (String)entry.getValue();
                        if (!item.isCommentedProperty(propertyName2)) continue;
                        logger.info("Update " + this.logHelper.getCleanPath(destinationFile.getPath()) + ". Uncomment property " + propertyName2 + ". Value set to '" + PropertyFileMigrator.getValueForLog(propertyName2, propertyValue, this.hidePasswordProperties) + "'");
                        this.appendProperty(propertyName2, propertyValue, contents);
                        appendItem = false;
                        propertiesInSourceNotInDestination.remove(propertyName2);
                        break;
                    }
                } else if (item.isProperty()) {
                    String customValue;
                    propertyName = item.getPropertyName();
                    String destinationPropertyValue = destinationProperties.getProperty(propertyName);
                    if (this.customMigrator != null && (customValue = this.customMigrator.migrateProperty(propertyName, sourceProperties.getProperty(propertyName), defaultSourceProperties.getProperty(propertyName), destinationPropertyValue, sourceProperties, defaultSourceProperties, destinationProperties, defaultFilePath.getFileName().toString())) != null) {
                        this.appendProperty(propertyName, customValue, contents);
                        appendItem = false;
                    }
                    if (appendItem && sourceProperties.containsKey(propertyName)) {
                        String customValue2;
                        String sourcePropertyValue = sourceProperties.getProperty(propertyName);
                        if (this.customActionListener != null && (customValue2 = this.customActionListener.handleCustomAction(propertyName, sourcePropertyValue, destinationPropertyValue, sourceProperties)) != null) {
                            this.appendProperty(propertyName, customValue2, contents);
                            appendItem = false;
                        }
                        if (appendItem && sourcePropertyValue != null && !sourcePropertyValue.equals(destinationPropertyValue)) {
                            String defaultSourcePropertyValue = defaultSourceProperties.getProperty(propertyName);
                            if (defaultSourcePropertyValue != null && sourcePropertyValue.equals(defaultSourcePropertyValue)) {
                                logger.info("New Default in " + this.logHelper.getCleanPath(destinationFile.getPath()) + ". The default value for " + propertyName + " was changed from '" + PropertyFileMigrator.getValueForLog(propertyName, defaultSourcePropertyValue, this.hidePasswordProperties) + "' to '" + PropertyFileMigrator.getValueForLog(propertyName, destinationPropertyValue, this.hidePasswordProperties) + "'.");
                            } else {
                                logger.info("Update " + this.logHelper.getCleanPath(destinationFile.getPath()) + ". The default value for property " + propertyName + " was changed from '" + PropertyFileMigrator.getValueForLog(propertyName, destinationPropertyValue, this.hidePasswordProperties) + "' to '" + PropertyFileMigrator.getValueForLog(propertyName, sourcePropertyValue, this.hidePasswordProperties) + "'.");
                                this.appendProperty(propertyName, sourcePropertyValue, contents);
                                appendItem = false;
                                if (propertyName.endsWith(".1")) {
                                    String rootPropertyName = propertyName.substring(0, propertyName.lastIndexOf("."));
                                    int i = 2;
                                    String nextPropertyNameInSeries = rootPropertyName + "." + i;
                                    while (propertiesInSourceNotInDestination.containsKey(nextPropertyNameInSeries)) {
                                        this.appendProperty(nextPropertyNameInSeries, (String)propertiesInSourceNotInDestination.get(nextPropertyNameInSeries), contents);
                                        propertiesInSourceNotInDestination.remove(nextPropertyNameInSeries);
                                        nextPropertyNameInSeries = rootPropertyName + "." + ++i;
                                    }
                                }
                            }
                        }
                    } else if (sourceProperties.containsKey(propertyName + ".1")) {
                        int i = 1;
                        String nextPropertyNameInSeries = propertyName + "." + i;
                        while (propertiesInSourceNotInDestination.containsKey(nextPropertyNameInSeries)) {
                            this.appendProperty(nextPropertyNameInSeries, (String)propertiesInSourceNotInDestination.get(nextPropertyNameInSeries), contents);
                            logger.info("Update " + this.logHelper.getCleanPath(destinationFile.getPath()) + ". Add property " + nextPropertyNameInSeries + ". Value set to '" + PropertyFileMigrator.getValueForLog(propertyName, (String)propertiesInSourceNotInDestination.get(nextPropertyNameInSeries), this.hidePasswordProperties) + "'.");
                            propertiesInSourceNotInDestination.remove(nextPropertyNameInSeries);
                            nextPropertyNameInSeries = propertyName + "." + ++i;
                            appendItem = false;
                        }
                    } else if (propertiesToRemove != null && !sourceProperties.containsKey(propertyName) && propertiesToRemove.contains(propertyName)) {
                        appendItem = false;
                        logger.info("Update " + this.logHelper.getCleanPath(destinationFile.getPath()) + ". Remove property " + item.getPropertyName() + ".");
                    } else {
                        this.hasNewPropertiesAdded = true;
                    }
                }
                if (!appendItem) continue;
                contents.append(item.getContent());
                contents.append(this.NEWLINE);
            }
            boolean appendedSeparator = false;
            for (Map.Entry entry : propertiesInSourceNotInDestination.entrySet()) {
                propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (defaultSourceProperties.containsKey(propertyName)) {
                    logger.warn("Property not migrated: " + this.logHelper.getCleanPath(sourceFile.getPath()) + ". Property '" + propertyName + "' no longer needed.");
                    continue;
                }
                logger.info("Update " + this.logHelper.getCleanPath(destinationFile.getPath()) + ". Add  property " + propertyName + ". Value set to '" + PropertyFileMigrator.getValueForLog(propertyName, propertyValue, this.hidePasswordProperties) + "'.");
                if (!appendedSeparator) {
                    contents.append(this.NEWLINE);
                    contents.append("# ------------------------------------------------------------------------------");
                    contents.append(this.NEWLINE);
                    contents.append("# Custom properties:").append(this.NEWLINE).append(this.NEWLINE);
                    appendedSeparator = true;
                }
                this.appendProperty(propertyName, propertyValue, contents);
            }
            this.appendPropertiesFromCustomAppenders(sourceProperties, destinationProperties, defaultFilePath, contents);
            FileUtils.writeStringToFile((File)destinationFile, (String)contents.toString(), (Charset)this.propertiesCharset);
        }
        catch (IOException ex) {
            logger.error("Unable to upgrade property file: ", (Throwable)ex);
        }
    }

    private void appendPropertiesFromCustomAppenders(Properties sourceProperties, Properties destinationProperties, Path defaultFilePath, StringBuilder contents) throws IOException {
        Map<String, String> customProperties;
        if (this.customPropertyAppender != null && defaultFilePath != null && defaultFilePath.getFileName() != null && (customProperties = this.customPropertyAppender.getPropertiesToAppend(sourceProperties, defaultFilePath.getFileName().toString())) != null) {
            for (Map.Entry<String, String> entry : customProperties.entrySet()) {
                if (sourceProperties.getProperty(entry.getKey()) != null || destinationProperties.getProperty(entry.getKey()) != null) continue;
                this.appendProperty(entry.getKey(), entry.getValue(), contents);
            }
        }
    }

    private void appendProperty(String name, String value, StringBuilder target) throws IOException {
        Properties temp = new Properties();
        temp.put(name, value);
        StringWriter buffer = new StringWriter();
        temp.store(buffer, null);
        String escaped = buffer.toString();
        target.append(escaped.substring(escaped.indexOf(this.NEWLINE) + 1));
    }

    private Properties loadProperties(File propertiesFile) throws IOException {
        Properties props = new Properties();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propertiesFile), this.propertiesCharset));){
            props.load(br);
        }
        return props;
    }

    public static String getValueForLog(String propertyName, String propertyValue) {
        return PropertyFileMigrator.getValueForLog(propertyName, propertyValue, false);
    }

    public static String getValueForLog(String propertyName, String propertyValue, boolean hidePasswordProperties) {
        String valueForLog = propertyValue == null || propertyValue.trim().equals("") ? "{no-value}" : (hidePasswordProperties && (propertyName.toLowerCase().contains("password") || propertyName.toLowerCase().contains(".pwd")) ? HIDDEN_LOG_VALUE : propertyValue);
        return valueForLog;
    }
}

