/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.zip;

import com.pingidentity.pingcommons.upgrade.zip.FileEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtil {
    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);

    public static byte[] zip(File baseDir) throws IOException {
        Set<File> empty = Collections.emptySet();
        return ZipUtil.zip(baseDir, empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(File baseDir, Set<File> excludes) throws IOException {
        log.debug("Zip " + baseDir + " exclude: " + excludes);
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(byteArrayOutputStream);
        boolean added = false;
        try {
            List<String> pathElements = Collections.emptyList();
            added = ZipUtil.addDir(pathElements, baseDir, zipOut, buffer, excludes);
        }
        finally {
            if (added) {
                zipOut.close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static boolean addDir(List<String> pathElements, File dir, ZipOutputStream zipOut, byte[] buffer, Set<File> excludes) throws IOException {
        boolean added = false;
        String zipPath = ZipUtil.getPath(pathElements).toString();
        if (!excludes.contains(dir)) {
            log.debug("Dir: " + zipPath);
            for (File file : dir.listFiles()) {
                if (file.isFile()) {
                    added |= ZipUtil.addFile(pathElements, file, zipOut, buffer, excludes);
                    continue;
                }
                if (!file.isDirectory()) continue;
                LinkedList<String> subDirPathElements = new LinkedList<String>(pathElements);
                subDirPathElements.add(file.getName());
                added |= ZipUtil.addDir(subDirPathElements, file, zipOut, buffer, excludes);
            }
        } else {
            log.debug("Excluding dir: " + zipPath);
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addFile(List<String> pathElements, File file, ZipOutputStream zipOut, byte[] buffer, Set<File> excludes) throws IOException {
        boolean added = false;
        String zipEntryName = ZipUtil.getFileName(pathElements, file);
        if (!excludes.contains(file)) {
            ZipEntry zipEntry = new ZipEntry(zipEntryName);
            log.debug("ZIPPING " + zipEntry);
            zipEntry.setTime(file.lastModified());
            zipOut.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                int nRead;
                while ((nRead = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                    zipOut.write(buffer, 0, nRead);
                }
                added = true;
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        log.debug("SKIPPING " + zipEntryName);
        return added;
    }

    private static String getFileName(List<String> pathElements, File file) {
        StringBuffer sb = ZipUtil.getPath(pathElements);
        sb.append(file.getName());
        String fileName = sb.toString();
        return fileName;
    }

    private static StringBuffer getPath(List<String> pathElements) {
        StringBuffer sb = new StringBuffer();
        for (String pathElement : pathElements) {
            sb.append(pathElement);
            sb.append("/");
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zip(List<FileEntry> fileList) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipOutputStream zipOut = new ZipOutputStream(byteArrayOutputStream);
        boolean added = false;
        try {
            if (fileList != null) {
                for (FileEntry entry : fileList) {
                    ZipEntry zipEntry = new ZipEntry(entry.getFileName());
                    log.debug("ZIPPING " + zipEntry);
                    zipOut.putNextEntry(zipEntry);
                    zipOut.write(entry.getData());
                    added = true;
                }
            }
        }
        finally {
            if (added) {
                zipOut.close();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

