/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.util.tree;

import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class PreOrderTraversal {
    public <T> void traverse(Tree<T> tree, TraversalVisitor<T> visitor) {
        Stack<Tree.Node> nodeStack = new Stack<Tree.Node>();
        Tree.Node node = tree.getRootNode();
        while (visitor.continueTraversal() && node != null) {
            visitor.visit(node.getData(), node);
            if (node.hasChildren()) {
                boolean first = true;
                LinkedList otherChildren = new LinkedList();
                for (Tree.Node childNode : node.getChildren()) {
                    if (first) {
                        node = childNode;
                        first = false;
                        continue;
                    }
                    otherChildren.add(childNode);
                }
                Iterator reverseChildIt = otherChildren.descendingIterator();
                while (reverseChildIt.hasNext()) {
                    nodeStack.push((Tree.Node)reverseChildIt.next());
                }
                continue;
            }
            if (nodeStack.isEmpty()) {
                node = null;
                continue;
            }
            node = (Tree.Node)nodeStack.pop();
        }
    }
}

