/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.util.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Tree<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Node<K> root;

    public Tree(Node<K> rootNode) {
        this.root = rootNode;
    }

    public Tree(K rootData) {
        this.root = new Node<K>(rootData);
    }

    public Node<K> getRootNode() {
        return this.root;
    }

    public Node<K> findNode(NodePosition<K> nodePosition) {
        return nodePosition.findNode(this);
    }

    public static class NodePosition<K>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<Integer> childIndices = new ArrayList<Integer>();

        public NodePosition(Node<K> node) {
            Node<K> currNode = node;
            for (Node<K> parent = node.getParent(); parent != null; parent = parent.getParent()) {
                this.childIndices.add(parent.getChildren().indexOf(currNode));
                currNode = parent;
            }
            Collections.reverse(this.childIndices);
        }

        public Node<K> findNode(Tree<K> tree) {
            Node<K> currNode = tree.getRootNode();
            LinkedList<Integer> tempChildIndices = new LinkedList<Integer>(this.childIndices);
            while (!tempChildIndices.isEmpty()) {
                int childIndex = tempChildIndices.removeFirst();
                List<Node<K>> children = currNode.getChildren();
                if (children != null && children.size() > childIndex) {
                    currNode = children.get(childIndex);
                    continue;
                }
                return null;
            }
            return currNode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.childIndices == null ? 0 : this.childIndices.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodePosition other = (NodePosition)obj;
            return !(this.childIndices == null ? other.childIndices != null : !this.childIndices.equals(other.childIndices));
        }
    }

    public static class Node<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final T data;
        private Node<T> parent = null;
        private List<Node<T>> children = null;

        public Node(T data) {
            this.data = data;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public Node<T> addChildData(T newChild) {
            if (this.children == null) {
                this.children = new LinkedList<Node<T>>();
            }
            Node<T> newNode = new Node<T>(newChild);
            newNode.parent = this;
            this.children.add(newNode);
            return newNode;
        }

        public void addChildNode(Node<T> newChildNode) {
            if (this.children == null) {
                this.children = new LinkedList<Node<T>>();
            }
            newChildNode.parent = this;
            this.children.add(newChildNode);
        }

        public List<Node<T>> getChildren() {
            return this.children;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public T getData() {
            return this.data;
        }

        public NodePosition<T> getPosition() {
            return new NodePosition(this);
        }
    }
}

