/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.p14c;

import com.pingidentity.plugins.pcvs.p14c.AuthenticationResult;
import com.pingidentity.plugins.pcvs.p14c.ExpiredPasswordCredentialValidatorAuthnException;
import com.pingidentity.plugins.pcvs.p14c.PingOneForCustomersPCV;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordResetException;
import java.util.List;
import java.util.Objects;
import org.sourceid.saml20.domain.AbstractPasswordCredentialValidatorResult;

public class PCVResult
extends AbstractPasswordCredentialValidatorResult {
    protected PCVResult(String msgKey, boolean isRecoverable) {
        super(msgKey, isRecoverable, true);
    }

    public void raisePcvAuthnException() throws PasswordCredentialValidatorAuthnException {
        throw new PasswordCredentialValidatorAuthnException(this.isRecoverable().booleanValue(), this.getMessageKey());
    }

    public void raisePcvExpiredPasswordAuthnException(String userId) throws PasswordCredentialValidatorAuthnException {
        throw new ExpiredPasswordCredentialValidatorAuthnException((boolean)this.isRecoverable(), this.getMessageKey(), userId);
    }

    public void raisePcvAuthnException(String exceptionMessage) throws PasswordCredentialValidatorAuthnException {
        throw new PasswordCredentialValidatorAuthnException(this.isRecoverable().booleanValue(), this.getMessageKey(), (Throwable)new Exception(exceptionMessage));
    }

    public void raisePasswordResetException(String exceptionMessage) throws PasswordResetException {
        throw new PasswordResetException(this.isRecoverable().booleanValue(), this.getMessageKey(), (Throwable)new Exception(exceptionMessage));
    }

    public static PCVResult getByExplanation(String errorCode, String explanation, List<PingOneForCustomersPCV.CustomAuthorizationError> customAuthnErrorList, boolean enableCaseSensitiveMatch) {
        AuthenticationResult resultEnum = AuthenticationResult.getByDisplayName(errorCode);
        assert (resultEnum != null);
        PCVResult result = new PCVResult(resultEnum.getMessageKey(), resultEnum.isRecoverable());
        if (customAuthnErrorList != null) {
            for (PingOneForCustomersPCV.CustomAuthorizationError customAuthnError : customAuthnErrorList) {
                if (!customAuthnError.matches(explanation, enableCaseSensitiveMatch)) continue;
                if (customAuthnError.getMsgKey() != null && !customAuthnError.getMsgKey().isEmpty()) {
                    result = new PCVResult(customAuthnError.getMsgKey(), customAuthnError.isRecoverable());
                } else if (customAuthnError.getId() != null && !customAuthnError.getId().isEmpty()) {
                    result = new PCVResult(Objects.requireNonNull(AuthenticationResult.getById(customAuthnError.getId()), "customAuthnError does not have valid id").getMessageKey(), customAuthnError.isRecoverable());
                }
                return result;
            }
        }
        return result;
    }
}

