/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.p14c;

import com.pingidentity.pingone.api.AccessTokenResponse;
import com.pingidentity.pingone.impl.AccessTokenHolder;
import com.pingidentity.plugins.datastore.p14c.DataStoreConstants;
import com.pingidentity.plugins.datastore.p14c.ExponentialBackOffCalculator;
import com.pingidentity.plugins.datastore.p14c.configuration.DataStoreConfiguration;
import com.pingidentity.plugins.datastore.p14c.configuration.Region;
import com.pingidentity.plugins.datastore.p14c.exception.AccessTokenProviderException;
import com.pingidentity.plugins.datastore.p14c.util.ReflectivePingOneEnvironmentAccessor;
import com.pingidentity.plugins.datastore.p14c.util.StringUtils;
import com.pingidentity.plugins.datastore.p14c.validators.RequiredFieldLabelValidator;
import com.pingidentity.plugins.pcvs.p14c.AuthenticationErrorFieldDescriptor;
import com.pingidentity.plugins.pcvs.p14c.AuthenticationErrorInfo;
import com.pingidentity.plugins.pcvs.p14c.CustomHttpClientFactory;
import com.pingidentity.plugins.pcvs.p14c.ExpiredPasswordCredentialValidatorAuthnException;
import com.pingidentity.plugins.pcvs.p14c.PCVLogEvent;
import com.pingidentity.plugins.pcvs.p14c.PCVResult;
import com.pingidentity.plugins.pcvs.p14c.PingOneForCustomersDatastoreFieldDescriptor;
import com.pingidentity.plugins.pcvs.p14c.PingOneForCustomersPCVUtil;
import com.pingidentity.plugins.pcvs.p14c.ReadDataSourceConfigException;
import com.pingidentity.plugins.pcvs.p14c.RequestResponse;
import com.pingidentity.plugins.pcvs.p14c.shade.com.fasterxml.jackson.annotation.JsonInclude;
import com.pingidentity.plugins.pcvs.p14c.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import com.pingidentity.plugins.pcvs.p14c.shade.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.plugins.pcvs.p14c.shade.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.plugins.pcvs.p14c.shade.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.GenericHttpQueryParams;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.HttpService;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.HttpServiceException;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpRequestBuilder;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpResponseBuilder;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.common.http.apache5.ApacheHttpServiceFactory;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.util.JsonNodeUtil;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.util.JsonPointerUtil;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.util.JsonPointerUtilException;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.account.AccountUnlockablePasswordCredential;
import com.pingidentity.sdk.password.ChangeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordChangeResult;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordResetException;
import com.pingidentity.sdk.password.PasswordValidationException;
import com.pingidentity.sdk.password.RecoverableUsername;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.sdk.password.UsernameRecoveryException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class PingOneForCustomersPCV
implements PasswordCredentialValidator,
ChangeablePasswordCredential,
ResettablePasswordCredential,
AccountUnlockablePasswordCredential,
RecoverableUsername {
    private static final String TYPE = "PingOne Password Credential Validator 2.7";
    private static final String TYPE_DESC = "This Password Credential Validator authenticates PingOne users and supports common password management operations.";
    private static final String TOKEN_ENDPOINT = "/as/token";
    private static final String ENVIRONMENTS_ENDPOINT = "/environments";
    private static final String USERS_ENDPOINT = "/users";
    private static final String PASSWORD_ENDPOINT = "/password";
    private static final String PASSWORD_POLICIES_ENDPOINT = "/passwordPolicies";
    private static final String DEVICES_ENDPOINT = "/devices";
    private static final String GROUP_QUERY_PARAM = "include=memberOfGroupNames,memberOfGroupIDs";
    private static final String APPLICATION_CHECK = "application/vnd.pingidentity.password.check+json";
    private static final String APPLICATION_RESET = "application/vnd.pingidentity.password.reset+json";
    private static final String APPLICATION_SET = "application/vnd.pingidentity.password.set+json";
    private static final String APPLICATION_UNLOCK = "application/vnd.pingidentity.password.unlock";
    private static final String PWD_EXPIRED_DESC = "Password expired, user must change password.";
    private static final String MUST_CHANGE_PWD_DESC = "Password must be changed before you can log on.";
    private static final String DEFAULT_ERROR_DESC = "Something went wrong. Please try again, and if this persists, contact your system administrator.";
    private static final String PWD_CHANGE_FAILED_DESC = "Password change was unsuccessful. Please try again.";
    private static final String PWD_RESET_FAILED_DESC = "Password reset was unsuccessful. Please try again.";
    private static final String ACCOUNT_UNLOCK_FAILED_DESC = "Account unlock was unsuccessful. Please try again.";
    private static final String ACCOUNT_RECOVERY_FORBIDDEN_DISABLED_USER_DESC = "You requested account recovery, but your account is disabled.";
    private static final boolean DEFAULT_VALUE_ENABLE_CASESENSITIVE = true;
    public static final String STATUS = "status";
    public static final String STATUS_OK = "OK";
    public static final String MESSAGE = "message";
    public static final String CODE = "code";
    public static final String DETAILS = "details";
    public static final String SIZE = "size";
    private String dataSourceId = null;
    private String baseUrl = "PingOne API Service";
    private String tokenServerUrl = "PingOne Authorization Service";
    private String environmentId = "Environment ID";
    private String environmentIdEndpoint = "/" + this.environmentId;
    private String clientId = "Client ID";
    private String clientSecret = "Client Secret";
    private int requestTimeoutMillis = 10000;
    private String previousProxySettings;
    private List<CustomAuthorizationError> customAuthnErrors = new ArrayList<CustomAuthorizationError>();
    boolean isStandalone;
    private final PluginDescriptor descriptor;
    private static ObjectMapper mapper = PingOneForCustomersPCV.makeLowerCaseWithUnderscoresObjectMapper();
    private ReflectivePingOneEnvironmentAccessor pingOneEnvironmentAccessor;
    private AccessTokenHolder accessTokenHolder = new AccessTokenHolder();
    private HttpService httpService;
    private static final IntegrationsLogger logger = new IntegrationsLogger(PingOneForCustomersPCV.class);
    private static final String UTC_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    ExponentialBackOffCalculator backoffCalculator = new ExponentialBackOffCalculator();
    private int maxRetriesAttempt = 5;
    private boolean retryRequest;
    private List<String> errorCodeForRetries = new ArrayList<String>();
    private Map<String, String> customAttributesTable = new HashMap<String, String>();
    private Configuration configuration = null;
    private boolean enableCaseSensitiveMatch = true;
    private boolean enableUserGroupInfoRetrieval = true;
    private boolean enableDeviceInfoRetrieval = true;
    private boolean enablePasswordExpiryInfoRetrieval = true;

    public PingOneForCustomersPCV() {
        this.isStandalone = MgmtFactory.getMediator().isStandalone();
        GuiConfigDescriptor guiDescriptor = new GuiConfigDescriptor();
        guiDescriptor.setDescription(TYPE_DESC);
        TableDescriptor authnErrorsTable = new TableDescriptor("Authentication Error Overrides", "A table to override the default error messages. Use the localization features to customize the error messages displayed to end users.");
        guiDescriptor.addTable(authnErrorsTable);
        TextFieldDescriptor matchExpressionField = new TextFieldDescriptor("Match Expression", "The expression matched against response message returned from PingOne.");
        matchExpressionField.addValidator((FieldValidator)new RequiredFieldValidator());
        matchExpressionField.setSize(50);
        matchExpressionField.addValidator(this.getExpressionValidator());
        authnErrorsTable.addRowField((FieldDescriptor)matchExpressionField);
        AuthenticationErrorFieldDescriptor errorCodeField = new AuthenticationErrorFieldDescriptor("Error", "");
        errorCodeField.addValidator((FieldValidator)new RequiredFieldValidator());
        authnErrorsTable.addRowField((FieldDescriptor)errorCodeField);
        TextFieldDescriptor msgKeyField = new TextFieldDescriptor("Message Properties Key", "This field defines the custom message key to use for displaying user-facing errors. The key must be defined in the localization message file. Otherwise, the text defined here will be displayed.");
        authnErrorsTable.addRowField((FieldDescriptor)msgKeyField);
        PingOneForCustomersDatastoreFieldDescriptor fieldDescriptor = new PingOneForCustomersDatastoreFieldDescriptor("PingOne For Customers Datastore", "Select a PingOne Datastore.");
        fieldDescriptor.setLabel("PingOne Datastore");
        fieldDescriptor.addValidator((FieldValidator)new RequiredFieldLabelValidator("PingOne Datastore"));
        guiDescriptor.addField((FieldDescriptor)fieldDescriptor);
        this.descriptor = new PluginDescriptor(TYPE, (ConfigurablePlugin)this, guiDescriptor, "1.1");
        fieldDescriptor = new TextFieldDescriptor("Display Name Attribute", "For password reset, account unlock and username recovery, the attribute used for personalizing messages to the user. Default: name.formatted.");
        guiDescriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor("PingID Username Attribute", "For password reset, the attribute containing the username to use for PingID based password reset. Default: username.");
        guiDescriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor("Username Attribute", "For username recovery, the attribute containing the username to send to the user. Default: username.");
        guiDescriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor("Mail Verified Attribute", "For password reset, account unlock and username recovery, the boolean attribute indicating that the user's email address has been verified. Default: enabled.");
        guiDescriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor("Mail Attribute", "For password reset, the attribute containing the email address used for notifications and email based password reset. Default: email.");
        guiDescriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        fieldDescriptor = new TextFieldDescriptor("SMS Attribute", "For password reset, the attribute containing the phone number to use for SMS based password reset. Default: mobilePhone.");
        guiDescriptor.addAdvancedField((FieldDescriptor)fieldDescriptor);
        CheckBoxFieldDescriptor enableUserGroupInfoFieldDescriptor = new CheckBoxFieldDescriptor("Enable User Group Info Retrieval", "If selected, the request to retrieve user group info will be made during credential authentication. The core contract attribute memberOfGroupIDs and memberOfGroupNames will be populated with retrieved values.");
        enableUserGroupInfoFieldDescriptor.setDefaultValue(true);
        enableUserGroupInfoFieldDescriptor.setDefaultForLegacyConfig(Boolean.TRUE.toString());
        guiDescriptor.addAdvancedField((FieldDescriptor)enableUserGroupInfoFieldDescriptor);
        CheckBoxFieldDescriptor enableDeviceInfoFieldDescriptor = new CheckBoxFieldDescriptor("Enable Device Info Retrieval", "If selected, the request to retrieve device info will be made during credential authentication. The core contract attributes devices.phone and devices.email will be populated with retrieved values.");
        enableDeviceInfoFieldDescriptor.setDefaultValue(true);
        enableDeviceInfoFieldDescriptor.setDefaultForLegacyConfig(Boolean.TRUE.toString());
        guiDescriptor.addAdvancedField((FieldDescriptor)enableDeviceInfoFieldDescriptor);
        CheckBoxFieldDescriptor enablePasswordInfoFieldDescriptor = new CheckBoxFieldDescriptor("Enable Password Expiry Info Retrieval", "If selected, the request to password policy endpoints to retrieve expiry information will be made during credential authentication. The core contract attribute passwordExpiryTime will be populated with retrieved value.");
        enablePasswordInfoFieldDescriptor.setDefaultValue(true);
        enablePasswordInfoFieldDescriptor.setDefaultForLegacyConfig(Boolean.TRUE.toString());
        guiDescriptor.addAdvancedField((FieldDescriptor)enablePasswordInfoFieldDescriptor);
        CheckBoxFieldDescriptor enableCaseSensitiveField = new CheckBoxFieldDescriptor("Case-Sensitive Matching", "Allows case-sensitive expression and LDAP error matching.");
        enableCaseSensitiveField.setDefaultValue(true);
        enableCaseSensitiveField.setDefaultForLegacyConfig(Boolean.toString(true));
        guiDescriptor.addField((FieldDescriptor)enableCaseSensitiveField);
        HashSet<String> contract = new HashSet<String>(Arrays.asList(DataStoreConstants.CORE_USER_ATTRIBUTES_LIST));
        this.descriptor.setAttributeContractSet(contract);
        this.descriptor.setSupportsExtendedContract(true);
        guiDescriptor.addValidator(configuration -> this.checkConfiguration(configuration));
    }

    public PingOneForCustomersPCV(Configuration configuration, HttpService httpService, AccessTokenHolder accessTokenHolder) {
        this.configure(configuration);
        this.isStandalone = false;
        this.descriptor = new PluginDescriptor();
        this.httpService = httpService;
        this.accessTokenHolder = accessTokenHolder;
    }

    public void checkConfiguration(Configuration configuration) throws ValidationException {
        boolean caseSensitive = true;
        Field caseSensitiveField = configuration.getField("Case-Sensitive Matching");
        if (caseSensitiveField != null) {
            caseSensitive = caseSensitiveField.getValueAsBoolean();
        }
        Table authErrorTable = configuration.getTable("Authentication Error Overrides");
        this.checkTableConfig(caseSensitive, authErrorTable, "Match Expression");
    }

    private void checkTableConfig(boolean caseSensitive, Table authErrorTable, String matchExprFieldName) throws ValidationException {
        if (authErrorTable != null && authErrorTable.getRows() != null) {
            HashSet<String> expressions = new HashSet<String>();
            for (Row authErrorRow : authErrorTable.getRows()) {
                String expr = authErrorRow.getFieldValue(matchExprFieldName);
                if (!caseSensitive) {
                    expr = expr.toLowerCase();
                }
                if (expressions.contains(expr)) {
                    throw new ValidationException("Duplicate expression: '" + authErrorRow.getFieldValue(matchExprFieldName) + "'.");
                }
                expressions.add(expr);
                String errorId = authErrorRow.getFieldValue("Error");
                if (!"use.message.properties.key".equals(errorId) && StringUtils.isNotEmpty((String)authErrorRow.getFieldValue("Message Properties Key"))) {
                    throw new ValidationException("The Message Properties Key is only used when \"Use Message Properties Key\" is selected in the Error list.");
                }
                if (!"use.message.properties.key".equals(errorId) || !StringUtils.isEmpty((String)authErrorRow.getFieldValue("Message Properties Key"))) continue;
                throw new ValidationException("You have selected \"Use Message Properties Key\" in the Error list. Type a key name of your choosing in the Message Properties Key field to continue.");
            }
        }
    }

    private void initializeHttpClient() throws ReadDataSourceConfigException {
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        CustomDataSource customDataSource = dataSourceManager.getCustomDataSource(this.dataSourceId);
        if (customDataSource == null) {
            logger.log(PCVLogEvent.NO_DATA_SOURCE);
            throw new ReadDataSourceConfigException("Empty or invalid Custom Data Source");
        }
        Configuration configuration = customDataSource.getConfiguration();
        String proxySettings = configuration.getFieldValue("Proxy Settings");
        if (proxySettings == null || proxySettings.isEmpty()) {
            proxySettings = "System Defaults";
        }
        String proxyHost = configuration.getFieldValue("Custom Proxy Host");
        int proxyPort = configuration.getIntFieldValue("Custom Proxy Port");
        CustomHttpClientFactory clientFactory = new CustomHttpClientFactory().setRequestTimeout(this.requestTimeoutMillis).setProxySettings(proxySettings).setProxyHost(proxyHost).setProxyPort(proxyPort);
        this.httpService = new ApacheHttpServiceFactory().make(new ApacheHttpRequestBuilder(), clientFactory, new ApacheHttpResponseBuilder());
    }

    private FieldValidator getExpressionValidator() {
        return new FieldValidator(){
            private static final long serialVersionUID = 20121113L;

            public void validate(Field field) throws ValidationException {
                try {
                    String value = field.getValue();
                    Util.wildCardMatch((String)"", (String)value, (boolean)true);
                }
                catch (PatternSyntaxException ex) {
                    throw new ValidationException("Invalid match expression " + field.getValue());
                }
            }
        };
    }

    private void readConfigStandaloneMode() {
        try {
            if (this.isStandalone) {
                Configuration datasourceConfiguration = this.readDataStoreConfig();
                if (this.previousProxySettings == null || this.previousProxySettings.isEmpty()) {
                    this.previousProxySettings = datasourceConfiguration.getFieldValue("Proxy Settings");
                    this.initializeHttpClient();
                } else {
                    String currentProxySettings = datasourceConfiguration.getFieldValue("Proxy Settings");
                    if (!currentProxySettings.equals(this.previousProxySettings)) {
                        this.initializeHttpClient();
                        this.previousProxySettings = currentProxySettings;
                    }
                }
            }
        }
        catch (ReadDataSourceConfigException e) {
            logger.log((LogEvent)PCVLogEvent.READ_DATA_SOURCE_ERROR, e);
        }
    }

    private Configuration readDataStoreConfig() throws ReadDataSourceConfigException {
        Table customAttrsTable;
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        CustomDataSource customDataSource = dataSourceManager.getCustomDataSource(this.dataSourceId);
        if (customDataSource == null) {
            logger.log(PCVLogEvent.NO_DATA_SOURCE);
            throw new ReadDataSourceConfigException("Empty or invalid Custom Data Source");
        }
        Configuration dsConfiguration = customDataSource.getConfiguration();
        String pingOneEnvironment = dsConfiguration.getFieldValue("PingOne Environment");
        if (pingOneEnvironment != null && !pingOneEnvironment.isEmpty()) {
            this.pingOneEnvironmentAccessor = new ReflectivePingOneEnvironmentAccessor(pingOneEnvironment);
            this.baseUrl = this.pingOneEnvironmentAccessor.getManagementEndpoint() + "/v1";
            this.tokenServerUrl = this.pingOneEnvironmentAccessor.getAuthenticationEndpoint(false);
            this.environmentId = this.pingOneEnvironmentAccessor.getEnvironmentId();
            this.environmentIdEndpoint = "/" + this.environmentId;
        } else {
            Region region = DataStoreConfiguration.RegionField.getRegion((Configuration)dsConfiguration);
            this.baseUrl = region.getApiEndpoint() + "/v1";
            this.tokenServerUrl = region.getAuthEndpoint();
            this.environmentId = dsConfiguration.getFieldValue("Environment ID");
            this.environmentIdEndpoint = "/" + this.environmentId;
            this.clientId = dsConfiguration.getFieldValue("Client ID");
            this.clientSecret = dsConfiguration.getFieldValue("Client Secret");
        }
        this.requestTimeoutMillis = dsConfiguration.getIntFieldValue("Connection Timeout");
        this.maxRetriesAttempt = dsConfiguration.getIntFieldValue("Maximum Retries Limit");
        this.retryRequest = dsConfiguration.getBooleanFieldValue("Retry Request");
        String errorCodeValuesForRetries = dsConfiguration.getFieldValue("Retry Error Codes");
        this.errorCodeForRetries.clear();
        if (errorCodeValuesForRetries != null && !errorCodeValuesForRetries.isEmpty()) {
            String[] errorCodeArr = errorCodeValuesForRetries.split(",");
            for (String errorCode : errorCodeArr) {
                this.errorCodeForRetries.add(errorCode.trim());
            }
        }
        if (!(customAttrsTable = dsConfiguration.getTable("Custom Attributes Details")).getRows().isEmpty()) {
            for (Row row : customAttrsTable.getRows()) {
                if (row == null) continue;
                String localAttribute = row.getFieldValue("Local Attribute");
                String path = row.getFieldValue("PingOne for Customers Attribute");
                if (localAttribute == null || localAttribute.isEmpty() || path == null || path.isEmpty()) continue;
                this.customAttributesTable.put(localAttribute, path);
            }
        }
        return dsConfiguration;
    }

    public void configure(Configuration configuration) {
        try {
            Field caseSensitiveField;
            this.customAuthnErrors = new ArrayList<CustomAuthorizationError>();
            Table authErrorTable = configuration.getTable("Authentication Error Overrides");
            if (authErrorTable != null && authErrorTable.getRows() != null) {
                for (Row authErrorRow : authErrorTable.getRows()) {
                    String errorId = authErrorRow.getFieldValue("Error");
                    String expr = authErrorRow.getFieldValue("Match Expression");
                    String msgKey = authErrorRow.getFieldValue("Message Properties Key");
                    CustomAuthorizationError customAuthnError = new CustomAuthorizationError(errorId, expr, msgKey, false);
                    this.customAuthnErrors.add(customAuthnError);
                }
            }
            if (configuration.getField("Enable User Group Info Retrieval") != null) {
                this.enableUserGroupInfoRetrieval = configuration.getBooleanFieldValue("Enable User Group Info Retrieval");
            }
            if (configuration.getField("Enable Device Info Retrieval") != null) {
                this.enableDeviceInfoRetrieval = configuration.getBooleanFieldValue("Enable Device Info Retrieval");
            }
            if (configuration.getField("Enable Password Expiry Info Retrieval") != null) {
                this.enablePasswordExpiryInfoRetrieval = configuration.getBooleanFieldValue("Enable Password Expiry Info Retrieval");
            }
            if ((caseSensitiveField = configuration.getField("Case-Sensitive Matching")) != null) {
                this.enableCaseSensitiveMatch = caseSensitiveField.getValueAsBoolean();
            }
            this.dataSourceId = configuration.getFieldValue("PingOne For Customers Datastore");
            this.configuration = configuration;
            this.readDataStoreConfig();
            this.initializeHttpClient();
        }
        catch (ReadDataSourceConfigException e) {
            logger.log((LogEvent)PCVLogEvent.READ_DATA_SOURCE_ERROR, e);
        }
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.descriptor;
    }

    public AttributeMap processPasswordCredential(String username, String password) throws PasswordValidationException {
        logger.log((LogEvent)PCVLogEvent.GENERIC_LOG, "Processing password credential for user: " + username);
        if (PingOneForCustomersPCV.isNullOrEmpty(username) || PingOneForCustomersPCV.isNullOrEmpty(password)) {
            throw new PasswordValidationException("Unable to validate null credentials.");
        }
        this.readConfigStandaloneMode();
        HashMap<String, Object> userAttributes = this.authenticatePassword(username, password, false);
        return PingOneForCustomersPCVUtil.getAttributeMap(userAttributes);
    }

    public long getPasswordExpiry(String userID) {
        long passwordExpiryTime = 0L;
        try {
            String getPasswordStateUrl = this.getBasicUrl() + "/" + userID + PASSWORD_ENDPOINT;
            RequestResponse returnResponse = this.doRequest(this.generateHttpGetRequest(getPasswordStateUrl), true, null);
            String response = returnResponse.getResponse();
            JSONObject jsonResponseObj = new JSONObject(response);
            if (jsonResponseObj.has("lastChangedAt")) {
                String lastChangedAtValue = jsonResponseObj.getString("lastChangedAt");
                SimpleDateFormat sdf = new SimpleDateFormat(UTC_FORMAT);
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date date = sdf.parse(lastChangedAtValue);
                long lastChangedAtValueMillis = date.getTime();
                if (jsonResponseObj.has("passwordPolicy")) {
                    JSONObject passwordPolicyObj = jsonResponseObj.getJSONObject("passwordPolicy");
                    String passwordPolicyId = "";
                    if (passwordPolicyObj.has("id")) {
                        passwordPolicyId = passwordPolicyObj.getString("id");
                    }
                    if (!passwordPolicyId.isEmpty()) {
                        String getPasswordPolicyUrl = this.baseUrl + ENVIRONMENTS_ENDPOINT + this.environmentIdEndpoint + PASSWORD_POLICIES_ENDPOINT + "/" + passwordPolicyId;
                        RequestResponse pwdPolicyResponse = this.doRequest(this.generateHttpGetRequest(getPasswordPolicyUrl), true, null);
                        JSONObject pwdPolicyResponseJSON = new JSONObject(pwdPolicyResponse.getResponse());
                        long maxAgeDays = 0L;
                        if (pwdPolicyResponseJSON.has("maxAgeDays")) {
                            maxAgeDays = pwdPolicyResponseJSON.getInt("maxAgeDays");
                        }
                        passwordExpiryTime = TimeUnit.DAYS.toMillis(maxAgeDays) + lastChangedAtValueMillis;
                    }
                }
            }
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
        }
        catch (HttpServiceException | IOException | ParseException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.RESPONSE_PROCESSING_ERROR, e.getMessage());
        }
        return passwordExpiryTime;
    }

    private AuthenticationErrorInfo getAuthenticationError(JSONObject response) throws JSONException {
        String authenticationErrorMessage;
        String detailsCode;
        String otherDefaultMessage;
        JSONObject detailsObject;
        JSONArray details;
        String detailedMessage = response.toString();
        AuthenticationErrorInfo authenticationErrorInfo = new AuthenticationErrorInfo("Default Error", DEFAULT_ERROR_DESC, detailedMessage);
        String code = response.getString(CODE);
        if (code != null && code.equals("NOT_FOUND")) {
            String authenticationErrorMessage2 = response.getString(MESSAGE);
            authenticationErrorInfo = new AuthenticationErrorInfo("User Not Found", authenticationErrorMessage2, detailedMessage);
            return authenticationErrorInfo;
        }
        if (code != null && (details = response.getJSONArray(DETAILS)) != null && details.length() > 0 && (detailsObject = details.getJSONObject(0)) != null && (otherDefaultMessage = detailsObject.getString(MESSAGE)) != null && !otherDefaultMessage.isEmpty()) {
            authenticationErrorInfo.setErrorMessage(otherDefaultMessage);
        }
        if (code != null && code.equals("REQUEST_FAILED") && (details = response.getJSONArray(DETAILS)) != null && details.length() > 0) {
            detailsObject = details.getJSONObject(0);
            detailsCode = detailsObject.getString(CODE);
            if (detailsCode != null && detailsCode.equalsIgnoreCase("PASSWORD_LOCKED_OUT")) {
                String authenticationErrorMessage3 = detailsObject.getString(MESSAGE);
                authenticationErrorInfo = new AuthenticationErrorInfo("Password Locked Out", authenticationErrorMessage3, detailedMessage);
                return authenticationErrorInfo;
            }
            if (detailsCode != null && detailsCode.equalsIgnoreCase("PASSWORD_TOO_YOUNG")) {
                String authenticationErrorMessage4 = detailsObject.getString(MESSAGE);
                authenticationErrorInfo = new AuthenticationErrorInfo("Password Too Young", authenticationErrorMessage4, detailedMessage);
                return authenticationErrorInfo;
            }
        }
        if (code != null && code.equals("INVALID_DATA") && (details = response.getJSONArray(DETAILS)) != null && details.length() > 0) {
            detailsObject = details.getJSONObject(0);
            detailsCode = detailsObject.getString(CODE);
            String target = detailsObject.getString("target");
            if (detailsCode != null && detailsCode.equalsIgnoreCase("INVALID_VALUE")) {
                String authenticationErrorMessage5 = detailsObject.getString(MESSAGE);
                authenticationErrorInfo = target != null && "password".equalsIgnoreCase(target) ? new AuthenticationErrorInfo("Invalid Credentials", authenticationErrorMessage5, detailedMessage) : new AuthenticationErrorInfo("Password Policy Violated", authenticationErrorMessage5, detailedMessage);
                return authenticationErrorInfo;
            }
        }
        if (code != null && code.equals("REQUEST_FAILED") && (details = response.getJSONArray(DETAILS)) != null && details.length() > 0 && (detailsCode = (detailsObject = details.getJSONObject(0)).getString(CODE)) != null && detailsCode.equalsIgnoreCase("NO_PASSWORD")) {
            authenticationErrorMessage = detailsObject.getString(MESSAGE);
            authenticationErrorInfo = new AuthenticationErrorInfo("No Password", authenticationErrorMessage, detailedMessage);
            return authenticationErrorInfo;
        }
        if (code != null && code.equals("REQUEST_FAILED") && (details = response.getJSONArray(DETAILS)) != null && details.length() > 0 && (detailsCode = (detailsObject = details.getJSONObject(0)).getString(CODE)) != null && detailsCode.equalsIgnoreCase("ACCOUNT_NOT_USABLE")) {
            authenticationErrorMessage = detailsObject.getString(MESSAGE);
            authenticationErrorInfo = new AuthenticationErrorInfo("Account Disabled", authenticationErrorMessage, detailedMessage);
            return authenticationErrorInfo;
        }
        return authenticationErrorInfo;
    }

    public HashMap<String, Object> authenticatePassword(String username, String password, boolean isChangePassword) {
        try {
            logger.log((LogEvent)PCVLogEvent.VALIDATE_USER, username);
            HashMap<String, Object> userAttributes = this.retrieveUserAttributes("username", username, !isChangePassword);
            String userId = (String)userAttributes.get("id");
            String validationUrl = this.getBasicUrl() + "/" + userId + PASSWORD_ENDPOINT;
            Map<String, String> body = Collections.singletonMap("password", password);
            GenericHttpBody httpBody = PingOneForCustomersPCV.getBody(body);
            GenericHttpRequest post = this.generateHttpRequest(GenericHttpMethod.POST, validationUrl, APPLICATION_CHECK, httpBody);
            RequestResponse returnResponse = this.doRequest(post, true, body);
            String vResponse = returnResponse.getResponse();
            JSONObject res = new JSONObject(vResponse);
            if (returnResponse.getStatusCode() == 200) {
                String result;
                switch (result = res.getString(STATUS)) {
                    case "OK": {
                        if (this.enableUserGroupInfoRetrieval) {
                            HashMap<String, Object> userGroupAttributes = this.retrieveUserGroupAttributesAttributes(userId);
                            userAttributes.putAll(userGroupAttributes);
                        } else {
                            logger.log((LogEvent)PCVLogEvent.GENERIC_LOG, "Skipping group attributes info retrieval");
                        }
                        return userAttributes;
                    }
                    case "PASSWORD_EXPIRED": {
                        PCVResult pcvResult = PCVResult.getByExplanation("User Password Expired", PWD_EXPIRED_DESC, this.customAuthnErrors, this.enableCaseSensitiveMatch);
                        pcvResult.raisePcvExpiredPasswordAuthnException(userId);
                    }
                    case "MUST_CHANGE_PASSWORD": {
                        PCVResult pcvResult;
                        if (!isChangePassword) {
                            pcvResult = PCVResult.getByExplanation("User Must Change Password", MUST_CHANGE_PWD_DESC, this.customAuthnErrors, this.enableCaseSensitiveMatch);
                            pcvResult.raisePcvAuthnException();
                            break;
                        }
                        if (this.enableUserGroupInfoRetrieval) {
                            HashMap<String, Object> userGroupAttributes = this.retrieveUserGroupAttributesAttributes(userId);
                            userAttributes.putAll(userGroupAttributes);
                        } else {
                            logger.log((LogEvent)PCVLogEvent.GENERIC_LOG, "Skipping group attributes info retrieval");
                        }
                        return userAttributes;
                    }
                }
                throw new PasswordCredentialValidatorAuthnException(false, DEFAULT_ERROR_DESC, (Throwable)new Exception(DEFAULT_ERROR_DESC));
            }
            AuthenticationErrorInfo authErrorInfo = this.getAuthenticationError(res);
            PCVResult result = PCVResult.getByExplanation(authErrorInfo.getErrorCode(), authErrorInfo.getDetailedErrorMessage(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
            result.raisePcvAuthnException(authErrorInfo.getErrorMessage());
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.CREDENTIAL_ERROR, e);
            throw new PasswordCredentialValidatorAuthnException(false, DEFAULT_ERROR_DESC, e);
        }
        return null;
    }

    private HashMap<String, Object> getMapFromJSONUserObject(JSONObject user) throws JSONException {
        JSONObject photoObj;
        HashMap<String, Object> userAttributesMap = new HashMap<String, Object>();
        if (user.has("email")) {
            userAttributesMap.put("email", user.getString("email"));
        }
        if (user.has("name")) {
            JSONObject nameObj = user.getJSONObject("name");
            if (nameObj.has("family")) {
                userAttributesMap.put("name.family", nameObj.getString("family"));
            }
            if (nameObj.has("formatted")) {
                userAttributesMap.put("name.formatted", nameObj.getString("formatted"));
            }
            if (nameObj.has("given")) {
                userAttributesMap.put("name.given", nameObj.getString("given"));
            }
            if (nameObj.has("honorificPrefix")) {
                userAttributesMap.put("name.honorificPrefix", nameObj.getString("honorificPrefix"));
            }
            if (nameObj.has("honorificSuffix")) {
                userAttributesMap.put("name.honorificSuffix", nameObj.getString("honorificSuffix"));
            }
            if (nameObj.has("middle")) {
                userAttributesMap.put("name.middle", nameObj.getString("middle"));
            }
        }
        if (user.has("nickname")) {
            userAttributesMap.put("nickname", user.getString("nickname"));
        }
        if (user.has("photo") && (photoObj = user.getJSONObject("photo")).has("href")) {
            userAttributesMap.put("photo.href", photoObj.getString("href"));
        }
        if (user.has("id")) {
            userAttributesMap.put("id", user.getString("id"));
        }
        if (user.has("createdAt")) {
            userAttributesMap.put("createdAt", user.getString("createdAt"));
        }
        if (user.has("updatedAt")) {
            userAttributesMap.put("updatedAt", user.getString("updatedAt"));
        }
        if (user.has("username")) {
            userAttributesMap.put("username", user.getString("username"));
        }
        if (user.has("title")) {
            userAttributesMap.put("title", user.getString("title"));
        }
        if (user.has("primaryPhone")) {
            userAttributesMap.put("primaryPhone", user.getString("primaryPhone"));
        }
        if (user.has("mobilePhone")) {
            userAttributesMap.put("mobilePhone", user.getString("mobilePhone"));
        }
        if (user.has("mfaEnabled")) {
            userAttributesMap.put("mfaEnabled", Boolean.toString(user.getBoolean("mfaEnabled")));
        }
        if (user.has("enabled")) {
            userAttributesMap.put("enabled", Boolean.toString(user.getBoolean("enabled")));
        }
        if (user.has("locale")) {
            userAttributesMap.put("locale", user.getString("locale"));
        }
        if (user.has("preferredLanguage")) {
            userAttributesMap.put("preferredLanguage", user.getString("preferredLanguage"));
        }
        if (user.has("timezone")) {
            userAttributesMap.put("timezone", user.getString("timezone"));
        }
        if (user.has("address")) {
            JSONObject addressObj = user.getJSONObject("address");
            if (addressObj.has("countryCode")) {
                userAttributesMap.put("address.countryCode", addressObj.getString("countryCode"));
            }
            if (addressObj.has("locality")) {
                userAttributesMap.put("address.locality", addressObj.getString("locality"));
            }
            if (addressObj.has("postalCode")) {
                userAttributesMap.put("address.postalCode", addressObj.getString("postalCode"));
            }
            if (addressObj.has("streetAddress")) {
                userAttributesMap.put("address.streetAddress", addressObj.getString("streetAddress"));
            }
            if (addressObj.has("region")) {
                userAttributesMap.put("address.region", addressObj.getString("region"));
            }
        }
        Set<String> keys = this.customAttributesTable.keySet();
        for (String key : keys) {
            String path = this.customAttributesTable.get(key);
            try {
                JsonNode result = JsonPointerUtil.evaluateJsonPointer(mapper, path, user.toString());
                userAttributesMap.put(key, JsonNodeUtil.convert(result));
            }
            catch (JsonPointerUtilException e) {
                logger.log((LogEvent)PCVLogEvent.ERROR_EVALUATING_JSON_POINTER, key);
            }
        }
        return userAttributesMap;
    }

    public HashMap<String, Object> retrieveUserDeviceAttributes(String userID) {
        HashMap<String, Object> userDeviceAttributesMap = new HashMap<String, Object>();
        try {
            String url = this.getBasicUrl() + "/" + userID + DEVICES_ENDPOINT;
            RequestResponse returnResponse = this.doRequest(this.generateHttpGetRequest(url), true, null);
            String response = returnResponse.getResponse();
            JSONObject obj = new JSONObject(response);
            if (obj.getInt(SIZE) == 0) {
                logger.log((LogEvent)PCVLogEvent.NO_DEVICE_INFO, userID);
                return userDeviceAttributesMap;
            }
            JSONObject emb = obj.getJSONObject("_embedded");
            JSONArray devices = emb.getJSONArray("devices");
            boolean phoneNumberRead = false;
            boolean emailRead = false;
            for (int index = 0; index < devices.length(); ++index) {
                JSONObject device = (JSONObject)devices.get(index);
                String deviceType = (String)device.get("type");
                if (deviceType.equals("EMAIL") && !emailRead) {
                    String emailValue = (String)device.get("email");
                    if (emailValue == null || emailValue.isEmpty()) continue;
                    userDeviceAttributesMap.put("devices.email", emailValue);
                    emailRead = true;
                    continue;
                }
                if (deviceType.equals("SMS") && !phoneNumberRead) {
                    String phoneValue = (String)device.get("phone");
                    if (phoneValue == null || phoneValue.isEmpty()) continue;
                    userDeviceAttributesMap.put("devices.phone", phoneValue);
                    phoneNumberRead = true;
                    continue;
                }
                if (!phoneNumberRead || !emailRead) {
                    continue;
                }
                break;
            }
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.RESPONSE_PROCESSING_ERROR, e.getMessage());
        }
        return userDeviceAttributesMap;
    }

    public HashMap<String, Object> retrieveUserAttributes(String filter, String field, boolean isAuthenticatePasswordFlow) {
        HashMap<String, Object> userAttributesMap = new HashMap<String, Object>();
        try {
            String encodedFieldValue = URLEncoder.encode(" eq \"", StandardCharsets.UTF_8.displayName()) + URLEncoder.encode(field, StandardCharsets.UTF_8.displayName()) + URLEncoder.encode("\"", StandardCharsets.UTF_8.displayName());
            String url = this.getBasicUrl() + "?filter=" + filter + encodedFieldValue.replace("+", "%20");
            RequestResponse returnResponse = this.doRequest(this.generateHttpGetRequest(url), true, null);
            String response = returnResponse.getResponse();
            JSONObject obj = new JSONObject(response);
            if (obj.getInt(SIZE) == 0) {
                logger.log((LogEvent)PCVLogEvent.USER_NOT_FOUND, filter, field);
                PCVResult result = PCVResult.getByExplanation("User Not Found", "User Not Found", this.customAuthnErrors, this.enableCaseSensitiveMatch);
                result.raisePcvAuthnException();
            }
            JSONObject emb = obj.getJSONObject("_embedded");
            JSONArray users = emb.getJSONArray("users");
            JSONObject user = users.getJSONObject(0);
            userAttributesMap = this.getMapFromJSONUserObject(user);
            if (user.has("id")) {
                String userId = (String)user.get("id");
                if (isAuthenticatePasswordFlow) {
                    if (this.enableDeviceInfoRetrieval) {
                        HashMap<String, Object> deviceAttributesMap = this.retrieveUserDeviceAttributes(userId);
                        userAttributesMap.putAll(deviceAttributesMap);
                    } else {
                        logger.log((LogEvent)PCVLogEvent.GENERIC_LOG, "Skipping device attributes info retrieval");
                    }
                    if (this.enablePasswordExpiryInfoRetrieval) {
                        long expiryTimeInMillis = this.getPasswordExpiry(userId);
                        userAttributesMap.put("passwordExpiryTime", Long.toString(expiryTimeInMillis));
                    } else {
                        logger.log((LogEvent)PCVLogEvent.GENERIC_LOG, "Skipping password expiry info retrieval");
                    }
                } else {
                    HashMap<String, Object> deviceAttributesMap = this.retrieveUserDeviceAttributes(userId);
                    userAttributesMap.putAll(deviceAttributesMap);
                    long expiryTimeInMillis = this.getPasswordExpiry(userId);
                    userAttributesMap.put("passwordExpiryTime", Long.toString(expiryTimeInMillis));
                }
            }
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.RESPONSE_PROCESSING_ERROR, e.getMessage());
        }
        return userAttributesMap;
    }

    public HashMap<String, Object> retrieveUserGroupAttributesAttributes(String userID) {
        HashMap<String, Object> userGroupAttributesMap = new HashMap<String, Object>();
        try {
            String url = this.getBasicUrl() + "/" + userID + "?" + GROUP_QUERY_PARAM;
            RequestResponse returnResponse = this.doRequest(this.generateHttpGetRequest(url), true, null);
            String response = returnResponse.getResponse();
            JSONObject obj = new JSONObject(response);
            if (!obj.isNull("memberOfGroupIDs")) {
                JSONArray groupIDs = obj.getJSONArray("memberOfGroupIDs");
                userGroupAttributesMap.put("memberOfGroupIDs", groupIDs);
            }
            if (!obj.isNull("memberOfGroupNames")) {
                JSONArray groupNames = obj.getJSONArray("memberOfGroupNames");
                userGroupAttributesMap.put("memberOfGroupNames", groupNames);
            }
        }
        catch (IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.RESPONSE_PROCESSING_ERROR, e.getMessage());
        }
        catch (HttpServiceException e) {
            logger.log((LogEvent)PCVLogEvent.RETRIEVING_USER_ERROR, e, e.getMessage());
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e, e.getMessage());
        }
        return userGroupAttributesMap;
    }

    public PasswordChangeResult changePassword(String username, String oldPassword, String newPassword, Map<String, Object> inParameters) throws PasswordValidationException {
        try {
            Map<String, String> body;
            String url;
            logger.log(PCVLogEvent.CHANGE_PASSWORD);
            this.readConfigStandaloneMode();
            HashMap<Object, Object> userAttributes = new HashMap();
            boolean expiredPasswordCase = false;
            String userId = null;
            try {
                userAttributes = this.authenticatePassword(username, oldPassword, true);
            }
            catch (PasswordCredentialValidatorAuthnException pcve) {
                PCVResult pcvResult = PCVResult.getByExplanation("User Password Expired", PWD_EXPIRED_DESC, this.customAuthnErrors, this.enableCaseSensitiveMatch);
                if (pcve instanceof ExpiredPasswordCredentialValidatorAuthnException) {
                    userId = ((ExpiredPasswordCredentialValidatorAuthnException)pcve).getUserId();
                    expiredPasswordCase = true;
                }
                throw pcve;
            }
            RequestResponse returnResponse = null;
            JSONObject obj = null;
            String response = null;
            if (expiredPasswordCase) {
                url = this.getBasicUrl() + "/" + userId + PASSWORD_ENDPOINT;
                body = Collections.singletonMap("value", newPassword);
                GenericHttpBody httpBody = PingOneForCustomersPCV.getBody(body);
                GenericHttpRequest put = this.generateHttpRequest(GenericHttpMethod.PUT, url, APPLICATION_SET, httpBody);
                returnResponse = this.doRequest(put, true, body);
                response = returnResponse.getResponse();
                obj = new JSONObject(response);
            } else {
                url = this.getBasicUrl() + "/" + userAttributes.get("id") + PASSWORD_ENDPOINT;
                body = new HashMap<String, String>();
                body.put("currentPassword", oldPassword);
                body.put("newPassword", newPassword);
                GenericHttpBody httpBody = PingOneForCustomersPCV.getBody(body);
                GenericHttpRequest put = this.generateHttpRequest(GenericHttpMethod.PUT, url, APPLICATION_RESET, httpBody);
                returnResponse = this.doRequest(put, true, body);
                response = returnResponse.getResponse();
                obj = new JSONObject(response);
            }
            if (returnResponse.getStatusCode() == 200) {
                logger.log((LogEvent)PCVLogEvent.RESPONSE_OK, returnResponse.getStatusCode());
                String result = obj.getString(STATUS);
                if (!STATUS_OK.equals(result)) {
                    throw new PasswordCredentialValidatorAuthnException(false, PWD_CHANGE_FAILED_DESC, (Throwable)new Exception(PWD_CHANGE_FAILED_DESC));
                }
            } else {
                logger.log((LogEvent)PCVLogEvent.RESPONSE_NOT_OK, returnResponse.getStatusCode(), response);
                AuthenticationErrorInfo authErrorInfo = this.getAuthenticationError(obj);
                PCVResult result = PCVResult.getByExplanation(authErrorInfo.getErrorCode(), authErrorInfo.getDetailedErrorMessage(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
                result.raisePcvAuthnException(authErrorInfo.getErrorMessage());
            }
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.CHANGE_PASSWORD_ERROR, e);
            throw new PasswordCredentialValidatorAuthnException(false, DEFAULT_ERROR_DESC, e);
        }
        return new PasswordChangeResult();
    }

    public boolean isPendingPasswordExpiryNotifiable() {
        return true;
    }

    public boolean isChangePasswordEmailNotifiable() {
        return true;
    }

    public boolean isPasswordChangeable() {
        return true;
    }

    public AttributeMap findUser(String username) throws PasswordResetException {
        this.readConfigStandaloneMode();
        HashMap<String, Object> userAttributes = this.retrieveUserAttributes("username", username, false);
        HashMap<String, Object> userGroupAttributes = this.retrieveUserGroupAttributesAttributes(username);
        userAttributes.putAll(userGroupAttributes);
        boolean isEnabled = Boolean.valueOf((String)userAttributes.get("enabled"));
        if (!isEnabled) {
            logger.log(PCVLogEvent.ACCOUNT_RECOVERY_NOT_ALLOWED_FOR_DISABLED_USER);
            PCVResult pcvResult = PCVResult.getByExplanation("Account Recovery Forbidden", ACCOUNT_RECOVERY_FORBIDDEN_DISABLED_USER_DESC, this.customAuthnErrors, this.enableCaseSensitiveMatch);
            pcvResult.raisePasswordResetException(ACCOUNT_RECOVERY_FORBIDDEN_DISABLED_USER_DESC);
        }
        return PingOneForCustomersPCVUtil.getAttributeMap(userAttributes);
    }

    public List<AttributeMap> findUsersByMail(String mail) throws UsernameRecoveryException {
        logger.log(PCVLogEvent.FIND_BY_EMAIL);
        this.readConfigStandaloneMode();
        ArrayList<AttributeMap> resultMaps = new ArrayList<AttributeMap>();
        try {
            String url = this.getBasicUrl() + "?filter=email" + URLEncoder.encode(" eq \"", StandardCharsets.UTF_8.displayName()) + URLEncoder.encode(mail, StandardCharsets.UTF_8.displayName()) + URLEncoder.encode("\"", StandardCharsets.UTF_8.displayName());
            RequestResponse returnResponse = this.doRequest(this.generateHttpGetRequest(url), true, null);
            String response = returnResponse.getResponse();
            JSONObject obj = new JSONObject(response);
            int numberOfUsers = obj.getInt(SIZE);
            JSONObject emb = obj.getJSONObject("_embedded");
            JSONArray users = emb.getJSONArray("users");
            for (int i = 0; i < numberOfUsers; ++i) {
                JSONObject user = users.getJSONObject(i);
                AttributeMap userAttributes = new AttributeMap();
                HashMap<String, Object> userInfoMap = this.getMapFromJSONUserObject(user);
                if (user.has("id")) {
                    String userId = (String)user.get("id");
                    HashMap<String, Object> deviceAttributesMap = this.retrieveUserDeviceAttributes(userId);
                    userInfoMap.putAll(deviceAttributesMap);
                }
                AttributeMap attributeMap = PingOneForCustomersPCVUtil.getAttributeMap(userInfoMap);
                userAttributes.put(this.getUsernameAttribute(), (AttributeValue)attributeMap.get((Object)this.getUsernameAttribute()));
                userAttributes.put(this.getNameAttribute(), (AttributeValue)attributeMap.get((Object)this.getNameAttribute()));
                userAttributes.put(this.getMailVerifiedAttribute(), (AttributeValue)attributeMap.get((Object)"enabled"));
                resultMaps.add(userAttributes);
            }
            if (resultMaps.isEmpty()) {
                logger.log((LogEvent)PCVLogEvent.USER_NOT_FOUND, "mail", mail);
                throw new UsernameRecoveryException("User Not Found: " + mail);
            }
            return resultMaps;
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.RETRIEVING_USER_ERROR, e);
        }
        return null;
    }

    public String getMailAttribute() {
        String mail = this.configuration.getFieldValue("Mail Attribute");
        if (StringUtils.isNotBlank((String)mail)) {
            return mail;
        }
        return "email";
    }

    public String getNameAttribute() {
        String displayNameAttribute = this.configuration.getFieldValue("Display Name Attribute");
        if (StringUtils.isNotBlank((String)displayNameAttribute)) {
            return displayNameAttribute;
        }
        return "name.formatted";
    }

    public String getPingIdUsernameAttribute() {
        String pingIDAttribute = this.configuration.getFieldValue("PingID Username Attribute");
        if (StringUtils.isNotBlank((String)pingIDAttribute)) {
            return pingIDAttribute;
        }
        return "username";
    }

    public String getMailVerifiedAttribute() {
        String mailVerifiedAttribute = this.configuration.getFieldValue("Mail Verified Attribute");
        if (StringUtils.isNotBlank((String)mailVerifiedAttribute)) {
            return mailVerifiedAttribute;
        }
        return "enabled";
    }

    public String getUsernameAttribute() {
        String usernameAttribute = this.configuration.getFieldValue("Username Attribute");
        if (StringUtils.isNotBlank((String)usernameAttribute)) {
            return usernameAttribute;
        }
        return "username";
    }

    public String getSmsAttribute() {
        String smsAttribute = this.configuration.getFieldValue("SMS Attribute");
        if (StringUtils.isNotBlank((String)smsAttribute)) {
            return smsAttribute;
        }
        return "mobilePhone";
    }

    public void resetPassword(String username, String password) throws PasswordResetException {
        try {
            logger.log(PCVLogEvent.RESET_PASSWORD);
            this.readConfigStandaloneMode();
            HashMap<String, Object> userAttributes = this.retrieveUserAttributes("username", username, false);
            String url = this.getBasicUrl() + "/" + userAttributes.get("id") + PASSWORD_ENDPOINT;
            Map<String, String> body = Collections.singletonMap("value", password);
            GenericHttpBody httpBody = PingOneForCustomersPCV.getBody(body);
            GenericHttpRequest put = this.generateHttpRequest(GenericHttpMethod.PUT, url, APPLICATION_SET, httpBody);
            RequestResponse returnResponse = this.doRequest(put, true, body);
            String response = returnResponse.getResponse();
            JSONObject obj = new JSONObject(response);
            if (returnResponse.getStatusCode() == 200) {
                logger.log((LogEvent)PCVLogEvent.RESPONSE_OK, returnResponse.getStatusCode());
                String result = obj.getString(STATUS);
                if (!STATUS_OK.equals(result)) {
                    throw new PasswordCredentialValidatorAuthnException(false, PWD_RESET_FAILED_DESC, (Throwable)new Exception(PWD_RESET_FAILED_DESC));
                }
            } else {
                logger.log((LogEvent)PCVLogEvent.RESPONSE_NOT_OK, returnResponse.getStatusCode(), response);
                AuthenticationErrorInfo authErrorInfo = this.getAuthenticationError(obj);
                PCVResult result = PCVResult.getByExplanation(authErrorInfo.getErrorCode(), authErrorInfo.getDetailedErrorMessage(), this.customAuthnErrors, this.enableCaseSensitiveMatch);
                result.raisePasswordResetException(authErrorInfo.getErrorMessage());
            }
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.RESET_PASSWORD_ERROR, e);
            throw new PasswordCredentialValidatorAuthnException(false, DEFAULT_ERROR_DESC, e);
        }
    }

    public boolean isPasswordResettable() {
        return true;
    }

    public boolean unlockAccount(String username) {
        try {
            logger.log(PCVLogEvent.UNLOCK_ACCOUNT);
            this.readConfigStandaloneMode();
            HashMap<String, Object> userAttributes = this.retrieveUserAttributes("username", username, false);
            String url = this.getBasicUrl() + "/" + userAttributes.get("id") + PASSWORD_ENDPOINT;
            GenericHttpRequest post = this.generateHttpRequest(GenericHttpMethod.POST, url, APPLICATION_UNLOCK, null);
            RequestResponse returnResponse = this.doRequest(post, true, null);
            String response = returnResponse.getResponse();
            JSONObject obj = new JSONObject(response);
            if (returnResponse.getStatusCode() == 200) {
                logger.log((LogEvent)PCVLogEvent.RESPONSE_OK, returnResponse.getStatusCode());
                String result = obj.getString(STATUS);
                if (STATUS_OK.equals(result)) {
                    return true;
                }
                throw new PasswordCredentialValidatorAuthnException(false, ACCOUNT_UNLOCK_FAILED_DESC, (Throwable)new Exception(ACCOUNT_UNLOCK_FAILED_DESC));
            }
            logger.log((LogEvent)PCVLogEvent.RESPONSE_NOT_OK, returnResponse.getStatusCode(), response);
            String exceptionMessage = "Account unlock was unsuccessful.";
            throw new PasswordCredentialValidatorAuthnException(true, exceptionMessage, (Throwable)new Exception(exceptionMessage));
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
            return false;
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.UNLOCK_ACCOUNT_ERROR, e);
            throw new PasswordCredentialValidatorAuthnException(false, DEFAULT_ERROR_DESC, e);
        }
    }

    public boolean isAccountLocked(String username) {
        boolean isLocked = false;
        try {
            JSONArray details;
            JSONObject code;
            String cond;
            logger.log(PCVLogEvent.CHECK_ACCOUNT_LOCK);
            this.readConfigStandaloneMode();
            HashMap<String, Object> userAttributes = this.retrieveUserAttributes("username", username, false);
            String url = this.getBasicUrl() + "/" + userAttributes.get("id") + PASSWORD_ENDPOINT;
            RequestResponse returnResponse = this.doRequest(this.generateHttpGetRequest(url), true, null);
            String response = returnResponse.getResponse();
            JSONObject obj = new JSONObject(response);
            if (returnResponse.getStatusCode() == 400 && (cond = (code = (details = obj.getJSONArray(DETAILS)).getJSONObject(0)).getString(CODE)).equals("PASSWORD_LOCKED_OUT")) {
                isLocked = true;
            }
        }
        catch (AccessTokenProviderException e) {
            logger.log((LogEvent)PCVLogEvent.ERROR_GETTING_ACCESS_TOKEN, e);
            isLocked = true;
        }
        catch (HttpServiceException | IOException | JSONException e) {
            logger.log((LogEvent)PCVLogEvent.CHECK_ACCOUNT_LOCK_ERROR, e);
            throw new PasswordCredentialValidatorAuthnException(false, DEFAULT_ERROR_DESC, e);
        }
        return isLocked;
    }

    public boolean isAccountUnlockable() {
        return true;
    }

    private String getAccessToken(boolean refresh) throws IOException, HttpServiceException, AccessTokenProviderException {
        String result = this.accessTokenHolder.getAccessToken();
        if (result == null || refresh) {
            if (this.pingOneEnvironmentAccessor != null) {
                logger.log(PCVLogEvent.GET_ACCESS_TOKEN);
                try {
                    result = this.pingOneEnvironmentAccessor.getAccessToken();
                    this.accessTokenHolder.setAccessToken(result);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new AccessTokenProviderException("Error requesting access token", e);
                }
            } else {
                result = this.retrieveAccessToken();
                this.accessTokenHolder.setAccessToken(result);
            }
        }
        return result;
    }

    private String retrieveAccessToken() throws IOException, HttpServiceException, AccessTokenProviderException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
        headerMap.put("Connection", "Keep-Alive");
        String encoding = Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes());
        headerMap.put("Authorization", "Basic " + encoding);
        GenericHttpQueryParams params = new GenericHttpQueryParams();
        params.add("grant_type", "client_credentials");
        params.add("action", "getjson");
        String url = this.tokenServerUrl + this.environmentIdEndpoint + TOKEN_ENDPOINT;
        GenericHttpRequest post = new GenericHttpRequest(GenericHttpMethod.POST, url, params, new GenericHttpHeaders(headerMap));
        RequestResponse returnResponse = this.doRequest(post, false, null);
        String response = returnResponse.getResponse();
        AccessTokenResponse accessTokenResponse = mapper.readValue(response, AccessTokenResponse.class);
        return accessTokenResponse.getAccessToken();
    }

    private GenericHttpRequest generateHttpRequest(GenericHttpMethod method, String url, String contentType, GenericHttpBody body) throws IOException, HttpServiceException, AccessTokenProviderException {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", contentType);
        headerMap.put("Connection", "Keep-Alive");
        headerMap.put("Authorization", "Bearer " + this.getAccessToken(false));
        return new GenericHttpRequest(method, url, new GenericHttpQueryParams(), new GenericHttpHeaders(headerMap), body);
    }

    public GenericHttpRequest generateHttpGetRequest(String url) throws IOException, HttpServiceException, AccessTokenProviderException {
        return this.generateHttpRequest(GenericHttpMethod.GET, url, ContentType.APPLICATION_JSON.toString(), null);
    }

    private RequestResponse doRequest(GenericHttpRequest request, boolean refreshAccessTokenIfNecessary, Map<String, String> payloadData) throws IOException, HttpServiceException, AccessTokenProviderException {
        int retryAttemptNumber = 0;
        boolean done = false;
        int statusCode = 0;
        RequestResponse currResponse = null;
        boolean firstAttempt = true;
        while (!done) {
            if (!(firstAttempt || this.backoffCalculator.shouldRetry() && retryAttemptNumber <= this.maxRetriesAttempt)) {
                logger.log(PCVLogEvent.EXCEEDING_RETRY);
                throw new IOException("Exceeded configured retries number or maximum retries attempt due to rate limiting");
            }
            if (!firstAttempt && this.backoffCalculator.isBackOffEnforced()) {
                long waitTime = this.backoffCalculator.calculateRetryDelay();
                logger.log((LogEvent)PCVLogEvent.BACKOFF_ENFORCED, (double)waitTime / 1000.0);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e1) {
                    logger.log((LogEvent)PCVLogEvent.THREAD_INTERRUPTED, e1.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
            if (retryAttemptNumber == 0) {
                logger.log((LogEvent)PCVLogEvent.SEND_REQUEST, new Object[]{request.getMethod(), request.getUrl()});
            } else {
                logger.log((LogEvent)PCVLogEvent.RETRY_REQUEST, new Object[]{request.getMethod(), request.getUrl(), retryAttemptNumber});
            }
            GenericHttpResponse httpResponse = this.httpService.execute(request);
            statusCode = httpResponse.getStatusCode();
            firstAttempt = false;
            currResponse = new RequestResponse();
            currResponse.setResponse(httpResponse.getBody().getContent());
            currResponse.setStatusCode(statusCode);
            String statusCodeStr = Integer.toString(statusCode);
            int index = StringUtils.indexOfAny((CharSequence)statusCodeStr, (CharSequence[])this.errorCodeForRetries.toArray(new String[this.errorCodeForRetries.size()]));
            if (index != -1 && this.retryRequest) {
                if (!this.backoffCalculator.isBackOffEnforced()) {
                    this.backoffCalculator.enableBackOffEnforcement();
                }
                ++retryAttemptNumber;
                continue;
            }
            if ((statusCode == 401 || statusCode == 403) && refreshAccessTokenIfNecessary) {
                logger.log((LogEvent)PCVLogEvent.REFRESH_ACCESS_TOKEN, statusCode);
                refreshAccessTokenIfNecessary = false;
                GenericHttpHeaders headers = request.getHeaders();
                headers.addHeader("Authorization", "Bearer " + this.getAccessToken(true));
                if (payloadData != null) {
                    GenericHttpBody httpBody = PingOneForCustomersPCV.getBody(payloadData);
                    request = new GenericHttpRequest(request.getMethod(), request.getUrl(), request.getParameters(), headers, httpBody);
                    continue;
                }
                request = new GenericHttpRequest(request.getMethod(), request.getUrl(), request.getParameters(), headers);
                continue;
            }
            done = true;
            if (!this.backoffCalculator.isBackOffEnforced()) continue;
            this.backoffCalculator.resetBackOffEnforcement();
        }
        if (statusCode != 200) {
            logger.log((LogEvent)PCVLogEvent.RESPONSE_NOT_OK, statusCode, currResponse.getResponse());
        } else {
            logger.log((LogEvent)PCVLogEvent.REQUEST_RESPONSE, new Object[]{request.getMethod(), request.getUrl(), statusCode});
        }
        return currResponse;
    }

    private static ObjectMapper makeLowerCaseWithUnderscoresObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    private String getBasicUrl() {
        return this.baseUrl + ENVIRONMENTS_ENDPOINT + this.environmentIdEndpoint + USERS_ENDPOINT;
    }

    private static GenericHttpBody getBody(Map<String, String> values) {
        String content = new JSONObject(values).toString();
        return new GenericHttpBody(content, ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_JSON.getCharset().toString());
    }

    private static boolean isNullOrEmpty(String check) {
        return check == null || check.isEmpty();
    }

    public static class CustomAuthorizationError
    implements Serializable {
        private static final long serialVersionUID = 20121113L;
        private final String errorId;
        private final String expr;
        private final String msgKey;
        private final boolean isRecoverable;

        public CustomAuthorizationError(String errorId, String expr, String msgKey, boolean isRecoverable) {
            this.errorId = errorId;
            this.expr = expr;
            this.msgKey = msgKey;
            this.isRecoverable = isRecoverable;
        }

        public String getId() {
            return this.errorId;
        }

        public String getMsgKey() {
            return this.msgKey;
        }

        public boolean isRecoverable() {
            return this.isRecoverable;
        }

        public boolean matches(String value, boolean isCaseSensitive) {
            if (value == null) {
                return false;
            }
            return Util.wildCardMatch((String)value, (String)this.expr, (boolean)isCaseSensitive);
        }
    }
}

