/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.client5.http.protocol;

import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.client5.http.RouteInfo;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.http.EntityDetails;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.http.HttpException;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.http.HttpRequest;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.http.Method;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.http.protocol.HttpContext;
import com.pingidentity.plugins.pcvs.p14c.shade.org.apache.hc.core5.util.Args;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClientConnControl.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.cast(context);
        String exchangeId = clientContext.getExchangeId();
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection route not set in the context", (Object)exchangeId);
            }
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "keep-alive");
        }
    }
}

