/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.dataarchiver;

import com.pingidentity.csd.server.dataarchiver.FileDataArchiver;
import com.pingidentity.csd.server.dataarchiver.RootDataArchiver;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class DirectoryRootArchiver
extends RootDataArchiver {
    private String absoluteDirectoryPath;

    public DirectoryRootArchiver(String absoluteDirectoryPath) throws IOException {
        this.absoluteDirectoryPath = absoluteDirectoryPath;
        Files.createDirectory(Paths.get(absoluteDirectoryPath, new String[0]).normalize(), new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void archiveFile(String absolutePath, FileDataArchiver dataArchiver) throws Exception {
        Path archiveFilePath = Paths.get(this.absoluteDirectoryPath + "/" + absolutePath, new String[0]).normalize();
        OutputStream outputStream = null;
        try {
            Files.createDirectories(archiveFilePath.getParent(), new FileAttribute[0]);
            outputStream = Files.newOutputStream(archiveFilePath, StandardOpenOption.CREATE_NEW);
            dataArchiver.archive(outputStream);
        }
        catch (Exception e) {
            System.err.println("Exception caught while archiving file:" + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException ioe) {
                    System.err.println("Exception caught while close output stream:" + ioe.getMessage());
                    ioe.printStackTrace(System.err);
                }
            }
        }
    }

    @Override
    void deleteArchive() {
        Path p = Paths.get(this.absoluteDirectoryPath, new String[0]).normalize();
        try {
            Files.walkFileTree(p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path d, IOException exc) throws IOException {
                    Files.delete(d);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                    Files.delete(f);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            System.err.println("Exception caught while attempting to delete archive:" + e.getMessage());
            e.printStackTrace(System.err);
        }
        if (Files.exists(p, new LinkOption[0])) {
            System.err.println("Failed to completely remove " + p.toString());
        }
    }

    @Override
    void finish() {
    }
}

