/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector;

import com.pingidentity.csd.server.datacollector.DataCollector;
import com.pingidentity.csd.server.datacollector.DataCollectorFactory;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfigurationList;
import com.pingidentity.csd.server.datacollector.process.ProcessDataCollector;
import com.pingidentity.csd.server.datacollector.task.GCContextCollector;
import com.pingidentity.csd.server.datacollector.task.VisualizeReplicationStateDataCollector;
import com.pingidentity.csd.server.tools.CleanupAction;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.Command;
import com.pingidentity.csd.server.tools.ProcessBuilderUtil;
import com.pingidentity.csd.server.types.DataCollectorType;
import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.types.ProductType;
import com.pingidentity.csd.server.util.FormatUtils;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.collectsupportdata.ArchiveFileFilter;
import com.pingidentity.csd.tools.collectsupportdata.ArchiveFileFilterBuilder;
import com.pingidentity.csd.tools.collectsupportdata.ConfigFileUtil;
import com.pingidentity.csd.tools.collectsupportdata.FileAction;
import com.pingidentity.csd.tools.collectsupportdata.LDIFUtils;
import com.pingidentity.csd.tools.collectsupportdata.SecurityLevel;
import com.unboundid.common.util.SystemUtils;
import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.util.args.ArgumentException;
import java.io.File;
import java.io.FilenameFilter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataCollectorListBuilder {
    private final CollectSupportData collectSupportData;
    private List<DataCollector> dataCollectors = new ArrayList<DataCollector>();
    private List<CleanupAction> cleanupActions = new ArrayList<CleanupAction>();
    private boolean parallel = false;
    private File serverRoot;
    DataCollectorFactory dataCollectorFactory;

    public DataCollectorListBuilder(CollectSupportData collectSupportData, boolean parallel) {
        this.collectSupportData = collectSupportData;
        this.parallel = parallel;
        this.serverRoot = new File(collectSupportData.getServerRoot());
        this.dataCollectorFactory = new DataCollectorFactory(collectSupportData);
    }

    public void addDefaults(ProductType productType) {
        if (!this.collectSupportData.isArgumentPresent("noJDKTools")) {
            this.addJdkToolProcesses();
        }
        this.addFileListCollectors();
        this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JAR_MANIFEST, "jar-manifests"), this.parallel);
        this.addOperatingSystemSpecificCollectors();
        if (ProductType.isPingDirectoryProduct(productType)) {
            if (OperatingSystem.isUNIXBased(this.collectSupportData.getOs())) {
                this.addUnixServerProcesses();
            } else {
                this.addWindowsServerProcesses();
            }
        }
    }

    public void addVisualizeReplicationStateCollector() {
        this.addProcess(new VisualizeReplicationStateDataCollector(this.collectSupportData, CollectSupportData.ZipParentPath.VISUALIZE_REPLICATION_STATE, "README.txt", null), true);
    }

    public void addDataCollectorsFromConfigFile(String filePath) {
        DataCollectorConfigurationList dataCollectorConfigurationList = ConfigFileUtil.readDataCollectorConfigurationListFromYamlFile(filePath);
        for (DataCollectorConfiguration config : dataCollectorConfigurationList.getCollectors()) {
            this.addProcesses(this.dataCollectorFactory.getDataCollectors(config), this.parallel);
            this.collectSupportData.log("Read " + config.getId() + " collector from " + filePath + ", and added if applicable");
        }
    }

    public void addDataCollectors(Collection<DataCollector> collectors) {
        for (DataCollector collector : collectors) {
            this.addProcess(collector, this.parallel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addJdkToolProcesses() {
        if (this.collectSupportData.getJdkBinDirPath() != null) {
            this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JPS, "jps"), this.parallel);
            if (this.collectSupportData.maxJstacks > 0) {
                this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JSTACK_SERVER_PID, "jstack"), this.parallel);
            }
            if (this.collectSupportData.collectExpensiveData) {
                this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JSTACK_SERVER_PID_WITH_LOCKS, "jstack-with-locks"), this.parallel);
                this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JMAP_SERVER_PID, "jmap"), this.parallel);
                this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JINFO_SERVER_PID, "jinfo"), this.parallel);
                if (this.collectSupportData.getOs() == OperatingSystem.SOLARIS) {
                    this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JINFO64_SERVER_PID, "jinfo-64"), this.parallel);
                }
            }
            if (this.collectSupportData.reportCount > 0) {
                this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.JSTAT_SERVER_PID, "jstat"), this.parallel);
            }
            if (ProductType.isPingDirectoryProduct(this.collectSupportData.productType)) {
                this.addDBPrintLogCollectors(this.collectSupportData.getJdkBinDirPath());
            }
            try {
                for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.JSTACK_ADDITIONAL_PIDS, "jstack")) {
                    this.addProcess(dataCollector, this.parallel);
                }
                for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.JSTAT_ADDITIONAL_PIDS, "jstat")) {
                    this.addProcess(dataCollector, this.parallel);
                }
                if (!this.collectSupportData.collectExpensiveData) return;
                for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.JINFO_ADDITIONAL_PIDS, "jinfo")) {
                    this.addProcess(dataCollector, this.parallel);
                }
                for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.JINFO64_ADDITIONAL_PIDS, "jinfo-64")) {
                    this.addProcess(dataCollector, this.parallel);
                }
                return;
            }
            catch (Exception e) {
                this.collectSupportData.log("Error creating JDK tool process for additional pids", e);
                return;
            }
        } else {
            this.collectSupportData.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_NO_JDK.get());
        }
    }

    private void addFileListCollectors() {
        this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.ROOT_ERR_FILE_LIST, "server-root"), this.parallel);
        this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.ROOT_ERR_FILE_LIST_BY_LAST_MODIFIED, "server-root-last-modified"), this.parallel);
        this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.ROOT_ERR_FILE_LIST_BY_SIZE, "server-root-file-size"), this.parallel);
        if (OperatingSystem.isUNIXBased(this.collectSupportData.getOs())) {
            this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.UNIX_FULL_SERVER_ROOT, "full-server-root"), true);
        } else {
            this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.FULL_SERVER_ROOT, "full-server-root"), true);
            this.addProcess(this.dataCollectorFactory.getDataCollector(DataCollectorType.SERVER_ROOT_ACLS, "server-root-acls"), true);
        }
        try {
            for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.EXTERNAL_DIR_FILE_LIST, "external")) {
                this.addProcess(dataCollector, this.parallel);
            }
            if (OperatingSystem.isUNIXBased(this.collectSupportData.getOs())) {
                for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.EXTERNAL_UNIX_FULL_SERVER_ROOT, "full-")) {
                    this.addProcess(dataCollector, this.parallel);
                }
            } else {
                for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.EXTERNAL_FULL_SERVER_ROOT, "full-")) {
                    this.addProcess(dataCollector, this.parallel);
                }
                for (DataCollector dataCollector : this.dataCollectorFactory.getDataCollectors(DataCollectorType.EXTERNAL_SERVER_ROOT_ACLS, "-acls")) {
                    this.addProcess(dataCollector, this.parallel);
                }
            }
        }
        catch (Exception e) {
            this.collectSupportData.log("Error creating listing for external server directories", e);
        }
    }

    private void addOperatingSystemSpecificCollectors() {
        switch (this.collectSupportData.getOs()) {
            case LINUX: {
                this.addLinuxSystemProcesses(this.collectSupportData.isAlpine());
                break;
            }
            case SOLARIS: {
                this.addSolarisSystemProcesses();
                break;
            }
            case WINDOWS: {
                this.addWindowsSystemProcesses();
                break;
            }
            case MACOS: {
                this.addMacOsSystemProcesses();
                break;
            }
            case AIX: {
                this.addAixSystemProcesses();
                break;
            }
        }
    }

    private void addLinuxSystemProcesses(boolean isAlpine) {
        this.addProcess("messages", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.TAIL, "-100000c", "/var/log/messages");
        this.addProcess("release", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "cat /etc/*-release");
        this.addProcess("system-info", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.UNAME, "-a");
        this.addProcess("df", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.DF, "-k");
        this.addProcess("crontab", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CRONTAB, "-l");
        this.addProcess("crontab-etc", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/etc/crontab");
        this.addProcess("anacron", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "ls -alRF /etc/cron.*");
        this.addProcess("cpuinfo", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/proc/cpuinfo");
        this.addProcess("meminfo", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/proc/meminfo");
        this.addProcess("hosts", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/etc/hosts");
        this.addProcess("nsswitch.conf", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/etc/nsswitch.conf");
        this.addProcess("resolv.conf", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/etc/resolv.conf");
        this.addProcess("krb5.conf", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, this.getKerberosConfigPath());
        this.addProcess("krb5.log", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/var/log/krb5.log");
        this.addProcess("netstat-int", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.NETSTAT, "-i");
        this.addProcess("netstat-sum", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.NETSTAT, "-s");
        this.addProcess("netstat-rn", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.NETSTAT, "-rn");
        this.addProcess("netstat-an", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.NETSTAT, "-an");
        this.addProcess("ifconfig", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.IFCONFIG, "-a");
        this.addProcess("ip-addr", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.IP, "addr");
        this.addProcess("ip-maddr", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.IP, "maddr");
        this.addProcess("ip-link", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.IP, "-s", "link");
        this.addProcess("ip-route", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.IP, "route");
        this.addProcess("ss-an", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SS, "-an");
        this.addProcess("ss-s", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SS, "-s");
        this.addProcess("uptime", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.UPTIME, new String[0]);
        this.addProcess("dmesg", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.DMESG, new String[0]);
        this.addProcess("sysctl", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SYSCTL, "-a");
        this.addProcess("udevadm-info-exportdb", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.UDEVADM, "info", "--export-db");
        this.addProcess("ulimit-a", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "ulimit -a");
        this.addProcess("sar-today", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SAR, "-A");
        this.addProcess("product-name", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.CAT, "/sys/class/dmi/id/product_name");
        this.addProcess("disk-drive-type", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "for ssd in `cd /sys/block && ls -d sd*`; do echo $ssd `cat /sys/block/$ssd/queue/rotational`; done");
        this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.PS, "-elZf" + (isAlpine ? "" : "y"));
        StringBuffer sarCommand = new StringBuffer();
        GregorianCalendar calendar = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        boolean sarWeekFilesFound = false;
        for (int i = 0; i < 7; ++i) {
            calendar.add(5, -1);
            String saFile = "/var/log/sa/sa" + sdf.format(calendar.getTime());
            if (new File(saFile).isFile()) {
                sarWeekFilesFound = true;
                sarCommand.append(Command.SAR.getName() + " -A -f " + saFile + ";");
                continue;
            }
            this.collectSupportData.log("Sar file unavailable:" + saFile);
        }
        if (sarWeekFilesFound) {
            this.addProcess("sar-week", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", sarCommand.toString());
        } else {
            this.collectSupportData.log("No recent sa files found in /var/log/sa/ !");
        }
        if (this.collectSupportData.reportCount > 0) {
            this.addProcess("vmstat", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.VMSTAT, Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            if (this.isUnixCommandAvailable("iostat")) {
                this.addProcess("iostat", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.IOSTAT, "-x", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            }
            if (this.isUnixCommandAvailable("mpstat")) {
                this.addProcess("mpstat", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.MPSTAT, "-P", "ALL", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            }
            this.addProcess("sar", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SAR, "-A", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            this.addProcess("top", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "top -b -n " + Integer.toString(this.collectSupportData.reportCount) + " | head -n 15");
            if (this.isUnixCommandAvailable(Command.DSTAT.getName())) {
                this.addProcesses(Command.DSTAT.getName(), this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, this.collectSupportData.getServerPID(this.serverRoot), new String[][]{{Command.DSTAT.getName(), "--cpu", "--disk", "--page", "--swap", "--mem", "--net", "--nocolor", "--output", "dstat.csv", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount), ">/dev/null"}, {Command.CAT.getName(), "dstat.csv"}, {Command.RM.getName(), "dstat.csv"}});
            }
        }
        if (this.isUnixCommandAvailable(Command.ETHTOOL.getName())) {
            this.addProcess("ethtool", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "for interface in `find /sys/class/net/ -name 'eth*' -exec basename {} \\;`; do ethtool -c $interface; done");
        }
        if (this.isUnixCommandAvailable(Command.TUNEDADM.getName())) {
            this.addProcess(Command.TUNEDADM.getName(), this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.TUNEDADM.getName(), "active");
        }
        if (this.collectSupportData.collectExpensiveData && this.isUnixCommandAvailable(Command.SYSTEMCTL.getName())) {
            this.addProcess("systemctl-timers", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "for service in `systemctl list-timers --full --all | head -n -1 | tail -n +2 | awk 'NF>1{print $NF}'`;do for file in `find /lib/systemd/system/ /etc/systemd/system/ -name \"$service\" 2> /dev/null | grep -v \\.gz`;do echo;echo \"In file: $file\";cat $file;done;done");
            this.addProcess("systemd-units", this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.SH, "-c", "for file in `grep -E -H -R -i -s \"start-server|stop-server\" /usr/lib/systemd/system/ /etc/systemd/system/ | cut -d \":\" -f 1 | uniq`;do echo;echo \"In file: $file\";cat $file;done");
        }
        if (this.isUnixCommandAvailable(Command.JOURNALCTL.getName())) {
            this.addProcess(Command.JOURNALCTL.getName(), this.parallel, CollectSupportData.ZipParentPath.LINUX_COMMAND, Command.JOURNALCTL.getName(), "-b");
        }
        boolean pstackAvailable = this.isUnixCommandAvailable(Command.PSTACK.getName(), false);
        boolean gstackAvailable = this.isUnixCommandAvailable(Command.GSTACK.getName(), false);
        Integer pid = this.collectSupportData.getServerPID(this.serverRoot);
        if (pid != null) {
            if (!isAlpine) {
                this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, Command.PS, "-p", Integer.toString(pid), "-Lo", "pid,ppid,lwp,nlwp,osz,rss,ruser,pcpu,stime,etime");
                this.addProcess("pmap-XX", false, CollectSupportData.ZipParentPath.SERVER, pid, Command.PMAP, "-XX", pid.toString());
            }
            this.addProcess("pmap-x", false, CollectSupportData.ZipParentPath.SERVER, pid, Command.PMAP, "-x", pid.toString());
            if (this.collectSupportData.collectExpensiveData) {
                if (pstackAvailable) {
                    this.addProcess("pstack", false, CollectSupportData.ZipParentPath.SERVER, pid, Command.PSTACK, pid.toString());
                } else if (gstackAvailable) {
                    this.addProcess("gstack", false, CollectSupportData.ZipParentPath.SERVER, pid, Command.GSTACK, pid.toString());
                }
            }
            if (this.collectSupportData.reportCount > 0) {
                this.addProcess("top", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, Command.TOP, "-b", "-H", "-d" + Integer.toString(this.collectSupportData.reportIntervalSeconds), "-n" + Integer.toString(this.collectSupportData.reportCount), (isAlpine ? "-pid" : "-p") + pid);
                this.addProcess("pidstat", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, Command.PIDSTAT, "-d", "-r", "-u", "-w", "-I", "-h", "-p", Integer.toString(pid), Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            }
        }
        for (Integer additionalPid : this.collectSupportData.additionalPids) {
            if (!isAlpine) {
                this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, additionalPid, Command.PS, "-p" + additionalPid, "-Lo", "pid,ppid,lwp,nlwp,osz,rss,ruser,pcpu,stime,etime");
                this.addProcess("pmap-XX", false, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, Command.PMAP, "-XX", additionalPid.toString());
                this.addProcess("pmap-x", false, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, Command.PMAP, "-x", additionalPid.toString());
            } else {
                this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, additionalPid, Command.PS, "-pid" + additionalPid, "-Lo", "pid,ppid,lwp,nlwp,osz,rss,ruser,pcpu,stime,etime");
            }
            if (this.collectSupportData.collectExpensiveData) {
                if (pstackAvailable) {
                    this.addProcess("pstack", false, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, additionalPid, Command.PSTACK, additionalPid.toString());
                } else if (gstackAvailable) {
                    this.addProcess("gstack", false, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, additionalPid, Command.GSTACK, additionalPid.toString());
                }
            }
            if (this.collectSupportData.reportCount <= 0) continue;
            this.addProcess("top", this.parallel, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, additionalPid, Command.TOP, "-b", "-H", "-d" + Integer.toString(this.collectSupportData.reportIntervalSeconds), "-n" + Integer.toString(this.collectSupportData.reportCount), "-p" + additionalPid);
            this.addProcess("pidstat", this.parallel, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, additionalPid, Command.PIDSTAT, "-d", "-r", "-u", "-w", "-I", "-h", "-p", Integer.toString(additionalPid), Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
        }
    }

    private void addAixSystemProcesses() {
        Integer pid;
        this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.PS, "-elZf");
        this.addProcess("df", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.DF, "-k");
        this.addProcess("crontab", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.CRONTAB, "-l");
        this.addProcess("crontab-etc", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.CAT, "/etc/crontab");
        this.addProcess("hosts", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.CAT, "/etc/hosts");
        this.addProcess("netsvc.conf", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.CAT, "/etc/netsvc.conf");
        this.addProcess("resolv.conf", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.CAT, "/etc/resolv.conf");
        this.addProcess("netstat-int", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.NETSTAT, "-i");
        this.addProcess("netstat-sum", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.NETSTAT, "-s");
        this.addProcess("netstat-rn", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.NETSTAT, "-rn");
        this.addProcess("netstat-an", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.NETSTAT, "-an");
        this.addProcess("krb5.conf", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.CAT, this.getKerberosConfigPath());
        this.addProcess("ifconfig", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.IFCONFIG, "-a");
        this.addProcess("uptime", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.UPTIME, new String[0]);
        this.addProcess("ulimit-a", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.SH, "-c", "ulimit -a");
        this.addProcess("sar-today", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.SAR, "-A", "1", "10");
        this.addProcess("alog", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.ALOG, "-o", "-t", "boot");
        this.addProcess("lparstat", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.LPARSTAT, new String[0]);
        this.addProcess("vmo", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.VMO, "-L");
        if (this.collectSupportData.reportCount > 0) {
            this.addProcess("vmstat", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.VMSTAT, Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            if (this.isUnixCommandAvailable("iostat")) {
                this.addProcess("iostat", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.IOSTAT, Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            }
            if (this.isUnixCommandAvailable("mpstat")) {
                this.addProcess("mpstat", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.MPSTAT, "-w", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            }
            this.addProcess("sar", this.parallel, CollectSupportData.ZipParentPath.AIX_COMMAND, Command.SAR, "-A", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
        }
        if ((pid = this.collectSupportData.getServerPID(this.serverRoot)) != null) {
            this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, Command.PS, "-p", Integer.toString(pid), "-o", "pid,ppid,thcount,ruser,pcpu,stime,etime");
            if (this.collectSupportData.reportCount > 0) {
                this.addProcess("sar", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, Command.SAR, "-A", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            }
        }
        for (Integer additionalPid : this.collectSupportData.additionalPids) {
            this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, additionalPid, Command.PS, "-p" + additionalPid, "-o", "pid,ppid,thcount,ruser,pcpu,stime,etime");
        }
    }

    private void addSolarisSystemProcesses() {
        Integer pid;
        this.addProcess("uname", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.UNAME, "-a");
        this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.PS, "-elyZf");
        this.addProcess("zonename", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.ZONENAME, new String[0]);
        this.addProcess("zoneadm", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.ZONEADM, "list", "-cv");
        this.addProcess("df", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.DF, "-k");
        this.addProcess("crontab", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.CRONTAB, "-l");
        this.addProcess("crontab-etc", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.CAT, "/etc/crontab");
        this.addProcess("zfs", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.ZFS, "list");
        this.addProcess("zpool", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.ZPOOL, "status");
        this.addProcess("fmdump", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.FMDUMP, "-V");
        this.addProcess("fmdump-e", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.FMDUMP, "-eV");
        this.addProcess("prtconf", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.PRTCONF, "-v");
        this.addProcess("sysdef", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.SYSDEF, new String[0]);
        this.addProcess("prtdiag", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.PRTDIAG, new String[0]);
        this.addProcess("psrinfo", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.PSRINFO, "-v");
        this.addProcess("etc-system", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.CAT, "/etc/system");
        this.addProcess("etc-release", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.CAT, "/etc/release");
        this.addProcess("hosts", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.CAT, "/etc/hosts");
        this.addProcess("nsswitch.conf", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.CAT, "/etc/nsswitch.conf");
        this.addProcess("resolv.conf", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.CAT, "/etc/resolv.conf");
        this.addProcess("messages", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.TAIL, "-100000c", "/var/adm/messages");
        this.addProcess("netstat-int", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.NETSTAT, "-i");
        this.addProcess("netstat-sum", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.NETSTAT, "-s");
        this.addProcess("netstat-rn", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.NETSTAT, "-rn");
        this.addProcess("netstat-an", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.NETSTAT, "-an");
        this.addProcess("ifconfig", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.IFCONFIG, "-au");
        this.addProcess("uptime", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.UPTIME, new String[0]);
        this.addProcess("dmesg", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.DMESG, new String[0]);
        this.addProcess("smbios", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.SMBIOS, new String[0]);
        this.addProcess("ulimit-a", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.SH, "-c", "ulimit -a");
        if (this.isUnixCommandAvailable(Command.PATCHADD.getName())) {
            this.addProcess("patchadd-p", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.PATCHADD, "-p");
        }
        if (this.isUnixCommandAvailable(Command.PKG.getName())) {
            this.addProcess("pkg-list", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.PKG, "list");
        }
        if (this.collectSupportData.reportCount > 0) {
            this.addProcess("vmstat", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.VMSTAT, Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            this.addProcess("iostat", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.IOSTAT, "-xn", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            this.addProcess("mpstat", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.MPSTAT, Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            this.addProcess("zpool-iostat", this.parallel, CollectSupportData.ZipParentPath.SOLARIS_COMMAND, Command.ZPOOL, Command.IOSTAT.getName(), "-v", Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
        }
        if ((pid = this.collectSupportData.getServerPID(this.serverRoot)) != null) {
            if (this.collectSupportData.collectExpensiveData) {
                this.addProcess("pstack", false, CollectSupportData.ZipParentPath.SERVER, pid, Command.PSTACK, pid.toString());
            }
            if (this.collectSupportData.reportCount > 0) {
                this.addProcess("prstat", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, Command.PRSTAT, "-L", "-n", "1000", "-p", pid.toString(), Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
            }
        }
        for (Integer additionalPid : this.collectSupportData.additionalPids) {
            if (this.collectSupportData.collectExpensiveData) {
                this.addProcess("pstack", false, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, pid, Command.PSTACK, pid.toString());
            }
            if (this.collectSupportData.reportCount <= 0) continue;
            this.addProcess("prstat", this.parallel, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, pid, Command.PRSTAT, "-L", "-n", "1000", "-p", pid.toString(), Integer.toString(this.collectSupportData.reportIntervalSeconds), Integer.toString(this.collectSupportData.reportCount));
        }
    }

    private void addMacOsSystemProcesses() {
        Integer pid;
        this.addProcess("uname", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.UNAME, "-a");
        this.addProcess("uptime", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.UPTIME, new String[0]);
        this.addProcess("ps", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.PS, "-Aeflr");
        this.addProcess("vm_stat", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.VM_STAT, new String[0]);
        this.addProcess("system-log", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.TAIL, "/var/log/system.log");
        this.addProcess("netstat-i", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.NETSTAT, "-i");
        this.addProcess("netstat-s", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.NETSTAT, "-s");
        this.addProcess("netstat-rn", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.NETSTAT, "-rn");
        this.addProcess("netstat-an", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.NETSTAT, "-an");
        this.addProcess("ifconfig", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.IFCONFIG, "-au");
        this.addProcess("df", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.DF, "-Hi");
        this.addProcess("crontab", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.CRONTAB, "-l");
        this.addProcess("crontab-etc", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.CAT, "/etc/crontab");
        this.addProcess("ulimit-a", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.SH, "-c", "ulimit -a");
        if (this.collectSupportData.collectExpensiveData) {
            this.addProcess("system-profiler", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.SYSTEM_PROFILER, "-detailLevel", "full");
        }
        if ((pid = this.collectSupportData.getServerPID(this.serverRoot)) != null) {
            this.addProcesses("sample", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, this.createMacOsSampleProcessesCommand(pid));
            this.addProcess("top", this.parallel, CollectSupportData.ZipParentPath.SERVER, pid, Command.SH, "-c", "top -l " + this.collectSupportData.reportCount + " -s " + this.collectSupportData.reportIntervalSeconds + " -pid " + pid);
        }
        for (Integer additionalPid : this.collectSupportData.additionalPids) {
            this.addProcesses("sample", this.parallel, CollectSupportData.ZipParentPath.ADDITIONAL_PROCESS, this.createMacOsSampleProcessesCommand(additionalPid));
        }
        if (this.collectSupportData.reportCount > 0) {
            this.addProcess("top", this.parallel, CollectSupportData.ZipParentPath.MAC_OS_COMMAND, Command.SH, "-c", "top -l " + this.collectSupportData.reportCount + " | head -n 25");
        }
    }

    private String[][] createMacOsSampleProcessesCommand(Integer pid) {
        String random = String.valueOf(System.currentTimeMillis()).substring(7);
        String rptFile = "uid-supp-data-" + pid + "." + random + "sample.txt";
        return new String[][]{{Command.SAMPLE.getName(), "-mayDie", "-file", rptFile, pid.toString()}, {Command.CAT.getName(), rptFile}, {Command.RM.getName(), rptFile}};
    }

    private void addWindowsSystemProcesses() {
        this.addProcess("netstat-s", this.parallel, CollectSupportData.ZipParentPath.WINDOWS_COMMAND, Command.NETSTAT, "-s");
        this.addProcess("netstat-rn", this.parallel, CollectSupportData.ZipParentPath.WINDOWS_COMMAND, Command.NETSTAT, "-rn");
        this.addProcess("netstat-an", this.parallel, CollectSupportData.ZipParentPath.WINDOWS_COMMAND, Command.NETSTAT, "-an");
        this.addProcess("krb5.conf", this.parallel, CollectSupportData.ZipParentPath.WINDOWS_COMMAND, Command.CMD, "/C", Command.TYPE.getName(), this.getKerberosConfigPath());
        this.addWmicCollector("bios", "list");
        this.addWmicCollector("computersystem", "list");
        this.addWmicCollector("cpu", "list");
        this.addWmicCollector("diskdrive", "list");
        this.addWmicCollector("diskquota", "list");
        this.addWmicCollector("process", "list", "full");
        this.addWmicCollector("pagefile", "list");
        Calendar calendar = Calendar.getInstance();
        if (this.collectSupportData.isWithinUnitTest() || this.collectSupportData.isWithinUnitTestExternalInstance()) {
            calendar.add(11, -1);
        } else {
            calendar.add(5, -7);
        }
        int tzOffsetMin = Math.abs(TimeZone.getDefault().getOffset(calendar.getTimeInMillis()) / 60000);
        DecimalFormat fmt = FormatUtils.newParseableDecimalFormat("000");
        String fmtStr = "yyyyMMddHHmmss.000000-" + fmt.format(tzOffsetMin);
        SimpleDateFormat timeGeneratedFormat = new SimpleDateFormat(fmtStr);
        String formattedInterval = timeGeneratedFormat.format(calendar.getTime());
        String query = "where \"EventType<3 AND TimeGenerated>'" + formattedInterval + "'\"";
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(query.split(" ")));
        args.add("list");
        this.addWmicCollector("ntevent", args.toArray(new String[args.size()]));
    }

    private void addProcesses(String name, boolean start, CollectSupportData.ZipParentPath zipParentPath, String[][] commands) {
        this.addProcesses(name, start, zipParentPath, null, commands);
    }

    private void addProcesses(String name, boolean start, CollectSupportData.ZipParentPath zipParentPath, Integer pid, String[][] commands) {
        ArrayList<ProcessBuilder> pbs = new ArrayList<ProcessBuilder>();
        for (String[] command : commands) {
            pbs.add(ProcessBuilderUtil.buildProcess(this.collectSupportData, command));
        }
        this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParentPath, pid, null, pbs.toArray(new ProcessBuilder[pbs.size()])), start);
    }

    private void addProcess(String name, boolean start, CollectSupportData.ZipParentPath zipParent, String ... command) {
        this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParent, ProcessBuilderUtil.buildProcess(this.collectSupportData, command)), start);
    }

    private void addProcess(String name, boolean start, Integer outputLimit, CollectSupportData.ZipParentPath zipParent, String ... command) {
        this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParent, null, null, (Boolean)false, (Boolean)false, (Boolean)false, outputLimit, ProcessBuilderUtil.buildProcess(this.collectSupportData, command)), start);
    }

    private void addProcess(String name, boolean start, CollectSupportData.ZipParentPath zipParent, Command command, String ... arguments) {
        this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParent, ProcessBuilderUtil.buildProcess(this.collectSupportData, command, arguments)), start);
    }

    private void addProcessIfAvailable(String name, boolean start, CollectSupportData.ZipParentPath zipParent, Command command, String ... arguments) {
        if (this.isUnixCommandAvailable(command.getName(), false)) {
            this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParent, ProcessBuilderUtil.buildProcess(this.collectSupportData, command, arguments)), start);
        }
    }

    private void addProcess(String name, boolean start, CollectSupportData.ZipParentPath zipParent, Integer pid, String ... command) {
        this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParent, pid, null, ProcessBuilderUtil.buildProcess(this.collectSupportData, command)), start);
    }

    private void addProcess(String name, boolean start, CollectSupportData.ZipParentPath zipParent, Integer pid, Command cmd, String ... args) {
        this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParent, pid, null, ProcessBuilderUtil.buildProcess(this.collectSupportData, cmd, args)), start);
    }

    private void addProcess(String name, boolean start, CollectSupportData.ZipParentPath zipParent, Integer pid, boolean filterOutput, Command cmd, String ... args) {
        this.addProcess(new ProcessDataCollector(this.collectSupportData, name, zipParent, pid, null, (Boolean)false, (Boolean)false, (Boolean)false, ProcessBuilderUtil.buildProcess(this.collectSupportData, cmd, args)), start);
    }

    private void addProcess(DataCollector collector, boolean start) {
        if (collector != null) {
            this.dataCollectors.add(collector);
            if (start) {
                collector.start();
                this.collectSupportData.log("Started " + collector.getName());
            }
        }
    }

    private void addProcesses(List<DataCollector> collectors, boolean start) {
        for (DataCollector collector : collectors) {
            this.addProcess(collector, start);
        }
    }

    private long parseFileSize(String fileSizeString) {
        long bytesPerKB = 1024L;
        long bytesPerMB = 0x100000L;
        long bytesPerGB = 0x40000000L;
        Pattern pattern = Pattern.compile("(?<number>\\d+) *(?<unit>[a-zA-Z]+)");
        Matcher matcher = pattern.matcher(fileSizeString);
        if (!matcher.find()) {
            return 0x3200000L;
        }
        long number = Long.valueOf(matcher.group("number"));
        String unit = matcher.group("unit");
        long multiplier = 1L;
        if (unit.equalsIgnoreCase("bytes") || unit.equalsIgnoreCase("b")) {
            multiplier = 1L;
        }
        if (unit.equalsIgnoreCase("kilobytes") || unit.equalsIgnoreCase("kb")) {
            multiplier = 1024L;
        }
        if (unit.equalsIgnoreCase("megabytes") || unit.equalsIgnoreCase("mb")) {
            multiplier = 0x100000L;
        }
        if (unit.equalsIgnoreCase("gigabytes") || unit.equalsIgnoreCase("gb")) {
            multiplier = 0x40000000L;
        }
        return multiplier * number;
    }

    private void addDBPrintLogCollectors(String jdkBinDirPath) {
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase("je.jar") || name.startsWith("je-") && name.endsWith("jar");
                }
            };
            File libDir = new File(this.serverRoot, "lib");
            String[] jeJarFiles = libDir.list(filter);
            if (jeJarFiles.length == 0) {
                this.collectSupportData.log("DBPrintLog: Error attempting to locate je.jar file");
                return;
            }
            File jeJarFile = new File(libDir, jeJarFiles[0]);
            File configFile = new File(this.serverRoot, "config" + File.separator + "config.ldif");
            List<Entry> backends = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.LOCAL_DB_BACKEND, new String[0]);
            for (Entry backend : backends) {
                long maxFileSize;
                long maxNumFiles;
                String backendId;
                File dbDir;
                File dbFileDir;
                String[] jdbFiles;
                String dbDirString = backend.getAttributeValue(LDIFUtils.DB_DIRECTORY);
                if (dbDirString == null) {
                    dbDirString = "db";
                }
                if ((jdbFiles = (dbFileDir = new File(dbDir = StaticUtils.getFileFromString(dbDirString, new File(this.collectSupportData.getServerRoot())), backendId = backend.getAttributeValue(LDIFUtils.BACKEND_ID))).list(filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("jdb");
                    }
                })).length == 0) {
                    return;
                }
                long lowestFileNumber = Long.MAX_VALUE;
                long highestFileNumber = Long.MIN_VALUE;
                for (String file : jdbFiles) {
                    String fileHexStr = file.substring(0, file.indexOf("."));
                    long fileNum = Long.parseLong(fileHexStr, 16);
                    if (fileNum < lowestFileNumber) {
                        lowestFileNumber = fileNum;
                    }
                    if (fileNum <= highestFileNumber) continue;
                    highestFileNumber = fileNum;
                }
                long firstFileNumber = 0L;
                long gb = 0x40000000L;
                String maxFileSizeString = backend.getAttributeValue(LDIFUtils.DB_LOG_FILE_MAX_SIZE);
                if (maxFileSizeString == null) {
                    maxFileSizeString = "50 mb";
                }
                firstFileNumber = (long)jdbFiles.length < (maxNumFiles = 0x40000000L / (maxFileSize = this.parseFileSize(maxFileSizeString))) ? lowestFileNumber : highestFileNumber - maxNumFiles;
                this.addProcess(backendId + "-DBPrintLog", this.parallel, CollectSupportData.ZipParentPath.SERVER_ROOT_FILES, jdkBinDirPath + "java", "-jar", jeJarFile.getAbsolutePath(), "DbPrintLog", "-S", "-h", dbFileDir.getAbsolutePath(), "-s", "0x" + Long.toHexString(firstFileNumber), "-e", "0x" + Long.toHexString(highestFileNumber));
            }
        }
        catch (Exception e) {
            this.collectSupportData.log("DBPrintLog: Error attempting to determine backend directories", e);
        }
    }

    private boolean isUnixCommandAvailable(String cmd) {
        return this.isUnixCommandAvailable(cmd, true);
    }

    private boolean isUnixCommandAvailable(String cmd, boolean warnIfUnavailable) {
        boolean available = true;
        try {
            available = SystemUtils.isUnixCommandAvailable((String)cmd);
            if (!available && warnIfUnavailable) {
                this.collectSupportData.addSummaryMessage(UBIDToolMessages.WARN_SUPP_DATA_CMD_UNAVAILABLE.get((Object)cmd, (Object)this.collectSupportData.productType.toString()));
            }
        }
        catch (Exception e) {
            this.collectSupportData.log("Error determining whether " + cmd + " is available", e);
        }
        return available;
    }

    private String getKerberosConfigPath() {
        String path = System.getenv("KRB5_CONFIG");
        if (path == null || path.isEmpty()) {
            String javaHome = System.getProperty("java.home");
            File securityDirConf = new File(javaHome, "security/krb5.conf");
            path = securityDirConf.exists() ? securityDirConf.getAbsolutePath() : (OperatingSystem.isUNIXBased(this.collectSupportData.getOs()) ? (this.collectSupportData.getOs().equals((Object)OperatingSystem.SOLARIS) ? "/etc/krb5/krb5.conf" : "/etc/krb5.conf") : System.getenv("SYSTEMROOT") + File.separator + "krb5.ini");
        }
        return path;
    }

    public List<DataCollector> getDataCollectorsList() {
        return this.dataCollectors;
    }

    public List<CleanupAction> getCleanupActionsList() {
        return this.cleanupActions;
    }

    private void addUnixServerProcesses() {
        try {
            String status = new File(this.serverRoot, "bin/status").getCanonicalPath();
            this.addProcess("full-version", this.parallel, CollectSupportData.ZipParentPath.SERVER, this.collectSupportData.getServerPID(this.serverRoot), status, "-F");
            String serverState = new File(this.serverRoot, "bin/server-state").getCanonicalPath();
            this.addProcess("server-state", this.parallel, CollectSupportData.ZipParentPath.SERVER, this.collectSupportData.getServerPID(this.serverRoot), serverState);
            File gcLog = new File(this.serverRoot, "logs/jvm");
            if (gcLog.exists()) {
                this.addProcess("lengthy-GCs", this.parallel, CollectSupportData.ZipParentPath.JAVA, Command.SH, "-c", "egrep -i \" real=[1-9]\" " + gcLog.getAbsolutePath() + "/*| grep -v concurrent");
                this.addProcess(new GCContextCollector(this.collectSupportData, "gc-with-context", CollectSupportData.ZipParentPath.JAVA, null, gcLog.getAbsolutePath()), this.parallel);
                this.addProcess("addl-jstat-gc-details", this.parallel, CollectSupportData.ZipParentPath.JAVA, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JSTAT), "-J-Djstat.showUnsupported=true", "-snap", String.valueOf(this.collectSupportData.getServerPID(this.serverRoot)));
            }
            if (this.collectSupportData.isArgumentPresent("timeRange") || this.collectSupportData.isArgumentPresent("duration")) {
                String searchLogs = new File(this.serverRoot, "bin/search-logs").getCanonicalPath();
                this.addSearchLogsCollector(searchLogs);
            }
        }
        catch (Exception ioe) {
            this.collectSupportData.log("Failed to create status command", ioe);
        }
    }

    private void addWindowsServerProcesses() {
        try {
            String status = new File(this.serverRoot, "bat/status.bat").getCanonicalPath();
            this.addProcess("full-version", this.parallel, CollectSupportData.ZipParentPath.SERVER, this.collectSupportData.getServerPID(this.serverRoot), status, "-F");
            String serverState = new File(this.serverRoot, "bat/server-state.bat").getCanonicalPath();
            this.addProcess("server-status", this.parallel, CollectSupportData.ZipParentPath.SERVER, this.collectSupportData.getServerPID(this.serverRoot), serverState);
            File gcLog = new File(this.serverRoot, "logs/jvm");
            if (gcLog.exists()) {
                this.addProcess("lengthy-GCs", this.parallel, CollectSupportData.ZipParentPath.JAVA, Command.CMD, "/C", "findstr /R -I \" real=[1-9]\" " + gcLog.getAbsolutePath() + "\\*|findstr /V concurrent");
                this.addProcess(new GCContextCollector(this.collectSupportData, "gc-with-context", CollectSupportData.ZipParentPath.JAVA, null, gcLog.getAbsolutePath()), this.parallel);
                this.addProcess("addl-jstat-gc-details", this.parallel, CollectSupportData.ZipParentPath.JAVA, this.collectSupportData.getJdkBinDirPath() + (Object)((Object)Command.JSTAT), "-J-Djstat.showUnsupported=true", "-snap", String.valueOf(this.collectSupportData.getServerPID(this.serverRoot)));
            }
            if (this.collectSupportData.isArgumentPresent("timeRange") || this.collectSupportData.isArgumentPresent("duration")) {
                String searchLogs = new File(this.serverRoot, "bat/search-logs").getCanonicalPath();
                this.addSearchLogsCollector(searchLogs);
            }
        }
        catch (Exception ioe) {
            this.collectSupportData.log("Failed to create status command", ioe);
        }
    }

    private void addSearchLogsCollector(String commandPath) throws ArgumentException {
        String endTime;
        String startTime;
        if (this.collectSupportData.isArgumentPresent("timeRange")) {
            String[] timeStamps = this.collectSupportData.getStringArgumentValue("timeRange").split(",");
            startTime = timeStamps[0];
            endTime = timeStamps[1];
        } else if (this.collectSupportData.isArgumentPresent("duration")) {
            long durationMs = this.collectSupportData.getDurationValue("duration", TimeUnit.MILLISECONDS);
            Date start = Date.from(CollectSupportData.NOW.toInstant().minusMillis(durationMs));
            startTime = CollectSupportData.DURATION_DATE_FORMAT.format(start);
            endTime = CollectSupportData.DURATION_DATE_FORMAT.format(CollectSupportData.NOW);
        } else {
            throw new IllegalArgumentException();
        }
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(commandPath);
        argList.add("--maxLines");
        argList.add("100000");
        argList.add("--startTime");
        argList.add(startTime);
        argList.add("--endTime");
        argList.add(endTime);
        File logsDir = new File(this.serverRoot, "logs");
        File[] gcLogs = new File(logsDir, "jvm").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("gc.log");
            }
        });
        ArchiveFileFilter logFilter = DataCollectorListBuilder.logsDirFilterBuilder(logsDir).build(this.collectSupportData.securityLevel);
        ArrayList<File> logFiles = new ArrayList<File>();
        logFiles.addAll(Arrays.asList(logsDir.listFiles(logFilter)));
        logFiles.addAll(Arrays.asList(gcLogs));
        for (File log : logFiles) {
            if (log.isDirectory() || logFilter.action(log).equals((Object)FileAction.EXCLUDE)) continue;
            argList.add("--logFile");
            argList.add(log.getAbsolutePath());
        }
        this.addProcess("logs-within-timerange", this.parallel, CollectSupportData.ZipParentPath.SERVER, (Integer)3000000, argList.toArray(new String[argList.size()]));
    }

    private void addWmicCollector(String alias, String ... options) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(alias);
        if (options != null) {
            args.addAll(Arrays.asList(options));
        }
        this.addProcess("wmic-" + alias, false, CollectSupportData.ZipParentPath.WINDOWS_COMMAND, Command.WMIC, args.toArray(new String[args.size()]));
    }

    public static ArchiveFileFilterBuilder bdbDirFilterBuilder(File bdbDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, bdbDir, "je.config");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, bdbDir, "je.info.0");
        builder.includeRegexFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.HEAD_AND_TAIL, bdbDir, false, "je\\.stat(\\.\\d)?\\.csv");
        return builder;
    }

    public static ArchiveFileFilterBuilder libDirFilterBuilder(File libDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, libDir, "set-java-home", "_script-util.bat", "_script-util.sh");
        return builder;
    }

    public static ArchiveFileFilterBuilder configDirFilterBuilder(File configDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, configDir, "alarms.ldif", "alerts.ldif", "api-users.ldif", "change-subscriptions.ldif", "config.ldif", "config.ldif.orig", "config.ldif.startok", "exec-command-whitelist.txt", "java-logging.properties", "java.properties", "java.properties.orig", "license.accepted", "scim-config-ds.dsconfig", "scim-config-proxy.dsconfig", "scim-resources.xml", "scim-resources.xsd", "server.user", "server.uuid", "spring-security-config.xml", "sync-state.ldif", "sync-state.ldif.old", "tasks.ldif", "tool-invocation-logging.properties", "wrapper.conf", "wrapper-product.conf", "wrapper-license.conf");
        builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, configDir, "server.umask", "tools.properties");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, configDir, true, ".*scim.*\\.xml");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, configDir, "wordlist.txt", "commonly-used-passwords.txt", "passphrase-wordlist.txt", "xacml-core-v3-schema-wd-17.xsd", "xml.xsd", "tools", "single-page-application-web.xml");
        File archivedConfigsDir = new File(configDir, "archived-configs");
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, archivedConfigsDir, "config\\-\\d+Z(\\-\\d+)?\\.gz", 5);
        File schemaDir = new File(configDir, "schema");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, schemaDir, false, "\\d\\d\\-.*\\.ldif");
        File velocityDir = new File(configDir, "velocity");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, velocityDir, true, ".*\\.vm");
        return builder;
    }

    public static ArchiveFileFilterBuilder logsDirFilterBuilder(File logsDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "shutdown-monitor.ldif", "shutdown-monitor.ldif.previous", "server.status", "dsstats.csv.format");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, logsDir, "config-audit.log", "errors", "server.out", "server.out.previous", "server.pid", "windows-service-wrapper.log", "windows-service-wrapper.log.1", "windows-service-wrapper.log.2", "dsstats.csv");
        builder.includeExactFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.HEAD_AND_TAIL, logsDir, "access", "ldap-access", "authorization", "expensive-ops", "expensive-write-ops", "failed-ops", "searches-returning-no-entries", "http-detailed-access", "replication");
        builder.includeExactFiles(SecurityLevel.NONE, FileAction.HEAD_AND_TAIL, logsDir, "audit", "ldap-audit", "change-notifications.log", "debug", "debug-aci", "debug-trace", "ldap-sdk-debug", "policy-decision", "server-sdk-extension-debug", "sync", "sync-failed-ops");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, logsDir, "access.json", "ldap-access.json", "errors.json");
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qshutdown-live-thread-dump-\\E[0-9\\.Z]+\\.log", 5);
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qexpensive-operation-dump-\\E[0-9\\.Z]+\\.log", 5);
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qlock-conflict-details-\\E.*\\.log", 5);
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qwork-queue-backlog-thread-dump-\\E[0-9\\.Z]+\\.log", 5);
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, new File(logsDir, ".index-logs"), "authorization");
        builder.includeExactFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.HEAD_AND_TAIL, new File(logsDir, "webapps"), "console.log");
        File logsToolsDir = new File(logsDir, "tools");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, logsToolsDir, false, ".*\\.((log)|(history)|(txt)|(csv))(\\.\\d+)?");
        File jvmLogsDir = new File(logsDir, "jvm");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, jvmLogsDir, true, ".*\\.current", ".*\\.\\d+", ".*\\.atShutdown", "gc\\.log");
        File logsDdlsDir = new File(logsDir, "ddls");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDdlsDir, false, ".*\\.sql");
        File monitorHistoryDir = new File(logsDir, "monitor-history");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, monitorHistoryDir, "historical-dsstats.csv.format");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, monitorHistoryDir, "historical-dsstats.csv");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, monitorHistoryDir, "monitor");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, new File(logsDir, "data-recovery"), "data-recovery");
        return builder;
    }

    public static ArchiveFileFilterBuilder velocityDirFilterBuilder(File velocityDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, velocityDir, true, ".*\\.vm", ".*\\.html");
        return builder;
    }
}

