/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.config;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.config.MessageDataCollectorConfiguration;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class LDAPSearchDataCollectorConfiguration
extends MessageDataCollectorConfiguration {
    private final String BASE_DN_KEY = "baseDN";
    private final String SEARCH_SCOPE_KEY = "searchScope";
    private final String FILTER_KEY = "filter";
    private static final String ADMIN_SESSION_KEY = "adminSession";
    private static final String ATTRIBUTES = "attributes";
    private final List<String> REQUIRED_KEYS = Collections.unmodifiableList(Arrays.asList("baseDN", "searchScope", "filter"));

    public LDAPSearchDataCollectorConfiguration(DataCollectorConfiguration dataCollectorConfiguration) {
        super(dataCollectorConfiguration);
    }

    public SearchRequest getSearchRequest() throws IllegalArgumentException {
        SearchRequest searchRequest = null;
        String baseDN = this.getStringParam("baseDN");
        SearchScope searchScope = SearchScope.valueOf((int)this.getIntParam("searchScope"));
        String filter = this.getStringParam("filter");
        String attributes = this.getStringParam(ATTRIBUTES);
        String[] attributeList = null;
        if (attributes != null && !attributes.isEmpty()) {
            attributeList = attributes.split(",");
        }
        try {
            searchRequest = attributeList != null ? new SearchRequest(baseDN, searchScope, filter, attributeList) : new SearchRequest(baseDN, searchScope, filter, new String[0]);
        }
        catch (LDAPException e) {
            System.err.println(e.getMessage());
            System.err.println("Could not create the LDAP search request associated with the configuration parameters of " + this.getId() + ". Valid configuration parameters are: \nbaseDn: String \nsearchScope: integer between 0 and 3 inclusive corresponding to SearchScope types.\nfilter: String");
        }
        return searchRequest;
    }

    public boolean getCreateAdminSession() {
        return this.getBooleanParam(ADMIN_SESSION_KEY, false);
    }

    @Override
    public boolean isValidConfiguration() {
        return this.getConfiguration().keySet().containsAll(this.REQUIRED_KEYS);
    }

    public List<String> getRequiredKeys() {
        return this.REQUIRED_KEYS;
    }
}

