/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.process;

import com.pingidentity.csd.server.datacollector.DataCollector;
import com.pingidentity.csd.server.datacollector.config.ProcessDataCollectorConfiguration;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.Command;
import com.pingidentity.csd.server.tools.ProcessBuilderUtil;
import com.unboundid.csd.messages.QuickSetupMessages;
import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.messages.Message;

public class ProcessDataCollector
extends DataCollector {
    private CollectSupportData collectSupportData;
    private final String command;
    private Message message;
    private final ProcessBuilder[] builders;
    private Integer currentInterval;
    private final Boolean repeating;
    private final Boolean failOnBadExitCode;
    private final Integer outputLimit;

    public ProcessDataCollector(CollectSupportData collectSupportData, ProcessDataCollectorConfiguration processDataCollectorConfiguration, Integer pid, Message message, boolean filterOutput, boolean failOnBadExitCode) {
        this(collectSupportData, processDataCollectorConfiguration.getId(), processDataCollectorConfiguration.getZipParentPathAsEnum(), pid, message, (Boolean)processDataCollectorConfiguration.isRepeating(), (Boolean)filterOutput, (Boolean)failOnBadExitCode, ProcessBuilderUtil.buildProcess(collectSupportData, processDataCollectorConfiguration.getCommand(), new String[0]));
    }

    public ProcessDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, ProcessBuilder ... builders) {
        this(collectSupportData, name, zipParent, (Integer)null, (Message)null, builders);
    }

    public ProcessDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Integer pid, Message failMessage, ProcessBuilder ... builders) {
        this(collectSupportData, name, zipParent, pid, failMessage, (Boolean)false, builders);
    }

    public ProcessDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Integer pid, Message failMessage, Boolean filterOutput, ProcessBuilder ... builders) {
        this(collectSupportData, name, zipParent, pid, failMessage, (Boolean)false, (Boolean)false, (Boolean)false, builders);
    }

    public ProcessDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Integer pid, Message failMessage, Boolean repeating, Boolean filterOutput, Boolean failOnBadExitCode, ProcessBuilder ... builders) {
        this(collectSupportData, name, zipParent, pid, failMessage, repeating, filterOutput, failOnBadExitCode, 1000000, builders);
    }

    public ProcessDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Integer pid, Message failMessage, Boolean repeating, Boolean filterOutput, Boolean failOnBadExitCode, Integer outputLimit, ProcessBuilder ... builders) {
        super(collectSupportData, name, zipParent, pid, failMessage);
        this.collectSupportData = collectSupportData;
        this.repeating = repeating;
        this.currentInterval = 0;
        this.builders = builders;
        this.command = CollectSupportData.getCommandString(builders);
        this.filterOutput = filterOutput;
        this.failOnBadExitCode = failOnBadExitCode;
        this.outputLimit = outputLimit;
    }

    @Override
    public synchronized void start() {
        if (this.builders != null) {
            this.startTime = System.currentTimeMillis();
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long lastTime = ProcessDataCollector.this.startTime;
                    boolean uncaughtExceptions = false;
                    try {
                        int numLoops = ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.reportCount;
                        int sleepSeconds = ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.reportIntervalSeconds;
                        if (Command.JSTACK.getName().equals(ProcessDataCollector.this.getName())) {
                            numLoops = ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.maxJstacks;
                            if (((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.maxJstacks < ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.reportCount && ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.maxJstacks > 0 && ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.reportCount > 0) {
                                int reportCount = ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.reportCount;
                                int reportInterval = ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.reportIntervalSeconds;
                                int maxJstacks = ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.maxJstacks;
                                sleepSeconds = reportCount * reportInterval / maxJstacks;
                            }
                        }
                        do {
                            if (ProcessDataCollector.this.currentInterval > 0) {
                                try {
                                    long now = System.currentTimeMillis();
                                    long sleepTime = lastTime + (long)sleepSeconds * 1000L - now;
                                    ProcessDataCollector.this.commandOutput.write(CollectSupportData.getBytes("# Execution (" + ProcessDataCollector.this.currentInterval + "/" + numLoops + ") completed in " + (now - lastTime) + "ms\n\n"));
                                    if (sleepTime > 0L) {
                                        Thread.sleep(sleepTime);
                                    }
                                }
                                catch (InterruptedException ie) {
                                    ProcessDataCollector.this.collectSupportData.log("Interrupted sleep before running " + ProcessDataCollector.this.getName() + "( Execution " + ProcessDataCollector.this.currentInterval + " of " + numLoops + ")", ie);
                                }
                                lastTime = System.currentTimeMillis();
                            }
                            for (ProcessBuilder builder : ProcessDataCollector.this.builders) {
                                try {
                                    ProcessDataCollector.this.createAndStartProcess(builder, ProcessDataCollector.this.failOnBadExitCode, ProcessDataCollector.this.outputLimit);
                                }
                                catch (InterruptedException ie) {
                                    ProcessDataCollector.this.collectSupportData.log("Interrupted process " + ProcessDataCollector.this.getName(), ie);
                                }
                                catch (Exception e) {
                                    ProcessDataCollector.this.collectSupportData.log("Error collecting output for " + ProcessDataCollector.this.getName() + e.getMessage());
                                    uncaughtExceptions = true;
                                }
                            }
                        } while (ProcessDataCollector.this.repeating.booleanValue() && (ProcessDataCollector.this.currentInterval = ProcessDataCollector.this.currentInterval + 1) < numLoops);
                    }
                    catch (Exception ioe) {
                        ProcessDataCollector.this.message = QuickSetupMessages.INFO_PROGRESS_ERROR.get();
                        ProcessDataCollector.this.collectSupportData.log("Error:  Error executing " + ProcessDataCollector.this.getName(), ioe);
                        if (ProcessDataCollector.this.failMessage != null) {
                            ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.summaryMessages.add(ProcessDataCollector.this.failMessage);
                        } else {
                            ((ProcessDataCollector)ProcessDataCollector.this).collectSupportData.summaryMessages.add(UBIDToolMessages.ERR_SUPP_DATA_ERROR_PROCESS.get((Object)ProcessDataCollector.this.command));
                        }
                    }
                    finally {
                        ProcessDataCollector.this.stopTime = System.currentTimeMillis();
                    }
                    if (ProcessDataCollector.this.commandOutput.size() == 0) {
                        ProcessDataCollector.this.collectSupportData.log("WARNING: collector " + ProcessDataCollector.this.getName() + " produced no output");
                    }
                    if (uncaughtExceptions) {
                        ProcessDataCollector.this.message = QuickSetupMessages.INFO_PROGRESS_ERROR.get();
                    } else {
                        ProcessDataCollector.this.message = QuickSetupMessages.INFO_PROGRESS_DONE.get();
                    }
                }
            }, "Thread: running " + this.getCommand());
            thread.setDaemon(true);
            thread.start();
        } else {
            this.startTime = this.stopTime = System.currentTimeMillis();
            this.message = UBIDToolMessages.INFO_SUPP_DATA_COMMAND_NOT_EXECUTED.get();
        }
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public String getCommand() {
        return this.command;
    }
}

