/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.XMLOutput;
import com.unboundid.messages.Message;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class BaselineDataCollector
extends DataCollectorTask {
    private String javaVersion;
    private String javaVmName;
    private String javaVmVendor;
    private String javaVmVersion;
    private String javaRuntimeVersion;
    private String javaClassPath;
    private String javaHome;
    private String javaVendor;
    private String javaOSArch;
    private String javaOSName;
    private String javaOSVersion;
    private String javaUserName;
    private String javaUserDir;
    private String javaUserHome;
    private int javaAvailableProcessors;
    private long javaFreeMemory;
    private long javaMaxMemory;
    private long javaTotalMemory;
    private String netLocalHostIP;
    private String netLocalHostName;
    private Set<String> netIPAddresses;

    public BaselineDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message) {
        super(collectSupportData, name, zipParent, message, DataCollectorFileType.XML);
    }

    public BaselineDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        this(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), (Message)null);
    }

    @Override
    protected void writeData() throws Exception {
        this.write("<baseData>");
        this.collectJavaInfo();
        this.collectNetworkInfo();
        String dataToWrite = this.toXML();
        this.write(dataToWrite);
        this.write("</baseData>");
    }

    private void collectJavaInfo() {
        this.javaVersion = System.getProperty("java.version");
        this.javaVmName = System.getProperty("java.vm.name");
        this.javaVmVendor = System.getProperty("java.vm.vendor");
        this.javaVmVersion = System.getProperty("java.vm.version");
        this.javaRuntimeVersion = System.getProperty("java.runtime.version");
        this.javaClassPath = System.getProperty("java.class.path");
        this.javaHome = System.getProperty("java.home");
        this.javaVendor = System.getProperty("java.vendor");
        this.javaOSArch = System.getProperty("os.arch");
        this.javaOSName = System.getProperty("os.name");
        this.javaOSVersion = System.getProperty("os.version");
        this.javaUserName = System.getProperty("user.name");
        this.javaUserDir = System.getProperty("user.dir");
        this.javaUserHome = System.getProperty("user.home");
        this.javaAvailableProcessors = Runtime.getRuntime().availableProcessors();
        this.javaFreeMemory = Runtime.getRuntime().freeMemory();
        this.javaMaxMemory = Runtime.getRuntime().maxMemory();
        this.javaTotalMemory = Runtime.getRuntime().totalMemory();
    }

    private void collectNetworkInfo() {
        try {
            this.netLocalHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this.log("Error getting local IP address", e);
        }
        try {
            this.netLocalHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.log("Error getting local hostname", e);
        }
        this.netIPAddresses = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> interfacesEnum = NetworkInterface.getNetworkInterfaces();
            while (interfacesEnum.hasMoreElements()) {
                NetworkInterface intf = interfacesEnum.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress tmpAddr = enumIpAddr.nextElement();
                    this.netIPAddresses.add(tmpAddr.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            this.log("Error collecting local network interface information", e);
        }
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        String newline = System.getProperty("line.separator");
        sb.append("<java>");
        sb.append(newline);
        sb.append("<javaAvailableProcessors>").append(this.javaAvailableProcessors).append("</javaAvailableProcessors>");
        sb.append(newline);
        sb.append("<javaClassPath>").append(XMLOutput.escapeXML(this.javaClassPath)).append("</javaClassPath>");
        sb.append(newline);
        sb.append("<javaFreeMemory>").append(this.javaFreeMemory).append("</javaFreeMemory>");
        sb.append(newline);
        sb.append("<javaHome>").append(XMLOutput.escapeXML(this.javaHome)).append("</javaHome>");
        sb.append(newline);
        sb.append("<javaMaxMemory>").append(this.javaMaxMemory).append("</javaMaxMemory>");
        sb.append(newline);
        sb.append("<javaOSArch>").append(XMLOutput.escapeXML(this.javaOSArch)).append("</javaOSArch>");
        sb.append(newline);
        sb.append("<javaOSName>").append(XMLOutput.escapeXML(this.javaOSName)).append("</javaOSName>");
        sb.append(newline);
        sb.append("<javaOSVersion>").append(XMLOutput.escapeXML(this.javaOSVersion)).append("</javaOSVersion>");
        sb.append(newline);
        sb.append("<javaRuntimeVersion>").append(XMLOutput.escapeXML(this.javaRuntimeVersion));
        sb.append("</javaRuntimeVersion>");
        sb.append(newline);
        sb.append("<javaTotalMemory>").append(this.javaTotalMemory).append("</javaTotalMemory>");
        sb.append(newline);
        sb.append("<javaUserDir>").append(XMLOutput.escapeXML(this.javaUserDir)).append("</javaUserDir>");
        sb.append(newline);
        sb.append("<javaUserHome>").append(XMLOutput.escapeXML(this.javaUserHome)).append("</javaUserHome>");
        sb.append(newline);
        sb.append("<javaUserName>").append(XMLOutput.escapeXML(this.javaUserName)).append("</javaUserName>");
        sb.append(newline);
        sb.append("<javaVendor>").append(XMLOutput.escapeXML(this.javaVendor)).append("</javaVendor>");
        sb.append(newline);
        sb.append("<javaVersion>").append(XMLOutput.escapeXML(this.javaVersion)).append("</javaVersion>");
        sb.append(newline);
        sb.append("<javaVmName>").append(XMLOutput.escapeXML(this.javaVmName)).append("</javaVmName>");
        sb.append(newline);
        sb.append("<javaVmVendor>").append(XMLOutput.escapeXML(this.javaVmVendor)).append("</javaVmVendor>");
        sb.append(newline);
        sb.append("<javaVmVersion>").append(XMLOutput.escapeXML(this.javaVmVersion)).append("</javaVmVersion>");
        sb.append(newline);
        sb.append("</java>");
        sb.append(newline);
        sb.append("<network>");
        sb.append(newline);
        sb.append("<netLocalHostIP>").append(XMLOutput.escapeXML(this.netLocalHostIP)).append("</netLocalHostIP>");
        sb.append(newline);
        sb.append("<netLocalHostName>").append(XMLOutput.escapeXML(this.netLocalHostName)).append("</netLocalHostName>");
        sb.append(newline);
        sb.append("<netIPAddresses>");
        if (this.netIPAddresses != null) {
            for (String tmpIPAddr : this.netIPAddresses) {
                sb.append("<netIPAddress>").append(XMLOutput.escapeXML(tmpIPAddr)).append("</netIPAddress>");
            }
        }
        sb.append("</netIPAddresses>");
        sb.append(newline);
        sb.append("</network>");
        sb.append(newline);
        sb.append("<osType>").append(this.collectSupportData.getOs().toString()).append("</osType>");
        sb.append(newline);
        return sb.toString();
    }
}

