/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.config.LDAPCommandDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.ProcessBuilderUtil;
import com.pingidentity.csd.server.tools.argument.BooleanOptionArgument;
import com.unboundid.csd.messages.QuickSetupMessages;
import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.messages.Message;
import com.unboundid.util.Validator;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.FileArgument;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LDAPCommandDataCollector
extends DataCollectorTask {
    private CollectSupportData collectSupportData;
    private final File command;
    private final File workingDir;
    private final String[] extraArgs;

    public LDAPCommandDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message, File command, String ... commandArgs) {
        super(collectSupportData, name, zipParent, message);
        this.collectSupportData = collectSupportData;
        Validator.ensureTrue((command != null ? 1 : 0) != 0);
        this.command = command;
        this.workingDir = command.getParentFile();
        this.extraArgs = commandArgs == null ? new String[0] : commandArgs;
    }

    public LDAPCommandDataCollector(CollectSupportData collectSupportData, LDAPCommandDataCollectorConfiguration ldapCommandDataCollectorConfiguration, boolean isUnixBased) {
        this(collectSupportData, ldapCommandDataCollectorConfiguration.getId(), ldapCommandDataCollectorConfiguration.getZipParentPathAsEnum(), ldapCommandDataCollectorConfiguration.getMessage(), isUnixBased ? ldapCommandDataCollectorConfiguration.getUnixCommand() : ldapCommandDataCollectorConfiguration.getWindowsCommand(), ldapCommandDataCollectorConfiguration.getArgs());
    }

    private boolean isLdapConnectionArgument(Argument arg) {
        boolean ldap = false;
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            ldap = "useSSL".equals(longId) || "useNoSecurity".equals(longId) || "useStartTLS".equals(longId) || "hostname".equals(longId) || "port".equals(longId) || "topologyFilePath".equals(longId) || "bindDN".equals(longId) || "bindPassword".equals(longId) || "bindPasswordFile".equals(longId) || "saslOption".equals(longId) || "trustAll".equals(longId) || "trustStorePath".equals(longId) || "trustStorePassword".equals(longId) || "trustStorePasswordFile".equals(longId) || "keyStorePath".equals(longId) || "keyStorePassword".equals(longId) || "keyStorePasswordFile".equals(longId) || "certNickname".equals(longId) || "referencedHostName".equals(longId) || "adminUID".equals(longId) || "reportAuthzID".equals(longId) || "usePasswordPolicyControl".equals(longId) || "useSASLExternal".equals(longId) || "ldapVersion".equals(longId);
        }
        return ldap;
    }

    @Override
    protected void writeData() throws Exception {
        try {
            this.collectSupportData.log("Running '" + this.getName() + "' command with LDAP connection arguments.");
            ArrayList<String> connectionArgs = new ArrayList<String>();
            boolean connSecurityPresent = false;
            boolean trustStorePathPresent = false;
            connectionArgs.add("--trustAll");
            for (Argument arg : this.collectSupportData.argParser.getNamedArguments()) {
                BooleanOptionArgument boolArg;
                if (arg.getLongIdentifier().equals("ldapHost")) {
                    connectionArgs.add("--hostname");
                    connectionArgs.add((String)arg.getValueStringRepresentations(true).get(0));
                    continue;
                }
                if (arg.getLongIdentifier().equals("ldapPort")) {
                    connectionArgs.add("--port");
                    connectionArgs.add((String)arg.getValueStringRepresentations(true).get(0));
                    continue;
                }
                if (!this.isLdapConnectionArgument(arg) || arg.getLongIdentifier().equals("trustAll") || arg instanceof BooleanOptionArgument && ((boolArg = (BooleanOptionArgument)arg).getValue() == null || !boolArg.getValue().booleanValue()) || !arg.isPresent()) continue;
                String longId = arg.getLongIdentifier();
                if ("useSSL".equals(longId) || "useStartTLS".equals(longId) || "useNoSecurity".equals(longId)) {
                    connSecurityPresent = true;
                }
                if ("bindPasswordFile".equals(longId)) {
                    longId = "bindPassword";
                } else if ("keyStorePasswordFile".equals(longId)) {
                    longId = "keyStorePassword";
                } else if ("trustStorePasswordFile".equals(longId)) {
                    longId = "trustStorePassword";
                }
                if (connectionArgs.contains("--" + longId)) continue;
                if (arg instanceof FileArgument) {
                    String line;
                    FileArgument fileArg = (FileArgument)arg;
                    List fileLines = fileArg.getFileLines();
                    if (fileLines.size() <= 0 || (line = String.join((CharSequence)System.lineSeparator(), fileLines)).isEmpty()) continue;
                    connectionArgs.add("--" + longId);
                    connectionArgs.add(line);
                    continue;
                }
                List argValues = arg.getValueStringRepresentations(true);
                if (argValues != null && argValues.size() > 0) {
                    for (String value : argValues) {
                        connectionArgs.add("--" + longId);
                        if ("trustStorePath".equals(longId)) {
                            trustStorePathPresent = true;
                            File f = new File(value);
                            connectionArgs.add(f.getCanonicalPath());
                            continue;
                        }
                        connectionArgs.add(value);
                    }
                    continue;
                }
                connectionArgs.add("--" + longId);
            }
            if (trustStorePathPresent) {
                connectionArgs.remove("--trustAll");
            }
            if (!connSecurityPresent) {
                connectionArgs.add("--useNoSecurity");
            }
            connectionArgs.add("--no-prompt");
            ArrayList<String> args = new ArrayList<String>();
            if (this.command.getName().endsWith(".bat")) {
                args.add("cmd");
                args.add("/C");
                args.add(this.command.getName());
            } else {
                args.add("./" + this.command.getName());
            }
            args.addAll(Arrays.asList(this.extraArgs));
            args.addAll(connectionArgs);
            ProcessBuilder pb = ProcessBuilderUtil.buildProcess(this.collectSupportData, args.toArray(new String[args.size()]));
            pb.directory(this.workingDir);
            int returnCode = this.createAndStartProcess(pb, false, 1000000);
            if (returnCode != 0) {
                throw new Exception("process returned with error code: " + returnCode);
            }
            this.message = QuickSetupMessages.INFO_PROGRESS_DONE.get();
        }
        catch (Exception ldape) {
            this.message = QuickSetupMessages.INFO_PROGRESS_ERROR.get();
            this.collectSupportData.log("Error obtaining LDAP data for " + this.getName() + " command", ldape);
            this.collectSupportData.summaryMessages.add(UBIDToolMessages.ERR_SUPP_DATA_ERROR_LDAP.get());
        }
    }

    @Override
    public String getCommand() {
        return this.command.getName();
    }
}

