/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.unboundid.csd.messages.QuickSetupMessages;
import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskManager;
import com.unboundid.messages.Message;

public class TaskCollector
extends DataCollectorTask {
    private CollectSupportData collectSupportData;
    private final Task task;
    private final LDAPConnection connection;

    private TaskCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message, LDAPConnection connection, Task task) {
        super(collectSupportData, name, zipParent, message);
        this.collectSupportData = collectSupportData;
        this.task = task;
        this.connection = connection;
    }

    @Override
    protected void writeData() throws Exception {
        if (this.connection != null && this.task != null) {
            try {
                this.collectSupportData.log("Task class " + this.task.getTaskClassName() + " invoked for " + this.getName());
                Task scheduledTask = TaskManager.scheduleTask((Task)this.task, (LDAPConnection)this.connection);
                scheduledTask = TaskManager.waitForTask((String)scheduledTask.getTaskID(), (LDAPConnection)this.connection, (long)1000L, (long)0L);
                this.collectSupportData.log("Task class " + this.task.getTaskClassName() + "completed for " + this.getName());
                this.taskCompleted(scheduledTask);
            }
            catch (TaskException taske) {
                this.message = QuickSetupMessages.INFO_PROGRESS_ERROR.get();
                this.collectSupportData.log("Error executing task for " + this.getName(), taske);
                this.collectSupportData.summaryMessages.add(UBIDToolMessages.ERR_SUPP_DATA_ERROR_LDAP.get());
            }
            catch (LDAPException ldape) {
                this.message = QuickSetupMessages.INFO_PROGRESS_ERROR.get();
                this.collectSupportData.log("Error parsing task entry for " + this.getName(), ldape);
                this.collectSupportData.summaryMessages.add(UBIDToolMessages.ERR_SUPP_DATA_ERROR_LDAP.get());
            }
        }
    }

    protected void taskCompleted(Task completeTask) {
    }

    @Override
    public String getCommand() {
        return "Task class: " + this.task.getTaskClassName();
    }
}

