/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.metrics;

import com.pingidentity.csd.server.datacollector.task.ExternalCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.unboundid.directory.mon.core.Context;
import com.unboundid.messages.Message;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class DbmsCommandDataCollector
extends ExternalCollectorTask {
    private final File cmdFile;
    private final String name;

    public DbmsCommandDataCollector(String name, CollectSupportData.ZipParentPath parent, Message message, File cmdFile) {
        super(name, parent, message);
        this.cmdFile = cmdFile;
        this.name = name;
    }

    @Override
    protected void writeData() throws IOException {
        PrintStream commandOutput;
        ByteArrayOutputStream rawOutput;
        try {
            Properties props = new Properties();
            Context ctx = Context.find(null);
            props.put("database", ctx.getDatabaseName());
            props.put("schema", ctx.getSchemaName());
            rawOutput = new ByteArrayOutputStream();
            commandOutput = new PrintStream(rawOutput);
            ctx.getDBMaintenance().executeExternalCommand(this.cmdFile.getName(), props, commandOutput);
        }
        catch (Exception e) {
            e.printStackTrace(this.getOutputStream());
            return;
        }
        if (rawOutput.size() == 0) {
            throw new IOException(String.format("No output for %s", this.name));
        }
        rawOutput.writeTo(this.getOutputStream());
        commandOutput.close();
    }
}

