/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pa;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.util.OrderedProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PARuntimeConfigDataCollector
extends DataCollectorTask {
    private HttpUtil httpUtilInstance = null;
    private String basicAuthorizationHeader = null;
    private String adminAPIBaseUrl = null;
    private final String sensitiveValueReplacement = "__REMOVED__";
    private final String paBaseDir;
    private boolean isSanitizationEnabled = true;
    private Set<String> sensitiveAPIFieldKeys;

    public PARuntimeConfigDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.JSON);
        this.paBaseDir = configuration.getStringParam("root");
        this.isSanitizationEnabled = configuration.getBooleanParam("sanitizeData", true);
        this.adminAPIBaseUrl = configuration.getStringParam("adminApiBaseUrl");
        this.basicAuthorizationHeader = this.base64Encode(configuration.getStringParam("adminApiUser") + ":" + configuration.getStringParam("adminApiPassword"));
        this.httpUtilInstance = new HttpUtil();
        if (this.adminAPIBaseUrl != null && this.adminAPIBaseUrl.endsWith("/")) {
            this.adminAPIBaseUrl = this.adminAPIBaseUrl.substring(0, this.adminAPIBaseUrl.length() - 1);
        }
        if (this.isSanitizationEnabled) {
            this.sensitiveAPIFieldKeys = new HashSet<String>();
            Properties sensitiveFieldPatternsProperties = new Properties();
            try {
                sensitiveFieldPatternsProperties.load(this.getClass().getClassLoader().getResourceAsStream("pa/sensitive-api-fieldname-patterns.properties"));
                for (Object tmpPropertiesValue : sensitiveFieldPatternsProperties.values()) {
                    this.sensitiveAPIFieldKeys.add(tmpPropertiesValue.toString());
                }
            }
            catch (Exception e) {
                this.log("ERROR: Error loading sensitive-api-fieldname-patterns.properties. SANITIZATION OF SENSITIVE DATA FROM CONFIGURATION DATA OBTAINED FROM THE ADMIN API WILL FAIL. PLEASE CONTACT SUPPORT.", e);
            }
        }
    }

    private String getFullApiUrl(String apiPath) {
        return this.adminAPIBaseUrl + apiPath;
    }

    private HttpUtil.HttpResponse getAPIResponse(String apiPath) {
        String fullApiUrl = this.getFullApiUrl(apiPath);
        HttpUtil.HttpResponse response = this.httpUtilInstance.httpsGet(fullApiUrl, null, this.basicAuthorizationHeader);
        return response;
    }

    private Map<String, Object> getValueFromJSON(JSONObject jsonObject, String path) {
        if (path == null) {
            return null;
        }
        String[] splitPath = path.split("/");
        LinkedList<String> pathPieces = new LinkedList<String>();
        Collections.addAll(pathPieces, splitPath);
        if (pathPieces.isEmpty()) {
            return jsonObject;
        }
        LinkedHashMap<String, Object> returnValues = new LinkedHashMap<String, Object>();
        this.recurseJsonTree(jsonObject, null, pathPieces, returnValues, "");
        return returnValues;
    }

    private boolean recurseJsonTree(Object jsonElement, String useThisPathPiece, List<String> pathPieces, Map<String, Object> returnValues, String pathToHere) {
        Object nextJsonElement = null;
        if (jsonElement instanceof JSONObject) {
            String currentPathPiece = useThisPathPiece;
            if (useThisPathPiece == null) {
                currentPathPiece = pathPieces.remove(0);
            }
            if (currentPathPiece.contains("|")) {
                String[] splitCurrentPathPiece = currentPathPiece.split("\\|");
                for (int jx = 0; jx < splitCurrentPathPiece.length; ++jx) {
                    this.processJsonElementValue(jsonElement, useThisPathPiece, pathPieces, returnValues, pathToHere, nextJsonElement, splitCurrentPathPiece[jx]);
                }
            } else {
                this.processJsonElementValue(jsonElement, useThisPathPiece, pathPieces, returnValues, pathToHere, nextJsonElement, currentPathPiece);
            }
        } else if (jsonElement instanceof JSONArray) {
            JSONArray jsonArrayForCurrentJsonElement = (JSONArray)jsonElement;
            String pathPieceToBeUsed = pathPieces.remove(0);
            for (int i = 0; i < jsonArrayForCurrentJsonElement.size(); ++i) {
                Object arrayElementObj = jsonArrayForCurrentJsonElement.get(i);
                this.recurseJsonTree(arrayElementObj, pathPieceToBeUsed, pathPieces, returnValues, pathToHere + "//" + i);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean processJsonElementValue(Object jsonElement, String useThisPathPiece, List<String> pathPieces, Map<String, Object> returnValues, String pathToHere, Object nextJsonElement, String currentPathPiece) {
        nextJsonElement = ((JSONObject)jsonElement).get((Object)currentPathPiece);
        if (pathPieces.isEmpty()) {
            returnValues.put(pathToHere + "//" + currentPathPiece, nextJsonElement);
            return true;
        }
        this.recurseJsonTree(nextJsonElement, null, pathPieces, returnValues, pathToHere + "//" + currentPathPiece);
        return true;
    }

    public boolean sanitizeJSONRecursively(Object key, Object value, String pathToHere) {
        if (value == null) {
            return false;
        }
        if (value instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)value;
            for (Object subKey : jsonObj.keySet()) {
                if (!this.sanitizeJSONRecursively(subKey, jsonObj.get(subKey), pathToHere + "/" + subKey)) continue;
                jsonObj.put(subKey, (Object)"__REMOVED__");
            }
        } else if (value instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)value;
            for (int i = 0; i < jsonArray.size(); ++i) {
                if (!this.sanitizeJSONRecursively(key, jsonArray.get(i), pathToHere + "[" + i + "]")) continue;
                jsonArray.set(i, (Object)"__REMOVED__");
            }
        } else {
            String valueAsString;
            String keyAsString = (String)key;
            if (keyAsString == null || keyAsString.isEmpty()) {
                return false;
            }
            String string = valueAsString = value == null ? "" : value.toString();
            if (valueAsString.isEmpty()) {
                return false;
            }
            String lowerCaseKey = keyAsString.toLowerCase(Locale.ENGLISH);
            for (String tmpSensitiveFieldName : this.sensitiveAPIFieldKeys) {
                if (!lowerCaseKey.matches(tmpSensitiveFieldName)) continue;
                this.log("Removed the value for sensitive field '" + pathToHere + "/" + keyAsString + "'");
                return true;
            }
            if (PARuntimeConfigDataCollector.isSensitiveValuePattern(valueAsString)) {
                this.log("Removed the value for sensitive field '" + pathToHere + "/" + keyAsString + "' (value matched a sensitive value pattern)");
                return true;
            }
        }
        return false;
    }

    public static boolean isSensitiveValuePattern(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.startsWith("OBF:AES:")) {
            return true;
        }
        if (str.startsWith("OBF:JWE:")) {
            return true;
        }
        if (str.startsWith("SHA1:")) {
            return true;
        }
        return str.matches("^([a-zA-Z0-9=_-]{6,})\\.([a-zA-Z0-9=_-]{4,})\\.([0-9]{1})$");
    }

    public HttpUtil.HttpResponse callAPIMethod(String apiPath, String logMsg) {
        this.log("Starting to collect data for '" + logMsg + "'");
        HttpUtil.HttpResponse response = this.getAPIResponse(apiPath);
        if (response.isJson()) {
            this.log("Response status=" + response.statusCode + " for " + apiPath);
            JSONParser jsonParser = new JSONParser();
            try {
                Object parsedJson = jsonParser.parse(response.body);
                if (this.isSanitizationEnabled) {
                    this.sanitizeJSONRecursively("", parsedJson, "");
                }
                response.parsedJSON = parsedJson;
                response.body = null;
            }
            catch (Exception ex) {
                this.log("ERROR: Error collecting data", ex);
            }
        }
        return response;
    }

    public HttpUtil.HttpResponse collectDataGeneric(String apiMethod, String msgForLogs) {
        return this.callAPIMethod(apiMethod, msgForLogs);
    }

    public boolean collectData() throws Exception {
        try {
            Properties runDotProps = new Properties();
            File runDotPropsFile = new File(this.paBaseDir + File.separator + "conf" + File.separator + "run.properties");
            FileInputStream runDotPropsInputStream = new FileInputStream(runDotPropsFile);
            runDotProps.load(runDotPropsInputStream);
            String paOperationalMode = runDotProps.getProperty("pa.operational.mode");
            if ("CLUSTERED_ENGINE".equals(paOperationalMode) || "CLUSTERED_CONSOLE_REPLICA".equals(paOperationalMode)) {
                this.log("INFO: Runtime Configuration can not be collected from " + paOperationalMode + " instances. Skipping.");
                return false;
            }
        }
        catch (IOException e) {
            this.log("WARN: Unable to determine pa.operational.mode", e);
        }
        LinkedHashMap<String, String> apiMethodPaths = new LinkedHashMap<String, String>();
        OrderedProperties apiMethodPathsProperties = new OrderedProperties();
        String apiPathsProps = "";
        try {
            String apiVersion = this.determineAPIVersion();
            apiPathsProps = "api-" + apiVersion + "-paths.properties";
            apiMethodPathsProperties.load(this.getClass().getClassLoader().getResourceAsStream("pa/" + apiPathsProps));
            for (Object tmpPropertyKey : ((Properties)apiMethodPathsProperties).keySet()) {
                apiMethodPaths.put(tmpPropertyKey.toString(), apiMethodPathsProperties.getProperty(tmpPropertyKey.toString()));
            }
        }
        catch (Exception e) {
            this.log("ERROR: Error loading " + apiPathsProps + ". Collecting data by using the admin API will not be possible.", e);
            return false;
        }
        return this.collectData(apiMethodPaths);
    }

    private String determineAPIVersion() throws Exception {
        HttpUtil.HttpResponse paV3Response = this.callAPIMethod("/pa-admin-api/v3/version", "/pa-admin-api/v3/version for version detection");
        if (!this.validAuthenticationCredential(paV3Response) || this.checkAPIVersion(paV3Response, "v3", "5") || this.checkAPIVersion(paV3Response, "v3", "6")) {
            return "v3";
        }
        HttpUtil.HttpResponse paV2Response = this.callAPIMethod("/pa-admin-api/v2/version", "/pa-admin-api/v2/version for version detection");
        if (!this.validAuthenticationCredential(paV2Response) || this.checkAPIVersion(paV2Response, "v2", "4")) {
            return "v2";
        }
        HttpUtil.HttpResponse paV1Response = this.callAPIMethod("/pa-admin-api/v1/version", "/pa-admin-api/v1/version for version detection");
        if (!this.validAuthenticationCredential(paV1Response) || this.checkAPIVersion(paV1Response, "v1", "3")) {
            return "v1";
        }
        this.log("Unable to determine api version using baseUrl=" + this.adminAPIBaseUrl + " for PingAccess. Using the default version, 'v1'");
        return "v1";
    }

    private boolean checkAPIVersion(HttpUtil.HttpResponse response, String apiVersion, String paVersion) {
        Object responseVersion;
        if (response.parsedJSON != null && (responseVersion = ((JSONObject)response.parsedJSON).get((Object)"version")) != null && responseVersion.toString().startsWith(paVersion)) {
            this.log("API version for PingAccess is " + apiVersion);
            return true;
        }
        return false;
    }

    private boolean validAuthenticationCredential(HttpUtil.HttpResponse response) throws Exception {
        if (response.statusCode == 401) {
            throw new Exception("Invalid Authentication Credential.");
        }
        return true;
    }

    public boolean collectData(Map<String, String> apiMethodPaths) throws Exception {
        Iterator<String> apiMethodPathsKeysetIterator = apiMethodPaths.keySet().iterator();
        HashMap<String, Map<String, Object>> savedItemValues = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> whatToSave = new HashMap<String, String>();
        ArrayList<Map> resultArray = new ArrayList<Map>();
        while (apiMethodPathsKeysetIterator.hasNext()) {
            String apiPathKey = apiMethodPathsKeysetIterator.next();
            String apiPath = apiMethodPaths.get(apiPathKey);
            if (apiPath == null || apiPath.isEmpty()) {
                this.log("WARN: Skipping empty apiPath for key '" + apiPathKey + "'");
                continue;
            }
            apiPath = apiPath.trim();
            if (apiPathKey.endsWith(".save")) {
                whatToSave.put(apiPathKey.substring(0, apiPathKey.length() - 5), apiPath);
                continue;
            }
            if (apiPath.contains("{")) {
                int openBracePos = apiPath.indexOf(123);
                int closeBracePos = apiPath.indexOf(125);
                String apiPathUpToOpeningBrace = apiPath.substring(0, openBracePos);
                String apiPathAfterClosingBrace = closeBracePos + 1 < apiPath.length() ? apiPath.substring(closeBracePos + 1) : "";
                String valueKeyInsideTheBraces = apiPath.substring(openBracePos + 1, closeBracePos);
                Map savedValuesForThisKey = (Map)savedItemValues.get(valueKeyInsideTheBraces);
                if (savedValuesForThisKey != null) {
                    for (Object tmpValueForLoop : savedValuesForThisKey.values()) {
                        String apiPathForThisItem = apiPathUpToOpeningBrace + tmpValueForLoop + apiPathAfterClosingBrace;
                        Map mapForThisItem = this.sendRequestsForDataCollection(apiPathForThisItem, apiPathKey, savedItemValues, whatToSave);
                        if (mapForThisItem == null || mapForThisItem.isEmpty()) continue;
                        resultArray.add(mapForThisItem);
                    }
                    continue;
                }
                this.log("WARN: API url replacement value not found for '" + apiPath + "'. Make sure that api paths with placeholders are ordered properly in api-paths.properties.");
                continue;
            }
            Map mapForThisItem = this.sendRequestsForDataCollection(apiPath, apiPathKey, savedItemValues, whatToSave);
            if (mapForThisItem == null || mapForThisItem.isEmpty()) continue;
            resultArray.add(mapForThisItem);
        }
        StringWriter stringWriter = new StringWriter();
        JSONArray.writeJSONString(resultArray, (Writer)stringWriter);
        this.write(stringWriter.toString());
        return true;
    }

    private Map sendRequestsForDataCollection(String apiPath, String apiPathKey, Map<String, Map<String, Object>> savedItemValues, Map<String, String> whatToSave) {
        HttpUtil.HttpResponse apiResponse = this.collectDataGeneric(apiPath, apiPath);
        HashMap<String, Object> mapForThisItem = new HashMap<String, Object>();
        mapForThisItem.put("apiPath", apiPath);
        mapForThisItem.put("statusCode", new Integer(apiResponse.statusCode));
        mapForThisItem.put("exception", apiResponse.getExceptionStackTraceAsString());
        mapForThisItem.put("json", apiResponse.parsedJSON);
        if (whatToSave.containsKey(apiPathKey)) {
            Map<String, Object> valuesToBeSaved = this.getValueFromJSON((JSONObject)apiResponse.parsedJSON, whatToSave.get(apiPathKey));
            savedItemValues.put(apiPathKey + ":" + whatToSave.get(apiPathKey), valuesToBeSaved);
            this.log("DEBUG: valuesToBeSaved for later use for " + apiPathKey + "=" + valuesToBeSaved);
        }
        mapForThisItem.put("contentType", apiResponse.contentType);
        return mapForThisItem;
    }

    @Override
    protected void writeData() throws Exception {
        this.collectData();
    }

    public String base64Encode(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        try {
            byte[] strBytes = str.getBytes(StandardCharsets.UTF_8);
            String encoded = this.base64Encode(strBytes);
            return encoded;
        }
        catch (Exception ex) {
            this.log("ERROR: Error base64 encoding", ex);
            return null;
        }
    }

    public String base64Encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            String encoded = DatatypeConverter.printBase64Binary((byte[])bytes);
            return encoded;
        }
        catch (Exception ex) {
            this.log("DEBUG: Error base64 encoding", ex);
            return null;
        }
    }

    private class HttpUtil {
        private HttpUtil() {
        }

        private TrustManager[] trustAll() {
            X509TrustManager trustAllCerts = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            };
            return new TrustManager[]{trustAllCerts};
        }

        private SSLSocketFactory getSSLSocketFactory() {
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, this.trustAll(), null);
                SSLSocketFactory sslFactory = ctx.getSocketFactory();
                return sslFactory;
            }
            catch (Exception e) {
                PARuntimeConfigDataCollector.this.log("ERROR: Error creating ssl socket factory", e);
                return null;
            }
        }

        private HostnameVerifier getHostnameVerifier() {
            return new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            };
        }

        private String createUrlWithParams(String url, Map<String, String> params) throws UnsupportedEncodingException {
            if (params == null || params.isEmpty()) {
                return url;
            }
            StringBuilder sb = new StringBuilder(url);
            if (!url.contains("?")) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            for (String paramName : params.keySet()) {
                sb.append(URLEncoder.encode(paramName, "UTF-8"));
                sb.append("=");
                sb.append(URLEncoder.encode(params.get(paramName), "UTF-8"));
                sb.append("&");
            }
            return sb.toString();
        }

        public HttpResponse httpsGet(String url, Map<String, String> params, String basicAuthorizationHeader) {
            HttpsURLConnection conn = null;
            try {
                if (params != null) {
                    url = this.createUrlWithParams(url, params);
                }
                URL urlObj = new URL(url);
                PARuntimeConfigDataCollector.this.log("DEBUG: GET url=" + url);
                conn = (HttpsURLConnection)urlObj.openConnection();
                conn.setSSLSocketFactory(this.getSSLSocketFactory());
                conn.setHostnameVerifier(this.getHostnameVerifier());
                conn.addRequestProperty("Authorization", "Basic " + basicAuthorizationHeader);
                conn.addRequestProperty("X-XSRF-Header", "PingAccess");
                ByteArrayOutputStream baos = this.readStreamToEnd(conn.getInputStream());
                String bodyStr = baos.toString();
                conn.disconnect();
                HttpResponse response = new HttpResponse(conn, bodyStr);
                return response;
            }
            catch (Exception e) {
                PARuntimeConfigDataCollector.this.log("ERROR: Error sending https get to '" + url + "'", e);
                HttpResponse response = null;
                try {
                    response = new HttpResponse(conn, null, e);
                    ByteArrayOutputStream baos = this.readStreamToEnd(conn.getErrorStream());
                    if (baos != null) {
                        String bodyStr = baos.toString();
                        response.body = bodyStr;
                    }
                    conn.disconnect();
                }
                catch (Exception secondEx) {
                    PARuntimeConfigDataCollector.this.log("ERROR: Error processing failure condition '" + url + "'", secondEx);
                }
                return response;
            }
        }

        private ByteArrayOutputStream readStreamToEnd(InputStream stream) throws Exception {
            if (stream == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8196];
            int bytesRead = -1;
            while ((bytesRead = stream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            return baos;
        }

        private class HttpResponse {
            private int statusCode = -1;
            private final Map<String, List<String>> headers;
            private String body;
            private final Exception exception;
            private final String contentType;
            private Object parsedJSON;

            public boolean isJson() {
                return "application/json".equals(this.contentType);
            }

            private boolean wasSuccess() {
                return this.statusCode >= 200 && this.statusCode <= 299;
            }

            public HttpResponse(HttpsURLConnection connection, String bodyString, Exception ex) throws Exception {
                this.exception = ex;
                this.body = bodyString;
                this.statusCode = connection.getResponseCode();
                this.headers = connection.getHeaderFields();
                this.contentType = connection.getContentType();
            }

            public HttpResponse(HttpsURLConnection connection, String bodyString) throws Exception {
                this(connection, bodyString, null);
            }

            public String getExceptionStackTraceAsString() {
                if (this.exception != null) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        this.exception.printStackTrace(pw);
                        return sw.toString();
                    }
                    catch (Exception exxx) {
                        return "ERROR while writing exception stacktrace at HttpResponse.getExceptionStackTraceAsString(). Exception=" + exxx.getMessage();
                    }
                }
                return null;
            }

            public String toString() {
                if (this.exception != null) {
                    return "HttpResponse={status=" + this.statusCode + "\ncontentType=" + this.contentType + "\nheaders=" + this.headers + "\nERROR: \n" + this.getExceptionStackTraceAsString() + "\n}";
                }
                return "HttpResponse={status=" + this.statusCode + "\ncontentType=" + this.contentType + "\nheaders=" + this.headers + "}";
            }
        }
    }
}

