/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pf;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.XMLOutput;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.net.SocketFactory;

public class PFClusterDataCollector
extends DataCollectorTask {
    private String pfBaseDir;

    public PFClusterDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
        this.pfBaseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        this.writeln("<clustertestresults>");
        this.collectData();
        this.writeln("</clustertestresults>");
    }

    private void collectData() throws Exception {
        Properties runDotProps = new Properties();
        File runDotPropertiesFile = new File(this.pfBaseDir + File.separator + "bin" + File.separator + "run.properties");
        try {
            runDotProps.load(new FileReader(runDotPropertiesFile));
        }
        catch (IOException e) {
            this.writeln("<error>\r\n<message>Error loading PingFederate run.properties file</message>\r\n<exception>");
            this.writeln(XMLOutput.escapeXML(e.getMessage()));
            this.writeln("</exception>\r\n</error>");
            this.log("Error loading PingFederate run.properties file. Can't continue", e);
            return;
        }
        String pfOperationalMode = runDotProps.getProperty("pf.operational.mode");
        if ("STANDALONE".equals(pfOperationalMode)) {
            this.writeln("<error>\r\n<message>PingFederate is not in clustered mode</message>\r\n</error>");
            this.log("PingFederate is not in clustered mode.");
            return;
        }
        String initialDiscoveryHosts = runDotProps.getProperty("pf.cluster.tcp.discovery.initial.hosts");
        if (initialDiscoveryHosts == null || initialDiscoveryHosts.isEmpty()) {
            this.writeln("<error>\r\n<message>PingFederate is in clustered mode but pf.cluster.tcp.discovery.initial.hosts is not set</message>\r\n<exception></exception>\r\n</error>");
            this.log("PingFederate is in clustered mode but pf.cluster.tcp.discovery.initial.hosts is not set.");
            return;
        }
        String pfClusterFailureDetectionPort = runDotProps.getProperty("pf.cluster.failure.detection.bind.port");
        int pfClusterFailureDetectionPortNo = -1;
        try {
            pfClusterFailureDetectionPortNo = Integer.parseInt(pfClusterFailureDetectionPort);
        }
        catch (Exception ex) {
            this.writeln("<error>\r\n<message>Invalid pf.cluster.failure.detection.bind.port setting in run.properties: " + XMLOutput.escapeXML(pfClusterFailureDetectionPort) + "</message>\r\n<exception></exception>\r\n</error>");
            this.log("Invalid pf.cluster.failure.detection.bind.port setting in run.properties: '" + pfClusterFailureDetectionPort + "'");
        }
        String[] splitInitialDiscoveryHosts = initialDiscoveryHosts.split(",");
        this.testInitialDiscoveryHosts(splitInitialDiscoveryHosts);
    }

    public void testInitialDiscoveryHosts(String[] initialDiscoveryHosts) throws Exception {
        this.writeln("<initialdiscoveryhosts>");
        for (int i = 0; i < initialDiscoveryHosts.length; ++i) {
            this.writeln("<hostresults>");
            this.writeln("<entryinrundotproperties>" + XMLOutput.escapeXML(initialDiscoveryHosts[i]) + "</entryinrundotproperties>");
            String hostPart = null;
            int clusterPortNo = -1;
            try {
                int openingParanPos = initialDiscoveryHosts[i].indexOf(91);
                hostPart = initialDiscoveryHosts[i].substring(0, openingParanPos).trim();
                int closingParanPos = initialDiscoveryHosts[i].indexOf(93);
                String portPart = initialDiscoveryHosts[i].substring(openingParanPos + 1, closingParanPos);
                clusterPortNo = Integer.parseInt(portPart.trim());
            }
            catch (Exception ex) {
                this.writeln("<error>Invalid initial discovery host port definition</error>");
                this.writeln("</hostresults>\r\n");
                this.log("Invalid initial discovery host '" + initialDiscoveryHosts[i] + "'", ex);
                continue;
            }
            if (hostPart == null || clusterPortNo == -1) {
                this.writeln("<error>Invalid initial discovery host port definition</error>");
                this.writeln("</hostresults>");
                this.log("Invalid initial discovery host '" + initialDiscoveryHosts[i] + "'. Skipping.");
                continue;
            }
            this.log("Starting to process initial discovery host entry : '" + initialDiscoveryHosts[i] + "'");
            HostnameResult hostInfoResult = this.collectHostInfo(hostPart);
            this.writeln(hostInfoResult.toXML());
            this.log("Host info : '" + hostInfoResult + "'");
            if (hostInfoResult.valid) {
                SocketConnectionResult clusterPortResult = this.testConnectionToHostPort(hostPart, clusterPortNo);
                this.writeln(clusterPortResult.toXML());
                this.log("Connection test on cluster port: '" + clusterPortResult + "'");
            }
            this.writeln("</hostresults>");
        }
        this.writeln("</initialdiscoveryhosts>");
    }

    private HostnameResult collectHostInfo(String hostPart) {
        HostnameResult rv = new HostnameResult();
        rv.originalHostnameOrIP = hostPart;
        try {
            InetAddress[] inetAddresses = InetAddress.getAllByName(hostPart);
            for (int inetAddressIndex = 0; inetAddressIndex < inetAddresses.length; ++inetAddressIndex) {
                if (hostPart.equals(inetAddresses[inetAddressIndex].getHostAddress())) {
                    rv.reverseDnsName = inetAddresses[inetAddressIndex].getCanonicalHostName();
                    rv.type = HostnameResult.HostnameEntryType.IPAddress;
                    continue;
                }
                rv.ipAddresses.add(inetAddresses[inetAddressIndex].getHostAddress());
                rv.type = HostnameResult.HostnameEntryType.Hostname;
            }
            rv.valid = true;
        }
        catch (UnknownHostException e) {
            rv.exception = e;
            rv.valid = false;
        }
        return rv;
    }

    private SocketConnectionResult testConnectionToHostPort(String hostPart, int clusterPortNo) {
        SocketConnectionResult rv = new SocketConnectionResult();
        rv.host = hostPart;
        rv.port = clusterPortNo;
        try {
            Socket sock = SocketFactory.getDefault().createSocket();
            sock.setSoTimeout(5000);
            long millisBeforeConnect = System.currentTimeMillis();
            sock.connect(new InetSocketAddress(hostPart, clusterPortNo), 5000);
            long millisAfterConnect = System.currentTimeMillis();
            rv.connectionTimeMillis = millisAfterConnect - millisBeforeConnect;
            rv.succeeded = true;
            sock.close();
        }
        catch (SocketTimeoutException ste) {
            rv.exception = ste;
            rv.timedout = true;
        }
        catch (IOException ioe) {
            rv.exception = ioe;
            rv.ioerror = true;
        }
        return rv;
    }

    public static class SocketConnectionResult {
        public String host;
        public int port;
        public long connectionTimeMillis;
        public Exception exception;
        public boolean succeeded;
        public boolean timedout;
        public boolean ioerror;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Connection to " + this.host + ":" + this.port + " ");
            if (this.succeeded) {
                sb.append("succeeded. Connected in " + this.connectionTimeMillis + " milliseconds");
            } else if (this.timedout) {
                sb.append("timed out with error '");
                sb.append(this.exception.getMessage());
            } else if (this.ioerror) {
                sb.append("failed with error '");
                sb.append(this.exception.getMessage());
            }
            return sb.toString();
        }

        public String toXML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<socketconnection>\r\n");
            sb.append("<host>" + this.host + "</host>\r\n");
            sb.append("<port>" + this.port + "</port>\r\n");
            sb.append("<connectionTimeMillis>" + this.connectionTimeMillis + "</connectionTimeMillis>\r\n");
            sb.append("<succeeded>" + this.succeeded + "</succeeded>\r\n");
            sb.append("<timedout>" + this.timedout + "</timedout>\r\n");
            sb.append("<ioerror>" + this.ioerror + "</ioerror>\r\n");
            if (this.exception != null) {
                sb.append("<exception>" + XMLOutput.escapeXML(this.exception.getMessage()) + "</exception>\r\n");
            }
            sb.append("</socketconnection>\r\n");
            return sb.toString();
        }
    }

    public static class HostnameResult {
        public String originalHostnameOrIP;
        public HostnameEntryType type;
        public List<String> ipAddresses = new ArrayList<String>();
        public String reverseDnsName;
        public Exception exception;
        public boolean valid;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (!this.valid) {
                sb.append(this.originalHostnameOrIP + " is invalid");
                sb.append(this.exception.getMessage());
            } else if (this.type == HostnameEntryType.Hostname) {
                sb.append("IP Addresses:");
                sb.append(System.lineSeparator());
                for (int i = 0; i < this.ipAddresses.size(); ++i) {
                    sb.append("  " + this.ipAddresses.get(i));
                    sb.append(System.lineSeparator());
                }
            } else {
                sb.append("Reverse Dns Name:" + this.reverseDnsName);
            }
            return sb.toString();
        }

        public String toXML() {
            StringBuilder sb = new StringBuilder();
            sb.append("<hostname>\r\n");
            sb.append("<valid>" + this.valid + "</valid>\r\n");
            sb.append("<type>" + (Object)((Object)this.type) + "</type>\r\n");
            if (this.exception != null) {
                sb.append("<exception>" + XMLOutput.escapeXML(this.exception.getMessage()) + "</exception>\r\n");
            }
            if (this.type == HostnameEntryType.Hostname) {
                sb.append("<ipaddresses>\r\n");
                for (int i = 0; i < this.ipAddresses.size(); ++i) {
                    sb.append("<ip>" + this.ipAddresses.get(i) + "</ip>\r\n");
                }
                sb.append("</ipaddresses>\r\n");
            } else {
                sb.append("<reversednsname>" + XMLOutput.escapeXML(this.reverseDnsName) + "</reversednsname>\r\n");
            }
            sb.append("</hostname>\r\n");
            return sb.toString();
        }

        public static enum HostnameEntryType {
            Hostname,
            IPAddress;

        }
    }
}

