/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pf;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.SslDataCollector;
import com.pingidentity.csd.server.tools.CollectSupportData;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Properties;

public class PFSslDataCollector
extends SslDataCollector {
    private String pfBaseDir;

    public PFSslDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration);
        this.pfBaseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        block16: {
            this.writeln("<ssltestresults>");
            HashSet<String> allProcessedPortNumbers = new HashSet<String>();
            Properties runDotProps = new Properties();
            try {
                File runDotPropsFile = new File(this.pfBaseDir + File.separator + "bin" + File.separator + "run.properties");
                FileInputStream runDotPropsInputStream = new FileInputStream(runDotPropsFile);
                runDotProps.load(runDotPropsInputStream);
                String pfOperationalMode = runDotProps.getProperty("pf.operational.mode");
                if (!"CLUSTERED_ENGINE".equals(pfOperationalMode)) {
                    String pfConsoleBindAddress = runDotProps.getProperty("pf.console.bind.address");
                    if (pfConsoleBindAddress == null || pfConsoleBindAddress.isEmpty() || "0.0.0.0".equals(pfConsoleBindAddress) || "::".equals(pfConsoleBindAddress)) {
                        pfConsoleBindAddress = "127.0.0.1";
                    }
                    String pfAdminHttpsPort = runDotProps.getProperty("pf.admin.https.port");
                    int adminPortNo = -1;
                    try {
                        adminPortNo = Integer.parseInt(pfAdminHttpsPort);
                        if (adminPortNo > -1) {
                            this.log("Collecting SSL/TLS data from PingFederate admin service " + pfConsoleBindAddress + ":" + adminPortNo);
                            allProcessedPortNumbers.add(pfConsoleBindAddress + ":" + adminPortNo);
                            this.collectDataForHostPort(pfConsoleBindAddress, adminPortNo);
                        } else {
                            this.log("Not collecting SSL/TLS data from PingFederate admin service as it's disabled");
                        }
                    }
                    catch (Exception e) {
                        this.log("Error collecting data for PingFederate admin console port '" + pfAdminHttpsPort + "'", e);
                    }
                }
                if ("CLUSTERED_CONSOLE".equals(pfOperationalMode)) break block16;
                String pfEngineBindAddress = runDotProps.getProperty("pf.engine.bind.address");
                if (pfEngineBindAddress == null || pfEngineBindAddress.isEmpty() || "0.0.0.0".equals(pfEngineBindAddress) || "::".equals(pfEngineBindAddress)) {
                    pfEngineBindAddress = "127.0.0.1";
                }
                String pfRuntimePort = runDotProps.getProperty("pf.https.port");
                int runtimePortNo = -1;
                try {
                    runtimePortNo = Integer.parseInt(pfRuntimePort);
                    if (runtimePortNo > -1) {
                        this.log("Collecting SSL/TLS data from PingFederate runtime service " + pfEngineBindAddress + ":" + runtimePortNo);
                        allProcessedPortNumbers.add(pfEngineBindAddress + ":" + runtimePortNo);
                        this.collectDataForHostPort(pfEngineBindAddress, runtimePortNo);
                    } else {
                        this.log("Not collecting SSL/TLS data from PingFederate runtime port as it's disabled");
                    }
                }
                catch (Exception e) {
                    this.log("Error collecting data for PingFederate runtime port '" + pfRuntimePort + "'", e);
                }
                String pfSecondaryPort = runDotProps.getProperty("pf.secondary.https.port");
                int secondaryPortNo = -1;
                try {
                    secondaryPortNo = Integer.parseInt(pfSecondaryPort);
                    if (secondaryPortNo > -1) {
                        this.log("Collecting SSL/TLS data from PingFederate secondary runtime service " + pfEngineBindAddress + ":" + secondaryPortNo);
                        allProcessedPortNumbers.add(pfEngineBindAddress + ":" + secondaryPortNo);
                        this.collectDataForHostPort(pfEngineBindAddress, secondaryPortNo);
                        break block16;
                    }
                    this.log("Not collecting SSL/TLS data from PingFederate secondary port as it's disabled");
                }
                catch (Exception e) {
                    this.log("Error collecting data for PingFederate secondary runtime port '" + pfSecondaryPort + "'", e);
                }
            }
            catch (Exception ex) {
                this.log("Unexpected error collecting ssl/tls data for PingFederate", ex);
            }
        }
        this.writeln("</ssltestresults>");
    }
}

