/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import com.pingidentity.csd.pingdata.PingDataLineTransformers;
import com.pingidentity.csd.server.conf.ConfigurationUtil;
import com.pingidentity.csd.server.conf.PropertyConfiguration;
import com.pingidentity.csd.server.conf.YamlConfigurationUtil;
import com.pingidentity.csd.server.datacollector.DataCollector;
import com.pingidentity.csd.server.datacollector.DataCollectorFactory;
import com.pingidentity.csd.server.datacollector.DataCollectorListBuilder;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.tools.CleanupAction;
import com.pingidentity.csd.server.tools.LdapTool;
import com.pingidentity.csd.server.tools.argument.ArgumentConfiguration;
import com.pingidentity.csd.server.tools.argument.BooleanOptionArgument;
import com.pingidentity.csd.server.tools.argument.ConfigFileArgumentFactory;
import com.pingidentity.csd.server.types.DataCollectorType;
import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.types.ProductType;
import com.pingidentity.csd.server.util.AdminSessionUtils;
import com.pingidentity.csd.server.util.DesensitizingOutputStream;
import com.pingidentity.csd.server.util.LineTransformer;
import com.pingidentity.csd.server.util.ServerUtils;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.collectsupportdata.ArchiveFileFilter;
import com.pingidentity.csd.tools.collectsupportdata.ArchiveFileFilterBuilder;
import com.pingidentity.csd.tools.collectsupportdata.FileAction;
import com.pingidentity.csd.tools.collectsupportdata.FilterStackTrace;
import com.pingidentity.csd.tools.collectsupportdata.LDIFUtils;
import com.pingidentity.csd.tools.collectsupportdata.PDMonitorFileUtils;
import com.pingidentity.csd.tools.collectsupportdata.SecurityLevel;
import com.pingidentity.csd.tools.examinesupportdata.ExamineSupportData;
import com.pingidentity.csd.tools.examinesupportdata.PASupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.PFSupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SimpleHTMLBuilder;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.visualizereplicationstate.VisualizeReplicationState;
import com.unboundid.common.util.FileUtils;
import com.unboundid.common.util.SystemUtils;
import com.unboundid.common.util.TextUtils;
import com.unboundid.csd.messages.AdminToolMessages;
import com.unboundid.csd.messages.QuickSetupMessages;
import com.unboundid.csd.messages.ToolMessages;
import com.unboundid.csd.messages.UBIDTool2Messages;
import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.directory.server.core.DirectoryServer;
import com.unboundid.directory.server.protocols.internal.InternalLDAPConnection;
import com.unboundid.directory.server.tools.config.ServerConfiguration;
import com.unboundid.directory.server.types.LdapServerAddress;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorManager;
import com.unboundid.ldap.sdk.unboundidds.monitors.SystemInfoMonitorEntry;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageBuilder;
import com.unboundid.messages.MessageUtils;
import com.unboundid.messages.Severity;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PassphraseEncryptedOutputStream;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CollectSupportData
extends CommandLineTool {
    private final long[] MONITOR_HISTORY_AGES_MILLIS = new long[]{600000L, 3600000L, 21600000L, 86400000L, 604800000L, 5270400000L};
    public static final long BYTES_PER_GIGABYTE = 0x40000000L;
    public static final char[] PASSPHRASE_ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890'()+,-.=/:?".toCharArray();
    private static final String SERVER_LOG_NAME_WITH_EXT = "server.log";
    public static final Date NOW = new Date();
    protected static final String internalToolDescription = "Collect Support Data";
    protected static final String internalToolName = "collect-support-data";
    private static String csdVersion;
    private LdapTool ldapTool;
    private ConfigurationUtil configUtil;
    private static Integer productPID;
    public ProductType productType;
    private static final String COMMENT_PREFIX = "# ";
    private static String archiveName;
    private static final int DEFAULT_REPORT_INTERVAL_SECONDS = 1;
    private static final int DEFAULT_REPORT_COUNT = 10;
    private static final int DEFAULT_JSTACK_COUNT = 10;
    private static final DateFormat DATE_FORMAT;
    public static final DateFormat DURATION_DATE_FORMAT;
    private static final String VAR_PID = "$PID";
    private static final String NO_PID = "nopid";
    private static final int DEFAULT_BINARY_SCAN_SIZE = 2048;
    static final int BOGUS_PID = 1234;
    private ZipParentPath zpp = ZipParentPath.SOLARIS_COMMAND;
    private static final int MAX_FILE_ARCHIVE_DEPTH = 8;
    private static final int HEAD_SIZE_KB = 100;
    private static final int TAIL_SIZE_KB = 900;
    private static final Set<String> DYNAMIC_SPECIAL_FILES;
    private static final Map<String, Long> SPECIAL_HEAD_SIZE;
    private static final Set<DataCollectorType> TYPES_WITH_MULTIPLE_DATA_COLLECTORS;
    private Set<File> externalServerDirs = null;
    private Set<File> externalLogDirs = null;
    private static final Map<String, Long> SPECIAL_TAIL_SIZE;
    public static final int DEFAULT_COLLECTOR_OUTPUT_BYTES_COUNT = 1000000;
    public static final int INCREASED_COLLECTOR_OUTPUT_BYTES_COUNT = 3000000;
    public static final int NUM_CONFIG_ARCHIVES_TO_INCLUDE = 5;
    public static final int NUM_THREAD_DUMP_FILES = 5;
    private static final boolean DEBUG = false;
    private static final String ZIP_SERVER_ROOT_FILES_ROOT_NAME = "server-root-files";
    private static final String ZIP_EXTERNAL_FILES_ROOT_NAME = "server-external-files";
    private static final String GENERATED_HTML_FILE_NAME = "index.html";
    private static final String relativePingDirectoryJarFilePath;
    private static final String relativePingDirectoryProxyJarFilePath;
    private static final String relativePingDataGovernanceJarFilePath;
    private static final String relativePingAuthorizeJarFilePath;
    private static final String relativePingDataMetricsJarFilePath;
    private static final String relativePingDataSyncJarFilePath;
    private static final String relativePingFederateStartupJarFilePath;
    private static final String CONFIG_FILE_NAME = "csd_configuration.yaml";
    private static final String CSD_CONFIG_PATH = "csd.config.path";
    private static final String DEFAULT_CONFIG_FILE_PATH = "../conf/csd_configuration.yaml";
    private static final int FIPS_MODE_MIN_PASSWORD_LENGTH = 14;
    public ArgumentParser argParser;
    private boolean initializeServer;
    private File serverRoot;
    private String serverRootPath;
    public List<Integer> additionalPids = new ArrayList<Integer>();
    public int maxJstacks;
    public int reportCount;
    public int reportIntervalSeconds;
    public int fileHeadCollectionSizeKB;
    public int fileTailCollectionSizeKB;
    public boolean collectExpensiveData;
    public boolean collectReplicationStateDump;
    private static PrintStream logOutputStream;
    public final List<Message> summaryMessages = new ArrayList<Message>();
    private StringArgument serverRootArg;
    private boolean noLdapOverride;
    private final LDAPConnectionOptions ldapConnectionOptions;
    private boolean parallel = true;
    private boolean includeBinaryOverride = false;
    private String jdkBinDirPath = null;
    private String productVersion = null;
    private final Set<String> zipEntryNames = new HashSet<String>();
    private final OperatingSystem os = OperatingSystem.forName(System.getProperty("os.name"));
    private ZipOutputStream rawZipOutputStream;
    private DesensitizingOutputStream desensitizedStream;
    public SecurityLevel securityLevel = SecurityLevel.OBSCURE_SECRETS;
    private static final String ENV_VAR_INSTANCE_ROOT = "INSTANCE_ROOT";
    private static final String ZIP_SEPARATOR = "/";
    public static final String EOL;
    public static String PINGACCESS2x_STARTER_CLASS;
    public static String PINGACCESS_STARTER_CLASS;

    public static void main(String[] args) {
        int exitCode;
        String configFilePath = DEFAULT_CONFIG_FILE_PATH;
        if (System.getProperty(CSD_CONFIG_PATH) != null) {
            configFilePath = System.getProperty(CSD_CONFIG_PATH) + File.separator + CONFIG_FILE_NAME;
        }
        if ((exitCode = CollectSupportData.doMain(configFilePath, args)) != 0) {
            System.exit(exitCode);
        }
    }

    public static int doMain(String configFilePath, String[] args) {
        csdVersion = CollectSupportData.getCSDVersion();
        File csd_config = new File(configFilePath);
        if (!csd_config.isFile()) {
            System.err.println("Error: Could not find the collect-support-data configuration file at '" + configFilePath + "'. Exiting.");
            return 1;
        }
        System.out.println("Using the CSD_Configuration file located: " + configFilePath);
        ConfigurationUtil config = CollectSupportData.registerArguments(configFilePath);
        String serverRootCmdLineLongArg = "--" + config.getArgument("serverRootArg").getLongIdentifier();
        String serverRootCmdLineShortArg = "-" + config.getArgument("serverRootArg").getShortIdentifier();
        for (int i = 0; i < args.length - 1; ++i) {
            if (!serverRootCmdLineLongArg.equals(args[i]) && !serverRootCmdLineShortArg.equals(args[i])) continue;
            config.setServerRoot(args[i + 1]);
        }
        if (config.getServerRoot() == null && System.getenv(ENV_VAR_INSTANCE_ROOT) != null) {
            config.setServerRoot(System.getenv(ENV_VAR_INSTANCE_ROOT));
        }
        CollectSupportData.handleFipsMode(config);
        CollectSupportData csd = new CollectSupportData(config);
        return csd.runTool(args).intValue();
    }

    private static void handleFipsMode(ConfigurationUtil config) {
        PropertyConfiguration fipsPropertyConfig = config.getPropertyConfiguration("fipsModeProperties");
        if (fipsPropertyConfig != null && config.getServerRoot() != null) {
            File propertiesFile = new File(fipsPropertyConfig.getFileLocation());
            if (!propertiesFile.isAbsolute()) {
                Path serverRootPath = Paths.get(config.getServerRoot(), new String[0]);
                Path configFilePath = serverRootPath.resolve(fipsPropertyConfig.getFileLocation());
                propertiesFile = new File(configFilePath.toString());
            }
            try {
                FileInputStream inputStream = new FileInputStream(propertiesFile);
                Properties properties = new Properties();
                properties.load(inputStream);
                String fipsPropertyValue = properties.getProperty(fipsPropertyConfig.getKeyName());
                if (fipsPropertyValue == null) {
                    System.out.println("Could not find the property " + fipsPropertyConfig.getKeyName() + " in " + propertiesFile.getPath());
                    System.out.println("FIPS mode will not be enabled.");
                }
                if (fipsPropertyConfig.getKeyValue().equals(fipsPropertyValue)) {
                    System.out.println("FIPS mode is enabled.");
                    System.setProperty("com.unboundid.crypto.FIPS_MODE", "true");
                    System.setProperty("com.unboundid.crypto.FIPS_PROVIDER", "BCFIPS");
                    System.setProperty("com.unboundid.crypto.REMOVE_NON_ESSENTIAL_PROVIDERS", "true");
                    System.setProperty("org.bouncycastle.rsa.allow_multi_use", "true");
                    System.setProperty("org.bouncycastle.fips.approved_only", "true");
                    System.setProperty("org.bouncycastle.jsse.enable_md5", "true");
                    config.setFipsModeEnabled(true);
                }
            }
            catch (IOException e) {
                System.out.println("Error occurred when attempting to read the " + propertiesFile.getPath() + " file.\n" + e.getMessage());
                System.exit(1);
            }
        }
    }

    private static String getCSDVersion() {
        String version = "NOT FOUND";
        InputStream is = null;
        try {
            is = CollectSupportData.class.getResourceAsStream("/META-INF/maven/com.pingidentity.csd/csd/pom.properties");
            Properties pomProps = new Properties();
            if (is != null) {
                pomProps.load(is);
                version = pomProps.getProperty("version");
            }
        }
        catch (Exception e) {
            System.err.println("Could not read CSD version " + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    System.err.println("Problem  closing  stream " + e);
                }
            }
        }
        return version;
    }

    public CollectSupportData() {
        this(false, null);
    }

    public CollectSupportData(boolean initializeServer, String configFilePath) {
        this(initializeServer, System.out, System.err, configFilePath);
    }

    public CollectSupportData(ConfigurationUtil config) {
        super((OutputStream)System.out, (OutputStream)System.err);
        this.configUtil = config;
        this.initializeJdkBinDirPath();
        this.ldapConnectionOptions = new LDAPConnectionOptions();
        this.ldapConnectionOptions.setResponseTimeoutMillis(30000L);
        this.ldapConnectionOptions.setConnectTimeoutMillis(20000);
    }

    CollectSupportData(boolean initializeServer, OutputStream out, OutputStream err, String configFilePath) {
        super(out, err);
        this.initializeJdkBinDirPath();
        this.ldapConnectionOptions = new LDAPConnectionOptions();
        this.ldapConnectionOptions.setResponseTimeoutMillis(30000L);
        this.ldapConnectionOptions.setConnectTimeoutMillis(20000);
        csdVersion = CollectSupportData.getCSDVersion();
        if (configFilePath != null) {
            this.log("Using the collect-support-data configuration file: " + configFilePath);
            this.configUtil = CollectSupportData.registerArguments(configFilePath);
        }
        this.initializeServer = initializeServer;
    }

    public File getZipFile() {
        try {
            if (this.isArgumentPresent("outputPath")) {
                File outputPath = new File(this.getStringArgumentValue("outputPath")).getAbsoluteFile();
                if (outputPath.exists()) {
                    if (outputPath.isFile()) {
                        return outputPath;
                    }
                    String archiveName = this.getArchiveName();
                    if (this.isArgumentPresent("encrypt")) {
                        return new File(outputPath, archiveName + "-zip-encrypted");
                    }
                    return new File(outputPath, archiveName + "-zip");
                }
                File parentFile = outputPath.getParentFile();
                if (parentFile != null && parentFile.isDirectory()) {
                    return outputPath;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isArgumentPresent("encrypt")) {
            return new File(this.getArchiveName() + "-zip-encrypted");
        }
        return new File(this.getArchiveName() + "-zip");
    }

    private void initializeJdkBinDirPath() {
        this.log("JAVA HOME: " + System.getProperty("java.home"));
        File jdkBinDir = SystemUtils.getJdkBinDirectory();
        if (jdkBinDir != null) {
            try {
                this.jdkBinDirPath = jdkBinDir.getCanonicalPath();
                if (!this.jdkBinDirPath.endsWith(File.separator)) {
                    this.jdkBinDirPath = this.jdkBinDirPath + File.separator;
                }
            }
            catch (Exception ioe) {
                this.log("Error obtaining JDK bin directory path", ioe);
                this.jdkBinDirPath = "";
            }
        }
    }

    public String getJdkBinDirPath() {
        return this.jdkBinDirPath;
    }

    public File getLogFile() throws IOException {
        File logFile = new File(DirectoryServer.getServerRoot() + "/logs/tools/" + this.getArchiveName() + "/collect-support-data.log");
        if (!logFile.exists()) {
            CollectSupportData.extractLogFile(this.getArchiveName());
        }
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractLogFile(String zipFile) throws IOException {
        String logPath = DirectoryServer.getServerRoot() + "/logs/tools/";
        try (ZipInputStream zip = new ZipInputStream(new FileInputStream(zipFile + "-zip"));){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                int count;
                if (!entry.getName().equals(zipFile + "/collect-support-data.log")) continue;
                File file = new File(logPath, entry.getName());
                if (!file.toPath().normalize().startsWith(file.toPath())) {
                    throw new IOException("Unable to normalize file path");
                }
                byte[] buffer = new byte[4096];
                file.getParentFile().mkdirs();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                while ((count = zip.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
                out.close();
                break;
            }
        }
    }

    public List<Message> getSummaryMessages() {
        return this.summaryMessages;
    }

    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(4);
        return examples;
    }

    public List<Message> getDescription() {
        return null;
    }

    public void doExtendedArgumentValidation() throws ArgumentException {
        Object passphrase;
        String levelValue;
        SecurityLevel level;
        File outputPath;
        this.log("Beginning argument validation.");
        if (this.isArgumentPresent("outputPath") && !(outputPath = new File(this.getStringArgumentValue("outputPath"))).exists()) {
            File parentFile = outputPath.getParentFile();
            if (parentFile == null || !parentFile.exists()) {
                throw new ArgumentException(UBIDTool2Messages.ERR_CSD_OUTPUT_PATH_PARENT_DOES_NOT_EXIST.get((Object)outputPath.getAbsolutePath()).toString());
            }
            if (parentFile.isFile()) {
                throw new ArgumentException(UBIDTool2Messages.ERR_CSD_OUTPUT_PATH_PARENT_NOT_DIR.get((Object)outputPath.getAbsolutePath()).toString());
            }
        }
        if (this.isArgumentPresent("securityLevel") && (level = SecurityLevel.fromCliArg(levelValue = this.getStringArgumentValue("securityLevel"))) == null) {
            throw new ArgumentException(UBIDTool2Messages.ERR_SUPP_DATA_SECURITY_LEVEL_INVALID_VALUE.get((Object)levelValue, (Object)this.configUtil.getArgument("securityLevel").toString(), (Object)SecurityLevel.MAXIMUM.getCliArgValue()).toString());
        }
        if (!(!this.isArgumentPresent("generatePassphrase") || this.isArgumentPresent("encrypt") && this.isArgumentPresent("passphraseFile"))) {
            throw new ArgumentException(UBIDTool2Messages.ERR_SUPP_DATA_GENERATE_REQURIES_PASSPHRASE_AND_ENCRYPT.get((Object)this.configUtil.getArgument("generatePassphrase").getLongIdentifier(), (Object)this.configUtil.getArgument("passphraseFile").getLongIdentifier(), (Object)this.configUtil.getArgument("encrypt").getLongIdentifier()).toString());
        }
        if ((this.isArgumentPresent("encryptionPassphrase") || this.isArgumentPresent("passphraseFile")) && !this.isArgumentPresent("encrypt") && !this.isArgumentPresent("decrypt")) {
            throw new ArgumentException(UBIDTool2Messages.ERR_SUPP_DATA_PASSPHRASE_REQUIRES_ENCRYPT_OR_DEDCRYPT.get((Object)this.configUtil.getArgument("passphraseFile").getLongIdentifier(), (Object)this.configUtil.getArgument("encrypt").getLongIdentifier(), (Object)this.configUtil.getArgument("decrypt").getLongIdentifier()).toString());
        }
        if ((this.isArgumentPresent("encrypt") || this.isArgumentPresent("decrypt")) && this.configUtil.getFipsModeEnabled()) {
            try {
                passphrase = this.getPassphrase(true);
            }
            catch (Exception e) {
                throw new ArgumentException(UBIDTool2Messages.ERR_SUPP_DATA_CANNOT_INITIALIZE_ENCRYPTION.get((Object)e.getMessage()).toString(), (Throwable)e);
            }
            if (((char[])passphrase).length < 14) {
                throw new ArgumentException("When FIPS mode is enabled, the passphrase must be at least 14 characters");
            }
        }
        if (this.isArgumentPresent("decrypt")) {
            passphrase = this.argParser.getNamedArguments().iterator();
            while (passphrase.hasNext()) {
                String longID;
                Argument a = (Argument)passphrase.next();
                if (!a.isPresent() || (longID = a.getLongIdentifier()).equals(this.configUtil.getArgument("decrypt").getLongIdentifier()) || longID.equals(this.configUtil.getArgument("passphraseFile").getLongIdentifier()) || this.configUtil.getCommandlineArguments().contains(a)) continue;
                throw new ArgumentException(UBIDTool2Messages.ERR_SUPP_DATA_DECRYPT_ARG_MISMATCH.get((Object)this.configUtil.getArgument("decrypt").getLongIdentifier(), (Object)a.getLongIdentifier()).toString());
            }
        }
        if (this.isArgumentPresent("timeRange") && this.isArgumentPresent("duration")) {
            throw new ArgumentException(UBIDTool2Messages.ERR_CSD_EXCLUSIVE_ARGUMENTS_PROVIDED.get((Object)this.configUtil.getArgument("timeRange").getLongIdentifier(), (Object)this.configUtil.getArgument("duration").getLongIdentifier()).toString());
        }
        if (this.isArgumentPresent("timeRange")) {
            String tsArg = this.getStringArgumentValue("timeRange");
            if (!tsArg.contains(",")) {
                throw new ArgumentException(UBIDTool2Messages.INFO_CSD_TIMERANGE_INVALID_FORMAT.get((Object)tsArg).toString());
            }
            if (tsArg.indexOf(",") == 0 || tsArg.indexOf(",") == tsArg.length() - 1) {
                throw new ArgumentException(UBIDTool2Messages.INFO_CSD_TIMERANGE_INVALID_FORMAT.get((Object)tsArg).toString());
            }
        } else {
            this.addSummaryMessage(UBIDTool2Messages.INFO_ENCOURAGE_RUN_WITH_TIME_RANGE_ARGUMENT.get());
        }
    }

    protected String getHeaderOutput() {
        Message m = UBIDTool2Messages.INFO_TOOL_HEADER_OUTPUT.get((Object)csdVersion, (Object)this.productType.toString(), (Object)this.productVersion);
        return MessageUtils.punctuate((Message)m).toString();
    }

    public ResultCode doToolProcessing() {
        ResultCode ret = ResultCode.SUCCESS;
        try {
            if (this.isArgumentPresent("decrypt")) {
                return this.decryptArchive();
            }
            ByteArrayOutputStream memoryBufferLogStream = new ByteArrayOutputStream();
            logOutputStream = new PrintStream(memoryBufferLogStream);
            boolean init = false;
            try {
                init = this.init();
            }
            catch (ArgumentException ae) {
                this.log("Error processing arguments", ae);
                this.addSummaryMessage(Message.raw((Category)Category.TOOLS, (Severity)Severity.SEVERE_ERROR, (CharSequence)ae.getMessage(), (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.log("Error initializing client", e);
                PrintStream ps = new PrintStream(new ByteArrayOutputStream());
                e.printStackTrace(ps);
                this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_ERROR_INITIALIZING.get((Object)ps.toString()));
            }
            if (init) {
                try {
                    File zipFile = this.getZipFile();
                    this.rawZipOutputStream = new ZipOutputStream(this.wrapInEncryptedOutputStreamIfAppropriate(Files.newOutputStream(zipFile.toPath(), new OpenOption[0])));
                    if (this.isArgumentPresent("securityLevel")) {
                        this.securityLevel = SecurityLevel.fromCliArg(this.getStringArgumentValue("securityLevel"));
                    }
                    this.desensitizedStream = ProductType.isPingDirectoryProduct(this.productType) ? new DesensitizingOutputStream(this.rawZipOutputStream, this.getDesensitizingReplacements(), PingDataLineTransformers.csnDecoder) : new DesensitizingOutputStream(this.rawZipOutputStream, this.getDesensitizingReplacements(), new LineTransformer[0]);
                    DataCollectorFactory dataCollectorFactory = new DataCollectorFactory(this);
                    if (this.configUtil.getDataCollectorConfigurations() != null) {
                        for (DataCollectorConfiguration config : this.configUtil.getDataCollectorConfigurations()) {
                            this.configUtil.resolve(config);
                            List<DataCollector> list = dataCollectorFactory.getDataCollectors(config);
                            if (!list.isEmpty()) {
                                DataCollector collector = list.get(0);
                                this.configUtil.registerDataCollector(config.getId(), collector);
                                continue;
                            }
                            String type = config.getType();
                            if (TYPES_WITH_MULTIPLE_DATA_COLLECTORS.contains((Object)DataCollectorType.valueOf(type))) {
                                list = dataCollectorFactory.getDataCollectors(DataCollectorType.valueOf(type), config.getId());
                                for (DataCollector collector : list) {
                                    this.configUtil.registerDataCollector(collector.getName(), collector);
                                }
                                continue;
                            }
                            DataCollector collector = dataCollectorFactory.getDataCollector(DataCollectorType.valueOf(type), config.getId());
                            this.configUtil.registerDataCollector(config.getId(), collector);
                        }
                    }
                    DataCollectorListBuilder dataCollectorListBuilder = new DataCollectorListBuilder(this, this.parallel);
                    dataCollectorListBuilder.addDefaults(this.productType);
                    dataCollectorListBuilder.addDataCollectors(this.configUtil.getDataCollectors());
                    if (this.productType.equals((Object)ProductType.PINGDIRECTORY)) {
                        dataCollectorListBuilder.addVisualizeReplicationStateCollector();
                    }
                    ArrayList<CleanupAction> cleanupActions = new ArrayList<CleanupAction>();
                    cleanupActions.addAll(dataCollectorListBuilder.getCleanupActionsList());
                    Iterator<DataCollector> content = dataCollectorListBuilder.getDataCollectorsList().iterator();
                    this.archiveSystemData(content);
                    for (CleanupAction action : cleanupActions) {
                        action.cleanup();
                    }
                    logOutputStream.flush();
                    this.archiveLogContents(memoryBufferLogStream);
                    this.desensitizedStream.flushAll();
                    this.rawZipOutputStream.flush();
                    this.rawZipOutputStream.close();
                    if (ProductType.isPingDirectoryProduct(this.productType)) {
                        this.examineData(zipFile);
                    }
                    if (this.productType.equals((Object)ProductType.PINGDIRECTORY)) {
                        this.visualizeReplicationState(zipFile);
                    }
                    this.createHtmlIndexFile(zipFile);
                    this.printAlarmDetails();
                    this.printlnToConsole();
                    this.printlnToConsole(MessageUtils.punctuate((Message)UBIDToolMessages.INFO_SUPP_DATA_FINISHED_WRITING.get((Object)zipFile.getName())));
                    if (this.isArgumentPresent("encrypt")) {
                        this.printlnToConsole();
                        if (this.isArgumentPresent("passphraseFile")) {
                            this.printlnToConsole(UBIDTool2Messages.INFO_SUPP_DATA_OUTPUT_ENCRYPTED_WITH_PASSPHRASE_FILE.get((Object)this.getStringArgumentValue("passphraseFile"), (Object)internalToolName));
                        } else {
                            this.printlnToConsole(UBIDTool2Messages.INFO_SUPP_DATA_OUTPUT_ENCRYPTED_WITHOUT_PASSPHRASE_FILE.get((Object)internalToolName));
                        }
                    }
                }
                catch (Exception e) {
                    this.log("Error running tool", e);
                    this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_ERROR_EXECUTING.get());
                }
            }
            logOutputStream.close();
            boolean errors = false;
            boolean fatalErrors = false;
            for (Message m : this.summaryMessages) {
                if (m.getDescriptor().getSeverity().getMask() >= Severity.FATAL_ERROR.getMask()) {
                    fatalErrors = true;
                } else if (m.getDescriptor().getSeverity().getMask() >= Severity.MILD_ERROR.getMask()) {
                    errors = true;
                }
                this.printlnToConsole(MessageUtils.punctuate((Message)m));
            }
            if (fatalErrors) {
                this.printlnToConsole();
                this.printlnToConsole(UBIDToolMessages.INFO_SUPP_DATA_ERRORS_SEE_LOG.get());
                ret = ResultCode.UNWILLING_TO_PERFORM;
            } else if (errors) {
                this.printlnToConsole();
                this.printlnToConsole(UBIDToolMessages.INFO_SUPP_DATA_MILD_ERRORS_SEE_LOG.get());
                ret = ResultCode.OTHER;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ret = ResultCode.UNWILLING_TO_PERFORM;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    private ResultCode decryptArchive() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [37[CATCHBLOCK], 34[CATCHBLOCK], 5[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private OutputStream wrapInEncryptedOutputStreamIfAppropriate(OutputStream s) throws Exception {
        if (this.isArgumentPresent("encrypt")) {
            char[] passphrase = this.getPassphrase(true);
            try {
                PassphraseEncryptedOutputStream passphraseEncryptedOutputStream = new PassphraseEncryptedOutputStream(passphrase, s);
                return passphraseEncryptedOutputStream;
            }
            catch (Exception e) {
                throw new Exception(UBIDTool2Messages.ERR_SUPP_DATA_CANNOT_INITIALIZE_ENCRYPTION.get((Object)e.getMessage()).toString(), e);
            }
            finally {
                Arrays.fill(passphrase, '\u0000');
            }
        }
        return s;
    }

    private char[] getPassphrase(boolean encryptMode) throws Exception {
        char[] passphrase;
        block13: {
            char[] confirm;
            boolean passphraseSpecified = this.isArgumentPresent("passphraseFile");
            boolean generatePassphrase = this.isArgumentPresent("generatePassphrase");
            if (encryptMode && generatePassphrase) {
                SecureRandom secureRandom = new SecureRandom();
                char[] passphrase2 = new char[64];
                for (int i = 0; i < passphrase2.length; ++i) {
                    passphrase2[i] = PASSPHRASE_ALPHABET[secureRandom.nextInt(PASSPHRASE_ALPHABET.length)];
                }
                String passphraseFile = this.getStringArgumentValue("passphraseFile");
                try {
                    PrintWriter w = new PrintWriter(passphraseFile);
                    w.write(passphrase2);
                    w.write(EOL);
                    w.close();
                }
                catch (Exception e) {
                    throw new Exception(UBIDTool2Messages.ERR_SUPP_DATA_ERROR_WRITING_PASSPHRASE.get((Object)passphraseFile, (Object)e.getMessage()).toString(), e);
                }
                return passphrase2;
            }
            if (passphraseSpecified) {
                String passphraseFile = this.getStringArgumentValue("passphraseFile");
                try {
                    BufferedReader r = new BufferedReader(new FileReader(passphraseFile));
                    String line = r.readLine();
                    r.close();
                    return line.toCharArray();
                }
                catch (Exception e) {
                    throw new Exception(UBIDTool2Messages.ERR_SUPP_DATA_ERROR_READING_PASSPHRASE.get((Object)passphraseFile, (Object)e.getMessage()).toString(), e);
                }
            }
            if (this.isArgumentPresent("encryptionPassphrase")) {
                return this.getStringArgumentValue("encryptionPassphrase").toCharArray();
            }
            while (true) {
                if (encryptMode) {
                    this.out(new Object[]{UBIDTool2Messages.INFO_SUPP_DATA_ENCRYPT_PASSPHRASE_PROMPT.get()});
                } else {
                    this.out(new Object[]{UBIDTool2Messages.INFO_SUPP_DATA_DECRYPT_PASSPHRASE_PROMPT.get((Object)internalToolName)});
                }
                passphrase = PasswordReader.readPasswordChars();
                if (passphrase == null || passphrase.length == 0) {
                    this.err(new Object[]{UBIDTool2Messages.ERR_SUPP_DATA_MUST_ENTER_PASSPHRASE.get()});
                    continue;
                }
                if (!encryptMode) break block13;
                this.out(new Object[]{UBIDTool2Messages.INFO_SUPP_DATA_PASSPHRASE_REPROMPT.get()});
                confirm = PasswordReader.readPasswordChars();
                if (confirm != null && Arrays.equals(passphrase, confirm)) break;
                Arrays.fill(passphrase, '\u0000');
                if (confirm != null) {
                    Arrays.fill(confirm, '\u0000');
                }
                this.err(new Object[]{UBIDTool2Messages.ERR_SUPP_DATA_PASSPHRASE_MISMATCH.get()});
            }
            Arrays.fill(confirm, '\u0000');
        }
        return passphrase;
    }

    private boolean init() throws Exception {
        this.doExtendedArgumentValidation();
        this.processArguments();
        this.productVersion = this.getProductVersionString(this.productType);
        String header = this.getHeaderOutput();
        this.log(header);
        this.printlnToConsole();
        this.printlnToConsole(header);
        if (this.ldapEnabled()) {
            this.initiateLDAPUtility();
        }
        this.log("INSTANCE_ROOT=" + this.serverRoot.getCanonicalPath());
        this.printlnToConsole(UBIDToolMessages.INFO_SUPP_DATA_SERVER_ROOT.get((Object)this.serverRootPath));
        boolean bl = this.parallel = !this.isArgumentPresent("sequential");
        if (this.isCurrentUserAdmin()) {
            String currentUserName = System.getProperty("user.name");
            String serverUserName = ServerUtils.getServerUserName(this.serverRoot);
            if (serverUserName != null && !serverUserName.equals(currentUserName)) {
                System.setProperty("user.name", serverUserName);
            }
        } else {
            this.addSummaryMessage(UBIDTool2Messages.INFO_CSD_ENCOURAGE_RUN_AS_ROOT.get());
        }
        if (this.initializeServer) {
            throw new Exception("Initializing the server is not supported");
        }
        if (this.ldapEnabled() && !this.validateLdapOptions()) {
            this.noLdapOverride = true;
            this.printlnToConsole(UBIDToolMessages.INFO_SUPP_DATA_LDAP_CONN.get((Object)AdminToolMessages.INFO_UNAVAILABLE_LABEL.get()));
        }
        this.printlnToConsole();
        return true;
    }

    private void initiateLDAPUtility() throws LDAPException {
        try {
            this.ldapTool = new LdapTool(System.out, System.err, this);
        }
        catch (ArgumentException e) {
            this.noLdapOverride = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Integer determineProductPID(ProductType productType) {
        switch (productType) {
            case PINGFEDERATE: {
                String pidString = null;
                if (this.getOs() == OperatingSystem.WINDOWS) {
                    int pid = this.determinePFProcessIdOnWindows();
                    if (pid == -1) {
                        this.log("Error determining PingFederate process ID. Please ensure that the PingFederate server is running");
                        return 1234;
                    }
                    return pid;
                }
                String pidFilePath = this.serverRootPath + File.separator + "bin" + File.separator + "pingfederate.pid";
                File pfPidFile = new File(pidFilePath);
                if (pfPidFile.exists()) {
                    BufferedReader bufReader = null;
                    FileReader fileReader = new FileReader(pfPidFile);
                    bufReader = new BufferedReader(fileReader);
                    pidString = bufReader.readLine();
                    this.log("PingFederate Process ID read from " + pidFilePath + " is " + pidString);
                    Integer n = Integer.parseInt(pidString);
                    try {
                        bufReader.close();
                    }
                    catch (IOException e) {
                        this.log("Error closing input stream: " + e);
                    }
                    return n;
                    catch (Exception e) {
                        try {
                            this.log("Error reading process id from '" + pidFilePath + "'", e);
                        }
                        catch (Throwable throwable) {
                            try {
                                bufReader.close();
                            }
                            catch (IOException e2) {
                                this.log("Error closing input stream: " + e2);
                            }
                            throw throwable;
                        }
                        try {
                            bufReader.close();
                        }
                        catch (IOException e3) {
                            this.log("Error closing input stream: " + e3);
                        }
                        break;
                    }
                }
                this.log("Error determining PingFederate process ID. " + pidFilePath + " does not exist");
                break;
            }
            case PINGDIRECTORY: 
            case PINGDIRECTORYPROXY: 
            case PINGDATAGOVERNANCE: 
            case PINGAUTHORIZE: 
            case PINGDATAMETRICS: 
            case PINGDATASYNC: {
                String pidString = null;
                String pidFilePath = this.serverRootPath + File.separator + "logs" + File.separator + "server.pid";
                File pdPidFile = new File(pidFilePath);
                if (pdPidFile.exists()) {
                    BufferedReader bufReader = null;
                    try {
                        FileReader fileReader = new FileReader(pdPidFile);
                        bufReader = new BufferedReader(fileReader);
                        pidString = bufReader.readLine();
                        this.log("PingDirectory Process ID read from " + pidFilePath + " is " + pidString);
                        Integer e3 = Integer.parseInt(pidString);
                        return e3;
                    }
                    catch (Exception e) {
                        this.log("Error reading process id from '" + pidFilePath + "'", e);
                    }
                    finally {
                        if (bufReader != null) {
                            try {
                                bufReader.close();
                            }
                            catch (IOException e) {
                                this.log("Error closing input stream: " + e);
                            }
                        }
                    }
                }
                this.log("Error determining PingDirectory process ID. " + pidFilePath + " does not exist");
                return null;
            }
            case PINGACCESS: {
                int pid = this.determinePAProcessId();
                if (pid == -1) {
                    this.log("Error determining PingAccess process ID. Please ensure that the PingAccess server is running");
                    break;
                }
                return pid;
            }
        }
        this.log("WARNING: Using bogus PID 1234.");
        return 1234;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int determinePFProcessIdOnWindows() {
        BufferedReader stdInput = null;
        BufferedReader stdError = null;
        try {
            String tmpStrFromStdErr;
            String tmpStrFromStdOut;
            Properties runDotProperties = new Properties();
            File runDotPropertiesFile = new File(this.serverRootPath + File.separator + "bin" + File.separator + "run.properties");
            runDotProperties.load(new FileReader(runDotPropertiesFile));
            String portNoForNetstat = null;
            String pfHttpsPort = runDotProperties.getProperty("pf.https.port");
            if (pfHttpsPort != null && !pfHttpsPort.equals("-1")) {
                portNoForNetstat = pfHttpsPort;
            } else {
                String pfAdminPort = runDotProperties.getProperty("pf.admin.https.port");
                if (pfAdminPort != null && !pfAdminPort.equals("-1")) {
                    portNoForNetstat = pfAdminPort;
                } else {
                    String pfHttpPort = runDotProperties.getProperty("pf.http.port");
                    if (pfHttpPort != null && !pfHttpPort.equals("-1")) {
                        portNoForNetstat = pfHttpPort;
                    }
                }
            }
            if (portNoForNetstat == null) {
                int pfAdminPort = -1;
                return pfAdminPort;
            }
            Process p = Runtime.getRuntime().exec("netstat -ao");
            StringBuilder sbStdErr = new StringBuilder();
            StringBuilder sbStdOut = new StringBuilder();
            stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((tmpStrFromStdOut = stdInput.readLine()) != null) {
                sbStdOut.append(tmpStrFromStdOut);
                sbStdOut.append("\r\n");
            }
            while ((tmpStrFromStdErr = stdError.readLine()) != null) {
                sbStdErr.append(tmpStrFromStdErr);
            }
            String netstatStdout = sbStdOut.toString();
            if (netstatStdout != null) {
                String[] netstatStdoutLines;
                for (String tmpStdoutLine : netstatStdoutLines = netstatStdout.split("\\r?\\n")) {
                    int processID;
                    String[] splitLine = tmpStdoutLine.split("\\s+");
                    if (splitLine == null || splitLine.length < 6 || !"LISTENING".equals(splitLine[4].trim()) || !splitLine[2].trim().endsWith(":" + portNoForNetstat)) continue;
                    int n = processID = Integer.parseInt(splitLine[5].trim());
                    return n;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Could not determine process id: " + e);
        }
        finally {
            try {
                if (stdInput != null) {
                    stdInput.close();
                }
                if (stdError != null) {
                    stdError.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int determinePAProcessId() {
        String processId = null;
        if (this.serverRootPath != null && !this.serverRootPath.isEmpty()) {
            BufferedReader stdError;
            BufferedReader stdInput;
            block40: {
                stdInput = null;
                stdError = null;
                try {
                    String[] jpsStdoutLines;
                    String tmpStrFromStdErr;
                    String tmpStrFromStdOut;
                    String jpsCmd = this.getJdkBinDirPath() + "jps";
                    File fileObjForJpsCmd = new File(jpsCmd);
                    if (!fileObjForJpsCmd.exists()) break block40;
                    Process p = Runtime.getRuntime().exec(jpsCmd + " -l -v  ");
                    stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    StringBuilder sbStdErr = new StringBuilder();
                    StringBuilder sbStdOut = new StringBuilder();
                    while ((tmpStrFromStdOut = stdInput.readLine()) != null) {
                        sbStdOut.append(tmpStrFromStdOut);
                        sbStdOut.append("\r\n");
                    }
                    while ((tmpStrFromStdErr = stdError.readLine()) != null) {
                        sbStdErr.append(tmpStrFromStdErr);
                    }
                    for (String jpsOutput : jpsStdoutLines = sbStdOut.toString().split("\\r?\\n")) {
                        if (!jpsOutput.contains(PINGACCESS2x_STARTER_CLASS) && !jpsOutput.contains(PINGACCESS_STARTER_CLASS) || !jpsOutput.contains(this.serverRootPath)) continue;
                        String[] splitLine = jpsOutput.split("\\s+");
                        processId = splitLine[0];
                        break;
                    }
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        if (stdInput != null) {
                            stdInput.close();
                        }
                        if (stdError != null) {
                            stdError.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (processId == null) {
                System.out.println("JPS command failed to execute or did not return the process id, trying other methods");
                if (this.getOs() == OperatingSystem.WINDOWS) {
                    try {
                        processId = this.determinePAProcessIdOnWindows();
                    }
                    catch (Exception e) {
                        System.out.println("ERROR: Error getting processid: " + e);
                        e.printStackTrace();
                    }
                } else {
                    stdInput = null;
                    stdError = null;
                    try {
                        String[] psStdoutLines;
                        String tmpStrFromStdErr;
                        String tmpStrFromStdOut;
                        Process p = Runtime.getRuntime().exec("ps axwww");
                        stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        StringBuilder sbStdErr = new StringBuilder();
                        StringBuilder sbStdOut = new StringBuilder();
                        while ((tmpStrFromStdOut = stdInput.readLine()) != null) {
                            sbStdOut.append(tmpStrFromStdOut);
                            sbStdOut.append("\r\n");
                        }
                        while ((tmpStrFromStdErr = stdError.readLine()) != null) {
                            sbStdErr.append(tmpStrFromStdErr);
                        }
                        for (String psOutput : psStdoutLines = sbStdOut.toString().split("\\r?\\n")) {
                            if (!psOutput.contains(PINGACCESS2x_STARTER_CLASS) && !psOutput.contains(PINGACCESS_STARTER_CLASS) || !psOutput.contains(this.serverRootPath)) continue;
                            String[] splitLine = psOutput.trim().split("\\s+");
                            processId = splitLine[0];
                            break;
                        }
                    }
                    catch (Exception e) {
                    }
                    finally {
                        try {
                            if (stdInput != null) {
                                stdInput.close();
                            }
                            if (stdError != null) {
                                stdError.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (processId == null || "".equals(processId)) {
                processId = "-1";
            }
        } else {
            processId = "-1";
        }
        return Integer.parseInt(processId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determinePAProcessIdOnWindows() throws FileNotFoundException, IOException {
        String processId = "-1";
        Properties runDotProperties = new Properties();
        File runDotPropertiesFile = new File(this.serverRootPath + File.separator + "conf" + File.separator + "run.properties");
        runDotProperties.load(new FileReader(runDotPropertiesFile));
        String operationalMode = runDotProperties.getProperty("pa.operational.mode");
        String portNoForNetstat = null;
        boolean usingAListeningPortNumber = false;
        if (operationalMode.equals("CLUSTERED_CONSOLE_REPLICA") || operationalMode.equals("CLUSTERED_CONSOLE") || operationalMode.equals("STANDALONE")) {
            portNoForNetstat = runDotProperties.getProperty("admin.port");
            usingAListeningPortNumber = true;
        } else {
            Properties boostrapDotProperties = new Properties();
            File boostrapDotPropertiesFile = new File(this.serverRootPath + File.separator + "conf" + File.separator + "bootstrap.properties");
            boostrapDotProperties.load(new FileReader(boostrapDotPropertiesFile));
            portNoForNetstat = boostrapDotProperties.getProperty("engine.admin.configuration.port");
        }
        if (portNoForNetstat != null && !portNoForNetstat.isEmpty()) {
            BufferedReader stdInput = null;
            BufferedReader stdError = null;
            try {
                String tmpStrFromStdErr;
                String tmpStrFromStdOut;
                Process p = Runtime.getRuntime().exec("netstat -aon");
                stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                StringBuilder sbStdErr = new StringBuilder();
                StringBuilder sbStdOut = new StringBuilder();
                while ((tmpStrFromStdOut = stdInput.readLine()) != null) {
                    sbStdOut.append(tmpStrFromStdOut);
                    sbStdOut.append("\r\n");
                }
                while ((tmpStrFromStdErr = stdError.readLine()) != null) {
                    sbStdErr.append(tmpStrFromStdErr);
                }
                String netstatStdout = sbStdOut.toString();
                if (netstatStdout == null) {
                    System.out.println("Netstat failed. Could not determine PingAccess process id");
                } else {
                    String[] netstatStdoutLines;
                    for (String tmpStdoutLine : netstatStdoutLines = netstatStdout.split("\\r?\\n")) {
                        String[] splitLine = tmpStdoutLine.split("\\s+");
                        if (splitLine == null || splitLine.length < 6) continue;
                        if (usingAListeningPortNumber) {
                            if (!"LISTENING".equals(splitLine[4].trim()) || !splitLine[2].trim().endsWith(":" + portNoForNetstat)) continue;
                            System.out.println("Found PingAccess process id, '" + splitLine[5].trim() + "'");
                            processId = splitLine[5].trim();
                            continue;
                        }
                        if (!"ESTABLISHED".equals(splitLine[4].trim()) || !splitLine[3].trim().endsWith(":" + portNoForNetstat)) continue;
                        System.out.println("Found PingAccess process id, '" + splitLine[5].trim() + "'");
                        processId = splitLine[5].trim();
                    }
                }
            }
            finally {
                try {
                    if (stdInput != null) {
                        stdInput.close();
                    }
                    if (stdError != null) {
                        stdError.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ("-1".equals(processId) || processId == null) {
            System.out.println("Unable to identify PingAccess PID using netstat.");
        }
        return processId;
    }

    private void processArguments() throws ArgumentException {
        this.log("Beginning argument processing.");
        this.serverRootArg = (StringArgument)this.configUtil.getArgument("serverRootArg");
        this.serverRootPath = this.serverRootArg.getValue();
        if (this.serverRootPath != null) {
            this.serverRoot = new File(this.serverRootPath);
        } else if (this.getServerRoot() != null) {
            this.serverRoot = new File(this.getServerRoot());
        } else {
            this.log("No server root found, please ensure the tool is being run with the --serverRoot argument or on a system with an INSTANCE_ROOT environment variable.");
            this.log("Exiting...");
            System.exit(1);
        }
        String productTypeString = this.getStringArgumentValue("productType");
        this.productType = ProductType.forName(productTypeString);
        if (!ProductType.isPingDirectoryProduct(this.productType)) {
            this.noLdapOverride = true;
        }
        productPID = this.determineProductPID(this.productType);
        if (this.isArgumentPresent("pid")) {
            this.additionalPids = this.getMultiStringArgumentValue("pid").stream().map(Integer::parseInt).collect(Collectors.toList());
            Integer serverPid = this.getServerPID(this.serverRoot);
            for (Integer additionalPid : this.additionalPids) {
                if (!additionalPid.equals(serverPid)) continue;
                throw new ArgumentException(MessageUtils.punctuate((Message)UBIDToolMessages.ERR_ADDITIONAL_PID_MATCHES_SERVER_PID.get((Object)serverPid)).toString());
            }
        }
        this.maxJstacks = this.getIntegerArgumentValue("maxJstacks", 10);
        this.reportCount = this.getIntegerArgumentValue("reportCount", 10);
        this.reportIntervalSeconds = this.getIntegerArgumentValue("reportInterval", 1);
        this.fileHeadCollectionSizeKB = this.getIntegerArgumentValue("fileHeadCollectionKBSize", 100);
        this.fileTailCollectionSizeKB = this.getIntegerArgumentValue("fileTailCollectionKBSize", 900);
        this.collectExpensiveData = this.isArgumentPresent("collectExpensiveData");
        this.collectReplicationStateDump = this.isOptionEnabled("collectReplicationStateDump");
    }

    private boolean validateLdapOptions() throws Exception {
        LDAPConnection connection;
        if (!ProductType.isPingDirectoryProduct(this.productType)) {
            throw new Exception(UBIDTool2Messages.ERR_ATTEMPTED_TO_VALIDATE_LDAP_OPTIONS_ON_WRONG_PRODUCT.get().toString());
        }
        if (this.isOptionEnabled("useInternalConnection")) {
            if (DirectoryServer.isRunning()) {
                return true;
            }
            this.addSummaryMessage(UBIDToolMessages.WARN_SUPP_DATA_SERVER_NOT_RUNNING.get((Object)this.serverRootPath));
            return false;
        }
        if (null == this.getServerPID(this.serverRoot) || this.ldapTool == null) {
            this.addSummaryMessage(UBIDToolMessages.WARN_SUPP_DATA_SERVER_NOT_RUNNING.get((Object)this.serverRootPath));
            return false;
        }
        try {
            connection = this.getConnection();
            connection.setConnectionOptions(this.ldapConnectionOptions);
            if (connection.getConnectionStatistics().getNumBindRequests() == 0L) {
                this.log("Anonymous LDAP connection");
                this.printlnToConsole();
                this.printlnToConsole(new MessageBuilder(UBIDToolMessages.WARN_SUPP_DATA_ANONYMOUS_LDAP.get()).append((CharSequence)".").toMessage());
            }
        }
        catch (LDAPException ldape) {
            this.log("Error establishing LDAP connection.", ldape);
            this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_SERVER_RUNNING_NO_CONNECT.get((Object)this.serverRootPath));
            return false;
        }
        String connectedAddressString = connection.getConnectedAddress();
        if (!"localhost".equalsIgnoreCase(connectedAddressString)) {
            try {
                InetAddress connectedInetAddress = InetAddress.getByName(connectedAddressString);
                InetAddress localHostAddress = InetAddress.getLocalHost();
                if (connectedInetAddress == null) {
                    this.log("ERROR:  Could not determine connection host.");
                    return false;
                }
                this.log("LDAP host: " + connectedInetAddress);
                if (!connectedInetAddress.isLoopbackAddress() && !connectedInetAddress.equals(localHostAddress)) {
                    this.log("Connection host " + connectedInetAddress + " not equal to " + localHostAddress);
                    String instance = "unknown";
                    SystemInfoMonitorEntry sime = MonitorManager.getSystemInfoMonitorEntry((LDAPConnection)connection);
                    if (sime != null) {
                        instance = sime.getInstanceRoot();
                    }
                    this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_SERVER_NOT_LOCAL.get((Object)connectedAddressString, (Object)instance));
                    return false;
                }
            }
            catch (Exception e) {
                this.log("Error validating LDAP host", e);
                this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_ERROR_LDAP_OPTIONS.get());
                return false;
            }
        }
        try {
            HashSet<Integer> ports = new HashSet<Integer>();
            File configFile = new File(this.serverRoot, "config/config.ldif");
            ServerConfiguration config = new ServerConfiguration(configFile);
            Set addresses = config.getEnabledLdapAddresses();
            for (LdapServerAddress address : addresses) {
                ports.add(address.getPort());
            }
            int ldapPort = connection.getConnectedPort();
            if (!ports.contains(ldapPort)) {
                this.log("Port " + connection.getConnectedPort() + " not one of " + StaticUtils.collectionToString(ports, ","));
                this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_SERVER_PORT_MISMATCH.get((Object)ldapPort, (Object)this.serverRootPath));
                return false;
            }
            this.printlnToConsole(new MessageBuilder("LDAP Connection: ").append((CharSequence)connection.getConnectedAddress()).append((CharSequence)":").append(connection.getConnectedPort()).toMessage());
            this.log("Verified that " + connection.getConnectedAddress() + ":" + connection.getConnectedPort() + " is server " + this.serverRoot.getCanonicalPath());
            return true;
        }
        catch (Exception e) {
            this.log("Error validating LDAP port", e);
            this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_ERROR_LDAP_OPTIONS.get());
            return false;
        }
    }

    public LDAPInterface createLdapConnection(boolean createAdminSession) {
        if (this.isOptionEnabled("useInternalConnection")) {
            return new InternalLDAPConnection(true);
        }
        LDAPConnection connection = null;
        try {
            connection = this.getConnection();
            connection.setConnectionOptions(this.ldapConnectionOptions);
            if (createAdminSession) {
                AdminSessionUtils.startSession(connection, internalToolName);
            }
        }
        catch (LDAPException ldape) {
            if (this.getServerPID(this.serverRoot) != null) {
                this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_SERVER_RUNNING_NO_CONNECT.get((Object)this.serverRootPath));
            }
            this.log("Error creating LDAP connection", ldape);
        }
        return connection;
    }

    private void archiveSystemData(Iterator<DataCollector> dataEnum) throws Exception {
        this.putNextEntry(this.getArchiveName() + ZIP_SEPARATOR);
        String comment = this.getStringArgumentValue("comment");
        if (comment != null && comment.length() > 0) {
            this.archiveComment(comment, "README");
        }
        this.archiveToolInfo();
        this.archiveServerRootFiles();
        this.archiveLatestHistoryFiles();
        while (dataEnum.hasNext()) {
            DataCollector data = dataEnum.next();
            if (!data.isStarted()) {
                data.start();
            }
            StringBuilder zipEntryPath = new StringBuilder();
            if (data.getZipParentPath() != null) {
                zipEntryPath.append(data.getZipParentPath()).append(ZIP_SEPARATOR);
            }
            if (data.getOutputFileType() != DataCollectorFileType.DEFAULT) {
                zipEntryPath.append(data.getName() + "." + (Object)((Object)data.getOutputFileType()));
            } else {
                zipEntryPath.append(data.getName());
            }
            this.printToConsole("Archiving " + zipEntryPath + " ..... ");
            this.log("Begin archive of " + data);
            StringBuilder zipEntryFullPath = new StringBuilder(this.getArchiveName()).append(ZIP_SEPARATOR).append((CharSequence)zipEntryPath);
            this.putNextEntry(zipEntryFullPath.toString());
            if (data.doWriteDataCollectorComments()) {
                this.writeComment("");
                this.writeComment("name:    " + data.getName());
                if (data.getCommand() != null) {
                    this.writeComment("command: " + data.getCommand());
                }
                if (data.getMessage() != null) {
                    this.writeComment("message: " + data.getMessage());
                }
                if (data.isStarted()) {
                    this.writeComment("started: " + DATE_FORMAT.format(data.getStartTime()));
                } else {
                    this.writeComment("this data was unretrievable");
                }
                if (data.isFinished()) {
                    this.writeEOL();
                    this.writeComment("stopped: " + DATE_FORMAT.format(data.getStopTime()));
                }
                this.writeComment("");
                this.writeEOL();
            }
            try {
                this.log("Writing content of " + data + " to zip");
                if (data.getName().contains("jps")) {
                    ByteArrayOutputStream ba = new ByteArrayOutputStream();
                    data.writeOutputTo(ba);
                    ba.close();
                    ArrayList<String> split = new ArrayList<String>(Arrays.asList(ba.toString().split(" ")));
                    ListIterator<String> listIterator = split.listIterator();
                    while (listIterator.hasNext()) {
                        String element = (String)listIterator.next();
                        if (!element.equals("--bindPassword") && !element.equals("-w")) continue;
                        listIterator.next();
                        listIterator.set("<removed>");
                    }
                    this.write(((Object)split).toString());
                } else {
                    data.writeOutputTo(this.desensitizedStream);
                }
                this.log("Finished content of " + data + " to zip");
                if (data.doWriteDataCollectorComments()) {
                    if (data.isFinished()) {
                        this.writeEOL();
                        this.writeComment("stopped: " + DATE_FORMAT.format(data.getStopTime()));
                    }
                    if (data.getMessage() != null) {
                        this.writeComment("message: " + data.getMessage());
                    }
                    this.writeComment("");
                }
                this.writeEOL();
            }
            catch (Exception ioe) {
                String logMessage = "Error output from data element " + data;
                this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_ERROR_ARCHIVING.get((Object)data.getName()));
                this.log(this.desensitizedStream, logMessage, ioe);
                this.log(logMessage, ioe);
            }
            this.log("Finished archiving " + data);
            if (data.isStarted() && data.isFinished()) {
                Message msg = data.getMessage();
                if (msg == null || msg.toString().trim().isEmpty()) {
                    msg = QuickSetupMessages.INFO_PROGRESS_DONE.get();
                }
                this.printlnToConsole(msg);
            } else {
                this.printErrorLnToConsole();
            }
            this.closeZipEntry();
            if (!data.doFilterOutput()) continue;
            this.log("Adding Filtered Version of " + data.getName());
            StringBuilder zipEntry = new StringBuilder(this.getArchiveName());
            zipEntry.append(ZIP_SEPARATOR);
            if (data.getZipParentPath() != null) {
                zipEntry.append(data.getZipParentPath()).append(ZIP_SEPARATOR);
            }
            zipEntry.append(data.getName());
            zipEntry.append("-filtered");
            this.putNextEntry(zipEntry.toString());
            try {
                File unfilteredFile = File.createTempFile(data.getName(), "-unfiltered");
                FileOutputStream unfilteredOut = new FileOutputStream(unfilteredFile);
                data.writeOutputTo(unfilteredOut);
                unfilteredOut.close();
                FilterStackTrace.main(this.desensitizedStream, this.desensitizedStream, "-f", unfilteredFile.getAbsolutePath());
                unfilteredFile.delete();
            }
            catch (Exception ioe) {
                String logMessage = "Error output from filtered data element " + data;
                this.addSummaryMessage(UBIDToolMessages.ERR_SUPP_DATA_ERROR_ARCHIVING.get((Object)(data.getName() + "-filtered")));
                this.log(this.desensitizedStream, logMessage, ioe);
                this.log(logMessage, ioe);
            }
            this.closeZipEntry();
        }
        if (this.isOptionEnabled("archiveExtensionSource")) {
            this.archiveExtensionSource();
        }
        this.archiveDataCollectorOutput(new File(this.serverRoot, "tmp/explore-metrics"), true);
        this.log("Finished archiving");
        this.closeZipEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHtmlIndexFile(File zipFile) throws IOException {
        List<String> filenames;
        if (this.isArgumentPresent("encrypt")) {
            this.log("The archive is encrypted, skipped creating HTML index file");
            return;
        }
        SimpleHTMLBuilder htmlBuilder = new SimpleHTMLBuilder();
        try (SupportDataArchive sda = null;){
            sda = this.productType == ProductType.PINGFEDERATE ? new PFSupportDataArchive(zipFile.getAbsolutePath()) : (this.productType == ProductType.PINGACCESS ? new PASupportDataArchive(zipFile.getAbsolutePath()) : new SupportDataArchive(zipFile.getAbsolutePath()));
            filenames = ExamineSupportData.calculatePathsForFiles(sda);
        }
        Collections.sort(filenames);
        htmlBuilder.addTopText((Object)((Object)this.productType) + " " + this.productVersion);
        htmlBuilder.addTopText("JAVA_HOME: " + this.jdkBinDirPath);
        for (String name : filenames) {
            htmlBuilder.addLink(name, name);
        }
        HashMap zipProperties = new HashMap();
        URI zipURI = URI.create("jar:" + zipFile.toURI());
        try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
            this.appendFileToArchive(GENERATED_HTML_FILE_NAME, htmlBuilder.build(), zipFS, false);
        }
        catch (Exception ex) {
            this.log("Html file error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void examineData(File zipFile) throws IOException {
        List<String> filenames;
        if (this.isArgumentPresent("encrypt")) {
            this.log("Skipped examining encrypted archive");
            return;
        }
        ByteArrayOutputStream esdCommandOutput = new ByteArrayOutputStream();
        ExamineSupportData examineTool = new ExamineSupportData(esdCommandOutput, esdCommandOutput);
        ExamineSupportData.doMain(examineTool, "--severity", "INFO", "--enableinternalanalysis", "--verbose", zipFile.getAbsolutePath());
        String examineSupportDataFilename = "examine-support-data";
        SimpleHTMLBuilder htmlBuilder = new SimpleHTMLBuilder();
        try (SupportDataArchive sda = null;){
            sda = new SupportDataArchive(zipFile.getAbsolutePath());
            filenames = ExamineSupportData.calculatePathsForFiles(sda);
        }
        filenames.add(examineSupportDataFilename);
        Collections.sort(filenames);
        htmlBuilder.addTopText((Object)((Object)this.productType) + " " + this.productVersion);
        htmlBuilder.addTopText("JAVA_HOME: " + this.jdkBinDirPath);
        htmlBuilder.addTopTextWithLink("Examiner found ", examineTool.getErrorCount() + " ERROR issues and " + examineTool.getWarningCount() + " WARNING issues.", examineSupportDataFilename);
        for (String name : filenames) {
            htmlBuilder.addLink(name, name);
        }
        HashMap zipProperties = new HashMap();
        URI zipURI = URI.create("jar:" + zipFile.toURI());
        try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
            this.appendFileToArchive(examineSupportDataFilename, esdCommandOutput.toString(), zipFS, true);
            try {
                this.appendFileToArchive(GENERATED_HTML_FILE_NAME, htmlBuilder.build(), zipFS, false);
            }
            catch (Exception ex) {
                this.log("Html file error", ex);
            }
            try {
                this.appendFileToArchive("Examiner__" + examineTool.getErrorCount() + "__ERROR_issues__" + examineTool.getWarningCount() + "__WARNING_issues", "", zipFS, false);
            }
            catch (Exception ex) {
                this.log("Examiner errors and warnings file error", ex);
            }
        }
        catch (Exception ex) {
            this.log("Error appending examine files to archive \"" + zipFile + "\"", ex);
        }
    }

    private void visualizeReplicationState(File zipFile) throws IOException {
        if (this.isArgumentPresent("encrypt")) {
            this.log("Skipped visualize replication state for encrypted archive");
            return;
        }
        this.printToConsole("Archiving replication state data ..... ");
        File tempDir = StaticUtils.createTempDir();
        String[] args = new String[]{"--csd-file", zipFile.getAbsolutePath(), "--output-folder", tempDir.getAbsolutePath()};
        ByteArrayOutputStream vrsCommandErr = new ByteArrayOutputStream();
        ResultCode rc = VisualizeReplicationState.doMain(null, vrsCommandErr, args);
        if (rc != ResultCode.SUCCESS || tempDir.list().length <= 1) {
            this.printErrorLnToConsole();
            this.log("Error analyzing the replication monitor in the archive: " + vrsCommandErr);
            return;
        }
        HashMap zipProperties = new HashMap();
        URI zipURI = URI.create("jar:" + zipFile.toURI());
        try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
            for (File file : tempDir.listFiles()) {
                try {
                    this.appendFileToArchive("visualize-replication-state/" + file.getName(), new String(Files.readAllBytes(file.toPath())), zipFS, false);
                }
                catch (Exception ex) {
                    this.log("Error appending visualize-replication-state file to CSD archive" + ex);
                }
            }
        }
        catch (Exception ex) {
            this.log("Error accessing CSD archive to append visualize-replication-state:  \"" + zipFile + "\"", ex);
        }
        this.printlnToConsole(QuickSetupMessages.INFO_PROGRESS_DONE.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFileToArchive(String filename, String fileContents, FileSystem zipFS, boolean desensitize) throws Exception {
        Path esdReportZipPath = zipFS.getPath(this.getArchiveName() + ZIP_SEPARATOR + filename, new String[0]);
        OutputStream outStream = Files.newOutputStream(esdReportZipPath, new OpenOption[0]);
        ArrayList<ObjectPair<Pattern, String>> replacements = desensitize ? this.getDesensitizingReplacements() : new ArrayList<ObjectPair<Pattern, String>>();
        outStream = ProductType.isPingDirectoryProduct(this.productType) ? new DesensitizingOutputStream(outStream, replacements, PingDataLineTransformers.csnDecoder) : new DesensitizingOutputStream(outStream, replacements, new LineTransformer[0]);
        try {
            CollectSupportData.write(outStream, fileContents);
            CollectSupportData.write(outStream, EOL);
        }
        finally {
            outStream.close();
        }
    }

    public boolean ldapEnabled() {
        return !this.isOptionEnabled("noLdap") && !this.noLdapOverride;
    }

    private void archiveComment(String comment, String fileName) throws Exception {
        String commentEntryName = this.getArchiveName() + ZIP_SEPARATOR + fileName;
        this.putNextEntry(commentEntryName);
        this.write(comment);
        this.writeEOL();
        this.closeZipEntry();
    }

    private void archiveToolInfo() throws Exception {
        String toolInfoEntryName = this.getArchiveName() + ZIP_SEPARATOR + "tool-info";
        this.putNextEntry(toolInfoEntryName);
        this.write(this.getHeaderOutput());
        this.writeEOL();
        this.closeZipEntry();
    }

    private void archiveLogContents(ByteArrayOutputStream memoryBufferLogStream) throws Exception {
        String logEntryName = this.getArchiveName() + ZIP_SEPARATOR + "collect-support-data.log";
        this.putNextEntry(logEntryName);
        memoryBufferLogStream.writeTo(this.desensitizedStream);
        this.writeEOL();
        this.closeZipEntry();
    }

    private void archiveServerRootFiles() {
        this.archiveRootFiles(this.serverRoot, true);
        if (ProductType.isPingDirectoryProduct(this.productType)) {
            this.archivePDMonitorFiles();
        }
    }

    private void archivePDMonitorFiles() {
        try {
            File configFile = new File(this.serverRoot, "config" + File.separator + "config.ldif");
            List<Entry> monitorHistoryPlugins = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.MONITOR_HISTORY_PLUGIN, new String[0]);
            for (Entry monitorHistoryPlugin : monitorHistoryPlugins) {
                String logFileString = monitorHistoryPlugin.getAttributeValue(LDIFUtils.LOG_FILE);
                File logFile = StaticUtils.getFileFromString(logFileString, this.serverRoot);
                LinkedHashSet<File> monitorFiles = new LinkedHashSet<File>(PDMonitorFileUtils.getFilesNearAges(logFile, System.currentTimeMillis(), this.MONITOR_HISTORY_AGES_MILLIS));
                if (this.isArgumentPresent("timeRange")) {
                    String[] timestamps = this.getStringArgumentValue("timeRange").split(",");
                    Date start = StaticUtils.parseTimestamp(timestamps[0]);
                    Date end = StaticUtils.parseTimestamp(timestamps[1]);
                    if (start != null && end != null) {
                        monitorFiles.addAll(PDMonitorFileUtils.getFilesWithinRange(logFile, start, end));
                    }
                }
                if (this.isArgumentPresent("duration")) {
                    long durationMs = this.getDurationValue("duration", TimeUnit.MILLISECONDS);
                    Date start = Date.from(NOW.toInstant().minusMillis(durationMs));
                    monitorFiles.addAll(PDMonitorFileUtils.getFilesWithinRange(logFile, start, NOW));
                }
                for (File monitorFile : monitorFiles) {
                    this.archiveFile(monitorFile, null);
                }
                File historyFile = new File(logFile.getParentFile(), logFile.getName() + ".history");
                this.archiveFile(historyFile, null);
            }
        }
        catch (Exception e) {
            this.log("Error attempting to retrieve monitor history plugins: ", e);
        }
    }

    private void archiveLatestHistoryFiles() {
        File historyDir = new File(this.serverRoot, "history");
        if (historyDir.exists()) {
            this.log("History content exists");
            List<File> archives = CollectSupportData.getHistoryToArchive(historyDir);
            if (!archives.isEmpty()) {
                for (File archive : archives) {
                    this.log("Archiving history snapshot " + archive);
                    final File archiveFiles = new File(archive, "files");
                    if (archiveFiles.exists()) {
                        this.log("Archiving update backup files for " + archive.getName());
                        this.archiveRootFiles(archiveFiles, false);
                    } else {
                        this.log("Archive " + archive.getName() + " contains no backed up files");
                    }
                    ArchiveFileFilter historyArchiveFilter = new ArchiveFileFilter(){

                        @Override
                        public FileAction action(File file) {
                            return FileAction.INCLUDE_ALL;
                        }

                        @Override
                        public boolean accept(File file) {
                            return file != null && !FileUtils.equals((File)file, (File)archiveFiles);
                        }
                    };
                    this.archiveDirectory(archive, historyArchiveFilter);
                }
            } else {
                this.log("No latest historical snapshot to archive");
            }
            File historyLog = new File(historyDir, "log");
            if (historyLog.exists()) {
                try {
                    this.archiveFile(historyLog, null);
                }
                catch (Exception ioe) {
                    this.log("Failed to archive history log file", ioe);
                }
            } else {
                this.log("History log does not exist");
            }
        } else {
            this.log("History directory does not exist");
        }
    }

    private void archiveExtensionSource() throws Exception {
        File extensionDir = new File(this.serverRoot, "extensions");
        if (extensionDir.exists()) {
            File extensionSourceDir = Files.createTempDirectory("extension-source", new FileAttribute[0]).toFile();
            extensionSourceDir.deleteOnExit();
            List<File> extensionDirs = CollectSupportData.getExtensionDirs(extensionDir);
            for (File dir : extensionDirs) {
                this.log("Extension directory found: " + dir.getAbsolutePath());
                File tmpExtensionDir = new File(extensionSourceDir, dir.getName());
                if (!tmpExtensionDir.exists()) {
                    tmpExtensionDir.mkdir();
                }
                JarFile extensionJar = CollectSupportData.getExtensionJar(dir);
                Enumeration<JarEntry> entries = extensionJar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    File entryFile = new File(tmpExtensionDir, entry.getName());
                    if (entry.isDirectory()) {
                        entryFile.mkdir();
                        continue;
                    }
                    if (!entry.getName().endsWith(".java")) continue;
                    InputStream is = null;
                    FileOutputStream fos = null;
                    try {
                        is = extensionJar.getInputStream(entry);
                        fos = new FileOutputStream(entryFile);
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.archiveDirectory(tmpExtensionDir, null, "server-root-files/extensions");
            }
        } else {
            this.log("Extensions directory does not exist");
        }
    }

    private void archiveRootFiles(File root, boolean includeDbs) {
        if (this.productType == ProductType.PINGFEDERATE) {
            this.archivePingFederateRootFiles(root);
        } else if (ProductType.isPingDirectoryProduct(this.productType)) {
            this.archivePingDirectoryRootFiles(root, includeDbs);
        } else if (this.productType == ProductType.PINGACCESS) {
            this.archivePingAccessRootFiles(root);
        }
    }

    private void archivePingDirectoryRootFiles(File root, boolean includeDbs) {
        File configDir = new File(root, "config");
        this.archiveDirectory(configDir, CollectSupportData.configDirFilterBuilder(configDir).build(this.securityLevel));
        File logsDir = new File(root, "logs");
        this.archiveDirectory(logsDir, CollectSupportData.logsDirFilterBuilder(logsDir, this.serverRoot, this.productType).build(this.securityLevel));
        File velocityDir = new File(root, "velocity");
        this.archiveDirectory(velocityDir, CollectSupportData.velocityDirFilterBuilder(velocityDir).build(this.securityLevel));
        File webappsDir = new File(root, "webapps");
        this.archiveDirectory(webappsDir, CollectSupportData.webappsDirFilterBuilder(webappsDir).build(this.securityLevel));
        for (File extLogDir : this.getExternalLogDirs()) {
            this.archiveDirectory(extLogDir, CollectSupportData.logsDirFilterBuilder(extLogDir, this.serverRoot, this.productType).build(this.securityLevel));
        }
        File configFile = new File(this.serverRootPath, "config" + File.separator + "config.ldif");
        if (includeDbs) {
            try {
                List<Entry> localDBBackends = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.LOCAL_DB_BACKEND, new String[0]);
                for (Entry entry : localDBBackends) {
                    String dbDirString = entry.getAttributeValue(LDIFUtils.DB_DIRECTORY);
                    if (dbDirString == null) {
                        dbDirString = "db";
                    }
                    File dbDir = StaticUtils.getFileFromString(dbDirString, this.serverRoot);
                    String backendId = entry.getAttributeValue(LDIFUtils.BACKEND_ID);
                    File dbFileDir = new File(dbDir, backendId);
                    this.archiveDirectory(dbFileDir, CollectSupportData.bdbDirFilterBuilder(dbFileDir).build(this.securityLevel));
                }
                List<Entry> changelogBackends = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.CHANGELOG_BACKEND, new String[0]);
                for (Entry backend : changelogBackends) {
                    String dbDirString = backend.getAttributeValue(LDIFUtils.DB_DIRECTORY);
                    if (dbDirString == null) {
                        dbDirString = "db";
                    }
                    File dbDir = StaticUtils.getFileFromString(dbDirString, this.serverRoot);
                    String backendId = backend.getAttributeValue(LDIFUtils.BACKEND_ID);
                    File dbFileDir = new File(dbDir, backendId);
                    this.archiveDirectory(dbFileDir, CollectSupportData.bdbDirFilterBuilder(dbFileDir).build(this.securityLevel));
                }
            }
            catch (Exception e) {
                this.log("Error attempting to determine backend directories", e);
            }
        }
        try {
            List<Entry> replicationSynchronizationProviders = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.REPLICATION_SYNCHRONIZATION_PROVIDER, new String[0]);
            for (Entry entry : replicationSynchronizationProviders) {
                List<Entry> replicationServers = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.REPLICATION_SERVER, "--baseDN", entry.getDN());
                for (Entry replicationServer : replicationServers) {
                    String dbDirString = replicationServer.getAttributeValue(LDIFUtils.REPLICATION_DB_DIRECTORY);
                    if (dbDirString == null) {
                        dbDirString = "changelogDb";
                    }
                    File dbDir = StaticUtils.getFileFromString(dbDirString, this.serverRoot);
                    this.archiveDirectory(dbDir, CollectSupportData.bdbDirFilterBuilder(dbDir).build(this.securityLevel));
                }
            }
        }
        catch (Exception e) {
            this.log("Error attempting to determine the replication server database directory", e);
        }
    }

    public static ArchiveFileFilterBuilder bdbDirFilterBuilder(File bdbDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, bdbDir, "je.config");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, bdbDir, "je.info.0");
        builder.includeRegexFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.HEAD_AND_TAIL, bdbDir, false, "je\\.stat(\\.\\d)?\\.csv");
        return builder;
    }

    private void archivePingFederateRootFiles(File root) {
        File binDir = new File(root, "bin");
        this.archiveDirectory(binDir, CollectSupportData.excludeJarsFilterBuilder(binDir, false, FileAction.INCLUDE_ALL).build(this.securityLevel));
        File logDir = new File(root, "log");
        FileAction logFileAction = FileAction.HEAD_AND_TAIL;
        if (this.isArgumentPresent("noTruncate")) {
            logFileAction = FileAction.INCLUDE_ALL;
        }
        this.archiveDirectory(logDir, CollectSupportData.genericDirFilterBuilder(logDir, false, logFileAction).build(this.securityLevel));
        File etcDir = new File(root, "etc");
        this.archiveDirectory(etcDir, CollectSupportData.genericDirFilterBuilder(etcDir, true, FileAction.INCLUDE_ALL).build(this.securityLevel));
        File confDir = new File(root, "server/default/conf");
        this.archiveDirectory(confDir, CollectSupportData.genericDirFilterBuilder(confDir, true, FileAction.INCLUDE_ALL).build(this.securityLevel));
        File dataDir = new File(root, "server/default/data");
        this.archiveDirectory(dataDir, CollectSupportData.pfServerDefaultDataFilterBuilder(dataDir).build(this.securityLevel));
        if (this.getOs() == OperatingSystem.WINDOWS) {
            File sbinDir = new File(root, "sbin/wrapper");
            this.archiveDirectory(sbinDir, CollectSupportData.sbinDirFilterBuilder(sbinDir).build(this.securityLevel));
        }
    }

    private void archivePingAccessRootFiles(File root) {
        File binDir = new File(root, "bin");
        this.archiveDirectory(binDir, CollectSupportData.excludeJarsFilterBuilder(binDir, false, FileAction.INCLUDE_ALL).build(this.securityLevel));
        File logDir = new File(root, "log");
        this.archiveDirectory(logDir, CollectSupportData.genericDirFilterBuilder(logDir, false, FileAction.HEAD_AND_TAIL).build(this.securityLevel));
        File confDir = new File(root, "conf");
        this.archiveDirectory(confDir, CollectSupportData.excludeFilterBuilder(confDir, FileAction.INCLUDE_ALL, Arrays.asList("pa.jwk", "static")).build(this.securityLevel));
        if (this.getOs() == OperatingSystem.WINDOWS) {
            File sbinWindowsDir = new File(root, "sbin/windows");
            this.archiveDirectory(sbinWindowsDir, CollectSupportData.sbinWindowsDirFilterBuilder(sbinWindowsDir).build(this.securityLevel));
        }
    }

    private void archiveDataCollectorOutput(File dir, boolean includeBinaryFiles) {
        if (dir.exists()) {
            ArchiveFileFilter filter = new ArchiveFileFilter(){

                @Override
                public FileAction action(File file) {
                    return FileAction.INCLUDE_ALL;
                }

                @Override
                public boolean accept(File file) {
                    return true;
                }
            };
            if (includeBinaryFiles) {
                this.includeBinaryOverride = true;
            }
            this.archiveDirectory(dir, filter);
            this.includeBinaryOverride = false;
        }
    }

    private void write(int b) throws Exception {
        this.desensitizedStream.write(b);
    }

    private void write(byte[] bytes) throws Exception {
        this.desensitizedStream.write(bytes);
    }

    private void write(byte[] bytes, int off, int len) throws Exception {
        this.desensitizedStream.write(bytes, off, len);
    }

    private void write(String str) throws Exception {
        CollectSupportData.write(this.desensitizedStream, str);
    }

    private void writeEOL() throws Exception {
        this.write(EOL);
    }

    private void writeComment(String comment) throws Exception {
        if (comment != null) {
            this.write(COMMENT_PREFIX);
            this.write(comment);
            this.write(EOL);
        }
    }

    private static String getHostName() {
        String hostName;
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            hostName = localAddr.getHostName();
        }
        catch (Exception e) {
            hostName = "unknown";
        }
        return hostName;
    }

    public String getArchiveName() {
        if (archiveName == null) {
            if (this.isArgumentPresent("outputPath")) {
                try {
                    File outputPath = new File(this.getStringArgumentValue("outputPath")).getAbsoluteFile();
                    if (!outputPath.exists() || outputPath.isFile()) {
                        String name = outputPath.getName();
                        int extensionPos = name.indexOf(46);
                        archiveName = extensionPos > 0 ? name.substring(0, extensionPos) : name;
                        return archiveName;
                    }
                }
                catch (Exception outputPath) {
                    // empty catch block
                }
            }
            String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            StringBuilder archiveNameSb = new StringBuilder("support-data-ping-");
            if (this.productVersion != null) {
                archiveNameSb.append(this.productVersion + "-");
            }
            archiveNameSb.append(CollectSupportData.getHostName()).append("-").append(timestamp);
            archiveName = archiveNameSb.toString();
        }
        return archiveName;
    }

    private void printAlarmDetails() {
        this.printlnToConsole();
    }

    private void printErrorLnToConsole() {
        this.printlnToConsole(QuickSetupMessages.INFO_PROGRESS_ERROR.get());
    }

    private void printToConsole(@Nullable Message entry) {
        if (entry != null) {
            this.printToConsole(entry.toString());
        }
    }

    private void printToConsole(@Nullable String entry) {
        if (entry != null) {
            this.getOut().print(entry);
        }
    }

    private void printlnToConsole() {
        this.out(new Object[0]);
    }

    private void printlnToConsole(Message entry) {
        if (entry != null) {
            this.out(new Object[]{TextUtils.wrapText((String)entry.toString())});
        }
    }

    private void printlnToConsole(String entry) {
        if (entry != null) {
            this.out(new Object[]{TextUtils.wrapText((String)entry)});
        }
    }

    public synchronized void log(String entry, Throwable t) {
        this.log(logOutputStream, entry, t);
    }

    public void log(String entry) {
        this.log(logOutputStream, entry);
    }

    private void log(OutputStream out, String message, Throwable t) {
        if (out != null) {
            this.log(out, "Error: " + message);
            PrintStream logPrintStream = new PrintStream(out);
            t.printStackTrace(logPrintStream);
            logPrintStream.flush();
        }
    }

    private synchronized void log(OutputStream out, String message) {
        if (out != null && message != null) {
            StringBuilder record = new StringBuilder(DATE_FORMAT.format(new Date())).append(": ").append(message);
            try {
                CollectSupportData.write(out, record.toString());
                CollectSupportData.write(out, EOL);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static synchronized void logArchiveMessage(String message) {
        if (logOutputStream != null && message != null) {
            StringBuilder record = new StringBuilder(DATE_FORMAT.format(new Date())).append(": ").append(message);
            try {
                CollectSupportData.write(logOutputStream, record.toString());
                CollectSupportData.write(logOutputStream, EOL);
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void addSummaryMessage(Message message) {
        if (message != null) {
            for (Message m : this.summaryMessages) {
                if (!m.equals((Object)message)) continue;
                return;
            }
            this.summaryMessages.add(message);
        }
    }

    public Set<File> getExternalServerDirs() throws Exception {
        if (this.externalServerDirs != null) {
            return this.externalServerDirs;
        }
        HashSet<File> extDirsToList = new HashSet<File>();
        if (!ProductType.isPingDirectoryProduct(this.productType)) {
            return extDirsToList;
        }
        File configFile = new File(this.serverRoot, "config" + File.separator + "config.ldif");
        List<Entry> backends = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.BACKEND, new String[0]);
        for (Entry backend : backends) {
            File dbDir;
            String dbDirString;
            if (backend.hasObjectClass(LDIFUtils.LOCAL_DB_BACKEND)) {
                dbDirString = backend.getAttributeValue(LDIFUtils.DB_DIRECTORY);
                if (dbDirString == null) {
                    dbDirString = "db";
                }
                if (!this.isServerRootFile(dbDir = StaticUtils.getFileFromString(dbDirString, this.serverRoot))) {
                    extDirsToList.add(dbDir);
                }
            }
            if (!backend.hasObjectClass(LDIFUtils.CHANGELOG_BACKEND)) continue;
            dbDirString = backend.getAttributeValue(LDIFUtils.DB_DIRECTORY);
            if (dbDirString == null) {
                dbDirString = "db";
            }
            if (this.isServerRootFile(dbDir = StaticUtils.getFileFromString(dbDirString, this.serverRoot))) continue;
            extDirsToList.add(dbDir);
        }
        List<Entry> replicationSynchronizationProviders = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.REPLICATION_SYNCHRONIZATION_PROVIDER, new String[0]);
        for (Entry provider : replicationSynchronizationProviders) {
            List<Entry> replicationServers = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.REPLICATION_SERVER, "--baseDN", provider.getDN());
            for (Entry replicationServer : replicationServers) {
                File dbDir;
                String dbDirString = replicationServer.getAttributeValue(LDIFUtils.REPLICATION_DB_DIRECTORY);
                if (dbDirString == null) {
                    dbDirString = "changelogDb";
                }
                if (this.isServerRootFile(dbDir = StaticUtils.getFileFromString(dbDirString, this.serverRoot))) continue;
                extDirsToList.add(dbDir);
            }
        }
        extDirsToList.addAll(this.getExternalLogDirs());
        this.externalServerDirs = extDirsToList;
        return extDirsToList;
    }

    private Set<File> getExternalLogDirs() {
        if (this.externalLogDirs != null) {
            return this.externalLogDirs;
        }
        LinkedHashSet<File> extLogFiles = new LinkedHashSet<File>();
        File configFile = new File(this.serverRoot, "config" + File.separator + "config.ldif");
        try {
            List<Entry> logPublishers = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.LOG_PUBLISHER, new String[0]);
            for (Entry logPublisher : logPublishers) {
                File logFile;
                String logFileString = logPublisher.getAttributeValue(LDIFUtils.LOG_FILE);
                if (logFileString == null || this.isServerRootFile(logFile = StaticUtils.getFileFromString(logFileString, this.serverRoot))) continue;
                extLogFiles.add(logFile);
            }
        }
        catch (Exception e) {
            this.log("Error getting external log directories", e);
        }
        LinkedHashSet<File> extLogDirs = new LinkedHashSet<File>();
        for (File extLogFile : extLogFiles) {
            File parent = extLogFile.getParentFile();
            if (parent == null) continue;
            extLogDirs.add(parent);
        }
        this.externalLogDirs = extLogDirs;
        return extLogDirs;
    }

    private void archiveFile(File file, ArchiveFileFilter filter) throws Exception {
        if (file != null) {
            String rootPath = file.getCanonicalPath().replace(this.serverRoot.getCanonicalPath(), "");
            if ((rootPath = rootPath.replaceAll("\\\\", ZIP_SEPARATOR)).startsWith(ZIP_SEPARATOR)) {
                rootPath = rootPath.substring(1);
            }
            if (this.skipBinaryFile(file)) {
                return;
            }
            this.printToConsole("Archiving " + rootPath + " ..... ");
            String serverRootParentPath = rootPath.substring(0, rootPath.length() - file.getName().length());
            StringBuilder zipRootName = new StringBuilder(this.getArchiveName()).append(ZIP_SEPARATOR);
            if (this.isServerRootFile(file)) {
                zipRootName.append(ZIP_SERVER_ROOT_FILES_ROOT_NAME);
            } else {
                zipRootName.append(ZIP_EXTERNAL_FILES_ROOT_NAME);
            }
            zipRootName.append(ZIP_SEPARATOR).append(serverRootParentPath);
            try {
                this.archive(zipRootName.toString(), file, filter, 0);
                this.printlnToConsole(QuickSetupMessages.INFO_PROGRESS_DONE.get());
            }
            catch (Exception ioe) {
                this.log("Error archiving " + file, ioe);
                this.printErrorLnToConsole();
            }
        }
    }

    private boolean isServerRootFile(File file) {
        boolean isServerRootFile = file.equals(this.serverRoot) || FileUtils.isDescendant((File)file, (File)this.serverRoot);
        return isServerRootFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean skipBinaryFile(File file) {
        if (file.getName().endsWith(".gz")) {
            FileInputStream fis = null;
            GZIPInputStream gzis = null;
            try {
                fis = new FileInputStream(file);
                gzis = new GZIPInputStream(fis);
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                if (gzis != null) {
                    try {
                        gzis.close();
                    }
                    catch (Exception exception) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return true;
        }
        boolean returnValue = false;
        if (!this.isArgumentPresent("includeBinaryFiles")) {
            try {
                if (this.isBinary(file, 2048) && !this.includeBinaryOverride) {
                    this.log("Skipping binary file " + file);
                    returnValue = true;
                }
            }
            catch (Exception ioe) {
                this.log("Exception while inspecting for binary data: " + file, ioe);
            }
        }
        return returnValue;
    }

    private void archiveDirectory(File root, ArchiveFileFilter filter) {
        this.archiveDirectory(root, filter, this.getRootNameFromRootFile(root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveDirectory(File root, ArchiveFileFilter filter, String rootName) {
        if (root != null) {
            String statusPath = this.isServerRootFile(root) ? this.getPathFromServerRoot(root) : root.getPath();
            statusPath = statusPath.replaceAll("\\\\", ZIP_SEPARATOR);
            this.printToConsole("Archiving " + statusPath + " ..... ");
            try {
                if (filter == null) {
                    filter = new ArchiveFileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return true;
                        }

                        @Override
                        public FileAction action(File file) {
                            return FileAction.INCLUDE_ALL;
                        }
                    };
                }
                this.archive(rootName, root, filter, 0);
                this.printlnToConsole(QuickSetupMessages.INFO_PROGRESS_DONE.get());
            }
            catch (Exception e) {
                this.log("Error archiving " + root, e);
                this.printErrorLnToConsole();
            }
            finally {
                this.closeZipEntry();
            }
        }
    }

    private String getRootNameFromRootFile(File root) {
        StringBuilder rootName;
        StringBuilder targetZipDirectory = new StringBuilder();
        if (root != null) {
            if (this.isServerRootFile(root)) {
                targetZipDirectory.append(ZIP_SERVER_ROOT_FILES_ROOT_NAME);
                targetZipDirectory.append(ZIP_SEPARATOR);
                String serverRootPath = this.getPathFromServerRoot(root);
                serverRootPath = serverRootPath.replaceAll("\\\\", ZIP_SEPARATOR);
                if (serverRootPath != null && serverRootPath.length() > 0 && serverRootPath.endsWith(root.getName())) {
                    serverRootPath = serverRootPath.substring(0, serverRootPath.length() - root.getName().length());
                    targetZipDirectory.append(serverRootPath);
                }
            } else {
                targetZipDirectory.append(ZIP_EXTERNAL_FILES_ROOT_NAME);
                targetZipDirectory.append(ZIP_SEPARATOR);
                String parentPath = "";
                File parent = root.getParentFile();
                if (parent != null) {
                    parentPath = parent.getPath();
                    if (parentPath.startsWith(File.separator)) {
                        parentPath = parentPath.substring(File.separator.length());
                    }
                    if (!parentPath.endsWith(File.separator)) {
                        parentPath = parentPath + File.separator;
                    }
                    parentPath = parentPath.replaceAll("\\\\", ZIP_SEPARATOR);
                }
                targetZipDirectory.append(parentPath);
            }
        }
        if (!(rootName = new StringBuilder(this.getArchiveName()).append(ZIP_SEPARATOR).append(targetZipDirectory.toString())).toString().endsWith(ZIP_SEPARATOR)) {
            rootName.append(ZIP_SEPARATOR);
        }
        return rootName.toString();
    }

    private void closeZipEntry() {
        this.fullyFlushOutput();
        try {
            this.rawZipOutputStream.closeEntry();
        }
        catch (Exception ioe) {
            this.log("Error closing zip entry", ioe);
        }
    }

    private void fullyFlushOutput() {
        try {
            this.desensitizedStream.flushAll();
        }
        catch (Exception ioe) {
            this.log("Error fully flushing output stream", ioe);
        }
    }

    private String putNextEntry(String entryName) throws Exception {
        if (entryName.endsWith(".gz")) {
            entryName = entryName.replaceFirst("\\.gz$", "");
        }
        String uniqueEntryName = entryName;
        int i = 1;
        while (this.zipEntryNames.contains(uniqueEntryName)) {
            uniqueEntryName = entryName + "-" + ++i;
        }
        this.fullyFlushOutput();
        this.rawZipOutputStream.putNextEntry(new ZipEntry(uniqueEntryName));
        this.zipEntryNames.add(uniqueEntryName);
        return uniqueEntryName;
    }

    private String getPathFromServerRoot(File f) {
        String path = null;
        if (f != null) {
            if (this.serverRoot != null) {
                try {
                    String serverRootCanonical = this.serverRoot.getCanonicalPath();
                    String fileCanonical = f.getCanonicalPath();
                    if (fileCanonical.startsWith(serverRootCanonical) && serverRootCanonical.length() < fileCanonical.length()) {
                        path = fileCanonical.substring(serverRootCanonical.length() + 1);
                    }
                }
                catch (Exception e) {
                    this.log("Error creating path string", e);
                }
            }
            if (path == null) {
                path = f.getName();
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archive(String rootPath, File file, ArchiveFileFilter filter, int depth) throws Exception {
        if (depth > 8) {
            this.log("Maximum file list archive depth reached");
            return;
        }
        ++depth;
        if (!file.exists()) {
            this.log("Error archiving " + file + ".  File does not exist");
            return;
        }
        if (file.getName().startsWith("support-data-")) {
            this.log("Ignoring " + file);
            return;
        }
        if (filter == null || filter.accept(file)) {
            String fileName = file.getName();
            if (file.isDirectory() && !fileName.endsWith(File.separator)) {
                fileName = fileName + File.separator;
            }
            try {
                String zipEntryName = rootPath + fileName.replaceAll("\\\\", ZIP_SEPARATOR);
                if (file.isDirectory()) {
                    if (!this.zipEntryNames.contains(zipEntryName)) {
                        this.putNextEntry(zipEntryName);
                        File[] children = file.listFiles();
                        if (children != null) {
                            List<File> filteredChildren = this.filterOldLogs(Arrays.asList(children));
                            for (File child : filteredChildren) {
                                this.archive(zipEntryName, child, filter, depth);
                            }
                        }
                    } else {
                        this.log("Already added directory " + file);
                    }
                } else if (!this.skipBinaryFile(file)) {
                    this.putNextEntry(zipEntryName);
                    this.writeFile(file, filter);
                }
            }
            catch (Exception e) {
                this.log("Error archiving " + file, e);
            }
            finally {
                this.closeZipEntry();
            }
        }
    }

    private List<File> filterOldLogs(List<File> files) throws ArgumentException {
        List logFiles = files.stream().filter(f -> f.getName().contains(".log")).collect(Collectors.toList());
        List<File> filteredFiles = files.stream().filter(f -> !f.getName().contains(".log")).collect(Collectors.toList());
        HashMap<String, File> recentLogs = new HashMap<String, File>();
        for (File log : logFiles) {
            String logName = log.getName();
            if ((logName = logName.replaceAll("\\d{4}[-_]\\d{2}[-_]\\d{2}\\.", "")).startsWith(SERVER_LOG_NAME_WITH_EXT) && this.isArgumentPresent("rolledLogCount")) {
                logName = this.handleServerLogRoll(logName);
            } else if (!logName.startsWith("dsreplication")) {
                logName = logName.replaceAll("\\.[0-9]+", "");
                logName = logName.replaceAll("[0-9]", "");
            }
            if (recentLogs.containsKey(logName)) {
                if (((File)recentLogs.get(logName)).lastModified() >= log.lastModified()) continue;
                recentLogs.put(logName, log);
                continue;
            }
            recentLogs.put(logName, log);
        }
        filteredFiles.addAll(recentLogs.values());
        return filteredFiles;
    }

    private String handleServerLogRoll(String logName) throws ArgumentException {
        String rolledIndexStr;
        if (SERVER_LOG_NAME_WITH_EXT.equals(logName)) {
            return logName;
        }
        Integer inputRolledLogCount = this.getIntegerArgumentValue("rolledLogCount");
        if (inputRolledLogCount <= 0 || inputRolledLogCount > 99) {
            this.log("rolledLogCount value of inputRolledLogCount " + inputRolledLogCount + " should be greater than 0 and less than 100. Collecting all server logs.");
            return logName;
        }
        Integer n = inputRolledLogCount;
        Integer n2 = inputRolledLogCount = Integer.valueOf(inputRolledLogCount + 1);
        if (logName.length() > SERVER_LOG_NAME_WITH_EXT.length() + 1 && (rolledIndexStr = logName.substring("server.log.".length())) != null && !rolledIndexStr.isEmpty()) {
            try {
                int rolledIndex = Integer.parseInt(rolledIndexStr);
                if (rolledIndex >= inputRolledLogCount) {
                    logName = SERVER_LOG_NAME_WITH_EXT;
                }
            }
            catch (NumberFormatException nfe) {
                logName = SERVER_LOG_NAME_WITH_EXT;
            }
        }
        return logName;
    }

    private void writeFile(File file, ArchiveFileFilter filter) throws Exception {
        if (filter != null) {
            switch (filter.action(file)) {
                case INCLUDE_ALL: {
                    this.writeEntireFile(file);
                    break;
                }
                case HEAD_AND_TAIL: {
                    Long tailSize = SPECIAL_TAIL_SIZE.get(file.getName());
                    if (tailSize == null) {
                        tailSize = this.getTailSizeInBytes();
                    } else if (DYNAMIC_SPECIAL_FILES.contains(file.getName())) {
                        tailSize = Math.max(tailSize, this.getTailSizeInBytes());
                    }
                    Long headSize = SPECIAL_HEAD_SIZE.get(file.getName());
                    if (headSize == null) {
                        headSize = this.getHeadSizeInBytes();
                    } else if (DYNAMIC_SPECIAL_FILES.contains(file.getName())) {
                        headSize = Math.max(headSize, this.getHeadSizeInBytes());
                    }
                    if (file.length() < headSize + tailSize) {
                        this.writeEntireFile(file);
                        break;
                    }
                    this.writeHeadAndTailOfFile(file, headSize, tailSize);
                    break;
                }
            }
        } else {
            this.writeEntireFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntireFile(File file) throws Exception {
        if (this.skipBinaryFile(file)) {
            return;
        }
        InputStream is = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        boolean isLDIF = false;
        String fileName = file.getName();
        if ((fileName.contains(".ldif") || fileName.startsWith("config-") && fileName.endsWith(".gz")) && !file.getParentFile().getName().equals("schema")) {
            isLDIF = true;
        }
        try {
            int BUFFER = 2048;
            byte[] dataArray = new byte[BUFFER];
            if (isLDIF) {
                LDIFUtils.unwrapLDIF(is, this.desensitizedStream);
            } else {
                int count;
                while (-1 != (count = is.read(dataArray, 0, BUFFER))) {
                    this.write(dataArray, 0, count);
                }
            }
        }
        finally {
            this.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeadAndTailOfFile(File file, long headSizeBytes, long tailSizeBytes) throws Exception {
        if (this.skipBinaryFile(file)) {
            return;
        }
        try (RandomAccessFile raf = null;){
            int bytesRead;
            raf = new RandomAccessFile(file, "r");
            this.writeComment("");
            this.writeComment("This file has been truncated in the middle in order to save space in this archive");
            this.writeComment("");
            this.writeComment("Search for 'Start tail' to go to the top of the file's tail.");
            this.writeComment("");
            this.writeComment("Start head " + headSizeBytes + " bytes of " + file.getName());
            this.writeEOL();
            long pos = 0L;
            raf.seek(pos);
            int i = 0;
            while ((long)i < headSizeBytes) {
                this.write(raf.readByte());
                ++i;
            }
            this.writeEOL();
            this.writeEOL();
            this.writeComment("");
            this.writeComment("Start tail " + tailSizeBytes + " bytes of " + file.getName());
            this.writeComment("");
            this.writeEOL();
            long fileLength = raf.length();
            pos = Math.max(fileLength - tailSizeBytes, 0L);
            raf.seek(pos);
            raf.readLine();
            int BUFFER_SIZE = 3000;
            byte[] dataArray = new byte[3000];
            int totalBytesRead = 0;
            while (-1 != (bytesRead = raf.read(dataArray, 0, 3000))) {
                if ((long)(totalBytesRead += bytesRead) > tailSizeBytes) {
                    int bytesToWrite = (int)((long)bytesRead - ((long)totalBytesRead - tailSizeBytes));
                    this.write(dataArray, 0, bytesToWrite);
                    this.writeEOL();
                    this.writeComment("");
                    this.writeComment("This file was updated during archival.  Characters added after archive start were not recorded.");
                    break;
                }
                this.write(dataArray, 0, bytesRead);
            }
        }
    }

    public long getMaximumCommandDurationMS() {
        return Math.max((long)(1.5 * (double)this.reportCount * (double)this.reportIntervalSeconds * 1000.0), 300000L);
    }

    public static void write(OutputStream out, String s) throws Exception {
        out.write(CollectSupportData.getBytes(s));
        out.flush();
    }

    public static String getCommandString(ProcessBuilder ... builders) {
        StringBuilder commandSb = new StringBuilder();
        if (builders != null) {
            for (int i = 0; i < builders.length; ++i) {
                commandSb.append(CollectSupportData.getCommandString(builders[i]));
                if (i >= builders.length - 1) continue;
                commandSb.append("; ");
            }
        }
        return commandSb.toString();
    }

    public static String getCommandString(ProcessBuilder builder) {
        List<String> commandList = builder.command();
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = commandList.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static byte[] getBytes(String str) {
        return str.getBytes(Charset.forName("UTF-8"));
    }

    private static List<File> getHistoryToArchive(File historyDir) {
        String setupFileRegex;
        Pattern setupFilePattern;
        FilenameFilter setupFileFilter;
        File[] setupFiles;
        ArrayList<File> updateBackups = new ArrayList<File>();
        if (!"history".equals(historyDir.getName()) || !historyDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid history directory");
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !"log".equals(name) && !"README".equals(name);
            }
        };
        String[] childNames = historyDir.list(filter);
        if (childNames != null && childNames.length > 0) {
            List<String> childNamesList = Arrays.asList(childNames);
            Collections.sort(childNamesList);
            Collections.reverse(childNamesList);
            for (String childName : childNames) {
                File b = new File(historyDir, childName);
                if (!b.isDirectory()) continue;
                updateBackups.add(b);
                if (new File(b, "files").exists()) break;
            }
        }
        if ((setupFiles = historyDir.listFiles(setupFileFilter = new FilenameFilter(setupFilePattern = Pattern.compile(setupFileRegex = "setup-\\d+\\.\\d+Z\\.log\\.gz")){
            final /* synthetic */ Pattern val$setupFilePattern;
            {
                this.val$setupFilePattern = pattern;
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.val$setupFilePattern.matcher(name).matches();
            }
        })) != null) {
            updateBackups.addAll(Arrays.asList(setupFiles));
        }
        return updateBackups;
    }

    private static List<File> getExtensionDirs(File extensionDir) throws Exception {
        ArrayList<File> extensionDirs = new ArrayList<File>();
        if (!"extensions".equals(extensionDir.getName()) || !extensionDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid extensions directory");
        }
        for (File childDir : extensionDir.listFiles()) {
            if (!childDir.isDirectory()) continue;
            extensionDirs.add(childDir);
        }
        return extensionDirs;
    }

    private static JarFile getExtensionJar(File extensionDir) throws Exception {
        if (extensionDir == null) {
            return null;
        }
        for (String childName : extensionDir.list()) {
            if (!childName.endsWith(".jar")) continue;
            return new JarFile(new File(extensionDir, childName));
        }
        return null;
    }

    private void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private List<ObjectPair<Pattern, String>> getDesensitizingReplacements() {
        String replacement = "---REDACTED---";
        if (this.securityLevel == SecurityLevel.NONE) {
            return DesensitizingOutputStream.buildReplacements("---REDACTED---", false, false, false, false);
        }
        if (this.securityLevel == SecurityLevel.OBSCURE_SECRETS) {
            return DesensitizingOutputStream.buildReplacements("---REDACTED---", true, true, true, false);
        }
        if (this.securityLevel == SecurityLevel.MAXIMUM) {
            return DesensitizingOutputStream.buildReplacements("---REDACTED---", true, true, true, true);
        }
        throw new IllegalStateException("Unrecognized level: " + (Object)((Object)this.securityLevel));
    }

    public String getToolDescription() {
        return internalToolDescription;
    }

    public static ConfigurationUtil registerArguments(String configFilePath) {
        YamlConfigurationUtil config = new YamlConfigurationUtil();
        try {
            config.load(configFilePath);
            ConfigFileArgumentFactory argumentFactory = new ConfigFileArgumentFactory();
            for (ArgumentConfiguration argConfig : config.getArgumentConfigurations()) {
                Argument arg = argumentFactory.createInstance(argConfig);
                config.registerArgument(argConfig.getId(), arg);
            }
            config.setCommandlineArguments(config.getArguments());
            StringArgument additionalPidsArg = new StringArgument(null, "pid", false, 0, UBIDToolMessages.INFO_SUPP_DATA_ARG_PLACEHOLDER_ADDITIONAL_PIDS.get().toString(), UBIDToolMessages.INFO_SUPP_DATA_ARG_DESC_ADDITIONAL_PIDS.get().toString());
            config.registerArgument("pid", (Argument)additionalPidsArg);
            BooleanArgument sequentialExecutionArg = new BooleanArgument(null, "sequential", UBIDToolMessages.INFO_SUPP_DATA_ARG_DESC_SEQUENTIAL.get().toString());
            config.registerArgument("sequential", (Argument)sequentialExecutionArg);
            IntegerArgument samplingCommandCountArg = new IntegerArgument(null, "reportCount", false, 1, UBIDToolMessages.INFO_SUPP_DATA_ARG_COUNT_PLACEHOLDER.get().toString(), UBIDToolMessages.INFO_SUPP_DATA_ARG_COUNT_DESC.get().toString());
            config.registerArgument("reportCount", (Argument)samplingCommandCountArg);
            IntegerArgument samplingCommandIntervalArg = new IntegerArgument(null, "reportInterval", false, 1, UBIDToolMessages.INFO_SUPP_DATA_ARG_INTERVAL_PLACEHOLDER.get().toString(), UBIDToolMessages.INFO_SUPP_DATA_ARG_INTERVAL_DESC.get().toString());
            config.registerArgument("reportInterval", (Argument)samplingCommandIntervalArg);
            IntegerArgument jstackCommandCountArg = new IntegerArgument(null, "maxJstacks", false, 1, UBIDToolMessages.INFO_SUPP_DATA_ARG_MAXJSTACKS_PLACEHOLDER.get().toString(), UBIDToolMessages.INFO_SUPP_DATA_ARG_MAXJSTACKS_DESC.get().toString());
            config.registerArgument("maxJstacks", (Argument)jstackCommandCountArg);
            BooleanArgument collectExpensiveDataArg = new BooleanArgument(null, "collectExpensiveData", UBIDToolMessages.INFO_SUPP_DATA_ARG_DESC_EXPENSIVE.get().toString());
            config.registerArgument("collectExpensiveData", (Argument)collectExpensiveDataArg);
            StringArgument commentArg = new StringArgument(null, "comment", false, 1, UBIDToolMessages.INFO_SUPP_DATA_ARG_COMMENT_PLACEHOLDER.get().toString(), UBIDToolMessages.INFO_SUPP_DATA_ARG_COMMENT_DESC.get().toString());
            config.registerArgument("comment", (Argument)commentArg);
            BooleanArgument encryptArg = new BooleanArgument(null, "encrypt", UBIDTool2Messages.INFO_SUPP_DATA_ARG_DESC_ENCRYPT.get((Object)"passphraseFile", (Object)"csd").toString());
            config.registerArgument("encrypt", (Argument)encryptArg);
            StringArgument passphraseFileArg = new StringArgument(null, "passphraseFile", false, 1, ToolMessages.INFO_PATH_PLACEHOLDER.get().toString(), UBIDTool2Messages.INFO_SUPP_DATA_ARG_DESC_PASSPHRASE_FILE.get((Object)"encrypt", (Object)"decrypt").toString());
            config.registerArgument("passphraseFile", (Argument)passphraseFileArg);
            BooleanArgument generatePassphraseArg = new BooleanArgument(null, "generatePassphrase", UBIDTool2Messages.INFO_SUPP_DATA_ARG_DESC_GENERATE_PASSPHRASE.get((Object)"passphraseFile", (Object)"encrypt", (Object)"passphraseFile").toString());
            config.registerArgument("generatePassphrase", (Argument)generatePassphraseArg);
            StringArgument decryptArg = new StringArgument(null, "decrypt", false, 1, ToolMessages.INFO_PATH_PLACEHOLDER.get().toString(), UBIDTool2Messages.INFO_SUPP_DATA_ARG_DESC_DECRYPT.get((Object)"csd", (Object)"passphraseFile").toString());
            config.registerArgument("decrypt", (Argument)decryptArg);
            StringArgument timeRangeArg = new StringArgument(null, "timeRange", false, 1, UBIDTool2Messages.INFO_CSD_TIMERANGE_ARG_STRUCTURE.get().toString(), UBIDTool2Messages.INFO_CSD_TIMERANGE_ARG_DESCRIPTION.get().toString());
            config.registerArgument("timeRange", (Argument)timeRangeArg);
            IntegerArgument fileHeadCollectionKBSizeArg = new IntegerArgument(null, "fileHeadCollectionKBSize", "The amount of data in kilobytes to collect at the beginning of truncated files");
            config.registerArgument("fileHeadCollectionKBSize", (Argument)fileHeadCollectionKBSizeArg);
            IntegerArgument fileTailCollectionKBSizeArg = new IntegerArgument(null, "fileTailCollectionKBSize", "The amount of data in kilobytes to collect at the end of truncated files");
            config.registerArgument("fileTailCollectionKBSize", (Argument)fileTailCollectionKBSizeArg);
            BooleanArgument noJdkTools = new BooleanArgument(null, "noJDKTools", 1, "If set, the output of jdk tool commands like jstack, jstat, jinfoand jmap will not be collected");
            config.registerArgument("noJDKTools", (Argument)noJdkTools);
            StringArgument outputPathArg = new StringArgument(null, "outputPath", false, 1, UBIDTool2Messages.INFO_CSD_OUTPUT_PATH_ARG_STRUCTURE.get().toString(), UBIDTool2Messages.INFO_CSD_OUTPUT_PATH_ARG_DESCRIPTION.get().toString());
            config.registerArgument("outputPath", (Argument)outputPathArg);
            BooleanArgument includeBinaryFiles = new BooleanArgument(null, "includeBinaryFiles", 1, UBIDToolMessages.INFO_SUPP_DATA_ARG_DESC_INCLUDE_BINARY_FILES.get().toString());
            config.registerArgument("includeBinaryFiles", (Argument)includeBinaryFiles);
            StringArgument passphraseArg = new StringArgument(null, "encryptionPassphrase", false, 1, UBIDTool2Messages.INFO_CSD_ARG_ENC_PASSPHRASE_PLACEHOLDER.get().toString(), UBIDTool2Messages.INFO_CSD_ARG_DESC_ENC_PASSPHRASE.get().toString());
            config.registerArgument("encryptionPassphrase", (Argument)passphraseArg);
            DurationArgument durationArg = new DurationArgument(null, "duration", UBIDTool2Messages.INFO_CSD_DURATION_ARG_DESCRIPTION.get().toString());
            config.registerArgument("duration", (Argument)durationArg);
            IntegerArgument logfileCount = new IntegerArgument(null, "rolledLogCount", UBIDTool2Messages.INFO_ROLLED_LOG_FILE_COUNT.get().toString());
            config.registerArgument("rolledLogCount", (Argument)logfileCount);
            BooleanArgument unTruncateLogFiles = new BooleanArgument(null, "noTruncate", UBIDTool2Messages.INFO_NO_TRUNCATE_LOG_FILE.get().toString());
            config.registerArgument("noTruncate", (Argument)unTruncateLogFiles);
        }
        catch (ArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.argParser = parser;
        for (Argument arg : this.configUtil.getArguments()) {
            parser.addArgument(arg);
        }
    }

    public String getToolName() {
        return internalToolName;
    }

    public String getServerRoot() {
        if (this.serverRootArg.isPresent()) {
            return this.serverRootArg.getValue();
        }
        return System.getenv(ENV_VAR_INSTANCE_ROOT);
    }

    private String getName() {
        return this.getToolName();
    }

    private String getProductVersionString(ProductType product) {
        switch (product) {
            case PINGACCESS: {
                break;
            }
            case PINGDIRECTORY: {
                return this.getVersionFromFile("Unknown PingDirectory version", relativePingDirectoryJarFilePath, "MANIFEST.MF", "META-INF/", "Implementation-Version", ProductType.PINGDIRECTORY);
            }
            case PINGDIRECTORYPROXY: {
                return this.getVersionFromFile("Unknown PingDirectoryProxy version", relativePingDirectoryProxyJarFilePath, "MANIFEST.MF", "META-INF/", "Implementation-Version", ProductType.PINGDIRECTORYPROXY);
            }
            case PINGDATAGOVERNANCE: {
                return this.getVersionFromFile("Unknown PingDataGovernance version", relativePingDataGovernanceJarFilePath, "MANIFEST.MF", "META-INF/", "Implementation-Version", ProductType.PINGDATAGOVERNANCE);
            }
            case PINGAUTHORIZE: {
                return this.getVersionFromFile("Unknown PingAuthorize version", relativePingAuthorizeJarFilePath, "MANIFEST.MF", "META-INF/", "Implementation-Version", ProductType.PINGAUTHORIZE);
            }
            case PINGDATAMETRICS: {
                return this.getVersionFromFile("Unknown PingDataMetrics version", relativePingDataMetricsJarFilePath, "MANIFEST.MF", "META-INF/", "Implementation-Version", ProductType.PINGDATAMETRICS);
            }
            case PINGDATASYNC: {
                return this.getVersionFromFile("Unknown PingDataSync version", relativePingDataSyncJarFilePath, "MANIFEST.MF", "META-INF/", "Implementation-Version", ProductType.PINGDATASYNC);
            }
            case PINGFEDERATE: {
                return this.getPingFederateVersion(relativePingFederateStartupJarFilePath, "Unknown PingFederate version");
            }
        }
        return "";
    }

    private String getPingFederateVersion(String targetJarPath, String defaultVersion) {
        String pfVersion = defaultVersion;
        File targetJarFile = new File(this.serverRootPath, targetJarPath);
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(targetJarFile);
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            Manifest jarManifest = jarInputStream.getManifest();
            Attributes attrs = jarManifest.getMainAttributes();
            pfVersion = attrs.getValue("Implementation-Version");
        }
        catch (IOException e) {
            this.log("Unable to retrieve PingFederate version: " + this.serverRootPath, e);
        }
        return pfVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersionFromFile(String defaultVersion, String targetJarPath, String targetFileName, String targetFileDirectory, String propertyName, ProductType product) {
        String version = defaultVersion;
        File tempDir = null;
        FileInputStream targetPropertiesFIS = null;
        try {
            tempDir = StaticUtils.createTempDir();
            File targetJarFile = new File(this.serverRootPath, targetJarPath);
            StaticUtils.unzipEntry(tempDir.getAbsolutePath(), new JarFile(targetJarFile), targetFileName, targetFileDirectory);
            File targetFile = new File(tempDir, targetFileName);
            targetPropertiesFIS = new FileInputStream(targetFile);
            Properties properties = new Properties();
            properties.load(targetPropertiesFIS);
            version = properties.getProperty(propertyName);
        }
        catch (IOException | NullPointerException e) {
            this.log("Unable to retrieve " + product.toString() + " version: " + this.serverRootPath, e);
        }
        finally {
            if (tempDir != null && tempDir.exists()) {
                tempDir.delete();
            }
            if (targetPropertiesFIS != null) {
                try {
                    targetPropertiesFIS.close();
                }
                catch (IOException e) {
                    System.err.println("Unable to retrieve " + product.toString() + " version: " + this.serverRootPath);
                }
            }
        }
        return version;
    }

    private Object gotVCSVersionString() {
        return null;
    }

    private boolean isValueSetByProperty(Argument argument) {
        return false;
    }

    private boolean isBinary(File file, int defaultBinaryScanSize) throws IOException {
        return StaticUtils.containsNonUTF8Data(file, defaultBinaryScanSize);
    }

    public Integer getServerPID(File serverRoot2) {
        return productPID;
    }

    private boolean isCurrentUserAdmin() {
        return System.getProperty("user.name").equals("root");
    }

    public boolean isWithinUnitTest() {
        return false;
    }

    public boolean isWithinUnitTestExternalInstance() {
        return false;
    }

    public static ArchiveFileFilterBuilder libDirFilterBuilder(File libDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, libDir, "set-java-home", "_script-util.bat", "_script-util.sh");
        return builder;
    }

    public static ArchiveFileFilterBuilder genericDirFilterBuilder(File dir, boolean includeDirectories, FileAction fileAction) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        if (includeDirectories) {
            builder.includeAllFilesAndDirectories(SecurityLevel.MAXIMUM, fileAction, dir);
        } else {
            builder.includeAllFiles(SecurityLevel.MAXIMUM, fileAction, dir);
        }
        return builder;
    }

    public static ArchiveFileFilterBuilder excludeFilterBuilder(File dir, FileAction fileAction, List<String> exclusionPatterns) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeAllFilesAndDirectoriesExceptExcludedPatterns(SecurityLevel.MAXIMUM, fileAction, dir, exclusionPatterns);
        return builder;
    }

    public static ArchiveFileFilterBuilder excludeJarsFilterBuilder(File dir, boolean includeDirectories, FileAction fileAction) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeAllFilesAndDirectoriesExceptExcludedPatterns(SecurityLevel.MAXIMUM, fileAction, dir, Collections.singletonList(".jar"));
        return builder;
    }

    public static ArchiveFileFilterBuilder pfServerDefaultDataFilterBuilder(File serverDefaultDataDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, serverDefaultDataDir, false, ".*\\.xml");
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "adapter-config"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "bearer-access-token-management-plugins"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "config-store"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "connection-mapping-contracts"));
        builder.includeAllFilesAndDirectories(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "connections"));
        builder.includeAllFilesAndDirectories(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "fragments"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "identity-store-provisioners"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "localidentity"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "module"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "notification-sender"));
        builder.includeAllFilesAndDirectories(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "oauth-clients"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "password-credential-validators"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "token-generators"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "token-processors"));
        builder.includeAllFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, new File(serverDefaultDataDir + File.separator + "adapter-selectors"));
        return builder;
    }

    public static ArchiveFileFilterBuilder configDirFilterBuilder(File configDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, configDir, "alarms.ldif", "alerts.ldif", "api-users.ldif", "change-subscriptions.ldif", "config.ldif", "config.ldif.orig", "config.ldif.startok", "exec-command-whitelist.txt", "java-logging.properties", "java.properties", "java.properties.orig", "license.accepted", "scim-config-ds.dsconfig", "scim-config-proxy.dsconfig", "scim-resources.xml", "scim-resources.xsd", "server.user", "server.uuid", "spring-security-config.xml", "sync-state.ldif", "sync-state.ldif.old", "tasks.ldif", "tool-invocation-logging.properties", "wrapper.conf", "wrapper-product.conf", "wrapper-license.conf");
        builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, configDir, "server.umask", "tools.properties");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, configDir, true, ".*scim.*\\.xml");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, configDir, "wordlist.txt", "commonly-used-passwords.txt", "passphrase-wordlist.txt", "xacml-core-v3-schema-wd-17.xsd", "xml.xsd", "tools", "single-page-application-web.xml");
        File archivedConfigsDir = new File(configDir, "archived-configs");
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, archivedConfigsDir, "config\\-\\d+Z(\\-\\d+)?\\.gz", 5);
        File schemaDir = new File(configDir, "schema");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, schemaDir, false, "\\d\\d\\-.*\\.ldif");
        File velocityDir = new File(configDir, "velocity");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, velocityDir, true, ".*\\.vm");
        File emailTemplatesDir = new File(configDir, "account-status-notification-email-templates");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, emailTemplatesDir, true, ".*\\.template");
        return builder;
    }

    public static ArchiveFileFilterBuilder sbinDirFilterBuilder(File sbinDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, sbinDir, "PingFederateService.conf");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, sbinDir, "wrapper-jvm-options.conf");
        return builder;
    }

    public static ArchiveFileFilterBuilder sbinWindowsDirFilterBuilder(File sbinWindowsDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, sbinWindowsDir, false, ".*\\.bat", ".*\\.conf");
        return builder;
    }

    public static ArchiveFileFilterBuilder logsDirFilterBuilder(File logsDir, File serverRoot, ProductType product) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "shutdown-monitor.ldif", "shutdown-monitor.ldif.previous", "server.status", "dsstats.csv.format");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, logsDir, "config-audit.log", "errors", "server.out", "server.out.previous", "server.pid", "windows-service-wrapper.log", "windows-service-wrapper.log.1", "windows-service-wrapper.log.2", "dsstats.csv", "dsstats.json");
        builder.includeExactFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.HEAD_AND_TAIL, logsDir, "access", "ldap-access", "authorization", "expensive-ops", "expensive-write-ops", "failed-ops", "searches-returning-no-entries", "http-detailed-access", "replication");
        builder.includeExactFiles(SecurityLevel.NONE, FileAction.HEAD_AND_TAIL, logsDir, "audit", "ldap-audit", "change-notifications.log", "debug", "debug-aci", "debug-trace", "ldap-sdk-debug", "policy-decision", "server-sdk-extension-debug", "sync", "sync-failed-ops");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, logsDir, "access.json", "ldap-access.json", "errors.json", "policy-query");
        if (ProductType.PINGDATAGOVERNANCE == product || ProductType.PINGAUTHORIZE == product) {
            File configFile = new File(serverRoot, "config" + File.separator + "config.ldif");
            try {
                List<Entry> traceLogPublishers = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.FILE_BASED_TRACE_LOG_PUBLISHER, new String[0]);
                for (Entry traceLogPublisher : traceLogPublishers) {
                    String[] debugMessageTypes;
                    String logFileString = traceLogPublisher.getAttributeValue(LDIFUtils.LOG_FILE);
                    if (logFileString == null) continue;
                    File logFile = new File(logFileString);
                    if (!logFile.isAbsolute()) {
                        logFile = new File(serverRoot, logFile.getPath());
                    }
                    if ((debugMessageTypes = traceLogPublisher.getAttributeValues(LDIFUtils.DEBUG_MESSAGE_TYPE)) == null || debugMessageTypes.length == 0) {
                        builder.includeExactFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.INCLUDE_ALL, logFile.getParentFile(), logFile.getName());
                        continue;
                    }
                    builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, logFile.getParentFile(), logFile.getName());
                }
            }
            catch (Exception e) {
                CollectSupportData.logArchiveMessage("Could not load trace log client configuration: " + StaticUtils.stackTraceToSingleLineString(e));
                builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, logsDir, "debug-trace", "trace");
            }
            try {
                List<Entry> policyDecisionServices = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.POLICY_DECISION_SERVICE, new String[0]);
                if (policyDecisionServices.size() != 0) {
                    Entry policyDecisionService = policyDecisionServices.get(0);
                    boolean includePolicyRequests = policyDecisionService.hasAttributeValue(LDIFUtils.DECISION_RESPONSE_VIEW, "request");
                    List<Entry> decisionLogPublishers = LDIFUtils.getEntriesMatchingObjectClass(configFile.getAbsolutePath(), LDIFUtils.FILE_BASED_POLICY_DECISION_LOG_PUBLISHER, new String[0]);
                    for (Entry decisionLogPublisher : decisionLogPublishers) {
                        boolean logRequests;
                        String logFileString = decisionLogPublisher.getAttributeValue(LDIFUtils.LOG_FILE);
                        if (logFileString == null) continue;
                        File logFile = new File(logFileString);
                        if (!logFile.isAbsolute()) {
                            logFile = new File(serverRoot, logFile.getPath());
                        }
                        boolean bl = logRequests = includePolicyRequests && decisionLogPublisher.getAttributeValueAsBoolean(LDIFUtils.INCLUDE_PDP_RESPONSE) != false;
                        if (logRequests) {
                            builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, logFile.getParentFile(), logFile.getName());
                            continue;
                        }
                        builder.includeExactFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.INCLUDE_ALL, logFile.getParentFile(), logFile.getName());
                    }
                }
            }
            catch (Exception e) {
                CollectSupportData.logArchiveMessage("Could not load policy decision client configuration: " + StaticUtils.stackTraceToSingleLineString(e));
                builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, logsDir, "policy-decision");
            }
        }
        if (StaticUtils.isWithinUnitTest(product)) {
            builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, logsDir, "debug-trace", "trace");
            builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, logsDir, "policy-decision", "trace");
        }
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qshutdown-live-thread-dump-\\E[0-9\\.Z]+\\.log", 5);
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qexpensive-operation-dump-\\E[0-9\\.Z]+\\.log", 5);
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qlock-conflict-details-\\E.*\\.log", 5);
        builder.includeTimestampedFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDir, "\\Qwork-queue-backlog-thread-dump-\\E[0-9\\.Z]+\\.log", 5);
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, new File(logsDir, ".index-logs"), "authorization");
        builder.includeExactFiles(SecurityLevel.OBSCURE_SECRETS, FileAction.HEAD_AND_TAIL, new File(logsDir, "webapps"), "console.log");
        File logsToolsDir = new File(logsDir, "tools");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, logsToolsDir, false, "^(?!dsreplication).*\\.((log)|(history)|(txt)|(csv))(\\.\\d+)?");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsToolsDir, false, "^dsreplication.*\\.gz$");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsToolsDir, false, "^dsreplication.*\\.((log)|(history))(\\.[1-5])?$");
        File jvmLogsDir = new File(logsDir, "jvm");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, jvmLogsDir, true, ".*\\.current", ".*\\.\\d+", ".*\\.atShutdown", "gc\\.log");
        File logsDdlsDir = new File(logsDir, "ddls");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, logsDdlsDir, false, ".*\\.sql");
        File monitorHistoryDir = new File(logsDir, "monitor-history");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, monitorHistoryDir, "historical-dsstats.csv.format");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.HEAD_AND_TAIL, monitorHistoryDir, "historical-dsstats.csv");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, monitorHistoryDir, "monitor");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.EXCLUDE, new File(logsDir, "data-recovery"), "data-recovery");
        return builder;
    }

    public static ArchiveFileFilterBuilder webappsDirFilterBuilder(File webappsDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeExactFiles(SecurityLevel.NONE, FileAction.INCLUDE_ALL, webappsDir, new String[0]);
        File delegatorDir = new File(webappsDir, "delegator");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, delegatorDir, "version");
        File delegatorAppDir = new File(delegatorDir, "app");
        builder.includeExactFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, delegatorAppDir, "config.js");
        File customAttributesDir = new File(delegatorAppDir, "customAttributes");
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, customAttributesDir, true, ".*\\.html", ".*\\.css", ".*\\.js");
        return builder;
    }

    public static ArchiveFileFilterBuilder velocityDirFilterBuilder(File velocityDir) {
        ArchiveFileFilterBuilder builder = new ArchiveFileFilterBuilder();
        builder.includeRegexFiles(SecurityLevel.MAXIMUM, FileAction.INCLUDE_ALL, velocityDir, true, ".*\\.vm", ".*\\.html");
        return builder;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.ldapTool.getConnection();
    }

    public Integer getIntegerArgumentValue(String uniqueId) throws ArgumentException {
        return this.getIntegerArgumentValue(uniqueId, null);
    }

    public Integer getIntegerArgumentValue(String uniqueId, Integer defaultValue) throws ArgumentException {
        Argument arg = this.configUtil.getArgument(uniqueId);
        if (arg != null && !(arg instanceof IntegerArgument)) {
            throw new ArgumentException("Argument " + uniqueId + " was not of the expected type. Expected IntegerArgument but was " + arg.getClass().getName());
        }
        if (arg == null || ((IntegerArgument)arg).getValue() == null) {
            return defaultValue;
        }
        return ((IntegerArgument)arg).getValue();
    }

    public String getStringArgumentValue(String uniqueId) throws ArgumentException {
        return this.getStringArgumentValue(uniqueId, null);
    }

    public String getStringArgumentValue(String uniqueId, String defaultValue) throws ArgumentException {
        Argument arg = this.configUtil.getArgument(uniqueId);
        if (arg != null && !(arg instanceof StringArgument)) {
            throw new ArgumentException("Argument " + uniqueId + " was not of the expected type. Expected StringArgument but was " + arg.getClass().getName());
        }
        if (arg == null || ((StringArgument)arg).getValue() == null) {
            return defaultValue;
        }
        return ((StringArgument)arg).getValue();
    }

    public List<String> getMultiStringArgumentValue(String uniqueId) {
        Argument arg = this.configUtil.getArgument(uniqueId);
        StringArgument sarg = (StringArgument)arg;
        return sarg.getValues();
    }

    public Boolean getBooleanArgumentValue(String uniqueId) throws ArgumentException {
        return this.getBooleanArgumentValue(uniqueId, null);
    }

    public Boolean getBooleanArgumentValue(String uniqueId, Boolean defaultValue) throws ArgumentException {
        Argument arg = this.configUtil.getArgument(uniqueId);
        if (arg != null && !(arg instanceof BooleanOptionArgument)) {
            throw new ArgumentException("Argument " + uniqueId + " was not of the expected type. Expected BooleanOptionArgument but was " + arg.getClass().getName());
        }
        if (arg == null || ((BooleanOptionArgument)arg).getValue() == null) {
            return defaultValue;
        }
        return ((BooleanOptionArgument)arg).getValue();
    }

    public File getFileArgumentValue(String uniqueId) throws ArgumentException {
        return this.getFileArgumentValue(uniqueId, null);
    }

    public File getFileArgumentValue(String uniqueId, File defaultValue) throws ArgumentException {
        Argument arg = this.configUtil.getArgument(uniqueId);
        if (arg != null && !(arg instanceof FileArgument)) {
            throw new ArgumentException("Argument " + uniqueId + " was not of the expected type. Expected FileArgument but was " + arg.getClass().getName());
        }
        if (arg == null || ((FileArgument)arg).getValue() == null) {
            return defaultValue;
        }
        return ((FileArgument)arg).getValue();
    }

    public DN getDNArgumentValue(String uniqueId) throws ArgumentException {
        return this.getDNArgumentValue(uniqueId, null);
    }

    public DN getDNArgumentValue(String uniqueId, DN defaultValue) throws ArgumentException {
        Argument arg = this.configUtil.getArgument(uniqueId);
        if (arg != null && !(arg instanceof DNArgument)) {
            throw new ArgumentException("Argument " + uniqueId + " was not of the expected type. Expected DNArgument but was " + arg.getClass().getName());
        }
        if (arg == null || ((DNArgument)arg).getValue() == null) {
            return defaultValue;
        }
        return ((DNArgument)arg).getValue();
    }

    public Long getDurationValue(String uniqueId, TimeUnit timeUnit) throws ArgumentException {
        Argument arg = this.configUtil.getArgument(uniqueId);
        if (arg != null && !(arg instanceof DurationArgument)) {
            throw new ArgumentException("Argument " + uniqueId + " was not of the expected type. Expected DurationArgument but was " + arg.getClass().getName());
        }
        return ((DurationArgument)arg).getValue(timeUnit);
    }

    public boolean isArgumentPresent(String argumentId) {
        Argument arg = this.configUtil.getArgument(argumentId);
        if (arg == null) {
            return false;
        }
        return arg.isPresent();
    }

    public boolean isOptionEnabled(String argumentId) {
        if (this.isArgumentPresent(argumentId)) {
            BooleanOptionArgument arg = (BooleanOptionArgument)this.configUtil.getArgument(argumentId);
            return arg.getValue();
        }
        return false;
    }

    private ProductType inferProductFromServerRoot(String serverRoot) {
        Path absolutePingDirectoryJarPath = Paths.get(serverRoot + File.separator + relativePingDirectoryJarFilePath, new String[0]);
        Path absolutePingFederateJarPath = Paths.get(serverRoot + File.separator + relativePingFederateStartupJarFilePath, new String[0]);
        Path absolutePingAuthorizeJarPath = Paths.get(serverRoot + File.separator + relativePingAuthorizeJarFilePath, new String[0]);
        Path absolutePingDataMetricsJarPath = Paths.get(serverRoot + File.separator + relativePingDataMetricsJarFilePath, new String[0]);
        Path absolutePingDataSyncJarPath = Paths.get(serverRoot + File.separator + relativePingDataSyncJarFilePath, new String[0]);
        Path absolutePingDirectoryProxyJarPath = Paths.get(serverRoot + File.separator + relativePingDirectoryProxyJarFilePath, new String[0]);
        Path absolutePingDataGovernanceJarPath = Paths.get(serverRoot + File.separator + relativePingDataGovernanceJarFilePath, new String[0]);
        if (Files.exists(absolutePingDirectoryJarPath, new LinkOption[0])) {
            return ProductType.PINGDIRECTORY;
        }
        if (Files.exists(absolutePingFederateJarPath, new LinkOption[0])) {
            return ProductType.PINGFEDERATE;
        }
        if (Files.exists(absolutePingDirectoryProxyJarPath, new LinkOption[0])) {
            return ProductType.PINGDIRECTORYPROXY;
        }
        if (Files.exists(absolutePingDataGovernanceJarPath, new LinkOption[0])) {
            return ProductType.PINGDATAGOVERNANCE;
        }
        if (Files.exists(absolutePingAuthorizeJarPath, new LinkOption[0])) {
            return ProductType.PINGAUTHORIZE;
        }
        if (Files.exists(absolutePingDataMetricsJarPath, new LinkOption[0])) {
            return ProductType.PINGDATAMETRICS;
        }
        if (Files.exists(absolutePingDataSyncJarPath, new LinkOption[0])) {
            return ProductType.PINGDATASYNC;
        }
        return ProductType.UNKNOWN;
    }

    public OperatingSystem getOs() {
        return this.os;
    }

    public boolean isAlpine() {
        Path osReleasePath = Paths.get("/etc/os-release", new String[0]);
        if (Files.exists(osReleasePath, new LinkOption[0])) {
            try {
                if (Files.readAllLines(osReleasePath, StandardCharsets.UTF_8).toString().toLowerCase().contains("id=alpine")) {
                    return true;
                }
            }
            catch (Exception e) {
                this.log("File '/etc/os-release' failed to load into memory.");
            }
        }
        return false;
    }

    private long getHeadSizeInBytes() {
        return (long)this.fileHeadCollectionSizeKB * 1024L;
    }

    private long getTailSizeInBytes() {
        return (long)this.fileTailCollectionSizeKB * 1024L;
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss.SSS Z", Locale.US);
        DURATION_DATE_FORMAT = new SimpleDateFormat("'['dd/MMM/yyyy:HH:mm:ss.SSS Z']'");
        DURATION_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DYNAMIC_SPECIAL_FILES = new HashSet<String>();
        DYNAMIC_SPECIAL_FILES.add("errors");
        DYNAMIC_SPECIAL_FILES.add("config-audit.log");
        DYNAMIC_SPECIAL_FILES.add("je.info.0");
        DYNAMIC_SPECIAL_FILES.add("historical-dsstats.csv");
        SPECIAL_HEAD_SIZE = new HashMap<String, Long>();
        SPECIAL_HEAD_SIZE.put("je.stat.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.0.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.1.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.2.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.3.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.4.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.5.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.6.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.7.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.8.csv", 8000L);
        SPECIAL_HEAD_SIZE.put("je.stat.9.csv", 8000L);
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS = new HashSet<DataCollectorType>();
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS.add(DataCollectorType.LOCAL_DB_ACI_LDAP_SEARCH);
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS.add(DataCollectorType.NOTIFICATION_MANAGER_LDAP_SEARCH);
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS.add(DataCollectorType.REPLICATION_DOMAIN_LDAP_SEARCH);
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS.add(DataCollectorType.METRICS_ENGINE_SUPPORT);
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS.add(DataCollectorType.METRICS_ENGINE_COMMANDS);
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS.add(DataCollectorType.METRICS_ENGINE_DIRECTORIES);
        TYPES_WITH_MULTIPLE_DATA_COLLECTORS.add(DataCollectorType.METRICS_ENGINE_FILES);
        SPECIAL_TAIL_SIZE = new HashMap<String, Long>();
        SPECIAL_TAIL_SIZE.put("errors", 0x100000L);
        SPECIAL_TAIL_SIZE.put("config-audit.log", 0x500000L);
        SPECIAL_TAIL_SIZE.put("je.info.0", 0x200000L);
        SPECIAL_TAIL_SIZE.put("historical-dsstats.csv", 0x200000L);
        relativePingDirectoryJarFilePath = "lib" + File.separator + "PingDirectory.jar";
        relativePingDirectoryProxyJarFilePath = "lib" + File.separator + "PingDirectoryProxy.jar";
        relativePingDataGovernanceJarFilePath = "lib" + File.separator + "PingDataGovernance.jar";
        relativePingAuthorizeJarFilePath = "lib" + File.separator + "PingAuthorize.jar";
        relativePingDataMetricsJarFilePath = "lib" + File.separator + "PingDataMetrics.jar";
        relativePingDataSyncJarFilePath = "lib" + File.separator + "PingDataSync.jar";
        relativePingFederateStartupJarFilePath = "bin" + File.separator + "pf-startup.jar";
        logOutputStream = null;
        EOL = System.getProperty("line.separator");
        PINGACCESS2x_STARTER_CLASS = "com.pingidentity.synapse.cli.Starter";
        PINGACCESS_STARTER_CLASS = "com.pingidentity.pa.cli.Starter";
    }

    public static class LastModifiedComparator
    extends ConcurrentFileComparator {
        @Override
        protected long getValue(File file) {
            return file.lastModified();
        }
    }

    public static class FileSizeComparator
    extends ConcurrentFileComparator {
        @Override
        protected long getValue(File file) {
            return file.length();
        }
    }

    static abstract class ConcurrentFileComparator
    implements Comparator<File> {
        private final Map<File, Long> rememberedValues = new HashMap<File, Long>();

        ConcurrentFileComparator() {
        }

        @Override
        public int compare(File file, File file1) {
            long file1Value;
            long fileValue = this.getValueAndRemember(file);
            if (fileValue < (file1Value = this.getValueAndRemember(file1))) {
                return -1;
            }
            if (fileValue > file1Value) {
                return 1;
            }
            return 0;
        }

        private long getValueAndRemember(File file) {
            Long fileValue = this.rememberedValues.get(file);
            if (fileValue == null) {
                fileValue = this.getValue(file);
                this.rememberedValues.put(file, fileValue);
            }
            return fileValue;
        }

        protected abstract long getValue(File var1);
    }

    public static enum ZipParentPath {
        SERVER_ROOT_FILES("server-root-files"),
        SOLARIS_COMMAND("system-solaris"),
        LINUX_COMMAND("system-linux"),
        AIX_COMMAND("system-aix"),
        WINDOWS_COMMAND("system-windows"),
        MAC_OS_COMMAND("system-mac-os"),
        SERVER("server-$PID"),
        ADDITIONAL_PROCESS("process-$PID"),
        LDAP("ldap"),
        DIRECTORY_LISTINGS("dir-listings"),
        JAVA("system-java"),
        METRICS_DBMS("metrics-engine-dbms"),
        CONFIG_DIFF("config-diff"),
        PF_DATA("pf-data"),
        PA_DATA("pa-data"),
        VISUALIZE_REPLICATION_STATE("visualize-replication-state");

        private String path;

        public String toString() {
            return this.path;
        }

        public String toString(Integer pid) {
            return this.toString().replace(CollectSupportData.VAR_PID, pid != null ? pid.toString() : CollectSupportData.NO_PID);
        }

        private ZipParentPath(String path) {
            this.path = path;
            if (path == null) {
                throw new IllegalArgumentException("Null path");
            }
        }
    }
}

