/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import com.pingidentity.csd.server.tools.CollectSupportData;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.PasswordFileReader;
import com.unboundid.util.SASLUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.ssl.AggregateTrustManager;
import com.unboundid.util.ssl.JVMDefaultTrustManager;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.PromptTrustManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class LdapTool {
    private Boolean helpSASL = null;
    private Boolean enableSSLDebugging = null;
    private Boolean promptForBindPassword = null;
    private Boolean promptForKeyStorePassword = null;
    private Boolean promptForTrustStorePassword = null;
    private Boolean trustAll = null;
    private Boolean useSASLExternal = null;
    private Boolean useSSL = null;
    private Boolean useStartTLS = null;
    private DN bindDN = null;
    private File bindPasswordFile = null;
    private File keyStorePasswordFile = null;
    private File trustStorePasswordFile = null;
    private String bindPassword = null;
    private String certificateNickname = null;
    private List<String> hosts = null;
    private List<Integer> ports = null;
    private String keyStoreFormat = null;
    private String keyStorePath = null;
    private String keyStorePassword = null;
    private String saslOption = null;
    private String trustStoreFormat = null;
    private String trustStorePath = null;
    private String trustStorePassword = null;
    private BindRequest bindRequest = null;
    private ServerSet serverSet = null;
    private SSLSocketFactory startTLSSocketFactory = null;
    private final PasswordFileReader passwordFileReader;
    private final AtomicReference<AggregateTrustManager> promptTrustManager;
    private static final String ERR_LDAP_TOOL_START_TLS_FAILED = "StartTLS negotiation failed";
    private static final String ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY = "Unable to create the SSL socket factory to use for secure communication with the server";
    private static final String ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD = "Unable to read the bind password";
    private static final String ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD = "Unable to read the trust store password";
    private static final String ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD = "Unable to read the key store password";
    private static final String ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER = "Unable to create the key manager for secure communication";

    public LdapTool(OutputStream out, OutputStream err, CollectSupportData csd) throws ArgumentException {
        Integer port;
        this.passwordFileReader = new PasswordFileReader(new PrintStream(out), new PrintStream(err));
        this.promptTrustManager = new AtomicReference();
        if (!csd.isArgumentPresent("ldapHost") || !csd.isArgumentPresent("ldapPort")) {
            throw new ArgumentException("The arguments ldapHost and ldapPort must be specified to connect to an LDAP server");
        }
        String hostname = csd.getStringArgumentValue("ldapHost");
        if (hostname != null) {
            this.hosts = Arrays.asList(hostname);
        }
        if ((port = csd.getIntegerArgumentValue("ldapPort")) != null) {
            this.ports = Arrays.asList(port);
        }
        this.bindDN = csd.getDNArgumentValue("bindDN");
        this.bindPassword = csd.getStringArgumentValue("bindPassword");
        this.bindPasswordFile = csd.getFileArgumentValue("bindPasswordFile");
        this.helpSASL = csd.getBooleanArgumentValue("helpSASL", false);
        this.enableSSLDebugging = csd.getBooleanArgumentValue("enableSSLDebugging", false);
        this.promptForBindPassword = csd.getBooleanArgumentValue("promptForBindPassword", false);
        this.promptForKeyStorePassword = csd.getBooleanArgumentValue("promptForKeyStorePassword", false);
        this.promptForTrustStorePassword = csd.getBooleanArgumentValue("promptForTrustStorePassword", false);
        this.trustAll = csd.getBooleanArgumentValue("trustAll", false);
        this.useSASLExternal = csd.getBooleanArgumentValue("useSASLExternal", false);
        this.useSSL = csd.getBooleanArgumentValue("useSSL", false);
        this.useStartTLS = csd.getBooleanArgumentValue("useStartTLS", false);
        this.keyStorePasswordFile = csd.getFileArgumentValue("keyStorePasswordFile");
        this.trustStorePasswordFile = csd.getFileArgumentValue("trustStorePasswordFile");
        this.certificateNickname = csd.getStringArgumentValue("certificateNickname");
        this.keyStoreFormat = csd.getStringArgumentValue("keyStoreFormat");
        this.keyStorePath = csd.getStringArgumentValue("keyStorePath");
        this.keyStorePassword = csd.getStringArgumentValue("keyStorePassword");
        this.saslOption = csd.getStringArgumentValue("saslOption");
        this.trustStoreFormat = csd.getStringArgumentValue("trustStoreFormat");
        this.trustStorePath = csd.getStringArgumentValue("trustStorePath");
        this.trustStorePassword = csd.getStringArgumentValue("trustStorePassword");
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final LDAPConnection getConnection() throws LDAPException {
        LDAPConnection connection = this.getUnauthenticatedConnection();
        try {
            if (this.bindRequest != null) {
                connection.bind(this.bindRequest);
            }
        }
        catch (LDAPException le) {
            Debug.debugException((Throwable)le);
            connection.close();
            throw le;
        }
        return connection;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    public final LDAPConnection getUnauthenticatedConnection() throws LDAPException {
        if (this.serverSet == null) {
            this.serverSet = this.createServerSet();
            this.bindRequest = this.createBindRequest();
        }
        LDAPConnection connection = this.serverSet.getConnection();
        if (this.useStartTLS.booleanValue()) {
            try {
                ExtendedResult extendedResult = connection.processExtendedOperation((ExtendedRequest)new StartTLSExtendedRequest(this.startTLSSocketFactory));
                if (!extendedResult.getResultCode().equals((Object)ResultCode.SUCCESS)) {
                    throw new LDAPException(extendedResult.getResultCode(), ERR_LDAP_TOOL_START_TLS_FAILED);
                }
            }
            catch (LDAPException le) {
                Debug.debugException((Throwable)le);
                connection.close();
                throw le;
            }
        }
        return connection;
    }

    public ServerSet createServerSet() throws LDAPException {
        SSLUtil sslUtil = this.createSSLUtil();
        SSLSocketFactory socketFactory = null;
        if (this.useSSL.booleanValue()) {
            try {
                socketFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY, (Throwable)e);
            }
        }
        if (this.useStartTLS.booleanValue()) {
            try {
                this.startTLSSocketFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY, (Throwable)e);
            }
        }
        if (this.hosts.size() == 1) {
            return new SingleServerSet(this.hosts.get(0), this.ports.get(0).intValue(), (SocketFactory)socketFactory, this.getConnectionOptions());
        }
        List<String> hostList = this.hosts;
        List<Integer> portList = this.ports;
        String[] hosts = new String[hostList.size()];
        int[] ports = new int[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hostList.get(i);
            ports[i] = portList.get(i);
        }
        return new RoundRobinServerSet(hosts, ports, (SocketFactory)socketFactory, this.getConnectionOptions());
    }

    public BindRequest createBindRequest() throws LDAPException {
        byte[] pw;
        Control[] bindControls;
        if (!this.supportsAuthentication()) {
            return null;
        }
        List<Control> bindControlList = this.getBindControls();
        if (bindControlList == null || bindControlList.isEmpty()) {
            bindControls = StaticUtils.NO_CONTROLS;
        } else {
            bindControls = new Control[bindControlList.size()];
            bindControlList.toArray(bindControls);
        }
        if (this.bindPassword != null) {
            pw = StaticUtils.getBytes((String)this.bindPassword);
        } else if (this.bindPasswordFile != null) {
            try {
                char[] pwChars = this.getPasswordFileReader().readPassword(this.bindPasswordFile);
                pw = StaticUtils.getBytes((String)new String(pwChars));
            }
            catch (Exception e) {
                Debug.debugException((Throwable)e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD, (Throwable)e);
            }
        } else {
            pw = null;
        }
        if (this.saslOption != null) {
            String dnStr = this.bindDN != null ? this.bindDN.toString() : null;
            return SASLUtils.createBindRequest((String)dnStr, (byte[])pw, (boolean)false, null, null, Arrays.asList(this.saslOption), (Control[])bindControls);
        }
        if (this.useSASLExternal.booleanValue()) {
            return new EXTERNALBindRequest(bindControls);
        }
        if (this.bindDN != null) {
            return new SimpleBindRequest(this.bindDN, pw, bindControls);
        }
        return null;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return new LDAPConnectionOptions();
    }

    protected List<Control> getBindControls() {
        return null;
    }

    public SSLUtil createSSLUtil() throws LDAPException {
        return this.createSSLUtil(false);
    }

    public SSLUtil createSSLUtil(boolean force) throws LDAPException {
        if (force || this.useSSL.booleanValue() || this.useStartTLS.booleanValue()) {
            Object tm;
            KeyStoreKeyManager keyManager = null;
            if (this.keyStorePath != null) {
                char[] pw = null;
                if (this.keyStorePassword != null) {
                    pw = this.keyStorePassword.toCharArray();
                } else if (this.keyStorePasswordFile != null) {
                    try {
                        pw = this.getPasswordFileReader().readPassword(this.keyStorePasswordFile);
                    }
                    catch (Exception e) {
                        Debug.debugException((Throwable)e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD, (Throwable)e);
                    }
                }
                try {
                    keyManager = new KeyStoreKeyManager(this.keyStorePath, pw, this.keyStoreFormat, this.certificateNickname);
                }
                catch (Exception e) {
                    Debug.debugException((Throwable)e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER, (Throwable)e);
                }
            }
            if (this.trustAll.booleanValue()) {
                tm = new TrustAllTrustManager(false);
            } else if (this.trustStorePath != null) {
                char[] pw = null;
                if (this.trustStorePassword != null) {
                    pw = this.trustStorePassword.toCharArray();
                } else if (this.trustStorePasswordFile != null) {
                    try {
                        pw = this.getPasswordFileReader().readPassword(this.trustStorePasswordFile);
                    }
                    catch (Exception e) {
                        Debug.debugException((Throwable)e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD, (Throwable)e);
                    }
                }
                tm = new TrustStoreTrustManager(this.trustStorePath, pw, this.trustStoreFormat, true);
            } else if (this.promptTrustManager.get() != null) {
                tm = (TrustManager)this.promptTrustManager.get();
            } else {
                AggregateTrustManager atm;
                ArrayList<String> expectedAddresses = new ArrayList<String>(5);
                if (this.useSSL.booleanValue() || this.useStartTLS.booleanValue()) {
                    expectedAddresses.addAll(this.hosts);
                }
                tm = this.promptTrustManager.compareAndSet(null, atm = new AggregateTrustManager(false, new X509TrustManager[]{JVMDefaultTrustManager.getInstance(), new PromptTrustManager(null, true, expectedAddresses, null, null)})) ? atm : (TrustManager)this.promptTrustManager.get();
            }
            return new SSLUtil(keyManager, (TrustManager)tm);
        }
        return null;
    }

    protected boolean supportsAuthentication() {
        return true;
    }

    public final PasswordFileReader getPasswordFileReader() {
        return this.passwordFileReader;
    }
}

