/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import com.pingidentity.csd.server.tools.VersionRestriction;
import com.pingidentity.csd.server.types.OperatingSystem;
import java.util.ArrayList;
import java.util.List;

public class OperatingSystemVersion {
    private OperatingSystem operatingSystem;
    private List<VersionRestriction> versionRestrictionList;

    public OperatingSystemVersion(OperatingSystem os, List<VersionRestriction> vrs) {
        this.operatingSystem = os;
        this.versionRestrictionList = vrs;
    }

    public OperatingSystemVersion(OperatingSystem os, String ... vrs) {
        ArrayList<VersionRestriction> versionRestrictions = null;
        if (vrs != null) {
            versionRestrictions = new ArrayList<VersionRestriction>(vrs.length);
            for (String vr : vrs) {
                versionRestrictions.add(new VersionRestriction(vr));
            }
        }
        this.operatingSystem = os;
        this.versionRestrictionList = versionRestrictions;
    }

    public OperatingSystemVersion(OperatingSystem os) {
        this.operatingSystem = os;
        this.versionRestrictionList = null;
    }

    public boolean includes(OperatingSystem os, String version) {
        if (this.operatingSystem != os) {
            return false;
        }
        if (this.versionRestrictionList == null) {
            return true;
        }
        for (VersionRestriction vr : this.versionRestrictionList) {
            if (vr.acceptsVersion(version)) continue;
            return false;
        }
        return true;
    }
}

