/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import com.pingidentity.csd.mon.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionRestriction {
    private static Pattern VERSION_RESTRICTION_REGEX = Pattern.compile("^([><=!]+)([^><=!]+)");
    private String version;
    private Restrictor restrictor;
    private static final String VERSION_RE = "[0-9\\.]+";

    public VersionRestriction(String versionRestriction) {
        Matcher matcher = VERSION_RESTRICTION_REGEX.matcher(versionRestriction);
        if (matcher.matches()) {
            this.restrictor = Restrictor.parse(matcher.group(1));
            this.version = matcher.group(2);
        } else {
            this.restrictor = Restrictor.EQUALS;
            this.version = versionRestriction;
        }
    }

    public boolean acceptsVersion(String version) {
        switch (this.restrictor) {
            case GREATER_THAN: {
                return Utils.newer(version, this.version);
            }
            case LESS_THAN: {
                return Utils.newer(this.version, version);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return this.version.equals(version) || Utils.newer(version, this.version);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return this.version.equals(version) || Utils.newer(this.version, version);
            }
            case NOT_EQUALS: {
                return !this.version.equals(version);
            }
        }
        return this.version.equals(version);
    }

    static enum Restrictor {
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL_TO(">="),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL_TO("<="),
        EQUALS("=", "", "=="),
        NOT_EQUALS("!", "!="),
        UNKNOWN_OPERATOR(new String[0]);

        private List<String> operators = new ArrayList<String>();

        public List<String> getOperators() {
            return this.operators;
        }

        private Restrictor(String ... operators) {
            this.operators = Arrays.asList(operators);
        }

        public static Restrictor parse(String op) {
            for (Restrictor r : Restrictor.values()) {
                if (!r.operators.contains(op)) continue;
                return r;
            }
            return UNKNOWN_OPERATOR;
        }
    }
}

