/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools.argument;

import com.pingidentity.csd.server.tools.argument.ArgumentConfiguration;
import com.pingidentity.csd.server.tools.argument.ArgumentFactory;
import com.pingidentity.csd.server.tools.argument.BooleanOptionArgument;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.util.Collections;

public class ConfigFileArgumentFactory
implements ArgumentFactory {
    @Override
    public Argument createInstance(ArgumentConfiguration configuration) throws ArgumentException {
        ConfigFileArgumentFactory factory;
        String type;
        switch (type = configuration.getType()) {
            case "string": {
                factory = new ConfigFileStringArgumentFactory();
                break;
            }
            case "boolean": {
                factory = new ConfigFileBooleanOptionArgumentFactory();
                break;
            }
            case "integer": {
                factory = new ConfigFileIntegerArgumentFactory();
                break;
            }
            case "dn": {
                factory = new ConfigFileDNArgumentFactory();
                break;
            }
            case "file": {
                factory = new ConfigFileFileArgumentFactory();
                break;
            }
            default: {
                throw new ArgumentException("Cannot create Argument: Invalid Argument Type");
            }
        }
        Argument arg = factory.createInstance(configuration);
        return arg;
    }

    private class StandardArgumentParams {
        private Character shortIdentifier;
        private String longIdentifier;
        private String description;
        private Boolean isRequired;

        public StandardArgumentParams(ArgumentConfiguration configuration) throws ArgumentException {
            this.shortIdentifier = configuration.getConfiguration().get("shortIdentifier") != null ? Character.valueOf(configuration.getConfiguration().get("shortIdentifier").charAt(0)) : null;
            this.longIdentifier = configuration.getConfiguration().get("longIdentifier");
            this.description = configuration.getConfiguration().get("description");
            if (this.description == null) {
                throw new ArgumentException("A value must be provided for description");
            }
            this.isRequired = Boolean.valueOf(configuration.getConfiguration().get("isRequired"));
        }

        public Character getShortIdentifier() {
            return this.shortIdentifier;
        }

        public String getLongIdentifier() {
            return this.longIdentifier;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getIsRequired() {
            return this.isRequired;
        }
    }

    class ConfigFileFileArgumentFactory
    extends ConfigFileArgumentFactory {
        ConfigFileFileArgumentFactory() {
        }

        @Override
        public Argument createInstance(ArgumentConfiguration configuration) throws ArgumentException {
            StandardArgumentParams standardParams = new StandardArgumentParams(configuration);
            Integer maxOccurrences = configuration.getIntParam("maxOccurrences");
            if (maxOccurrences == null) {
                maxOccurrences = 1;
            }
            Boolean fileMustExist = configuration.getBooleanParam("fileMustExist", false);
            Boolean parentMustExist = configuration.getBooleanParam("parentMustExist", false);
            Boolean mustBeFile = configuration.getBooleanParam("mustBeFile", false);
            Boolean mustBeDirectory = configuration.getBooleanParam("mustBeDirectory", false);
            String defaultFileName = (String)configuration.getDefaultValue();
            File defaultFile = null;
            if (defaultFileName != null) {
                defaultFile = new File(defaultFileName);
            }
            return new FileArgument(standardParams.getShortIdentifier(), standardParams.getLongIdentifier(), standardParams.getIsRequired().booleanValue(), maxOccurrences.intValue(), null, standardParams.getDescription(), fileMustExist.booleanValue(), parentMustExist.booleanValue(), mustBeFile.booleanValue(), mustBeDirectory.booleanValue(), defaultFile == null ? null : Collections.singletonList(defaultFile));
        }
    }

    class ConfigFileDNArgumentFactory
    extends ConfigFileArgumentFactory {
        ConfigFileDNArgumentFactory() {
        }

        @Override
        public Argument createInstance(ArgumentConfiguration configuration) throws ArgumentException {
            StandardArgumentParams standardParams = new StandardArgumentParams(configuration);
            Integer maxOccurrences = configuration.getIntParam("maxOccurrences");
            if (maxOccurrences == null) {
                maxOccurrences = 1;
            }
            String defaultValue = (String)configuration.getDefaultValue();
            DN defaultDN = null;
            if (defaultValue != null) {
                try {
                    defaultDN = new DN(defaultValue);
                }
                catch (LDAPException e) {
                    throw new ArgumentException("Could not create DNArgument:", (Throwable)e);
                }
            }
            DNArgument dnArgument = new DNArgument(standardParams.getShortIdentifier(), standardParams.getLongIdentifier(), standardParams.getIsRequired().booleanValue(), maxOccurrences.intValue(), null, standardParams.getDescription(), defaultDN);
            return dnArgument;
        }
    }

    class ConfigFileIntegerArgumentFactory
    extends ConfigFileArgumentFactory {
        ConfigFileIntegerArgumentFactory() {
        }

        @Override
        public Argument createInstance(ArgumentConfiguration configuration) throws ArgumentException {
            StandardArgumentParams standardParams = new StandardArgumentParams(configuration);
            String defaultValueString = (String)configuration.getDefaultValue();
            Integer defaultValue = null;
            if (defaultValueString != null) {
                defaultValue = Integer.valueOf(defaultValueString);
            }
            Integer lowerBound = configuration.getIntParam("lowerBound");
            Integer upperBound = configuration.getIntParam("upperBound");
            if (lowerBound == null) {
                lowerBound = Integer.MIN_VALUE;
            }
            if (upperBound == null) {
                upperBound = Integer.MAX_VALUE;
            }
            if (lowerBound >= upperBound) {
                throw new ArgumentException("Lower bound must be strictly less than the Upper bound");
            }
            return new IntegerArgument(standardParams.getShortIdentifier(), standardParams.getLongIdentifier(), standardParams.getIsRequired().booleanValue(), 1, null, standardParams.getDescription(), lowerBound.intValue(), upperBound.intValue(), defaultValue);
        }
    }

    class ConfigFileBooleanOptionArgumentFactory
    extends ConfigFileArgumentFactory {
        ConfigFileBooleanOptionArgumentFactory() {
        }

        @Override
        public Argument createInstance(ArgumentConfiguration configuration) throws ArgumentException {
            StandardArgumentParams standardParams = new StandardArgumentParams(configuration);
            String defaultValueString = (String)configuration.getDefaultValue();
            Boolean defaultValue = Boolean.valueOf(defaultValueString);
            return new BooleanOptionArgument(standardParams.getShortIdentifier(), standardParams.getLongIdentifier(), standardParams.getIsRequired(), standardParams.getDescription(), defaultValue);
        }
    }

    class ConfigFileStringArgumentFactory
    extends ConfigFileArgumentFactory {
        ConfigFileStringArgumentFactory() {
        }

        @Override
        public Argument createInstance(ArgumentConfiguration configuration) throws ArgumentException {
            StandardArgumentParams standardParams = new StandardArgumentParams(configuration);
            Integer maxOccurrences = configuration.getIntParam("maxOccurrences");
            if (maxOccurrences == null) {
                maxOccurrences = 1;
            }
            String defaultValue = (String)configuration.getDefaultValue();
            return new StringArgument(standardParams.getShortIdentifier(), standardParams.getLongIdentifier(), standardParams.getIsRequired().booleanValue(), maxOccurrences.intValue(), null, standardParams.getDescription(), defaultValue);
        }
    }
}

