/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.util;

import com.pingidentity.csd.server.types.ProductType;
import com.pingidentity.csd.server.util.BufferUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public final class StaticUtils {
    public static String stackTraceToSingleLineString(Throwable t) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(ba);
        t.printStackTrace(ps);
        return new String(ba.toByteArray());
    }

    public static File createTempDir() throws IOException {
        String dirName;
        File newTempDir;
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        int maxAttempts = 9;
        int attemptCount = 0;
        do {
            if (++attemptCount <= 9) continue;
            throw new IOException("The highly improbable has occurred! Failed to create a unique temporary directory after 9 attempts.");
        } while ((newTempDir = new File(sysTempDir, dirName = "pingidentity-csd-" + UUID.randomUUID().toString())).exists());
        if (newTempDir.mkdirs()) {
            return newTempDir;
        }
        throw new IOException("Failed to create temp dir named " + newTempDir.getAbsolutePath());
    }

    public static void unzipEntry(String destinationDir, ZipFile zipFile, String targetFileName, String targetFilePath) throws IOException, IllegalArgumentException {
        if (targetFileName.contains(File.separator)) {
            throw new IllegalArgumentException("The target file name being unzipped is a directory: " + targetFileName);
        }
        InputStream in = zipFile.getInputStream(zipFile.getEntry(targetFilePath + targetFileName));
        String fileName = destinationDir + File.separator + targetFileName;
        File f = new File(fileName);
        FileOutputStream fos = new FileOutputStream(f);
        while (in.available() > 0) {
            fos.write(in.read());
        }
        in.close();
        fos.close();
    }

    public static File[] listFiles(File directory, FilenameFilter filter) {
        File[] files;
        if (directory != null && (files = directory.listFiles(filter)) != null) {
            return files;
        }
        return new File[0];
    }

    public static Date parseTimestamp(String s) throws ParseException, StringIndexOutOfBoundsException {
        SimpleDateFormat f;
        boolean bracketedJava8GCTS;
        Date timestamp = null;
        SimpleDateFormat gcDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
        SimpleDateFormat rotatedLogsDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        SimpleDateFormat msDateFormat = new SimpleDateFormat("'['dd/MMM/yyyy:HH:mm:ss.SSS Z']'");
        SimpleDateFormat secDateFormat = new SimpleDateFormat("'['dd/MMM/yyyy:HH:mm:ss Z']'");
        Pattern GC_TIMESTAMP_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.\\d{3}-\\d{4}");
        Pattern ROTATED_LOGS_PATTERN = Pattern.compile(".+(\\d{14,}?).+");
        int openBracketPos = s.indexOf(91);
        int closeBracketPos = s.indexOf(93);
        int gap = closeBracketPos - openBracketPos;
        boolean bl = bracketedJava8GCTS = openBracketPos == 0 && closeBracketPos == 29;
        if (gap < 27 || gap > 32 || bracketedJava8GCTS) {
            Matcher m = GC_TIMESTAMP_PATTERN.matcher(s);
            if (m.find()) {
                SimpleDateFormat f2 = gcDateFormat;
                f2.setTimeZone(TimeZone.getTimeZone("UTC"));
                timestamp = f2.parse(m.group());
                return timestamp;
            }
            m = ROTATED_LOGS_PATTERN.matcher(s);
            if (m.find()) {
                SimpleDateFormat f3 = rotatedLogsDateFormat;
                f3.setTimeZone(TimeZone.getTimeZone("UTC"));
                timestamp = f3.parse(m.group(1));
                return timestamp;
            }
            return null;
        }
        String timestampString = s.substring(openBracketPos, closeBracketPos + 1);
        if (timestampString.length() > 21 && timestampString.charAt(21) == '.') {
            f = msDateFormat;
            f.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            f = secDateFormat;
            f.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return f.parse(timestampString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> readFileToLines(File file) throws IOException {
        ArrayList<String> lines;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(file))));){
            String line;
            lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    public static File getFileFromString(String fileString, File serverRoot) {
        File dbDir = new File(fileString);
        if (!dbDir.isAbsolute()) {
            dbDir = new File(serverRoot, fileString);
        }
        return dbDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsNonUTF8Data(File file, int initialBytesToCheck) throws IOException {
        FileChannel scanFile = null;
        boolean foundBinaryData = false;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            scanFile = fis.getChannel();
            int n = initialBytesToCheck = scanFile.size() < (long)initialBytesToCheck ? (int)scanFile.size() : initialBytesToCheck;
            if (0 >= initialBytesToCheck) {
                boolean bl = false;
                return bl;
            }
            scanFile.position(0L);
            ByteBuffer scanBuffer = ByteBuffer.allocate(initialBytesToCheck);
            int readBytes = scanFile.read(scanBuffer);
            if (0 < readBytes) {
                foundBinaryData = StaticUtils.segmentContainsBinaryData(scanBuffer);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (null != scanFile) {
                scanFile.close();
            }
        }
        return foundBinaryData;
    }

    private static boolean segmentContainsBinaryData(ByteBuffer byteBuffer) {
        BufferUtils.rewind(byteBuffer);
        CharsetDecoder cd = StandardCharsets.UTF_8.newDecoder();
        CoderResult result = cd.decode(byteBuffer, CharBuffer.allocate(byteBuffer.capacity()), false);
        return result.isError() || result.isMalformed() || result.isUnmappable();
    }

    public static boolean isWithinUnitTest(ProductType product) {
        if (!ProductType.isPingDirectoryProduct(product)) {
            return false;
        }
        Boolean isWithinUnitTestProcess = Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        Boolean isWithinUnitTestExternalInstance = System.getenv().get("CODE_COVERAGE_ARGS_SET_BY_UNITTESTS") != null;
        return isWithinUnitTestProcess != false || isWithinUnitTestExternalInstance != false;
    }

    public static String collectionToString(Collection<?> collection, String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

