/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.tools.ToolConstants;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.SimpleHTMLBuilder;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.ToolMessages;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class ExamineSupportData
extends CommandLineTool {
    private StringArgument severityArg;
    private BooleanArgument verboseArg;
    private BooleanArgument internalAnalysisArg;
    private BooleanArgument noExplanationArg;
    private StringArgument generateHTMLArg;
    private boolean verbose;
    boolean allowInternal;
    boolean noExplanation;
    Severity severityLevel;
    Set<Category> categories;
    private int warningCount;
    private int errorCount;
    private ArgumentParser parser;
    public static final int RC_SUCCESS = 0;
    public static final int RC_ERROR = 1;
    public static final int RC_ISSUES = 2;
    public static final String SCRIPT_NAME = "examine-support-data";

    public static void main(String[] args) {
        int exitCode = ExamineSupportData.doMain(System.out, System.err, args);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    public static int doMain(ExamineSupportData examineSupportData, String ... args) {
        return examineSupportData.runTool(args).intValue();
    }

    public static int doMain(OutputStream outStream, OutputStream errStream, String ... args) {
        ExamineSupportData examineSupportData = new ExamineSupportData(outStream, errStream);
        return ExamineSupportData.doMain(examineSupportData, args);
    }

    public ExamineSupportData() {
        this(System.out, System.err);
    }

    public ExamineSupportData(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    public List<Message> getDescription() {
        return Arrays.asList(UBIDExaminerMessages.INFO_ESD_DESCRIPTION.get());
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void doExtendedArgumentValidation() throws ArgumentException {
        this.verbose = this.verboseArg.isPresent();
        this.noExplanation = this.noExplanationArg.isPresent();
        this.allowInternal = this.internalAnalysisArg.isPresent();
        if (this.allowInternal) {
            this.printerr("NOTICE: Internal Analysis is Enabled!");
        }
        Severity severity = null;
        if (this.severityArg.isPresent()) {
            try {
                String sevStr = this.severityArg.getValue().toUpperCase();
                if (sevStr.startsWith("ERR")) {
                    sevStr = "MILD_ERR";
                }
                if (sevStr.startsWith("WARN")) {
                    sevStr = "MILD_WARN";
                }
                severity = Severity.parseString((String)sevStr);
                this.info("Severity Level set to " + severity + " from " + this.severityArg.getValue());
            }
            catch (Exception ex) {
                this.printerr("Invalid Severity: " + this.severityArg.getValue() + " Exception: " + ex);
                throw new ArgumentException("Invalid Severity: " + this.severityArg.getValue(), (Throwable)ex);
            }
        }
        if (severity == null) {
            this.info("Unable to determine severity from arguments!");
            severity = Severity.MILD_ERROR;
        }
        this.severityLevel = severity;
        this.categories = EnumSet.allOf(Category.class);
    }

    public ResultCode doToolProcessing() {
        this.info("Examine Support Data tool launched");
        if (this.verbose) {
            SupportDataArchive.setConsoleLogger(this.getOut());
            SupportDataExaminer.setConsoleLogger(this.getOut());
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        boolean foundError = false;
        this.errorCount = 0;
        this.warningCount = 0;
        for (String archiveName : this.parser.getTrailingArguments()) {
            SupportDataArchive sda;
            this.println("*****************");
            this.println("Examining Archive: " + archiveName);
            this.println("*****************");
            try {
                sda = new SupportDataArchive(archiveName);
            }
            catch (Exception ex) {
                this.printerr(UBIDExaminerMessages.ERR_ESD_FAILED_TO_OPEN_ARCHIVE.get((Object)archiveName, (Object)StaticUtils.stackTraceToSingleLineString(ex)).toString());
                foundError = true;
                continue;
            }
            if (sda.getSystem() == null) {
                this.printerr("");
                this.printerr("WARNING: This archive is likely invalid or corrupt!");
                this.printerr("");
            }
            for (SupportDataExaminer examiner : SupportDataExaminer.getExaminers(sda)) {
                if (!examiner.getSupportedOperatingSystems().contains((Object)sda.getSystem())) {
                    this.info("\n============");
                    this.info("> " + examiner.getTitle() + " does not support " + (Object)((Object)sda.getSystem()));
                    continue;
                }
                if (examiner.getCategories() != null) {
                    boolean categoryFound = false;
                    for (Category category : examiner.getCategories()) {
                        if (!this.categories.contains(category)) continue;
                        categoryFound = true;
                        break;
                    }
                    if (!categoryFound) {
                        this.info("");
                        this.info("> " + examiner.getTitle() + " categories " + examiner.getCategories() + " are undesired");
                        continue;
                    }
                }
                this.info("");
                this.info("============");
                this.info("Running Examine for: " + examiner.getTitle());
                SupportDataExaminer.Result result = null;
                try {
                    result = examiner.examine(sda);
                }
                catch (Exception ex) {
                    this.info("Exception occurred while doing analysis:" + StaticUtils.stackTraceToSingleLineString(ex));
                }
                if (result == null || result.isInternalOnly() && !this.allowInternal) continue;
                if (result.output.size() == 0 && result.getSeverity() == null) {
                    this.println("Examiner '" + examiner.getTitle() + "' has nothing to report.");
                }
                if (!result.isSevereAs(this.severityLevel)) continue;
                try {
                    this.println("");
                    this.println("Results for: " + examiner.getTitle());
                    this.println("Categories: " + (examiner.getCategories() != null ? examiner.getCategories().toString() : "Not Categorized"));
                    this.println("Severity: " + result.getSeverity().messageDesciptorName());
                    result.writeTo(this.getOut());
                    if (!this.noExplanation) {
                        this.println("Explanation: " + examiner.getExplanation());
                    }
                    if (result.getSeverity().messageDesciptorName().equals("ERR")) {
                        ++this.errorCount;
                    }
                    if (result.getSeverity().messageDesciptorName().equals("WARN")) {
                        ++this.warningCount;
                    }
                }
                catch (IOException ex) {
                    this.info(StaticUtils.stackTraceToSingleLineString(ex));
                }
                if (foundError || !result.isSevereAs(Severity.MILD_ERROR)) continue;
                foundError = true;
            }
            if (this.generateHTMLArg.isPresent()) {
                filePaths.addAll(ExamineSupportData.calculatePathsForFiles(sda));
            }
            sda.close();
        }
        if (this.generateHTMLArg.isPresent()) {
            String file = this.generateHTMLArg.getValue();
            SimpleHTMLBuilder htmlBuilder = new SimpleHTMLBuilder();
            Collections.sort(filePaths);
            for (String filePath : filePaths) {
                htmlBuilder.addLink(filePath, filePath);
            }
            try {
                String htmlText = htmlBuilder.build();
                Files.write(Paths.get(file, new String[0]), htmlText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException exception) {
                this.printerr("Error occurred while writing to HTML file: " + StaticUtils.stackTraceToSingleLineString(exception));
            }
        }
        if (foundError) {
            return ResultCode.OTHER;
        }
        return ResultCode.SUCCESS;
    }

    public static List<String> calculatePathsForFiles(SupportDataArchive archive) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> filenames = archive.listFiles();
        for (String name : filenames) {
            int firstPath = name.indexOf(File.separator);
            if (firstPath >= 0 && firstPath + 1 < name.length()) {
                name = name.substring(firstPath + 1);
            }
            if (name.endsWith(File.separator)) continue;
            result.add(name);
        }
        return result;
    }

    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleUsages = new LinkedHashMap<String[], String>();
        String[] args = new String[]{"support-data-ds-server-zip"};
        exampleUsages.put(args, UBIDExaminerMessages.INFO_ESD_EXAMPLE_ZIP.get().toString());
        return exampleUsages;
    }

    private void println(String message) {
        this.out(new Object[]{message});
    }

    private void printerr(String message) {
        this.err(new Object[]{message});
    }

    private void info(String message) {
        if (this.verbose) {
            this.out(new Object[]{message});
        }
    }

    public String getToolName() {
        return SCRIPT_NAME;
    }

    public String getToolDescription() {
        return UBIDExaminerMessages.INFO_ESD_TOOL_DESCRIPTION.get().toString();
    }

    public int getMinTrailingArguments() {
        return 1;
    }

    public int getMaxTrailingArguments() {
        return Integer.MAX_VALUE;
    }

    public String getTrailingArgumentsPlaceholder() {
        return UBIDExaminerMessages.INFO_ESD_TRAILING_ARGS_DISPLAY_NAME.get().toString();
    }

    public void addToolArguments(ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.verboseArg = new BooleanArgument(ToolConstants.OPTION_SHORT_VERBOSE, "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get().toString());
        parser.addArgument((Argument)this.verboseArg);
        this.internalAnalysisArg = new BooleanArgument(null, "enableInternalAnalysis", UBIDExaminerMessages.INFO_ESD_ARG_DESCRIPTION_INTERNAL.get().toString());
        this.internalAnalysisArg.setHidden(true);
        parser.addArgument((Argument)this.internalAnalysisArg);
        this.severityArg = new StringArgument(Character.valueOf('S'), "severity", false, 1, UBIDExaminerMessages.INFO_ESD_ARG_PLACEHOLDER_SEVERITY.get().toString(), UBIDExaminerMessages.INFO_ESD_ARG_DESCRIPTION_SEVERITY.get().toString());
        parser.addArgument((Argument)this.severityArg);
        this.noExplanationArg = new BooleanArgument(null, "no-explanation", UBIDExaminerMessages.INFO_ESD_ARG_DESCRIPTION_NO_EXPLANATION.get().toString());
        parser.addArgument((Argument)this.noExplanationArg);
        this.generateHTMLArg = new StringArgument(null, "generate-html", false, 1, UBIDExaminerMessages.INFO_ESD_ARG_PLACEHOLDER_GENERATE_HTML.get().toString(), UBIDExaminerMessages.INFO_ESD_ARG_DESCRIPTION_GENERATE_HTML.get().toString());
        parser.addArgument((Argument)this.generateHTMLArg);
    }
}

