/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataExaminer;
import com.unboundid.csd.messages.UBIDExaminerMessages;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.util.ArrayList;
import java.util.List;

public abstract class MonitorExaminer
extends SupportDataExaminer {
    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        examiners.add(new DisassociatedConnectionsExaminer());
        examiners.add(new LargeStaticGroupsExaminer());
        examiners.add(new StatusSummaryExaminer());
        return examiners;
    }

    public static class StatusSummaryExaminer
    extends MonitorExaminer {
        private static final String NAME = "Status Health Summary";

        @Override
        public String getTitle() {
            return "Status Summary Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_STATUS_SUMMARY_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) throws Exception {
            Integer concerns;
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            result.setInternalOnly(true);
            Entry entry = sda.getMonitorEntry("cn=Status Health Summary,cn=monitor");
            if (entry == null) {
                result.setSeverity(Severity.MILD_ERROR);
                result.write("No status summary monitor entry found.");
                return result;
            }
            Integer criticalConcerns = entry.getAttributeValueAsInteger("num-active-critical-concerns");
            if (criticalConcerns == null) {
                criticalConcerns = 0;
            }
            if ((concerns = entry.getAttributeValueAsInteger("num-active-concerns")) == null) {
                concerns = 0;
            }
            if (concerns > 0) {
                result.write("The Status Health Summary monitor entry reports that there are " + criticalConcerns + " active critical concerns and " + (concerns - criticalConcerns) + " active non-critical concerns. The full monitor entry is: " + EOL + entry.toLDIFString());
                result.setSeverity(criticalConcerns > 0 ? Severity.SEVERE_ERROR : Severity.SEVERE_WARNING);
            }
            return result;
        }
    }

    public static class LargeStaticGroupsExaminer
    extends MonitorExaminer {
        private static String staticGroupName = "com.unboundid.directory.server.extensions.StaticGroup";
        private static int MIN_GROUP_SIZE_TO_WARN = Integer.getInteger(staticGroupName + ".MIN_GROUP_SIZE_TO_WARN", 20000);
        private String CSDMessage = "The largest static group has %,d members.";
        private long minSevereWarningSize = 200000L;

        @Override
        public String getTitle() {
            return "Large Static Groups Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_LARGE_STATIC_GROUPS_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            try {
                Entry entry = sda.getMonitorEntry("cn=Group Cache,cn=monitor");
                if (entry == null) {
                    result.setSeverity(Severity.MILD_ERROR);
                    result.write("Group Cache Monitor is unavailable.");
                    return result;
                }
                Long staticGroupMax = entry.getAttributeValueAsLong("static-group-size-maximum");
                if (staticGroupMax == null) {
                    return result;
                }
                Severity sev = staticGroupMax >= this.minSevereWarningSize ? Severity.SEVERE_WARNING : (staticGroupMax >= (long)MIN_GROUP_SIZE_TO_WARN ? Severity.MILD_WARNING : Severity.NOTICE);
                result.writeln(String.format(this.CSDMessage, staticGroupMax));
                result.setSeverity(sev);
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }

    public static class DisassociatedConnectionsExaminer
    extends MonitorExaminer {
        @Override
        public String getTitle() {
            return "Disassociated Connections Analysis";
        }

        @Override
        public Message getExplanation() {
            return UBIDExaminerMessages.INFO_DISASSOCIATED_CONNECTIONS_EXPLANATION.get();
        }

        @Override
        public SupportDataExaminer.Result examine(SupportDataArchive sda) {
            SupportDataExaminer.Result result = new SupportDataExaminer.Result(this);
            try {
                Entry entry = sda.getMonitorEntry("cn=Client Connections,cn=monitor");
                if (entry == null) {
                    result.setSeverity(Severity.MILD_ERROR);
                    result.write("Client Connections monitor is unavailable.");
                    return result;
                }
                String connsStr = entry.getAttributeValue("disassociated-connection-count");
                if (connsStr == null) {
                    return result;
                }
                result.writeln("Disassociated Connections detected: " + connsStr + ".");
                long dConns = Long.parseLong(connsStr);
                if (dConns > 0L && dConns <= 10L) {
                    result.setSeverity(Severity.INFORMATION);
                } else if (dConns > 10L && dConns <= 100L) {
                    result.setSeverity(Severity.MILD_WARNING);
                } else if (dConns > 100L) {
                    result.setSeverity(Severity.MILD_ERROR);
                }
            }
            catch (Exception ex) {
                this.log("Exception occurred while doing analysis: " + StaticUtils.stackTraceToSingleLineString(ex));
            }
            return result;
        }
    }
}

