/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;

public class SimpleHTMLBuilder {
    private static final String HTML_TAG = "html";
    private static final String BODY_TAG = "body";
    private final LinkedList<String> links = new LinkedList();
    private final LinkedList<String> topLines = new LinkedList();

    public SimpleHTMLBuilder addLink(String path, String text) {
        this.links.add("<a href=\"" + SimpleHTMLBuilder.escapeLinkPath(path) + "\">" + SimpleHTMLBuilder.escapeHTML(text) + "</a><br/>" + System.lineSeparator());
        return this;
    }

    public SimpleHTMLBuilder addTopText(String text) {
        this.topLines.add("<p>" + SimpleHTMLBuilder.escapeHTML(text) + "</p>" + System.lineSeparator());
        return this;
    }

    public SimpleHTMLBuilder addTopTextWithLink(String normalText, String linkText, String linkPath) {
        this.topLines.add("<p>" + SimpleHTMLBuilder.escapeHTML(normalText) + " <a href=\"" + SimpleHTMLBuilder.escapeLinkPath(linkPath) + "\">" + SimpleHTMLBuilder.escapeHTML(linkText) + "</a></p>" + System.lineSeparator());
        return this;
    }

    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append(SimpleHTMLBuilder.createTag(HTML_TAG, false));
        sb.append(SimpleHTMLBuilder.createTag(BODY_TAG, false));
        for (String line : this.topLines) {
            sb.append(line);
        }
        for (String line : this.links) {
            sb.append(line);
        }
        sb.append(SimpleHTMLBuilder.createTag(BODY_TAG, true));
        sb.append(SimpleHTMLBuilder.createTag(HTML_TAG, true));
        return sb.toString();
    }

    private static String createTag(String tag, boolean isClosing) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        if (isClosing) {
            sb.append("/");
        }
        sb.append(tag);
        sb.append(">");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    private static String escapeLinkPath(String path) {
        String escapedPath;
        try {
            if (File.separatorChar == '\\') {
                path = path.replace("\\", "/");
            }
            URI uri = new URI(null, null, path, null);
            escapedPath = uri.toASCIIString();
        }
        catch (URISyntaxException ignored) {
            escapedPath = path;
        }
        return escapedPath;
    }

    private static String escapeHTML(String html) {
        StringBuilder buffer = new StringBuilder();
        block4: for (char c : html.toCharArray()) {
            switch (c) {
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    buffer.append("<br/>");
                    continue block4;
                }
                default: {
                    if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                        buffer.append("&#");
                        buffer.append((int)c);
                        buffer.append(';');
                        continue block4;
                    }
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }
}

