/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.tools.examinesupportdata;

import com.pingidentity.csd.server.types.OperatingSystem;
import com.pingidentity.csd.server.util.StaticUtils;
import com.pingidentity.csd.tools.examinesupportdata.AlarmExaminer;
import com.pingidentity.csd.tools.examinesupportdata.BusyThreadsExaminer;
import com.pingidentity.csd.tools.examinesupportdata.ConfigurationExaminer;
import com.pingidentity.csd.tools.examinesupportdata.ExamineSupportData;
import com.pingidentity.csd.tools.examinesupportdata.FileSystemExaminer;
import com.pingidentity.csd.tools.examinesupportdata.JavaExaminer;
import com.pingidentity.csd.tools.examinesupportdata.LicenseExaminer;
import com.pingidentity.csd.tools.examinesupportdata.LinuxExaminer;
import com.pingidentity.csd.tools.examinesupportdata.MonitorExaminer;
import com.pingidentity.csd.tools.examinesupportdata.ReplicationExaminer;
import com.pingidentity.csd.tools.examinesupportdata.SolarisExaminer;
import com.pingidentity.csd.tools.examinesupportdata.SupportDataArchive;
import com.pingidentity.csd.tools.examinesupportdata.ThirdPartyExtensionExaminer;
import com.pingidentity.csd.tools.examinesupportdata.VersionExaminer;
import com.unboundid.messages.Category;
import com.unboundid.messages.Message;
import com.unboundid.messages.Severity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SupportDataExaminer {
    public static final String EOL = System.getProperty("line.separator");
    private static PrintStream clog;
    private static final Logger log;

    public static List<SupportDataExaminer> getExaminers(SupportDataArchive sda) {
        ArrayList<SupportDataExaminer> examiners = new ArrayList<SupportDataExaminer>();
        examiners.addAll(ReplicationExaminer.getExaminers(sda));
        examiners.addAll(LinuxExaminer.getExaminers(sda));
        examiners.addAll(SolarisExaminer.getExaminers(sda));
        examiners.addAll(JavaExaminer.getExaminers(sda));
        examiners.addAll(MonitorExaminer.getExaminers(sda));
        examiners.addAll(ConfigurationExaminer.getExaminers(sda));
        examiners.addAll(AlarmExaminer.getExaminers(sda));
        examiners.addAll(FileSystemExaminer.getExaminers());
        examiners.add(new BusyThreadsExaminer());
        examiners.add(new ThirdPartyExtensionExaminer());
        examiners.add(new VersionExaminer());
        examiners.add(new LicenseExaminer());
        return examiners;
    }

    public static void setConsoleLogger(PrintStream logger) {
        clog = logger;
    }

    protected void log(String message) {
        if (clog != null) {
            clog.println(message);
        }
        log.log(Level.INFO, message);
    }

    protected void log(Level level, String message) {
        log.log(level, message);
    }

    public abstract String getTitle();

    public abstract Message getExplanation();

    public abstract Result examine(SupportDataArchive var1) throws Exception;

    public List<Category> getCategories() {
        return null;
    }

    public List<OperatingSystem> getSupportedOperatingSystems() {
        return Arrays.asList(OperatingSystem.values());
    }

    static {
        log = Logger.getLogger(ExamineSupportData.class.getName());
    }

    public class Result {
        private boolean internalOnly;
        private Severity severity;
        protected ByteArrayOutputStream output;

        public Result(boolean internalOnly, Severity severity, ByteArrayOutputStream output) {
            this.internalOnly = internalOnly;
            this.severity = severity;
            this.output = output;
        }

        public Result() {
            this(false, null, new ByteArrayOutputStream());
        }

        protected synchronized void write(String data) {
            if (data != null) {
                try {
                    this.output.write(data.getBytes(Charset.forName("UTF-8")));
                }
                catch (IOException ex) {
                    SupportDataExaminer.this.log("Error writing this string: " + data);
                    SupportDataExaminer.this.log(StaticUtils.stackTraceToSingleLineString(ex));
                }
            }
        }

        protected void writeln() {
            this.write(EOL);
        }

        protected void writeln(String data) throws IOException {
            this.write(data);
            this.write(EOL);
        }

        public void writeTo(PrintStream outStream) throws IOException {
            this.output.writeTo(outStream);
        }

        public void setInternalOnly(boolean internalOnly) {
            this.internalOnly = internalOnly;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public void upSeverity(Severity severity) {
            if (this.isLessSevereThan(severity)) {
                this.severity = severity;
            }
        }

        public boolean isInternalOnly() {
            return this.internalOnly;
        }

        public boolean isSevereAs(Severity level) {
            if (this.severity == null) {
                return false;
            }
            return this.severity.compareTo((Enum)level) >= 0;
        }

        public boolean isLessSevereThan(Severity level) {
            if (this.severity == null) {
                return true;
            }
            return this.severity.compareTo((Enum)level) < 0;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }
}

